/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.DefaultLivePlaybackSpeedControl;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.device.DeviceListener;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import java.util.List;

public interface ExoPlayer
extends Player {
    public static final long DEFAULT_RELEASE_TIMEOUT_MS = 500L;

    @Nullable
    public AudioComponent getAudioComponent();

    @Nullable
    public VideoComponent getVideoComponent();

    @Nullable
    public TextComponent getTextComponent();

    @Nullable
    public MetadataComponent getMetadataComponent();

    @Nullable
    public DeviceComponent getDeviceComponent();

    public void addAudioOffloadListener(AudioOffloadListener var1);

    public void removeAudioOffloadListener(AudioOffloadListener var1);

    public int getRendererCount();

    public int getRendererType(int var1);

    @Nullable
    public TrackSelector getTrackSelector();

    public Looper getPlaybackLooper();

    public Clock getClock();

    @Deprecated
    public void retry();

    @Deprecated
    public void prepare(MediaSource var1);

    @Deprecated
    public void prepare(MediaSource var1, boolean var2, boolean var3);

    public void setMediaSources(List<MediaSource> var1);

    public void setMediaSources(List<MediaSource> var1, boolean var2);

    public void setMediaSources(List<MediaSource> var1, int var2, long var3);

    public void setMediaSource(MediaSource var1);

    public void setMediaSource(MediaSource var1, long var2);

    public void setMediaSource(MediaSource var1, boolean var2);

    public void addMediaSource(MediaSource var1);

    public void addMediaSource(int var1, MediaSource var2);

    public void addMediaSources(List<MediaSource> var1);

    public void addMediaSources(int var1, List<MediaSource> var2);

    public void setShuffleOrder(ShuffleOrder var1);

    public PlayerMessage createMessage(PlayerMessage.Target var1);

    public void setSeekParameters(@Nullable SeekParameters var1);

    public SeekParameters getSeekParameters();

    public void setForegroundMode(boolean var1);

    public void setPauseAtEndOfMediaItems(boolean var1);

    public boolean getPauseAtEndOfMediaItems();

    public void experimentalSetOffloadSchedulingEnabled(boolean var1);

    public boolean experimentalIsSleepingForOffload();

    @Deprecated
    public static final class Builder {
        private final Renderer[] renderers;
        private Clock clock;
        private TrackSelector trackSelector;
        private MediaSourceFactory mediaSourceFactory;
        private LoadControl loadControl;
        private BandwidthMeter bandwidthMeter;
        private Looper looper;
        @Nullable
        private AnalyticsCollector analyticsCollector;
        private boolean useLazyPreparation;
        private SeekParameters seekParameters;
        private boolean pauseAtEndOfMediaItems;
        private long releaseTimeoutMs;
        private LivePlaybackSpeedControl livePlaybackSpeedControl;
        private boolean buildCalled;
        private long setForegroundModeTimeoutMs;

        public Builder(Context context, Renderer ... renderers) {
            this(renderers, new DefaultTrackSelector(context), new DefaultMediaSourceFactory(context), new DefaultLoadControl(), DefaultBandwidthMeter.getSingletonInstance(context));
        }

        public Builder(Renderer[] renderers, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter) {
            Assertions.checkArgument((renderers.length > 0 ? 1 : 0) != 0);
            this.renderers = renderers;
            this.trackSelector = trackSelector;
            this.mediaSourceFactory = mediaSourceFactory;
            this.loadControl = loadControl;
            this.bandwidthMeter = bandwidthMeter;
            this.looper = Util.getCurrentOrMainLooper();
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.livePlaybackSpeedControl = new DefaultLivePlaybackSpeedControl.Builder().build();
            this.clock = Clock.DEFAULT;
            this.releaseTimeoutMs = 500L;
        }

        public Builder experimentalSetForegroundModeTimeoutMs(long timeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.setForegroundModeTimeoutMs = timeoutMs;
            return this;
        }

        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.trackSelector = trackSelector;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.loadControl = loadControl;
            return this;
        }

        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.bandwidthMeter = bandwidthMeter;
            return this;
        }

        public Builder setLooper(Looper looper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.looper = looper;
            return this;
        }

        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.analyticsCollector = analyticsCollector;
            return this;
        }

        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekParameters = seekParameters;
            return this;
        }

        public Builder setReleaseTimeoutMs(long releaseTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.releaseTimeoutMs = releaseTimeoutMs;
            return this;
        }

        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        public Builder setLivePlaybackSpeedControl(LivePlaybackSpeedControl livePlaybackSpeedControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.livePlaybackSpeedControl = livePlaybackSpeedControl;
            return this;
        }

        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.clock = clock;
            return this;
        }

        public ExoPlayer build() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            ExoPlayerImpl player = new ExoPlayerImpl(this.renderers, this.trackSelector, this.mediaSourceFactory, this.loadControl, this.bandwidthMeter, this.analyticsCollector, this.useLazyPreparation, this.seekParameters, this.livePlaybackSpeedControl, this.releaseTimeoutMs, this.pauseAtEndOfMediaItems, this.clock, this.looper, null, Player.Commands.EMPTY);
            if (this.setForegroundModeTimeoutMs > 0L) {
                player.experimentalSetForegroundModeTimeoutMs(this.setForegroundModeTimeoutMs);
            }
            return player;
        }
    }

    public static interface AudioOffloadListener {
        default public void onExperimentalOffloadSchedulingEnabledChanged(boolean offloadSchedulingEnabled) {
        }

        default public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
        }
    }

    public static interface DeviceComponent {
        @Deprecated
        public void addDeviceListener(DeviceListener var1);

        @Deprecated
        public void removeDeviceListener(DeviceListener var1);

        public DeviceInfo getDeviceInfo();

        public int getDeviceVolume();

        public boolean isDeviceMuted();

        public void setDeviceVolume(int var1);

        public void increaseDeviceVolume();

        public void decreaseDeviceVolume();

        public void setDeviceMuted(boolean var1);
    }

    public static interface MetadataComponent {
        @Deprecated
        public void addMetadataOutput(MetadataOutput var1);

        @Deprecated
        public void removeMetadataOutput(MetadataOutput var1);
    }

    public static interface TextComponent {
        @Deprecated
        public void addTextOutput(TextOutput var1);

        @Deprecated
        public void removeTextOutput(TextOutput var1);

        public List<Cue> getCurrentCues();
    }

    public static interface VideoComponent {
        public void setVideoScalingMode(int var1);

        public int getVideoScalingMode();

        @Deprecated
        public void addVideoListener(VideoListener var1);

        @Deprecated
        public void removeVideoListener(VideoListener var1);

        public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void setCameraMotionListener(CameraMotionListener var1);

        public void clearCameraMotionListener(CameraMotionListener var1);

        public void clearVideoSurface();

        public void clearVideoSurface(@Nullable Surface var1);

        public void setVideoSurface(@Nullable Surface var1);

        public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        public void setVideoSurfaceView(@Nullable SurfaceView var1);

        public void clearVideoSurfaceView(@Nullable SurfaceView var1);

        public void setVideoTextureView(@Nullable TextureView var1);

        public void clearVideoTextureView(@Nullable TextureView var1);

        public VideoSize getVideoSize();
    }

    public static interface AudioComponent {
        @Deprecated
        public void addAudioListener(AudioListener var1);

        @Deprecated
        public void removeAudioListener(AudioListener var1);

        public void setAudioAttributes(AudioAttributes var1, boolean var2);

        public AudioAttributes getAudioAttributes();

        public void setAudioSessionId(int var1);

        public int getAudioSessionId();

        public void setAuxEffectInfo(AuxEffectInfo var1);

        public void clearAuxEffectInfo();

        public void setVolume(float var1);

        public float getVolume();

        public void setSkipSilenceEnabled(boolean var1);

        public boolean getSkipSilenceEnabled();
    }
}

