/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImplInternal;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ExoTimeoutException;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.MediaSourceInfoHolder;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.PlaylistTimeline;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

final class ExoPlayerImpl
extends BasePlayer
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    final TrackSelectorResult emptyTrackSelectorResult;
    final Player.Commands permanentAvailableCommands;
    private final Renderer[] renderers;
    private final TrackSelector trackSelector;
    private final HandlerWrapper playbackInfoUpdateHandler;
    private final ExoPlayerImplInternal.PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final ExoPlayerImplInternal internalPlayer;
    private final ListenerSet<Player.EventListener> listeners;
    private final CopyOnWriteArraySet<ExoPlayer.AudioOffloadListener> audioOffloadListeners;
    private final Timeline.Period period;
    private final List<MediaSourceHolderSnapshot> mediaSourceHolderSnapshots;
    private final boolean useLazyPreparation;
    private final MediaSourceFactory mediaSourceFactory;
    @Nullable
    private final AnalyticsCollector analyticsCollector;
    private final Looper applicationLooper;
    private final BandwidthMeter bandwidthMeter;
    private final Clock clock;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private int pendingOperationAcks;
    private int pendingDiscontinuityReason;
    private boolean pendingDiscontinuity;
    private int pendingPlayWhenReadyChangeReason;
    private boolean foregroundMode;
    private SeekParameters seekParameters;
    private ShuffleOrder shuffleOrder;
    private boolean pauseAtEndOfMediaItems;
    private Player.Commands availableCommands;
    private MediaMetadata mediaMetadata;
    private PlaybackInfo playbackInfo;
    private int maskingWindowIndex;
    private int maskingPeriodIndex;
    private long maskingWindowPositionMs;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(Renderer[] renderers, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, @Nullable AnalyticsCollector analyticsCollector, boolean useLazyPreparation, SeekParameters seekParameters, LivePlaybackSpeedControl livePlaybackSpeedControl, long releaseTimeoutMs, boolean pauseAtEndOfMediaItems, Clock clock, Looper applicationLooper, @Nullable Player wrappingPlayer, Player.Commands additionalPermanentAvailableCommands) {
        String string = Integer.toHexString(System.identityHashCode(this));
        String string2 = Util.DEVICE_DEBUG_INFO;
        Log.i((String)TAG, (String)new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Init ").append(string).append(" [").append("ExoPlayerLib/2.14.1").append("] [").append(string2).append("]").toString());
        Assertions.checkState((renderers.length > 0 ? 1 : 0) != 0);
        this.renderers = (Renderer[])Assertions.checkNotNull((Object)renderers);
        this.trackSelector = (TrackSelector)Assertions.checkNotNull((Object)trackSelector);
        this.mediaSourceFactory = mediaSourceFactory;
        this.bandwidthMeter = bandwidthMeter;
        this.analyticsCollector = analyticsCollector;
        this.useLazyPreparation = useLazyPreparation;
        this.seekParameters = seekParameters;
        this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
        this.applicationLooper = applicationLooper;
        this.clock = clock;
        this.repeatMode = 0;
        Player playerForListeners = wrappingPlayer != null ? wrappingPlayer : this;
        this.listeners = new ListenerSet(applicationLooper, clock, (listener, flags) -> listener.onEvents(playerForListeners, new Player.Events(flags)));
        this.audioOffloadListeners = new CopyOnWriteArraySet();
        this.mediaSourceHolderSnapshots = new ArrayList<MediaSourceHolderSnapshot>();
        this.shuffleOrder = new ShuffleOrder.DefaultShuffleOrder(0);
        this.emptyTrackSelectorResult = new TrackSelectorResult(new RendererConfiguration[renderers.length], new ExoTrackSelection[renderers.length], null);
        this.period = new Timeline.Period();
        this.permanentAvailableCommands = new Player.Commands.Builder().addAll(new int[]{1, 2, 8, 9, 10, 11, 12, 13, 14}).addAll(additionalPermanentAvailableCommands).build();
        this.availableCommands = new Player.Commands.Builder().addAll(this.permanentAvailableCommands).add(3).add(7).build();
        this.mediaMetadata = MediaMetadata.EMPTY;
        this.maskingWindowIndex = -1;
        this.playbackInfoUpdateHandler = clock.createHandler(applicationLooper, null);
        this.playbackInfoUpdateListener = playbackInfoUpdate -> this.playbackInfoUpdateHandler.post(() -> this.handlePlaybackInfo(playbackInfoUpdate));
        this.playbackInfo = PlaybackInfo.createDummy(this.emptyTrackSelectorResult);
        if (analyticsCollector != null) {
            analyticsCollector.setPlayer(playerForListeners, applicationLooper);
            this.addListener(analyticsCollector);
            bandwidthMeter.addEventListener(new Handler(applicationLooper), analyticsCollector);
        }
        this.internalPlayer = new ExoPlayerImplInternal(renderers, trackSelector, this.emptyTrackSelectorResult, loadControl, bandwidthMeter, this.repeatMode, this.shuffleModeEnabled, analyticsCollector, seekParameters, livePlaybackSpeedControl, releaseTimeoutMs, pauseAtEndOfMediaItems, applicationLooper, clock, this.playbackInfoUpdateListener);
    }

    public void experimentalSetForegroundModeTimeoutMs(long timeoutMs) {
        this.internalPlayer.experimentalSetForegroundModeTimeoutMs(timeoutMs);
    }

    @Override
    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.internalPlayer.experimentalSetOffloadSchedulingEnabled(offloadSchedulingEnabled);
    }

    @Override
    public boolean experimentalIsSleepingForOffload() {
        return this.playbackInfo.sleepingForOffload;
    }

    @Override
    @Nullable
    public ExoPlayer.AudioComponent getAudioComponent() {
        return null;
    }

    @Override
    @Nullable
    public ExoPlayer.VideoComponent getVideoComponent() {
        return null;
    }

    @Override
    @Nullable
    public ExoPlayer.TextComponent getTextComponent() {
        return null;
    }

    @Override
    @Nullable
    public ExoPlayer.MetadataComponent getMetadataComponent() {
        return null;
    }

    @Override
    @Nullable
    public ExoPlayer.DeviceComponent getDeviceComponent() {
        return null;
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    public Looper getApplicationLooper() {
        return this.applicationLooper;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    public void addListener(Player.Listener listener) {
        Player.Listener eventListener = listener;
        this.addListener((Player.EventListener)eventListener);
    }

    public void addListener(Player.EventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Player.Listener listener) {
        Player.Listener eventListener = listener;
        this.removeListener((Player.EventListener)eventListener);
    }

    public void removeListener(Player.EventListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void addAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.audioOffloadListeners.add(listener);
    }

    @Override
    public void removeAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.audioOffloadListeners.remove(listener);
    }

    public Player.Commands getAvailableCommands() {
        return this.availableCommands;
    }

    public int getPlaybackState() {
        return this.playbackInfo.playbackState;
    }

    public int getPlaybackSuppressionReason() {
        return this.playbackInfo.playbackSuppressionReason;
    }

    @Nullable
    public ExoPlaybackException getPlayerError() {
        return this.playbackInfo.playbackError;
    }

    @Override
    @Deprecated
    public void retry() {
        this.prepare();
    }

    public void prepare() {
        if (this.playbackInfo.playbackState != 1) {
            return;
        }
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlaybackError(null);
        playbackInfo = playbackInfo.copyWithPlaybackState(playbackInfo.timeline.isEmpty() ? 4 : 2);
        ++this.pendingOperationAcks;
        this.internalPlayer.prepare();
        this.updatePlaybackInfo(playbackInfo, 1, 1, false, false, 5, -9223372036854775807L, -1);
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.setMediaSource(mediaSource);
        this.prepare();
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.setMediaSource(mediaSource, resetPosition);
        this.prepare();
    }

    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.setMediaSources(this.createMediaSources(mediaItems), resetPosition);
    }

    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.setMediaSources(this.createMediaSources(mediaItems), startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        this.setMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, long startPositionMs) {
        this.setMediaSources(Collections.singletonList(mediaSource), 0, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, boolean resetPosition) {
        this.setMediaSources(Collections.singletonList(mediaSource), resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources) {
        this.setMediaSources(mediaSources, true);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, boolean resetPosition) {
        this.setMediaSourcesInternal(mediaSources, -1, -9223372036854775807L, resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs) {
        this.setMediaSourcesInternal(mediaSources, startWindowIndex, startPositionMs, false);
    }

    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        index = Math.min(index, this.mediaSourceHolderSnapshots.size());
        this.addMediaSources(index, this.createMediaSources(mediaItems));
    }

    @Override
    public void addMediaSource(MediaSource mediaSource) {
        this.addMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSource(int index, MediaSource mediaSource) {
        this.addMediaSources(index, Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSources(List<MediaSource> mediaSources) {
        this.addMediaSources(this.mediaSourceHolderSnapshots.size(), mediaSources);
    }

    @Override
    public void addMediaSources(int index, List<MediaSource> mediaSources) {
        Assertions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(index, mediaSources);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.addMediaSources(index, holders, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    public void removeMediaItems(int fromIndex, int toIndex) {
        toIndex = Math.min(toIndex, this.mediaSourceHolderSnapshots.size());
        PlaybackInfo newPlaybackInfo = this.removeMediaItemsInternal(fromIndex, toIndex);
        boolean positionDiscontinuity = !newPlaybackInfo.periodId.periodUid.equals(this.playbackInfo.periodId.periodUid);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(newPlaybackInfo), -1);
    }

    public void moveMediaItems(int fromIndex, int toIndex, int newFromIndex) {
        Assertions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.mediaSourceHolderSnapshots.size() && newFromIndex >= 0 ? 1 : 0) != 0);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        newFromIndex = Math.min(newFromIndex, this.mediaSourceHolderSnapshots.size() - (toIndex - fromIndex));
        Util.moveItems(this.mediaSourceHolderSnapshots, (int)fromIndex, (int)toIndex, (int)newFromIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.moveMediaSources(fromIndex, toIndex, newFromIndex, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    @Override
    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        Timeline timeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, this.getCurrentWindowIndex(), this.getCurrentPosition()));
        ++this.pendingOperationAcks;
        this.shuffleOrder = shuffleOrder;
        this.internalPlayer.setShuffleOrder(shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.setPlayWhenReady(playWhenReady, 0, 1);
    }

    @Override
    public void setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
        if (this.pauseAtEndOfMediaItems == pauseAtEndOfMediaItems) {
            return;
        }
        this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
        this.internalPlayer.setPauseAtEndOfWindow(pauseAtEndOfMediaItems);
    }

    @Override
    public boolean getPauseAtEndOfMediaItems() {
        return this.pauseAtEndOfMediaItems;
    }

    public void setPlayWhenReady(boolean playWhenReady, int playbackSuppressionReason, int playWhenReadyChangeReason) {
        if (this.playbackInfo.playWhenReady == playWhenReady && this.playbackInfo.playbackSuppressionReason == playbackSuppressionReason) {
            return;
        }
        ++this.pendingOperationAcks;
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.internalPlayer.setPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.updatePlaybackInfo(playbackInfo, 0, playWhenReadyChangeReason, false, false, 5, -9223372036854775807L, -1);
    }

    public boolean getPlayWhenReady() {
        return this.playbackInfo.playWhenReady;
    }

    public void setRepeatMode(int repeatMode) {
        if (this.repeatMode != repeatMode) {
            this.repeatMode = repeatMode;
            this.internalPlayer.setRepeatMode(repeatMode);
            this.listeners.queueEvent(9, listener -> listener.onRepeatModeChanged(repeatMode));
            this.updateAvailableCommands();
            this.listeners.flushEvents();
        }
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        if (this.shuffleModeEnabled != shuffleModeEnabled) {
            this.shuffleModeEnabled = shuffleModeEnabled;
            this.internalPlayer.setShuffleModeEnabled(shuffleModeEnabled);
            this.listeners.queueEvent(10, listener -> listener.onShuffleModeEnabledChanged(shuffleModeEnabled));
            this.updateAvailableCommands();
            this.listeners.flushEvents();
        }
    }

    public boolean getShuffleModeEnabled() {
        return this.shuffleModeEnabled;
    }

    public boolean isLoading() {
        return this.playbackInfo.isLoading;
    }

    public void seekTo(int windowIndex, long positionMs) {
        Timeline timeline = this.playbackInfo.timeline;
        if (windowIndex < 0 || !timeline.isEmpty() && windowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, windowIndex, positionMs);
        }
        ++this.pendingOperationAcks;
        if (this.isPlayingAd()) {
            Log.w((String)TAG, (String)"seekTo ignored because an ad is playing");
            ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate = new ExoPlayerImplInternal.PlaybackInfoUpdate(this.playbackInfo);
            playbackInfoUpdate.incrementPendingOperationAcks(1);
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(playbackInfoUpdate);
            return;
        }
        int newPlaybackState = this.getPlaybackState() == 1 ? 1 : 2;
        int oldMaskingWindowIndex = this.getCurrentWindowIndex();
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackState(newPlaybackState);
        newPlaybackInfo = this.maskTimelineAndPosition(newPlaybackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, windowIndex, positionMs));
        this.internalPlayer.seekTo(timeline, windowIndex, C.msToUs((long)positionMs));
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, true, true, 1, this.getCurrentPositionUsInternal(newPlaybackInfo), oldMaskingWindowIndex);
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        if (playbackParameters == null) {
            playbackParameters = PlaybackParameters.DEFAULT;
        }
        if (this.playbackInfo.playbackParameters.equals((Object)playbackParameters)) {
            return;
        }
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        ++this.pendingOperationAcks;
        this.internalPlayer.setPlaybackParameters(playbackParameters);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    public PlaybackParameters getPlaybackParameters() {
        return this.playbackInfo.playbackParameters;
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        if (seekParameters == null) {
            seekParameters = SeekParameters.DEFAULT;
        }
        if (!this.seekParameters.equals(seekParameters)) {
            this.seekParameters = seekParameters;
            this.internalPlayer.setSeekParameters(seekParameters);
        }
    }

    @Override
    public SeekParameters getSeekParameters() {
        return this.seekParameters;
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!this.internalPlayer.setForegroundMode(foregroundMode)) {
                this.stop(false, ExoPlaybackException.createForRenderer((Exception)new ExoTimeoutException(2)));
            }
        }
    }

    public void stop(boolean reset) {
        this.stop(reset, null);
    }

    public void stop(boolean reset, @Nullable ExoPlaybackException error) {
        PlaybackInfo playbackInfo;
        if (reset) {
            playbackInfo = this.removeMediaItemsInternal(0, this.mediaSourceHolderSnapshots.size());
            playbackInfo = playbackInfo.copyWithPlaybackError(null);
        } else {
            playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            playbackInfo.totalBufferedDurationUs = 0L;
        }
        playbackInfo = playbackInfo.copyWithPlaybackState(1);
        if (error != null) {
            playbackInfo = playbackInfo.copyWithPlaybackError(error);
        }
        ++this.pendingOperationAcks;
        this.internalPlayer.stop();
        boolean positionDiscontinuity = playbackInfo.timeline.isEmpty() && !this.playbackInfo.timeline.isEmpty();
        this.updatePlaybackInfo(playbackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(playbackInfo), -1);
    }

    public void release() {
        String string = Integer.toHexString(System.identityHashCode(this));
        String string2 = Util.DEVICE_DEBUG_INFO;
        String string3 = ExoPlayerLibraryInfo.registeredModules();
        Log.i((String)TAG, (String)new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Release ").append(string).append(" [").append("ExoPlayerLib/2.14.1").append("] [").append(string2).append("] [").append(string3).append("]").toString());
        if (!this.internalPlayer.release()) {
            this.listeners.sendEvent(11, listener -> listener.onPlayerError(ExoPlaybackException.createForRenderer((Exception)new ExoTimeoutException(1))));
        }
        this.listeners.release();
        this.playbackInfoUpdateHandler.removeCallbacksAndMessages(null);
        if (this.analyticsCollector != null) {
            this.bandwidthMeter.removeEventListener(this.analyticsCollector);
        }
        this.playbackInfo = this.playbackInfo.copyWithPlaybackState(1);
        this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
        this.playbackInfo.bufferedPositionUs = this.playbackInfo.positionUs;
        this.playbackInfo.totalBufferedDurationUs = 0L;
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        return new PlayerMessage(this.internalPlayer, target, this.playbackInfo.timeline, this.getCurrentWindowIndex(), this.clock, this.internalPlayer.getPlaybackLooper());
    }

    public int getCurrentPeriodIndex() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingPeriodIndex;
        }
        return this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
    }

    public int getCurrentWindowIndex() {
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        return currentWindowIndex == -1 ? 0 : currentWindowIndex;
    }

    public long getDuration() {
        if (this.isPlayingAd()) {
            MediaSource.MediaPeriodId periodId = this.playbackInfo.periodId;
            this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
            long adDurationUs = this.period.getAdDurationUs(periodId.adGroupIndex, periodId.adIndexInAdGroup);
            return C.usToMs((long)adDurationUs);
        }
        return this.getContentDuration();
    }

    public long getCurrentPosition() {
        return C.usToMs((long)this.getCurrentPositionUsInternal(this.playbackInfo));
    }

    public long getBufferedPosition() {
        if (this.isPlayingAd()) {
            return this.playbackInfo.loadingMediaPeriodId.equals((Object)this.playbackInfo.periodId) ? C.usToMs((long)this.playbackInfo.bufferedPositionUs) : this.getDuration();
        }
        return this.getContentBufferedPosition();
    }

    public long getTotalBufferedDuration() {
        return C.usToMs((long)this.playbackInfo.totalBufferedDurationUs);
    }

    public boolean isPlayingAd() {
        return this.playbackInfo.periodId.isAd();
    }

    public int getCurrentAdGroupIndex() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adGroupIndex : -1;
    }

    public int getCurrentAdIndexInAdGroup() {
        return this.isPlayingAd() ? this.playbackInfo.periodId.adIndexInAdGroup : -1;
    }

    public long getContentPosition() {
        if (this.isPlayingAd()) {
            this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
            return this.playbackInfo.requestedContentPositionUs == -9223372036854775807L ? this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDefaultPositionMs() : this.period.getPositionInWindowMs() + C.usToMs((long)this.playbackInfo.requestedContentPositionUs);
        }
        return this.getCurrentPosition();
    }

    public long getContentBufferedPosition() {
        Timeline.Period loadingPeriod;
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.loadingMediaPeriodId.windowSequenceNumber != this.playbackInfo.periodId.windowSequenceNumber) {
            return this.playbackInfo.timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
        }
        long contentBufferedPositionUs = this.playbackInfo.bufferedPositionUs;
        if (this.playbackInfo.loadingMediaPeriodId.isAd() && (contentBufferedPositionUs = (loadingPeriod = this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.loadingMediaPeriodId.periodUid, this.period)).getAdGroupTimeUs(this.playbackInfo.loadingMediaPeriodId.adGroupIndex)) == Long.MIN_VALUE) {
            contentBufferedPositionUs = loadingPeriod.durationUs;
        }
        return C.usToMs((long)this.periodPositionUsToWindowPositionUs(this.playbackInfo.timeline, this.playbackInfo.loadingMediaPeriodId, contentBufferedPositionUs));
    }

    @Override
    public int getRendererCount() {
        return this.renderers.length;
    }

    @Override
    public int getRendererType(int index) {
        return this.renderers[index].getTrackType();
    }

    @Override
    @Nullable
    public TrackSelector getTrackSelector() {
        return this.trackSelector;
    }

    public TrackGroupArray getCurrentTrackGroups() {
        return this.playbackInfo.trackGroups;
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        return new TrackSelectionArray((TrackSelection[])this.playbackInfo.trackSelectorResult.selections);
    }

    public List<Metadata> getCurrentStaticMetadata() {
        return this.playbackInfo.staticMetadata;
    }

    public MediaMetadata getMediaMetadata() {
        return this.mediaMetadata;
    }

    public void onMetadata(Metadata metadata) {
        MediaMetadata newMediaMetadata = this.mediaMetadata.buildUpon().populateFromMetadata(metadata).build();
        if (newMediaMetadata.equals((Object)this.mediaMetadata)) {
            return;
        }
        this.mediaMetadata = newMediaMetadata;
        this.listeners.sendEvent(15, listener -> listener.onMediaMetadataChanged(this.mediaMetadata));
    }

    public Timeline getCurrentTimeline() {
        return this.playbackInfo.timeline;
    }

    public AudioAttributes getAudioAttributes() {
        return AudioAttributes.DEFAULT;
    }

    public void setVolume(float audioVolume) {
    }

    public float getVolume() {
        return 1.0f;
    }

    public void clearVideoSurface() {
    }

    public void clearVideoSurface(@Nullable Surface surface) {
    }

    public void setVideoSurface(@Nullable Surface surface) {
    }

    public void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
    }

    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
    }

    public void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
    }

    public void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
    }

    public void setVideoTextureView(@Nullable TextureView textureView) {
    }

    public void clearVideoTextureView(@Nullable TextureView textureView) {
    }

    public VideoSize getVideoSize() {
        return VideoSize.UNKNOWN;
    }

    public ImmutableList<Cue> getCurrentCues() {
        return ImmutableList.of();
    }

    public DeviceInfo getDeviceInfo() {
        return DeviceInfo.UNKNOWN;
    }

    public int getDeviceVolume() {
        return 0;
    }

    public boolean isDeviceMuted() {
        return false;
    }

    public void setDeviceVolume(int volume) {
    }

    public void increaseDeviceVolume() {
    }

    public void decreaseDeviceVolume() {
    }

    public void setDeviceMuted(boolean muted) {
    }

    private int getCurrentWindowIndexInternal() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowIndex;
        }
        return this.playbackInfo.timeline.getPeriodByUid((Object)this.playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
    }

    private long getCurrentPositionUsInternal(PlaybackInfo playbackInfo) {
        if (playbackInfo.timeline.isEmpty()) {
            return C.msToUs((long)this.maskingWindowPositionMs);
        }
        if (playbackInfo.periodId.isAd()) {
            return playbackInfo.positionUs;
        }
        return this.periodPositionUsToWindowPositionUs(playbackInfo.timeline, playbackInfo.periodId, playbackInfo.positionUs);
    }

    private List<MediaSource> createMediaSources(List<MediaItem> mediaItems) {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (int i = 0; i < mediaItems.size(); ++i) {
            mediaSources.add(this.mediaSourceFactory.createMediaSource(mediaItems.get(i)));
        }
        return mediaSources;
    }

    private void handlePlaybackInfo(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.pendingOperationAcks -= playbackInfoUpdate.operationAcks;
        if (playbackInfoUpdate.positionDiscontinuity) {
            this.pendingDiscontinuityReason = playbackInfoUpdate.discontinuityReason;
            this.pendingDiscontinuity = true;
        }
        if (playbackInfoUpdate.hasPlayWhenReadyChangeReason) {
            this.pendingPlayWhenReadyChangeReason = playbackInfoUpdate.playWhenReadyChangeReason;
        }
        if (this.pendingOperationAcks == 0) {
            Timeline newTimeline = playbackInfoUpdate.playbackInfo.timeline;
            if (!this.playbackInfo.timeline.isEmpty() && newTimeline.isEmpty()) {
                this.maskingWindowIndex = -1;
                this.maskingWindowPositionMs = 0L;
                this.maskingPeriodIndex = 0;
            }
            if (!newTimeline.isEmpty()) {
                List<Timeline> timelines = ((PlaylistTimeline)newTimeline).getChildTimelines();
                Assertions.checkState((timelines.size() == this.mediaSourceHolderSnapshots.size() ? 1 : 0) != 0);
                for (int i = 0; i < timelines.size(); ++i) {
                    this.mediaSourceHolderSnapshots.get(i).timeline = timelines.get(i);
                }
            }
            boolean positionDiscontinuity = false;
            long discontinuityWindowStartPositionUs = -9223372036854775807L;
            if (this.pendingDiscontinuity) {
                boolean bl = positionDiscontinuity = !playbackInfoUpdate.playbackInfo.periodId.equals((Object)this.playbackInfo.periodId) || playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs != this.playbackInfo.positionUs;
                if (positionDiscontinuity) {
                    discontinuityWindowStartPositionUs = newTimeline.isEmpty() || playbackInfoUpdate.playbackInfo.periodId.isAd() ? playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs : this.periodPositionUsToWindowPositionUs(newTimeline, playbackInfoUpdate.playbackInfo.periodId, playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs);
                }
            }
            this.pendingDiscontinuity = false;
            this.updatePlaybackInfo(playbackInfoUpdate.playbackInfo, 1, this.pendingPlayWhenReadyChangeReason, false, positionDiscontinuity, this.pendingDiscontinuityReason, discontinuityWindowStartPositionUs, -1);
        }
    }

    private void updatePlaybackInfo(PlaybackInfo playbackInfo, int timelineChangeReason, int playWhenReadyChangeReason, boolean seekProcessed, boolean positionDiscontinuity, int positionDiscontinuityReason, long discontinuityWindowStartPositionUs, int oldMaskingWindowIndex) {
        PlaybackInfo previousPlaybackInfo = this.playbackInfo;
        PlaybackInfo newPlaybackInfo = playbackInfo;
        this.playbackInfo = playbackInfo;
        Pair<Boolean, Integer> mediaItemTransitionInfo = this.evaluateMediaItemTransitionReason(newPlaybackInfo, previousPlaybackInfo, positionDiscontinuity, positionDiscontinuityReason, !previousPlaybackInfo.timeline.equals((Object)newPlaybackInfo.timeline));
        boolean mediaItemTransitioned = (Boolean)mediaItemTransitionInfo.first;
        int mediaItemTransitionReason = (Integer)mediaItemTransitionInfo.second;
        MediaMetadata newMediaMetadata = this.mediaMetadata;
        MediaItem mediaItem = null;
        if (mediaItemTransitioned) {
            if (!newPlaybackInfo.timeline.isEmpty()) {
                int windowIndex = newPlaybackInfo.timeline.getPeriodByUid((Object)newPlaybackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
                mediaItem = newPlaybackInfo.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).mediaItem;
            }
            MediaMetadata mediaMetadata = this.mediaMetadata = mediaItem != null ? mediaItem.mediaMetadata : MediaMetadata.EMPTY;
        }
        if (!previousPlaybackInfo.staticMetadata.equals(newPlaybackInfo.staticMetadata)) {
            newMediaMetadata = newMediaMetadata.buildUpon().populateFromMetadata(newPlaybackInfo.staticMetadata).build();
        }
        boolean metadataChanged = !newMediaMetadata.equals((Object)this.mediaMetadata);
        this.mediaMetadata = newMediaMetadata;
        if (!previousPlaybackInfo.timeline.equals((Object)newPlaybackInfo.timeline)) {
            this.listeners.queueEvent(0, listener -> {
                Object manifest = null;
                if (newPlaybackInfo.timeline.getWindowCount() == 1) {
                    Timeline.Window window = new Timeline.Window();
                    manifest = newPlaybackInfo.timeline.getWindow((int)0, (Timeline.Window)window).manifest;
                }
                listener.onTimelineChanged(newPlaybackInfo.timeline, manifest, timelineChangeReason);
                listener.onTimelineChanged(newPlaybackInfo.timeline, timelineChangeReason);
            });
        }
        if (positionDiscontinuity) {
            Player.PositionInfo previousPositionInfo = this.getPreviousPositionInfo(positionDiscontinuityReason, previousPlaybackInfo, oldMaskingWindowIndex);
            Player.PositionInfo positionInfo = this.getPositionInfo(discontinuityWindowStartPositionUs);
            this.listeners.queueEvent(12, listener -> {
                listener.onPositionDiscontinuity(positionDiscontinuityReason);
                listener.onPositionDiscontinuity(previousPositionInfo, positionInfo, positionDiscontinuityReason);
            });
        }
        if (mediaItemTransitioned) {
            MediaItem finalMediaItem = mediaItem;
            this.listeners.queueEvent(1, listener -> listener.onMediaItemTransition(finalMediaItem, mediaItemTransitionReason));
        }
        if (previousPlaybackInfo.playbackError != newPlaybackInfo.playbackError && newPlaybackInfo.playbackError != null) {
            this.listeners.queueEvent(11, listener -> listener.onPlayerError(newPlaybackInfo.playbackError));
        }
        if (previousPlaybackInfo.trackSelectorResult != newPlaybackInfo.trackSelectorResult) {
            this.trackSelector.onSelectionActivated(newPlaybackInfo.trackSelectorResult.info);
            TrackSelectionArray newSelection = new TrackSelectionArray((TrackSelection[])newPlaybackInfo.trackSelectorResult.selections);
            this.listeners.queueEvent(2, listener -> listener.onTracksChanged(newPlaybackInfo.trackGroups, newSelection));
        }
        if (!previousPlaybackInfo.staticMetadata.equals(newPlaybackInfo.staticMetadata)) {
            this.listeners.queueEvent(3, listener -> listener.onStaticMetadataChanged(newPlaybackInfo.staticMetadata));
        }
        if (metadataChanged) {
            MediaMetadata finalMediaMetadata = this.mediaMetadata;
            this.listeners.queueEvent(15, listener -> listener.onMediaMetadataChanged(finalMediaMetadata));
        }
        if (previousPlaybackInfo.isLoading != newPlaybackInfo.isLoading) {
            this.listeners.queueEvent(4, listener -> {
                listener.onLoadingChanged(newPlaybackInfo.isLoading);
                listener.onIsLoadingChanged(newPlaybackInfo.isLoading);
            });
        }
        if (previousPlaybackInfo.playbackState != newPlaybackInfo.playbackState || previousPlaybackInfo.playWhenReady != newPlaybackInfo.playWhenReady) {
            this.listeners.queueEvent(-1, listener -> listener.onPlayerStateChanged(newPlaybackInfo.playWhenReady, newPlaybackInfo.playbackState));
        }
        if (previousPlaybackInfo.playbackState != newPlaybackInfo.playbackState) {
            this.listeners.queueEvent(5, listener -> listener.onPlaybackStateChanged(newPlaybackInfo.playbackState));
        }
        if (previousPlaybackInfo.playWhenReady != newPlaybackInfo.playWhenReady) {
            this.listeners.queueEvent(6, listener -> listener.onPlayWhenReadyChanged(newPlaybackInfo.playWhenReady, playWhenReadyChangeReason));
        }
        if (previousPlaybackInfo.playbackSuppressionReason != newPlaybackInfo.playbackSuppressionReason) {
            this.listeners.queueEvent(7, listener -> listener.onPlaybackSuppressionReasonChanged(newPlaybackInfo.playbackSuppressionReason));
        }
        if (ExoPlayerImpl.isPlaying(previousPlaybackInfo) != ExoPlayerImpl.isPlaying(newPlaybackInfo)) {
            this.listeners.queueEvent(8, listener -> listener.onIsPlayingChanged(ExoPlayerImpl.isPlaying(newPlaybackInfo)));
        }
        if (!previousPlaybackInfo.playbackParameters.equals((Object)newPlaybackInfo.playbackParameters)) {
            this.listeners.queueEvent(13, listener -> listener.onPlaybackParametersChanged(newPlaybackInfo.playbackParameters));
        }
        if (seekProcessed) {
            this.listeners.queueEvent(-1, Player.EventListener::onSeekProcessed);
        }
        this.updateAvailableCommands();
        this.listeners.flushEvents();
        if (previousPlaybackInfo.offloadSchedulingEnabled != newPlaybackInfo.offloadSchedulingEnabled) {
            for (ExoPlayer.AudioOffloadListener listener2 : this.audioOffloadListeners) {
                listener2.onExperimentalOffloadSchedulingEnabledChanged(newPlaybackInfo.offloadSchedulingEnabled);
            }
        }
        if (previousPlaybackInfo.sleepingForOffload != newPlaybackInfo.sleepingForOffload) {
            for (ExoPlayer.AudioOffloadListener listener2 : this.audioOffloadListeners) {
                listener2.onExperimentalSleepingForOffloadChanged(newPlaybackInfo.sleepingForOffload);
            }
        }
    }

    private Player.PositionInfo getPreviousPositionInfo(int positionDiscontinuityReason, PlaybackInfo oldPlaybackInfo, int oldMaskingWindowIndex) {
        long oldContentPositionUs;
        long oldPositionUs;
        Object oldWindowUid = null;
        Object oldPeriodUid = null;
        int oldWindowIndex = oldMaskingWindowIndex;
        int oldPeriodIndex = -1;
        Timeline.Period oldPeriod = new Timeline.Period();
        if (!oldPlaybackInfo.timeline.isEmpty()) {
            oldPeriodUid = oldPlaybackInfo.periodId.periodUid;
            oldPlaybackInfo.timeline.getPeriodByUid(oldPeriodUid, oldPeriod);
            oldWindowIndex = oldPeriod.windowIndex;
            oldPeriodIndex = oldPlaybackInfo.timeline.getIndexOfPeriod(oldPeriodUid);
            oldWindowUid = oldPlaybackInfo.timeline.getWindow((int)oldWindowIndex, (Timeline.Window)this.window).uid;
        }
        if (positionDiscontinuityReason == 0) {
            oldContentPositionUs = oldPositionUs = oldPeriod.positionInWindowUs + oldPeriod.durationUs;
            if (oldPlaybackInfo.periodId.isAd()) {
                oldPositionUs = oldPeriod.getAdDurationUs(oldPlaybackInfo.periodId.adGroupIndex, oldPlaybackInfo.periodId.adIndexInAdGroup);
                oldContentPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(oldPlaybackInfo);
            } else if (oldPlaybackInfo.periodId.nextAdGroupIndex != -1 && this.playbackInfo.periodId.isAd()) {
                oldContentPositionUs = oldPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(this.playbackInfo);
            }
        } else if (oldPlaybackInfo.periodId.isAd()) {
            oldPositionUs = oldPlaybackInfo.positionUs;
            oldContentPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(oldPlaybackInfo);
        } else {
            oldContentPositionUs = oldPositionUs = oldPeriod.positionInWindowUs + oldPlaybackInfo.positionUs;
        }
        return new Player.PositionInfo(oldWindowUid, oldWindowIndex, oldPeriodUid, oldPeriodIndex, C.usToMs((long)oldPositionUs), C.usToMs((long)oldContentPositionUs), oldPlaybackInfo.periodId.adGroupIndex, oldPlaybackInfo.periodId.adIndexInAdGroup);
    }

    private Player.PositionInfo getPositionInfo(long discontinuityWindowStartPositionUs) {
        Object newWindowUid = null;
        Object newPeriodUid = null;
        int newWindowIndex = this.getCurrentWindowIndex();
        int newPeriodIndex = -1;
        if (!this.playbackInfo.timeline.isEmpty()) {
            newPeriodUid = this.playbackInfo.periodId.periodUid;
            this.playbackInfo.timeline.getPeriodByUid(newPeriodUid, this.period);
            newPeriodIndex = this.playbackInfo.timeline.getIndexOfPeriod(newPeriodUid);
            newWindowUid = this.playbackInfo.timeline.getWindow((int)newWindowIndex, (Timeline.Window)this.window).uid;
        }
        long positionMs = C.usToMs((long)discontinuityWindowStartPositionUs);
        return new Player.PositionInfo(newWindowUid, newWindowIndex, newPeriodUid, newPeriodIndex, positionMs, this.playbackInfo.periodId.isAd() ? C.usToMs((long)ExoPlayerImpl.getRequestedContentPositionUs(this.playbackInfo)) : positionMs, this.playbackInfo.periodId.adGroupIndex, this.playbackInfo.periodId.adIndexInAdGroup);
    }

    private static long getRequestedContentPositionUs(PlaybackInfo playbackInfo) {
        Timeline.Window window = new Timeline.Window();
        Timeline.Period period = new Timeline.Period();
        playbackInfo.timeline.getPeriodByUid(playbackInfo.periodId.periodUid, period);
        return playbackInfo.requestedContentPositionUs == -9223372036854775807L ? playbackInfo.timeline.getWindow(period.windowIndex, window).getDefaultPositionUs() : period.getPositionInWindowUs() + playbackInfo.requestedContentPositionUs;
    }

    private Pair<Boolean, Integer> evaluateMediaItemTransitionReason(PlaybackInfo playbackInfo, PlaybackInfo oldPlaybackInfo, boolean positionDiscontinuity, int positionDiscontinuityReason, boolean timelineChanged) {
        Timeline oldTimeline = oldPlaybackInfo.timeline;
        Timeline newTimeline = playbackInfo.timeline;
        if (newTimeline.isEmpty() && oldTimeline.isEmpty()) {
            return new Pair((Object)false, (Object)-1);
        }
        if (newTimeline.isEmpty() != oldTimeline.isEmpty()) {
            return new Pair((Object)true, (Object)3);
        }
        int oldWindowIndex = oldTimeline.getPeriodByUid((Object)oldPlaybackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object oldWindowUid = oldTimeline.getWindow((int)oldWindowIndex, (Timeline.Window)this.window).uid;
        int newWindowIndex = newTimeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object newWindowUid = newTimeline.getWindow((int)newWindowIndex, (Timeline.Window)this.window).uid;
        if (!oldWindowUid.equals(newWindowUid)) {
            int transitionReason;
            if (positionDiscontinuity && positionDiscontinuityReason == 0) {
                transitionReason = 1;
            } else if (positionDiscontinuity && positionDiscontinuityReason == 1) {
                transitionReason = 2;
            } else if (timelineChanged) {
                transitionReason = 3;
            } else {
                throw new IllegalStateException();
            }
            return new Pair((Object)true, (Object)transitionReason);
        }
        if (positionDiscontinuity && positionDiscontinuityReason == 0 && oldPlaybackInfo.periodId.windowSequenceNumber < playbackInfo.periodId.windowSequenceNumber) {
            return new Pair((Object)true, (Object)0);
        }
        return new Pair((Object)false, (Object)-1);
    }

    private void updateAvailableCommands() {
        Player.Commands previousAvailableCommands = this.availableCommands;
        this.availableCommands = this.getAvailableCommands(this.permanentAvailableCommands);
        if (!this.availableCommands.equals((Object)previousAvailableCommands)) {
            this.listeners.queueEvent(14, listener -> listener.onAvailableCommandsChanged(this.availableCommands));
        }
    }

    private void setMediaSourcesInternal(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs, boolean resetToDefaultPosition) {
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        long currentPositionMs = this.getCurrentPosition();
        ++this.pendingOperationAcks;
        if (!this.mediaSourceHolderSnapshots.isEmpty()) {
            this.removeMediaSourceHolders(0, this.mediaSourceHolderSnapshots.size());
        }
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(0, mediaSources);
        Timeline timeline = this.createMaskingTimeline();
        if (!timeline.isEmpty() && startWindowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, startWindowIndex, startPositionMs);
        }
        if (resetToDefaultPosition) {
            startWindowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            startPositionMs = -9223372036854775807L;
        } else if (startWindowIndex == -1) {
            startWindowIndex = currentWindowIndex;
            startPositionMs = currentPositionMs;
        }
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.getPeriodPositionOrMaskWindowPosition(timeline, startWindowIndex, startPositionMs));
        int maskingPlaybackState = newPlaybackInfo.playbackState;
        if (startWindowIndex != -1 && newPlaybackInfo.playbackState != 1) {
            maskingPlaybackState = timeline.isEmpty() || startWindowIndex >= timeline.getWindowCount() ? 4 : 2;
        }
        newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(maskingPlaybackState);
        this.internalPlayer.setMediaSources(holders, startWindowIndex, C.msToUs((long)startPositionMs), this.shuffleOrder);
        boolean positionDiscontinuity = !this.playbackInfo.periodId.periodUid.equals(newPlaybackInfo.periodId.periodUid) && !this.playbackInfo.timeline.isEmpty();
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(newPlaybackInfo), -1);
    }

    private List<MediaSourceList.MediaSourceHolder> addMediaSourceHolders(int index, List<MediaSource> mediaSources) {
        ArrayList<MediaSourceList.MediaSourceHolder> holders = new ArrayList<MediaSourceList.MediaSourceHolder>();
        for (int i = 0; i < mediaSources.size(); ++i) {
            MediaSourceList.MediaSourceHolder holder = new MediaSourceList.MediaSourceHolder(mediaSources.get(i), this.useLazyPreparation);
            holders.add(holder);
            this.mediaSourceHolderSnapshots.add(i + index, new MediaSourceHolderSnapshot(holder.uid, holder.mediaSource.getTimeline()));
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndInsert(index, holders.size());
        return holders;
    }

    private PlaybackInfo removeMediaItemsInternal(int fromIndex, int toIndex) {
        boolean transitionsToEnded;
        Assertions.checkArgument((fromIndex >= 0 && toIndex >= fromIndex && toIndex <= this.mediaSourceHolderSnapshots.size() ? 1 : 0) != 0);
        int currentWindowIndex = this.getCurrentWindowIndex();
        Timeline oldTimeline = this.getCurrentTimeline();
        int currentMediaSourceCount = this.mediaSourceHolderSnapshots.size();
        ++this.pendingOperationAcks;
        this.removeMediaSourceHolders(fromIndex, toIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionAfterTimelineChanged(oldTimeline, newTimeline));
        boolean bl = transitionsToEnded = newPlaybackInfo.playbackState != 1 && newPlaybackInfo.playbackState != 4 && fromIndex < toIndex && toIndex == currentMediaSourceCount && currentWindowIndex >= newPlaybackInfo.timeline.getWindowCount();
        if (transitionsToEnded) {
            newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(4);
        }
        this.internalPlayer.removeMediaSources(fromIndex, toIndex, this.shuffleOrder);
        return newPlaybackInfo;
    }

    private void removeMediaSourceHolders(int fromIndex, int toIndexExclusive) {
        for (int i = toIndexExclusive - 1; i >= fromIndex; --i) {
            this.mediaSourceHolderSnapshots.remove(i);
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndRemove(fromIndex, toIndexExclusive);
    }

    private Timeline createMaskingTimeline() {
        return new PlaylistTimeline(this.mediaSourceHolderSnapshots, this.shuffleOrder);
    }

    private PlaybackInfo maskTimelineAndPosition(PlaybackInfo playbackInfo, Timeline timeline, @Nullable Pair<Object, Long> periodPosition) {
        Assertions.checkArgument((timeline.isEmpty() || periodPosition != null ? 1 : 0) != 0);
        Timeline oldTimeline = playbackInfo.timeline;
        playbackInfo = playbackInfo.copyWithTimeline(timeline);
        if (timeline.isEmpty()) {
            MediaSource.MediaPeriodId dummyMediaPeriodId = PlaybackInfo.getDummyPeriodForEmptyTimeline();
            long positionUs = C.msToUs((long)this.maskingWindowPositionMs);
            playbackInfo = playbackInfo.copyWithNewPosition(dummyMediaPeriodId, positionUs, positionUs, positionUs, 0L, TrackGroupArray.EMPTY, this.emptyTrackSelectorResult, (List<Metadata>)ImmutableList.of());
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(dummyMediaPeriodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            return playbackInfo;
        }
        Object oldPeriodUid = playbackInfo.periodId.periodUid;
        boolean playingPeriodChanged = !oldPeriodUid.equals(((Pair)Util.castNonNull(periodPosition)).first);
        MediaSource.MediaPeriodId newPeriodId = playingPeriodChanged ? new MediaSource.MediaPeriodId(periodPosition.first) : playbackInfo.periodId;
        long newContentPositionUs = (Long)periodPosition.second;
        long oldContentPositionUs = C.msToUs((long)this.getContentPosition());
        if (!oldTimeline.isEmpty()) {
            oldContentPositionUs -= oldTimeline.getPeriodByUid(oldPeriodUid, this.period).getPositionInWindowUs();
        }
        if (playingPeriodChanged || newContentPositionUs < oldContentPositionUs) {
            Assertions.checkState((!newPeriodId.isAd() ? 1 : 0) != 0);
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, newContentPositionUs, 0L, playingPeriodChanged ? TrackGroupArray.EMPTY : playbackInfo.trackGroups, playingPeriodChanged ? this.emptyTrackSelectorResult : playbackInfo.trackSelectorResult, (List<Metadata>)(playingPeriodChanged ? ImmutableList.of() : playbackInfo.staticMetadata));
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
            playbackInfo.bufferedPositionUs = newContentPositionUs;
        } else if (newContentPositionUs == oldContentPositionUs) {
            int loadingPeriodIndex = timeline.getIndexOfPeriod(playbackInfo.loadingMediaPeriodId.periodUid);
            if (loadingPeriodIndex == -1 || timeline.getPeriod((int)loadingPeriodIndex, (Timeline.Period)this.period).windowIndex != timeline.getPeriodByUid((Object)newPeriodId.periodUid, (Timeline.Period)this.period).windowIndex) {
                timeline.getPeriodByUid(newPeriodId.periodUid, this.period);
                long maskedBufferedPositionUs = newPeriodId.isAd() ? this.period.getAdDurationUs(newPeriodId.adGroupIndex, newPeriodId.adIndexInAdGroup) : this.period.durationUs;
                playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, playbackInfo.positionUs, playbackInfo.positionUs, playbackInfo.discontinuityStartPositionUs, maskedBufferedPositionUs - playbackInfo.positionUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata);
                playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
                playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
            }
        } else {
            Assertions.checkState((!newPeriodId.isAd() ? 1 : 0) != 0);
            long maskedTotalBufferedDurationUs = Math.max(0L, playbackInfo.totalBufferedDurationUs - (newContentPositionUs - oldContentPositionUs));
            long maskedBufferedPositionUs = playbackInfo.bufferedPositionUs;
            if (playbackInfo.loadingMediaPeriodId.equals((Object)playbackInfo.periodId)) {
                maskedBufferedPositionUs = newContentPositionUs + maskedTotalBufferedDurationUs;
            }
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, newContentPositionUs, maskedTotalBufferedDurationUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata);
            playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
        }
        return playbackInfo;
    }

    @Nullable
    private Pair<Object, Long> getPeriodPositionAfterTimelineChanged(Timeline oldTimeline, Timeline newTimeline) {
        long currentPositionMs = this.getContentPosition();
        if (oldTimeline.isEmpty() || newTimeline.isEmpty()) {
            boolean isCleared = !oldTimeline.isEmpty() && newTimeline.isEmpty();
            return this.getPeriodPositionOrMaskWindowPosition(newTimeline, isCleared ? -1 : this.getCurrentWindowIndexInternal(), isCleared ? -9223372036854775807L : currentPositionMs);
        }
        int currentWindowIndex = this.getCurrentWindowIndex();
        Pair oldPeriodPosition = oldTimeline.getPeriodPosition(this.window, this.period, currentWindowIndex, C.msToUs((long)currentPositionMs));
        Object periodUid = ((Pair)Util.castNonNull((Object)oldPeriodPosition)).first;
        if (newTimeline.getIndexOfPeriod(periodUid) != -1) {
            return oldPeriodPosition;
        }
        Object nextPeriodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(this.window, this.period, this.repeatMode, this.shuffleModeEnabled, periodUid, oldTimeline, newTimeline);
        if (nextPeriodUid != null) {
            newTimeline.getPeriodByUid(nextPeriodUid, this.period);
            return this.getPeriodPositionOrMaskWindowPosition(newTimeline, this.period.windowIndex, newTimeline.getWindow(this.period.windowIndex, this.window).getDefaultPositionMs());
        }
        return this.getPeriodPositionOrMaskWindowPosition(newTimeline, -1, -9223372036854775807L);
    }

    @Nullable
    private Pair<Object, Long> getPeriodPositionOrMaskWindowPosition(Timeline timeline, int windowIndex, long windowPositionMs) {
        if (timeline.isEmpty()) {
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = windowPositionMs == -9223372036854775807L ? 0L : windowPositionMs;
            this.maskingPeriodIndex = 0;
            return null;
        }
        if (windowIndex == -1 || windowIndex >= timeline.getWindowCount()) {
            windowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            windowPositionMs = timeline.getWindow(windowIndex, this.window).getDefaultPositionMs();
        }
        return timeline.getPeriodPosition(this.window, this.period, windowIndex, C.msToUs((long)windowPositionMs));
    }

    private long periodPositionUsToWindowPositionUs(Timeline timeline, MediaSource.MediaPeriodId periodId, long positionUs) {
        timeline.getPeriodByUid(periodId.periodUid, this.period);
        return positionUs += this.period.getPositionInWindowUs();
    }

    private static boolean isPlaying(PlaybackInfo playbackInfo) {
        return playbackInfo.playbackState == 3 && playbackInfo.playWhenReady && playbackInfo.playbackSuppressionReason == 0;
    }

    private static final class MediaSourceHolderSnapshot
    implements MediaSourceInfoHolder {
        private final Object uid;
        private Timeline timeline;

        public MediaSourceHolderSnapshot(Object uid, Timeline timeline) {
            this.uid = uid;
            this.timeline = timeline;
        }

        @Override
        public Object getUid() {
            return this.uid;
        }

        @Override
        public Timeline getTimeline() {
            return this.timeline;
        }
    }
}

