/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ClippingMediaPeriod;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class MediaPeriodHolder {
    private static final String TAG = "MediaPeriodHolder";
    public final MediaPeriod mediaPeriod;
    public final Object uid;
    public final @NullableType SampleStream[] sampleStreams;
    public boolean prepared;
    public boolean hasEnabledTracks;
    public MediaPeriodInfo info;
    public boolean allRenderersInCorrectState;
    private final boolean[] mayRetainStreamFlags;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector trackSelector;
    private final MediaSourceList mediaSourceList;
    @Nullable
    private MediaPeriodHolder next;
    private TrackGroupArray trackGroups;
    private TrackSelectorResult trackSelectorResult;
    private long rendererPositionOffsetUs;

    public MediaPeriodHolder(RendererCapabilities[] rendererCapabilities, long rendererPositionOffsetUs, TrackSelector trackSelector, Allocator allocator, MediaSourceList mediaSourceList, MediaPeriodInfo info, TrackSelectorResult emptyTrackSelectorResult) {
        this.rendererCapabilities = rendererCapabilities;
        this.rendererPositionOffsetUs = rendererPositionOffsetUs;
        this.trackSelector = trackSelector;
        this.mediaSourceList = mediaSourceList;
        this.uid = info.id.periodUid;
        this.info = info;
        this.trackGroups = TrackGroupArray.EMPTY;
        this.trackSelectorResult = emptyTrackSelectorResult;
        this.sampleStreams = new SampleStream[rendererCapabilities.length];
        this.mayRetainStreamFlags = new boolean[rendererCapabilities.length];
        this.mediaPeriod = MediaPeriodHolder.createMediaPeriod(info.id, mediaSourceList, allocator, info.startPositionUs, info.endPositionUs);
    }

    public long toRendererTime(long periodTimeUs) {
        return periodTimeUs + this.getRendererOffset();
    }

    public long toPeriodTime(long rendererTimeUs) {
        return rendererTimeUs - this.getRendererOffset();
    }

    public long getRendererOffset() {
        return this.rendererPositionOffsetUs;
    }

    public void setRendererOffset(long rendererPositionOffsetUs) {
        this.rendererPositionOffsetUs = rendererPositionOffsetUs;
    }

    public long getStartPositionRendererTime() {
        return this.info.startPositionUs + this.rendererPositionOffsetUs;
    }

    public boolean isFullyBuffered() {
        return this.prepared && (!this.hasEnabledTracks || this.mediaPeriod.getBufferedPositionUs() == Long.MIN_VALUE);
    }

    public long getBufferedPositionUs() {
        if (!this.prepared) {
            return this.info.startPositionUs;
        }
        long bufferedPositionUs = this.hasEnabledTracks ? this.mediaPeriod.getBufferedPositionUs() : Long.MIN_VALUE;
        return bufferedPositionUs == Long.MIN_VALUE ? this.info.durationUs : bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        return !this.prepared ? 0L : this.mediaPeriod.getNextLoadPositionUs();
    }

    public void handlePrepared(float playbackSpeed, Timeline timeline) throws ExoPlaybackException {
        this.prepared = true;
        this.trackGroups = this.mediaPeriod.getTrackGroups();
        TrackSelectorResult selectorResult = this.selectTracks(playbackSpeed, timeline);
        long requestedStartPositionUs = this.info.startPositionUs;
        if (this.info.durationUs != -9223372036854775807L && requestedStartPositionUs >= this.info.durationUs) {
            requestedStartPositionUs = Math.max(0L, this.info.durationUs - 1L);
        }
        long newStartPositionUs = this.applyTrackSelection(selectorResult, requestedStartPositionUs, false);
        this.rendererPositionOffsetUs += this.info.startPositionUs - newStartPositionUs;
        this.info = this.info.copyWithStartPositionUs(newStartPositionUs);
    }

    public void reevaluateBuffer(long rendererPositionUs) {
        Assertions.checkState((boolean)this.isLoadingMediaPeriod());
        if (this.prepared) {
            this.mediaPeriod.reevaluateBuffer(this.toPeriodTime(rendererPositionUs));
        }
    }

    public void continueLoading(long rendererPositionUs) {
        Assertions.checkState((boolean)this.isLoadingMediaPeriod());
        long loadingPeriodPositionUs = this.toPeriodTime(rendererPositionUs);
        this.mediaPeriod.continueLoading(loadingPeriodPositionUs);
    }

    public TrackSelectorResult selectTracks(float playbackSpeed, Timeline timeline) throws ExoPlaybackException {
        TrackSelectorResult selectorResult = this.trackSelector.selectTracks(this.rendererCapabilities, this.getTrackGroups(), this.info.id, timeline);
        for (ExoTrackSelection trackSelection : selectorResult.selections) {
            if (trackSelection == null) continue;
            trackSelection.onPlaybackSpeed(playbackSpeed);
        }
        return selectorResult;
    }

    public long applyTrackSelection(TrackSelectorResult trackSelectorResult, long positionUs, boolean forceRecreateStreams) {
        return this.applyTrackSelection(trackSelectorResult, positionUs, forceRecreateStreams, new boolean[this.rendererCapabilities.length]);
    }

    public long applyTrackSelection(TrackSelectorResult newTrackSelectorResult, long positionUs, boolean forceRecreateStreams, boolean[] streamResetFlags) {
        int i;
        for (i = 0; i < newTrackSelectorResult.length; ++i) {
            this.mayRetainStreamFlags[i] = !forceRecreateStreams && newTrackSelectorResult.isEquivalent(this.trackSelectorResult, i);
        }
        this.disassociateNoSampleRenderersWithEmptySampleStream(this.sampleStreams);
        this.disableTrackSelectionsInResult();
        this.trackSelectorResult = newTrackSelectorResult;
        this.enableTrackSelectionsInResult();
        positionUs = this.mediaPeriod.selectTracks(newTrackSelectorResult.selections, this.mayRetainStreamFlags, this.sampleStreams, streamResetFlags, positionUs);
        this.associateNoSampleRenderersWithEmptySampleStream(this.sampleStreams);
        this.hasEnabledTracks = false;
        for (i = 0; i < this.sampleStreams.length; ++i) {
            if (this.sampleStreams[i] != null) {
                Assertions.checkState((boolean)newTrackSelectorResult.isRendererEnabled(i));
                if (this.rendererCapabilities[i].getTrackType() == 7) continue;
                this.hasEnabledTracks = true;
                continue;
            }
            Assertions.checkState((newTrackSelectorResult.selections[i] == null ? 1 : 0) != 0);
        }
        return positionUs;
    }

    public void release() {
        this.disableTrackSelectionsInResult();
        MediaPeriodHolder.releaseMediaPeriod(this.info.endPositionUs, this.mediaSourceList, this.mediaPeriod);
    }

    public void setNext(@Nullable MediaPeriodHolder nextMediaPeriodHolder) {
        if (nextMediaPeriodHolder == this.next) {
            return;
        }
        this.disableTrackSelectionsInResult();
        this.next = nextMediaPeriodHolder;
        this.enableTrackSelectionsInResult();
    }

    @Nullable
    public MediaPeriodHolder getNext() {
        return this.next;
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public TrackSelectorResult getTrackSelectorResult() {
        return this.trackSelectorResult;
    }

    private void enableTrackSelectionsInResult() {
        if (!this.isLoadingMediaPeriod()) {
            return;
        }
        for (int i = 0; i < this.trackSelectorResult.length; ++i) {
            boolean rendererEnabled = this.trackSelectorResult.isRendererEnabled(i);
            ExoTrackSelection trackSelection = this.trackSelectorResult.selections[i];
            if (!rendererEnabled || trackSelection == null) continue;
            trackSelection.enable();
        }
    }

    private void disableTrackSelectionsInResult() {
        if (!this.isLoadingMediaPeriod()) {
            return;
        }
        for (int i = 0; i < this.trackSelectorResult.length; ++i) {
            boolean rendererEnabled = this.trackSelectorResult.isRendererEnabled(i);
            ExoTrackSelection trackSelection = this.trackSelectorResult.selections[i];
            if (!rendererEnabled || trackSelection == null) continue;
            trackSelection.disable();
        }
    }

    private void disassociateNoSampleRenderersWithEmptySampleStream(@NullableType SampleStream[] sampleStreams) {
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            if (this.rendererCapabilities[i].getTrackType() != 7) continue;
            sampleStreams[i] = null;
        }
    }

    private void associateNoSampleRenderersWithEmptySampleStream(@NullableType SampleStream[] sampleStreams) {
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            if (this.rendererCapabilities[i].getTrackType() != 7 || !this.trackSelectorResult.isRendererEnabled(i)) continue;
            sampleStreams[i] = new EmptySampleStream();
        }
    }

    private boolean isLoadingMediaPeriod() {
        return this.next == null;
    }

    private static MediaPeriod createMediaPeriod(MediaSource.MediaPeriodId id, MediaSourceList mediaSourceList, Allocator allocator, long startPositionUs, long endPositionUs) {
        MediaPeriod mediaPeriod = mediaSourceList.createPeriod(id, allocator, startPositionUs);
        if (endPositionUs != -9223372036854775807L && endPositionUs != Long.MIN_VALUE) {
            mediaPeriod = new ClippingMediaPeriod(mediaPeriod, true, 0L, endPositionUs);
        }
        return mediaPeriod;
    }

    private static void releaseMediaPeriod(long endPositionUs, MediaSourceList mediaSourceList, MediaPeriod mediaPeriod) {
        try {
            if (endPositionUs != -9223372036854775807L && endPositionUs != Long.MIN_VALUE) {
                mediaSourceList.releasePeriod(((ClippingMediaPeriod)mediaPeriod).mediaPeriod);
            } else {
                mediaSourceList.releasePeriod(mediaPeriod);
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Period release failed.", (Throwable)e);
        }
    }
}

