/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaPeriodHolder;
import com.google.android.exoplayer2.MediaPeriodInfo;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class MediaPeriodQueue {
    private static final int MAXIMUM_BUFFER_AHEAD_PERIODS = 100;
    private final Timeline.Period period;
    private final Timeline.Window window;
    @Nullable
    private final AnalyticsCollector analyticsCollector;
    private final Handler analyticsCollectorHandler;
    private long nextWindowSequenceNumber;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    @Nullable
    private MediaPeriodHolder playing;
    @Nullable
    private MediaPeriodHolder reading;
    @Nullable
    private MediaPeriodHolder loading;
    private int length;
    @Nullable
    private Object oldFrontPeriodUid;
    private long oldFrontPeriodWindowSequenceNumber;

    public MediaPeriodQueue(@Nullable AnalyticsCollector analyticsCollector, Handler analyticsCollectorHandler) {
        this.analyticsCollector = analyticsCollector;
        this.analyticsCollectorHandler = analyticsCollectorHandler;
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
    }

    public boolean updateRepeatMode(Timeline timeline, int repeatMode) {
        this.repeatMode = repeatMode;
        return this.updateForPlaybackModeChange(timeline);
    }

    public boolean updateShuffleModeEnabled(Timeline timeline, boolean shuffleModeEnabled) {
        this.shuffleModeEnabled = shuffleModeEnabled;
        return this.updateForPlaybackModeChange(timeline);
    }

    public boolean isLoading(MediaPeriod mediaPeriod) {
        return this.loading != null && this.loading.mediaPeriod == mediaPeriod;
    }

    public void reevaluateBuffer(long rendererPositionUs) {
        if (this.loading != null) {
            this.loading.reevaluateBuffer(rendererPositionUs);
        }
    }

    public boolean shouldLoadNextMediaPeriod() {
        return this.loading == null || !this.loading.info.isFinal && this.loading.isFullyBuffered() && this.loading.info.durationUs != -9223372036854775807L && this.length < 100;
    }

    @Nullable
    public MediaPeriodInfo getNextMediaPeriodInfo(long rendererPositionUs, PlaybackInfo playbackInfo) {
        return this.loading == null ? this.getFirstMediaPeriodInfo(playbackInfo) : this.getFollowingMediaPeriodInfo(playbackInfo.timeline, this.loading, rendererPositionUs);
    }

    public MediaPeriodHolder enqueueNextMediaPeriodHolder(RendererCapabilities[] rendererCapabilities, TrackSelector trackSelector, Allocator allocator, MediaSourceList mediaSourceList, MediaPeriodInfo info, TrackSelectorResult emptyTrackSelectorResult) {
        long rendererPositionOffsetUs = this.loading == null ? (info.id.isAd() && info.requestedContentPositionUs != -9223372036854775807L ? info.requestedContentPositionUs : 0L) : this.loading.getRendererOffset() + this.loading.info.durationUs - info.startPositionUs;
        MediaPeriodHolder newPeriodHolder = new MediaPeriodHolder(rendererCapabilities, rendererPositionOffsetUs, trackSelector, allocator, mediaSourceList, info, emptyTrackSelectorResult);
        if (this.loading != null) {
            this.loading.setNext(newPeriodHolder);
        } else {
            this.playing = newPeriodHolder;
            this.reading = newPeriodHolder;
        }
        this.oldFrontPeriodUid = null;
        this.loading = newPeriodHolder;
        ++this.length;
        this.notifyQueueUpdate();
        return newPeriodHolder;
    }

    @Nullable
    public MediaPeriodHolder getLoadingPeriod() {
        return this.loading;
    }

    @Nullable
    public MediaPeriodHolder getPlayingPeriod() {
        return this.playing;
    }

    @Nullable
    public MediaPeriodHolder getReadingPeriod() {
        return this.reading;
    }

    public MediaPeriodHolder advanceReadingPeriod() {
        Assertions.checkState((this.reading != null && this.reading.getNext() != null ? 1 : 0) != 0);
        this.reading = this.reading.getNext();
        this.notifyQueueUpdate();
        return this.reading;
    }

    @Nullable
    public MediaPeriodHolder advancePlayingPeriod() {
        if (this.playing == null) {
            return null;
        }
        if (this.playing == this.reading) {
            this.reading = this.playing.getNext();
        }
        this.playing.release();
        --this.length;
        if (this.length == 0) {
            this.loading = null;
            this.oldFrontPeriodUid = this.playing.uid;
            this.oldFrontPeriodWindowSequenceNumber = this.playing.info.id.windowSequenceNumber;
        }
        this.playing = this.playing.getNext();
        this.notifyQueueUpdate();
        return this.playing;
    }

    public boolean removeAfter(MediaPeriodHolder mediaPeriodHolder) {
        Assertions.checkState((mediaPeriodHolder != null ? 1 : 0) != 0);
        if (mediaPeriodHolder.equals(this.loading)) {
            return false;
        }
        boolean removedReading = false;
        this.loading = mediaPeriodHolder;
        while (mediaPeriodHolder.getNext() != null) {
            if ((mediaPeriodHolder = mediaPeriodHolder.getNext()) == this.reading) {
                this.reading = this.playing;
                removedReading = true;
            }
            mediaPeriodHolder.release();
            --this.length;
        }
        this.loading.setNext(null);
        this.notifyQueueUpdate();
        return removedReading;
    }

    public void clear() {
        MediaPeriodHolder front;
        if (this.length == 0) {
            return;
        }
        this.oldFrontPeriodUid = front.uid;
        this.oldFrontPeriodWindowSequenceNumber = front.info.id.windowSequenceNumber;
        for (front = (MediaPeriodHolder)Assertions.checkStateNotNull((Object)this.playing); front != null; front = front.getNext()) {
            front.release();
        }
        this.playing = null;
        this.loading = null;
        this.reading = null;
        this.length = 0;
        this.notifyQueueUpdate();
    }

    public boolean updateQueuedPeriods(Timeline timeline, long rendererPositionUs, long maxRendererReadPositionUs) {
        MediaPeriodHolder previousPeriodHolder = null;
        for (MediaPeriodHolder periodHolder = this.playing; periodHolder != null; periodHolder = periodHolder.getNext()) {
            MediaPeriodInfo newPeriodInfo;
            MediaPeriodInfo oldPeriodInfo = periodHolder.info;
            if (previousPeriodHolder == null) {
                newPeriodInfo = this.getUpdatedMediaPeriodInfo(timeline, oldPeriodInfo);
            } else {
                newPeriodInfo = this.getFollowingMediaPeriodInfo(timeline, previousPeriodHolder, rendererPositionUs);
                if (newPeriodInfo == null) {
                    return !this.removeAfter(previousPeriodHolder);
                }
                if (!this.canKeepMediaPeriodHolder(oldPeriodInfo, newPeriodInfo)) {
                    return !this.removeAfter(previousPeriodHolder);
                }
            }
            periodHolder.info = newPeriodInfo.copyWithRequestedContentPositionUs(oldPeriodInfo.requestedContentPositionUs);
            if (!this.areDurationsCompatible(oldPeriodInfo.durationUs, newPeriodInfo.durationUs)) {
                long newDurationInRendererTime = newPeriodInfo.durationUs == -9223372036854775807L ? Long.MAX_VALUE : periodHolder.toRendererTime(newPeriodInfo.durationUs);
                boolean isReadingAndReadBeyondNewDuration = periodHolder == this.reading && (maxRendererReadPositionUs == Long.MIN_VALUE || maxRendererReadPositionUs >= newDurationInRendererTime);
                boolean readingPeriodRemoved = this.removeAfter(periodHolder);
                return !readingPeriodRemoved && !isReadingAndReadBeyondNewDuration;
            }
            previousPeriodHolder = periodHolder;
        }
        return true;
    }

    public MediaPeriodInfo getUpdatedMediaPeriodInfo(Timeline timeline, MediaPeriodInfo info) {
        MediaSource.MediaPeriodId id = info.id;
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInWindow = this.isLastInWindow(timeline, id);
        boolean isLastInTimeline = this.isLastInTimeline(timeline, id, isLastInPeriod);
        timeline.getPeriodByUid(info.id.periodUid, this.period);
        long durationUs = id.isAd() ? this.period.getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup) : (info.endPositionUs == -9223372036854775807L || info.endPositionUs == Long.MIN_VALUE ? this.period.getDurationUs() : info.endPositionUs);
        return new MediaPeriodInfo(id, info.startPositionUs, info.requestedContentPositionUs, info.endPositionUs, durationUs, isLastInPeriod, isLastInWindow, isLastInTimeline);
    }

    public MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Timeline timeline, Object periodUid, long positionUs) {
        long windowSequenceNumber = this.resolvePeriodIndexToWindowSequenceNumber(timeline, periodUid);
        return MediaPeriodQueue.resolveMediaPeriodIdForAds(timeline, periodUid, positionUs, windowSequenceNumber, this.period);
    }

    private void notifyQueueUpdate() {
        if (this.analyticsCollector != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MediaPeriodHolder period = this.playing; period != null; period = period.getNext()) {
                builder.add((Object)period.info.id);
            }
            MediaSource.MediaPeriodId readingPeriodId = this.reading == null ? null : this.reading.info.id;
            this.analyticsCollectorHandler.post(() -> this.analyticsCollector.updateMediaPeriodQueueInfo((List<MediaSource.MediaPeriodId>)builder.build(), readingPeriodId));
        }
    }

    private static MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Timeline timeline, Object periodUid, long positionUs, long windowSequenceNumber, Timeline.Period period) {
        timeline.getPeriodByUid(periodUid, period);
        int adGroupIndex = period.getAdGroupIndexForPositionUs(positionUs);
        if (adGroupIndex == -1) {
            int nextAdGroupIndex = period.getAdGroupIndexAfterPositionUs(positionUs);
            return new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        }
        int adIndexInAdGroup = period.getFirstAdIndexToPlay(adGroupIndex);
        return new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
    }

    private long resolvePeriodIndexToWindowSequenceNumber(Timeline timeline, Object periodUid) {
        MediaPeriodHolder mediaPeriodHolder;
        int oldFrontWindowIndex;
        int oldFrontPeriodIndex;
        int windowIndex = timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)this.period).windowIndex;
        if (this.oldFrontPeriodUid != null && (oldFrontPeriodIndex = timeline.getIndexOfPeriod(this.oldFrontPeriodUid)) != -1 && (oldFrontWindowIndex = timeline.getPeriod((int)oldFrontPeriodIndex, (Timeline.Period)this.period).windowIndex) == windowIndex) {
            return this.oldFrontPeriodWindowSequenceNumber;
        }
        for (mediaPeriodHolder = this.playing; mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            if (!mediaPeriodHolder.uid.equals(periodUid)) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        for (mediaPeriodHolder = this.playing; mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            int holderWindowIndex;
            int indexOfHolderInTimeline = timeline.getIndexOfPeriod(mediaPeriodHolder.uid);
            if (indexOfHolderInTimeline == -1 || (holderWindowIndex = timeline.getPeriod((int)indexOfHolderInTimeline, (Timeline.Period)this.period).windowIndex) != windowIndex) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        long windowSequenceNumber = this.nextWindowSequenceNumber++;
        if (this.playing == null) {
            this.oldFrontPeriodUid = periodUid;
            this.oldFrontPeriodWindowSequenceNumber = windowSequenceNumber;
        }
        return windowSequenceNumber;
    }

    private boolean canKeepMediaPeriodHolder(MediaPeriodInfo oldInfo, MediaPeriodInfo newInfo) {
        return oldInfo.startPositionUs == newInfo.startPositionUs && oldInfo.id.equals((Object)newInfo.id);
    }

    private boolean areDurationsCompatible(long previousDurationUs, long newDurationUs) {
        return previousDurationUs == -9223372036854775807L || previousDurationUs == newDurationUs;
    }

    private boolean updateForPlaybackModeChange(Timeline timeline) {
        MediaPeriodHolder lastValidPeriodHolder = this.playing;
        if (lastValidPeriodHolder == null) {
            return true;
        }
        int currentPeriodIndex = timeline.getIndexOfPeriod(lastValidPeriodHolder.uid);
        while (true) {
            int nextPeriodHolderPeriodIndex;
            int nextPeriodIndex = timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
            while (lastValidPeriodHolder.getNext() != null && !lastValidPeriodHolder.info.isLastInTimelinePeriod) {
                lastValidPeriodHolder = lastValidPeriodHolder.getNext();
            }
            MediaPeriodHolder nextMediaPeriodHolder = lastValidPeriodHolder.getNext();
            if (nextPeriodIndex == -1 || nextMediaPeriodHolder == null || (nextPeriodHolderPeriodIndex = timeline.getIndexOfPeriod(nextMediaPeriodHolder.uid)) != nextPeriodIndex) break;
            lastValidPeriodHolder = nextMediaPeriodHolder;
            currentPeriodIndex = nextPeriodIndex;
        }
        boolean readingPeriodRemoved = this.removeAfter(lastValidPeriodHolder);
        lastValidPeriodHolder.info = this.getUpdatedMediaPeriodInfo(timeline, lastValidPeriodHolder.info);
        return !readingPeriodRemoved;
    }

    @Nullable
    private MediaPeriodInfo getFirstMediaPeriodInfo(PlaybackInfo playbackInfo) {
        return this.getMediaPeriodInfo(playbackInfo.timeline, playbackInfo.periodId, playbackInfo.requestedContentPositionUs, playbackInfo.positionUs);
    }

    @Nullable
    private MediaPeriodInfo getFollowingMediaPeriodInfo(Timeline timeline, MediaPeriodHolder mediaPeriodHolder, long rendererPositionUs) {
        MediaPeriodInfo mediaPeriodInfo = mediaPeriodHolder.info;
        long bufferedDurationUs = mediaPeriodHolder.getRendererOffset() + mediaPeriodInfo.durationUs - rendererPositionUs;
        if (mediaPeriodInfo.isLastInTimelinePeriod) {
            long startPositionUs;
            long contentPositionUs;
            int currentPeriodIndex = timeline.getIndexOfPeriod(mediaPeriodInfo.id.periodUid);
            int nextPeriodIndex = timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
            if (nextPeriodIndex == -1) {
                return null;
            }
            int nextWindowIndex = timeline.getPeriod((int)nextPeriodIndex, (Timeline.Period)this.period, (boolean)true).windowIndex;
            Object nextPeriodUid = this.period.uid;
            long windowSequenceNumber = mediaPeriodInfo.id.windowSequenceNumber;
            if (timeline.getWindow((int)nextWindowIndex, (Timeline.Window)this.window).firstPeriodIndex == nextPeriodIndex) {
                contentPositionUs = -9223372036854775807L;
                Pair defaultPosition = timeline.getPeriodPosition(this.window, this.period, nextWindowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
                if (defaultPosition == null) {
                    return null;
                }
                nextPeriodUid = defaultPosition.first;
                startPositionUs = (Long)defaultPosition.second;
                MediaPeriodHolder nextMediaPeriodHolder = mediaPeriodHolder.getNext();
                windowSequenceNumber = nextMediaPeriodHolder != null && nextMediaPeriodHolder.uid.equals(nextPeriodUid) ? nextMediaPeriodHolder.info.id.windowSequenceNumber : this.nextWindowSequenceNumber++;
            } else {
                startPositionUs = 0L;
                contentPositionUs = 0L;
            }
            MediaSource.MediaPeriodId periodId = MediaPeriodQueue.resolveMediaPeriodIdForAds(timeline, nextPeriodUid, startPositionUs, windowSequenceNumber, this.period);
            return this.getMediaPeriodInfo(timeline, periodId, contentPositionUs, startPositionUs);
        }
        MediaSource.MediaPeriodId currentPeriodId = mediaPeriodInfo.id;
        timeline.getPeriodByUid(currentPeriodId.periodUid, this.period);
        if (currentPeriodId.isAd()) {
            int adGroupIndex = currentPeriodId.adGroupIndex;
            int adCountInCurrentAdGroup = this.period.getAdCountInAdGroup(adGroupIndex);
            if (adCountInCurrentAdGroup == -1) {
                return null;
            }
            int nextAdIndexInAdGroup = this.period.getNextAdIndexToPlay(adGroupIndex, currentPeriodId.adIndexInAdGroup);
            if (nextAdIndexInAdGroup < adCountInCurrentAdGroup) {
                return this.getMediaPeriodInfoForAd(timeline, currentPeriodId.periodUid, adGroupIndex, nextAdIndexInAdGroup, mediaPeriodInfo.requestedContentPositionUs, currentPeriodId.windowSequenceNumber);
            }
            long startPositionUs = mediaPeriodInfo.requestedContentPositionUs;
            if (startPositionUs == -9223372036854775807L) {
                Pair defaultPosition = timeline.getPeriodPosition(this.window, this.period, this.period.windowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
                if (defaultPosition == null) {
                    return null;
                }
                startPositionUs = (Long)defaultPosition.second;
            }
            return this.getMediaPeriodInfoForContent(timeline, currentPeriodId.periodUid, startPositionUs, mediaPeriodInfo.requestedContentPositionUs, currentPeriodId.windowSequenceNumber);
        }
        int adIndexInAdGroup = this.period.getFirstAdIndexToPlay(currentPeriodId.nextAdGroupIndex);
        if (adIndexInAdGroup == this.period.getAdCountInAdGroup(currentPeriodId.nextAdGroupIndex)) {
            return this.getMediaPeriodInfoForContent(timeline, currentPeriodId.periodUid, mediaPeriodInfo.durationUs, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
        }
        return this.getMediaPeriodInfoForAd(timeline, currentPeriodId.periodUid, currentPeriodId.nextAdGroupIndex, adIndexInAdGroup, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
    }

    @Nullable
    private MediaPeriodInfo getMediaPeriodInfo(Timeline timeline, MediaSource.MediaPeriodId id, long requestedContentPositionUs, long startPositionUs) {
        timeline.getPeriodByUid(id.periodUid, this.period);
        if (id.isAd()) {
            return this.getMediaPeriodInfoForAd(timeline, id.periodUid, id.adGroupIndex, id.adIndexInAdGroup, requestedContentPositionUs, id.windowSequenceNumber);
        }
        return this.getMediaPeriodInfoForContent(timeline, id.periodUid, startPositionUs, requestedContentPositionUs, id.windowSequenceNumber);
    }

    private MediaPeriodInfo getMediaPeriodInfoForAd(Timeline timeline, Object periodUid, int adGroupIndex, int adIndexInAdGroup, long contentPositionUs, long windowSequenceNumber) {
        long startPositionUs;
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
        long durationUs = timeline.getPeriodByUid(id.periodUid, this.period).getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup);
        long l = startPositionUs = adIndexInAdGroup == this.period.getFirstAdIndexToPlay(adGroupIndex) ? this.period.getAdResumePositionUs() : 0L;
        if (durationUs != -9223372036854775807L && startPositionUs >= durationUs) {
            startPositionUs = Math.max(0L, durationUs - 1L);
        }
        return new MediaPeriodInfo(id, startPositionUs, contentPositionUs, -9223372036854775807L, durationUs, false, false, false);
    }

    private MediaPeriodInfo getMediaPeriodInfoForContent(Timeline timeline, Object periodUid, long startPositionUs, long requestedContentPositionUs, long windowSequenceNumber) {
        long durationUs;
        timeline.getPeriodByUid(periodUid, this.period);
        int nextAdGroupIndex = this.period.getAdGroupIndexAfterPositionUs(startPositionUs);
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInWindow = this.isLastInWindow(timeline, id);
        boolean isLastInTimeline = this.isLastInTimeline(timeline, id, isLastInPeriod);
        long endPositionUs = nextAdGroupIndex != -1 ? this.period.getAdGroupTimeUs(nextAdGroupIndex) : -9223372036854775807L;
        long l = durationUs = endPositionUs == -9223372036854775807L || endPositionUs == Long.MIN_VALUE ? this.period.durationUs : endPositionUs;
        if (durationUs != -9223372036854775807L && startPositionUs >= durationUs) {
            startPositionUs = Math.max(0L, durationUs - 1L);
        }
        return new MediaPeriodInfo(id, startPositionUs, requestedContentPositionUs, endPositionUs, durationUs, isLastInPeriod, isLastInWindow, isLastInTimeline);
    }

    private boolean isLastInPeriod(MediaSource.MediaPeriodId id) {
        return !id.isAd() && id.nextAdGroupIndex == -1;
    }

    private boolean isLastInWindow(Timeline timeline, MediaSource.MediaPeriodId id) {
        if (!this.isLastInPeriod(id)) {
            return false;
        }
        int windowIndex = timeline.getPeriodByUid((Object)id.periodUid, (Timeline.Period)this.period).windowIndex;
        int periodIndex = timeline.getIndexOfPeriod(id.periodUid);
        return timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).lastPeriodIndex == periodIndex;
    }

    private boolean isLastInTimeline(Timeline timeline, MediaSource.MediaPeriodId id, boolean isLastMediaPeriodInPeriod) {
        int periodIndex = timeline.getIndexOfPeriod(id.periodUid);
        int windowIndex = timeline.getPeriod((int)periodIndex, (Timeline.Period)this.period).windowIndex;
        return !timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic && timeline.isLastPeriod(periodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled) && isLastMediaPeriodInPeriod;
    }
}

