/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaSourceInfoHolder;
import com.google.android.exoplayer2.PlaylistTimeline;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MaskingMediaPeriod;
import com.google.android.exoplayer2.source.MaskingMediaSource;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MediaSourceList {
    private static final String TAG = "MediaSourceList";
    private final List<MediaSourceHolder> mediaSourceHolders;
    private final IdentityHashMap<MediaPeriod, MediaSourceHolder> mediaSourceByMediaPeriod;
    private final Map<Object, MediaSourceHolder> mediaSourceByUid;
    private final MediaSourceListInfoRefreshListener mediaSourceListInfoListener;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final HashMap<MediaSourceHolder, MediaSourceAndListener> childSources;
    private final Set<MediaSourceHolder> enabledMediaSourceHolders;
    private ShuffleOrder shuffleOrder;
    private boolean isPrepared;
    @Nullable
    private TransferListener mediaTransferListener;

    public MediaSourceList(MediaSourceListInfoRefreshListener listener, @Nullable AnalyticsCollector analyticsCollector, Handler analyticsCollectorHandler) {
        this.mediaSourceListInfoListener = listener;
        this.shuffleOrder = new ShuffleOrder.DefaultShuffleOrder(0);
        this.mediaSourceByMediaPeriod = new IdentityHashMap();
        this.mediaSourceByUid = new HashMap<Object, MediaSourceHolder>();
        this.mediaSourceHolders = new ArrayList<MediaSourceHolder>();
        this.mediaSourceEventDispatcher = new MediaSourceEventListener.EventDispatcher();
        this.drmEventDispatcher = new DrmSessionEventListener.EventDispatcher();
        this.childSources = new HashMap();
        this.enabledMediaSourceHolders = new HashSet<MediaSourceHolder>();
        if (analyticsCollector != null) {
            this.mediaSourceEventDispatcher.addEventListener(analyticsCollectorHandler, analyticsCollector);
            this.drmEventDispatcher.addEventListener(analyticsCollectorHandler, analyticsCollector);
        }
    }

    public Timeline setMediaSources(List<MediaSourceHolder> holders, ShuffleOrder shuffleOrder) {
        this.removeMediaSourcesInternal(0, this.mediaSourceHolders.size());
        return this.addMediaSources(this.mediaSourceHolders.size(), holders, shuffleOrder);
    }

    public Timeline addMediaSources(int index, List<MediaSourceHolder> holders, ShuffleOrder shuffleOrder) {
        if (!holders.isEmpty()) {
            this.shuffleOrder = shuffleOrder;
            for (int insertionIndex = index; insertionIndex < index + holders.size(); ++insertionIndex) {
                MediaSourceHolder holder = holders.get(insertionIndex - index);
                if (insertionIndex > 0) {
                    MediaSourceHolder previousHolder = this.mediaSourceHolders.get(insertionIndex - 1);
                    Timeline previousTimeline = previousHolder.mediaSource.getTimeline();
                    holder.reset(previousHolder.firstWindowIndexInChild + previousTimeline.getWindowCount());
                } else {
                    holder.reset(0);
                }
                Timeline newTimeline = holder.mediaSource.getTimeline();
                this.correctOffsets(insertionIndex, newTimeline.getWindowCount());
                this.mediaSourceHolders.add(insertionIndex, holder);
                this.mediaSourceByUid.put(holder.uid, holder);
                if (!this.isPrepared) continue;
                this.prepareChildSource(holder);
                if (this.mediaSourceByMediaPeriod.isEmpty()) {
                    this.enabledMediaSourceHolders.add(holder);
                    continue;
                }
                this.disableChildSource(holder);
            }
        }
        return this.createTimeline();
    }

    public Timeline removeMediaSourceRange(int fromIndex, int toIndex, ShuffleOrder shuffleOrder) {
        Assertions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.getSize() ? 1 : 0) != 0);
        this.shuffleOrder = shuffleOrder;
        this.removeMediaSourcesInternal(fromIndex, toIndex);
        return this.createTimeline();
    }

    public Timeline moveMediaSource(int currentIndex, int newIndex, ShuffleOrder shuffleOrder) {
        return this.moveMediaSourceRange(currentIndex, currentIndex + 1, newIndex, shuffleOrder);
    }

    public Timeline moveMediaSourceRange(int fromIndex, int toIndex, int newFromIndex, ShuffleOrder shuffleOrder) {
        Assertions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.getSize() && newFromIndex >= 0 ? 1 : 0) != 0);
        this.shuffleOrder = shuffleOrder;
        if (fromIndex == toIndex || fromIndex == newFromIndex) {
            return this.createTimeline();
        }
        int startIndex = Math.min(fromIndex, newFromIndex);
        int newEndIndex = newFromIndex + (toIndex - fromIndex) - 1;
        int endIndex = Math.max(newEndIndex, toIndex - 1);
        int windowOffset = this.mediaSourceHolders.get((int)startIndex).firstWindowIndexInChild;
        Util.moveItems(this.mediaSourceHolders, (int)fromIndex, (int)toIndex, (int)newFromIndex);
        for (int i = startIndex; i <= endIndex; ++i) {
            MediaSourceHolder holder = this.mediaSourceHolders.get(i);
            holder.firstWindowIndexInChild = windowOffset;
            windowOffset += holder.mediaSource.getTimeline().getWindowCount();
        }
        return this.createTimeline();
    }

    public Timeline clear(@Nullable ShuffleOrder shuffleOrder) {
        this.shuffleOrder = shuffleOrder != null ? shuffleOrder : this.shuffleOrder.cloneAndClear();
        this.removeMediaSourcesInternal(0, this.getSize());
        return this.createTimeline();
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public int getSize() {
        return this.mediaSourceHolders.size();
    }

    public Timeline setShuffleOrder(ShuffleOrder shuffleOrder) {
        int size = this.getSize();
        if (shuffleOrder.getLength() != size) {
            shuffleOrder = shuffleOrder.cloneAndClear().cloneAndInsert(0, size);
        }
        this.shuffleOrder = shuffleOrder;
        return this.createTimeline();
    }

    public void prepare(@Nullable TransferListener mediaTransferListener) {
        Assertions.checkState((!this.isPrepared ? 1 : 0) != 0);
        this.mediaTransferListener = mediaTransferListener;
        for (int i = 0; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder mediaSourceHolder = this.mediaSourceHolders.get(i);
            this.prepareChildSource(mediaSourceHolder);
            this.enabledMediaSourceHolders.add(mediaSourceHolder);
        }
        this.isPrepared = true;
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        Object mediaSourceHolderUid = MediaSourceList.getMediaSourceHolderUid(id.periodUid);
        MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(MediaSourceList.getChildPeriodUid(id.periodUid));
        MediaSourceHolder holder = (MediaSourceHolder)Assertions.checkNotNull((Object)this.mediaSourceByUid.get(mediaSourceHolderUid));
        this.enableMediaSource(holder);
        holder.activeMediaPeriodIds.add(childMediaPeriodId);
        MaskingMediaPeriod mediaPeriod = holder.mediaSource.createPeriod(childMediaPeriodId, allocator, startPositionUs);
        this.mediaSourceByMediaPeriod.put(mediaPeriod, holder);
        this.disableUnusedMediaSources();
        return mediaPeriod;
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        MediaSourceHolder holder = (MediaSourceHolder)Assertions.checkNotNull((Object)this.mediaSourceByMediaPeriod.remove(mediaPeriod));
        holder.mediaSource.releasePeriod(mediaPeriod);
        holder.activeMediaPeriodIds.remove((Object)((MaskingMediaPeriod)mediaPeriod).id);
        if (!this.mediaSourceByMediaPeriod.isEmpty()) {
            this.disableUnusedMediaSources();
        }
        this.maybeReleaseChildSource(holder);
    }

    public void release() {
        for (MediaSourceAndListener childSource : this.childSources.values()) {
            try {
                childSource.mediaSource.releaseSource(childSource.caller);
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to release child source.", (Throwable)e);
            }
            childSource.mediaSource.removeEventListener(childSource.eventListener);
            childSource.mediaSource.removeDrmEventListener(childSource.eventListener);
        }
        this.childSources.clear();
        this.enabledMediaSourceHolders.clear();
        this.isPrepared = false;
    }

    public Timeline createTimeline() {
        if (this.mediaSourceHolders.isEmpty()) {
            return Timeline.EMPTY;
        }
        int windowOffset = 0;
        for (int i = 0; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder mediaSourceHolder = this.mediaSourceHolders.get(i);
            mediaSourceHolder.firstWindowIndexInChild = windowOffset;
            windowOffset += mediaSourceHolder.mediaSource.getTimeline().getWindowCount();
        }
        return new PlaylistTimeline(this.mediaSourceHolders, this.shuffleOrder);
    }

    private void enableMediaSource(MediaSourceHolder mediaSourceHolder) {
        this.enabledMediaSourceHolders.add(mediaSourceHolder);
        MediaSourceAndListener enabledChild = this.childSources.get(mediaSourceHolder);
        if (enabledChild != null) {
            enabledChild.mediaSource.enable(enabledChild.caller);
        }
    }

    private void disableUnusedMediaSources() {
        Iterator<MediaSourceHolder> iterator = this.enabledMediaSourceHolders.iterator();
        while (iterator.hasNext()) {
            MediaSourceHolder holder = iterator.next();
            if (!holder.activeMediaPeriodIds.isEmpty()) continue;
            this.disableChildSource(holder);
            iterator.remove();
        }
    }

    private void disableChildSource(MediaSourceHolder holder) {
        MediaSourceAndListener disabledChild = this.childSources.get(holder);
        if (disabledChild != null) {
            disabledChild.mediaSource.disable(disabledChild.caller);
        }
    }

    private void removeMediaSourcesInternal(int fromIndex, int toIndex) {
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            MediaSourceHolder holder = this.mediaSourceHolders.remove(index);
            this.mediaSourceByUid.remove(holder.uid);
            Timeline oldTimeline = holder.mediaSource.getTimeline();
            this.correctOffsets(index, -oldTimeline.getWindowCount());
            holder.isRemoved = true;
            if (!this.isPrepared) continue;
            this.maybeReleaseChildSource(holder);
        }
    }

    private void correctOffsets(int startIndex, int windowOffsetUpdate) {
        for (int i = startIndex; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder mediaSourceHolder = this.mediaSourceHolders.get(i);
            mediaSourceHolder.firstWindowIndexInChild += windowOffsetUpdate;
        }
    }

    @Nullable
    private static MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSourceHolder mediaSourceHolder, MediaSource.MediaPeriodId mediaPeriodId) {
        for (int i = 0; i < mediaSourceHolder.activeMediaPeriodIds.size(); ++i) {
            if (mediaSourceHolder.activeMediaPeriodIds.get((int)i).windowSequenceNumber != mediaPeriodId.windowSequenceNumber) continue;
            Object periodUid = MediaSourceList.getPeriodUid(mediaSourceHolder, mediaPeriodId.periodUid);
            return mediaPeriodId.copyWithPeriodUid(periodUid);
        }
        return null;
    }

    private static int getWindowIndexForChildWindowIndex(MediaSourceHolder mediaSourceHolder, int windowIndex) {
        return windowIndex + mediaSourceHolder.firstWindowIndexInChild;
    }

    private void prepareChildSource(MediaSourceHolder holder) {
        MaskingMediaSource mediaSource = holder.mediaSource;
        MediaSource.MediaSourceCaller caller = (source, timeline) -> this.mediaSourceListInfoListener.onPlaylistUpdateRequested();
        ForwardingEventListener eventListener = new ForwardingEventListener(holder);
        this.childSources.put(holder, new MediaSourceAndListener(mediaSource, caller, eventListener));
        mediaSource.addEventListener(Util.createHandlerForCurrentOrMainLooper(), eventListener);
        mediaSource.addDrmEventListener(Util.createHandlerForCurrentOrMainLooper(), eventListener);
        mediaSource.prepareSource(caller, this.mediaTransferListener);
    }

    private void maybeReleaseChildSource(MediaSourceHolder mediaSourceHolder) {
        if (mediaSourceHolder.isRemoved && mediaSourceHolder.activeMediaPeriodIds.isEmpty()) {
            MediaSourceAndListener removedChild = (MediaSourceAndListener)Assertions.checkNotNull((Object)this.childSources.remove(mediaSourceHolder));
            removedChild.mediaSource.releaseSource(removedChild.caller);
            removedChild.mediaSource.removeEventListener(removedChild.eventListener);
            removedChild.mediaSource.removeDrmEventListener(removedChild.eventListener);
            this.enabledMediaSourceHolders.remove(mediaSourceHolder);
        }
    }

    private static Object getMediaSourceHolderUid(Object periodUid) {
        return PlaylistTimeline.getChildTimelineUidFromConcatenatedUid(periodUid);
    }

    private static Object getChildPeriodUid(Object periodUid) {
        return PlaylistTimeline.getChildPeriodUidFromConcatenatedUid(periodUid);
    }

    private static Object getPeriodUid(MediaSourceHolder holder, Object childPeriodUid) {
        return PlaylistTimeline.getConcatenatedUid(holder.uid, childPeriodUid);
    }

    private final class ForwardingEventListener
    implements MediaSourceEventListener,
    DrmSessionEventListener {
        private final MediaSourceHolder id;
        private MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
        private DrmSessionEventListener.EventDispatcher drmEventDispatcher;

        public ForwardingEventListener(MediaSourceHolder id) {
            this.mediaSourceEventDispatcher = MediaSourceList.this.mediaSourceEventDispatcher;
            this.drmEventDispatcher = MediaSourceList.this.drmEventDispatcher;
            this.id = id;
        }

        @Override
        public void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadStarted(loadEventData, mediaLoadData);
            }
        }

        @Override
        public void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCompleted(loadEventData, mediaLoadData);
            }
        }

        @Override
        public void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCanceled(loadEventData, mediaLoadData);
            }
        }

        @Override
        public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventData, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadError(loadEventData, mediaLoadData, error, wasCanceled);
            }
        }

        @Override
        public void onUpstreamDiscarded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.upstreamDiscarded(mediaLoadData);
            }
        }

        @Override
        public void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.downstreamFormatChanged(mediaLoadData);
            }
        }

        @Override
        public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionAcquired(state);
            }
        }

        @Override
        public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysLoaded();
            }
        }

        @Override
        public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionManagerError(error);
            }
        }

        @Override
        public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRestored();
            }
        }

        @Override
        public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRemoved();
            }
        }

        @Override
        public void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(windowIndex, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionReleased();
            }
        }

        private boolean maybeUpdateEventDispatcher(int childWindowIndex, @Nullable MediaSource.MediaPeriodId childMediaPeriodId) {
            MediaSource.MediaPeriodId mediaPeriodId = null;
            if (childMediaPeriodId != null && (mediaPeriodId = MediaSourceList.getMediaPeriodIdForChildMediaPeriodId(this.id, childMediaPeriodId)) == null) {
                return false;
            }
            int windowIndex = MediaSourceList.getWindowIndexForChildWindowIndex(this.id, childWindowIndex);
            if (this.mediaSourceEventDispatcher.windowIndex != windowIndex || !Util.areEqual((Object)((Object)this.mediaSourceEventDispatcher.mediaPeriodId), (Object)((Object)mediaPeriodId))) {
                this.mediaSourceEventDispatcher = MediaSourceList.this.mediaSourceEventDispatcher.withParameters(windowIndex, mediaPeriodId, 0L);
            }
            if (this.drmEventDispatcher.windowIndex != windowIndex || !Util.areEqual((Object)((Object)this.drmEventDispatcher.mediaPeriodId), (Object)((Object)mediaPeriodId))) {
                this.drmEventDispatcher = MediaSourceList.this.drmEventDispatcher.withParameters(windowIndex, mediaPeriodId);
            }
            return true;
        }
    }

    private static final class MediaSourceAndListener {
        public final MediaSource mediaSource;
        public final MediaSource.MediaSourceCaller caller;
        public final ForwardingEventListener eventListener;

        public MediaSourceAndListener(MediaSource mediaSource, MediaSource.MediaSourceCaller caller, ForwardingEventListener eventListener) {
            this.mediaSource = mediaSource;
            this.caller = caller;
            this.eventListener = eventListener;
        }
    }

    static final class MediaSourceHolder
    implements MediaSourceInfoHolder {
        public final MaskingMediaSource mediaSource;
        public final Object uid;
        public final List<MediaSource.MediaPeriodId> activeMediaPeriodIds;
        public int firstWindowIndexInChild;
        public boolean isRemoved;

        public MediaSourceHolder(MediaSource mediaSource, boolean useLazyPreparation) {
            this.mediaSource = new MaskingMediaSource(mediaSource, useLazyPreparation);
            this.activeMediaPeriodIds = new ArrayList<MediaSource.MediaPeriodId>();
            this.uid = new Object();
        }

        public void reset(int firstWindowIndexInChild) {
            this.firstWindowIndexInChild = firstWindowIndexInChild;
            this.isRemoved = false;
            this.activeMediaPeriodIds.clear();
        }

        @Override
        public Object getUid() {
            return this.uid;
        }

        @Override
        public Timeline getTimeline() {
            return this.mediaSource.getTimeline();
        }
    }

    public static interface MediaSourceListInfoRefreshListener {
        public void onPlaylistUpdateRequested();
    }
}

