/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DefaultAllocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class MetadataRetriever {
    private MetadataRetriever() {
    }

    public static ListenableFuture<TrackGroupArray> retrieveMetadata(Context context, MediaItem mediaItem) {
        return MetadataRetriever.retrieveMetadata(context, mediaItem, Clock.DEFAULT);
    }

    public static ListenableFuture<TrackGroupArray> retrieveMetadata(MediaSourceFactory mediaSourceFactory, MediaItem mediaItem) {
        return MetadataRetriever.retrieveMetadata(mediaSourceFactory, mediaItem, Clock.DEFAULT);
    }

    @VisibleForTesting
    static ListenableFuture<TrackGroupArray> retrieveMetadata(Context context, MediaItem mediaItem, Clock clock) {
        DefaultExtractorsFactory extractorsFactory = new DefaultExtractorsFactory().setMp4ExtractorFlags(6);
        DefaultMediaSourceFactory mediaSourceFactory = new DefaultMediaSourceFactory(context, (ExtractorsFactory)extractorsFactory);
        return MetadataRetriever.retrieveMetadata(mediaSourceFactory, mediaItem, clock);
    }

    private static ListenableFuture<TrackGroupArray> retrieveMetadata(MediaSourceFactory mediaSourceFactory, MediaItem mediaItem, Clock clock) {
        return new MetadataRetrieverInternal(mediaSourceFactory, clock).retrieveMetadata(mediaItem);
    }

    private static final class MetadataRetrieverInternal {
        private static final int MESSAGE_PREPARE_SOURCE = 0;
        private static final int MESSAGE_CHECK_FOR_FAILURE = 1;
        private static final int MESSAGE_CONTINUE_LOADING = 2;
        private static final int MESSAGE_RELEASE = 3;
        private final MediaSourceFactory mediaSourceFactory;
        private final HandlerThread mediaSourceThread;
        private final HandlerWrapper mediaSourceHandler;
        private final SettableFuture<TrackGroupArray> trackGroupsFuture;

        public MetadataRetrieverInternal(MediaSourceFactory mediaSourceFactory, Clock clock) {
            this.mediaSourceFactory = mediaSourceFactory;
            this.mediaSourceThread = new HandlerThread("ExoPlayer:MetadataRetriever");
            this.mediaSourceThread.start();
            this.mediaSourceHandler = clock.createHandler(this.mediaSourceThread.getLooper(), (Handler.Callback)new MediaSourceHandlerCallback());
            this.trackGroupsFuture = SettableFuture.create();
        }

        public ListenableFuture<TrackGroupArray> retrieveMetadata(MediaItem mediaItem) {
            this.mediaSourceHandler.obtainMessage(0, (Object)mediaItem).sendToTarget();
            return this.trackGroupsFuture;
        }

        private final class MediaSourceHandlerCallback
        implements Handler.Callback {
            private static final int ERROR_POLL_INTERVAL_MS = 100;
            private final MediaSourceCaller mediaSourceCaller = new MediaSourceCaller();
            private @MonotonicNonNull MediaSource mediaSource;
            private @MonotonicNonNull MediaPeriod mediaPeriod;

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        MediaItem mediaItem = (MediaItem)msg.obj;
                        this.mediaSource = MetadataRetrieverInternal.this.mediaSourceFactory.createMediaSource(mediaItem);
                        this.mediaSource.prepareSource(this.mediaSourceCaller, null);
                        MetadataRetrieverInternal.this.mediaSourceHandler.sendEmptyMessage(1);
                        return true;
                    }
                    case 1: {
                        try {
                            if (this.mediaPeriod == null) {
                                ((MediaSource)Assertions.checkNotNull((Object)this.mediaSource)).maybeThrowSourceInfoRefreshError();
                            } else {
                                this.mediaPeriod.maybeThrowPrepareError();
                            }
                            MetadataRetrieverInternal.this.mediaSourceHandler.sendEmptyMessageDelayed(1, 100);
                        }
                        catch (Exception e) {
                            MetadataRetrieverInternal.this.trackGroupsFuture.setException((Throwable)e);
                            MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(3).sendToTarget();
                        }
                        return true;
                    }
                    case 2: {
                        ((MediaPeriod)Assertions.checkNotNull((Object)this.mediaPeriod)).continueLoading(0L);
                        return true;
                    }
                    case 3: {
                        if (this.mediaPeriod != null) {
                            ((MediaSource)Assertions.checkNotNull((Object)this.mediaSource)).releasePeriod(this.mediaPeriod);
                        }
                        ((MediaSource)Assertions.checkNotNull((Object)this.mediaSource)).releaseSource(this.mediaSourceCaller);
                        MetadataRetrieverInternal.this.mediaSourceHandler.removeCallbacksAndMessages(null);
                        MetadataRetrieverInternal.this.mediaSourceThread.quit();
                        return true;
                    }
                }
                return false;
            }

            private final class MediaSourceCaller
            implements MediaSource.MediaSourceCaller {
                private final MediaPeriodCallback mediaPeriodCallback = new MediaPeriodCallback();
                private final Allocator allocator = new DefaultAllocator(true, 65536);
                private boolean mediaPeriodCreated;

                @Override
                public void onSourceInfoRefreshed(MediaSource source, Timeline timeline) {
                    if (this.mediaPeriodCreated) {
                        return;
                    }
                    this.mediaPeriodCreated = true;
                    MediaSourceHandlerCallback.this.mediaPeriod = source.createPeriod(new MediaSource.MediaPeriodId(timeline.getUidOfPeriod(0)), this.allocator, 0L);
                    MediaSourceHandlerCallback.this.mediaPeriod.prepare(this.mediaPeriodCallback, 0L);
                }

                private final class MediaPeriodCallback
                implements MediaPeriod.Callback {
                    private MediaPeriodCallback() {
                    }

                    @Override
                    public void onPrepared(MediaPeriod mediaPeriod) {
                        MetadataRetrieverInternal.this.trackGroupsFuture.set((Object)mediaPeriod.getTrackGroups());
                        MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(3).sendToTarget();
                    }

                    @Override
                    public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
                        MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(2).sendToTarget();
                    }
                }
            }
        }
    }
}

