/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.AudioTrack;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.AudioBecomingNoisyManager;
import com.google.android.exoplayer2.AudioFocusManager;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultLivePlaybackSpeedControl;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.ExoTimeoutException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.StreamVolumeManager;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.WakeLockManager;
import com.google.android.exoplayer2.WifiLockManager;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.device.DeviceListener;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import com.google.android.exoplayer2.video.spherical.SphericalGLSurfaceView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;

public class SimpleExoPlayer
extends BasePlayer
implements ExoPlayer,
ExoPlayer.AudioComponent,
ExoPlayer.VideoComponent,
ExoPlayer.TextComponent,
ExoPlayer.MetadataComponent,
ExoPlayer.DeviceComponent {
    public static final long DEFAULT_DETACH_SURFACE_TIMEOUT_MS = 2000L;
    private static final String TAG = "SimpleExoPlayer";
    protected final Renderer[] renderers;
    private final ConditionVariable constructorFinished = new ConditionVariable();
    private final Context applicationContext;
    private final ExoPlayerImpl player;
    private final ComponentListener componentListener;
    private final FrameMetadataListener frameMetadataListener;
    private final CopyOnWriteArraySet<VideoListener> videoListeners;
    private final CopyOnWriteArraySet<AudioListener> audioListeners;
    private final CopyOnWriteArraySet<TextOutput> textOutputs;
    private final CopyOnWriteArraySet<MetadataOutput> metadataOutputs;
    private final CopyOnWriteArraySet<DeviceListener> deviceListeners;
    private final AnalyticsCollector analyticsCollector;
    private final AudioBecomingNoisyManager audioBecomingNoisyManager;
    private final AudioFocusManager audioFocusManager;
    private final StreamVolumeManager streamVolumeManager;
    private final WakeLockManager wakeLockManager;
    private final WifiLockManager wifiLockManager;
    private final long detachSurfaceTimeoutMs;
    @Nullable
    private Format videoFormat;
    @Nullable
    private Format audioFormat;
    @Nullable
    private AudioTrack keepSessionIdAudioTrack;
    @Nullable
    private Object videoOutput;
    @Nullable
    private Surface ownedSurface;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private SphericalGLSurfaceView sphericalGLSurfaceView;
    private boolean surfaceHolderSurfaceIsVideoOutput;
    @Nullable
    private TextureView textureView;
    private int videoScalingMode;
    private int surfaceWidth;
    private int surfaceHeight;
    @Nullable
    private DecoderCounters videoDecoderCounters;
    @Nullable
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private AudioAttributes audioAttributes;
    private float audioVolume;
    private boolean skipSilenceEnabled;
    private List<Cue> currentCues;
    @Nullable
    private VideoFrameMetadataListener videoFrameMetadataListener;
    @Nullable
    private CameraMotionListener cameraMotionListener;
    private boolean throwsWhenUsingWrongThread;
    private boolean hasNotifiedFullWrongThreadWarning;
    @Nullable
    private PriorityTaskManager priorityTaskManager;
    private boolean isPriorityTaskManagerRegistered;
    private boolean playerReleased;
    private DeviceInfo deviceInfo;
    private VideoSize videoSize;

    @Deprecated
    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector, boolean useLazyPreparation, Clock clock, Looper applicationLooper) {
        this(new Builder(context, renderersFactory).setTrackSelector(trackSelector).setMediaSourceFactory(mediaSourceFactory).setLoadControl(loadControl).setBandwidthMeter(bandwidthMeter).setAnalyticsCollector(analyticsCollector).setUseLazyPreparation(useLazyPreparation).setClock(clock).setLooper(applicationLooper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleExoPlayer(Builder builder) {
        try {
            this.applicationContext = builder.context.getApplicationContext();
            this.analyticsCollector = builder.analyticsCollector;
            this.priorityTaskManager = builder.priorityTaskManager;
            this.audioAttributes = builder.audioAttributes;
            this.videoScalingMode = builder.videoScalingMode;
            this.skipSilenceEnabled = builder.skipSilenceEnabled;
            this.detachSurfaceTimeoutMs = builder.detachSurfaceTimeoutMs;
            this.componentListener = new ComponentListener();
            this.frameMetadataListener = new FrameMetadataListener();
            this.videoListeners = new CopyOnWriteArraySet();
            this.audioListeners = new CopyOnWriteArraySet();
            this.textOutputs = new CopyOnWriteArraySet();
            this.metadataOutputs = new CopyOnWriteArraySet();
            this.deviceListeners = new CopyOnWriteArraySet();
            Handler eventHandler = new Handler(builder.looper);
            this.renderers = builder.renderersFactory.createRenderers(eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener);
            this.audioVolume = 1.0f;
            this.audioSessionId = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : C.generateAudioSessionIdV21((Context)this.applicationContext);
            this.currentCues = Collections.emptyList();
            this.throwsWhenUsingWrongThread = true;
            Player.Commands additionalPermanentAvailableCommands = new Player.Commands.Builder().addAll(new int[]{15, 16, 17, 18, 19, 20, 21, 22}).build();
            this.player = new ExoPlayerImpl(this.renderers, builder.trackSelector, builder.mediaSourceFactory, builder.loadControl, builder.bandwidthMeter, this.analyticsCollector, builder.useLazyPreparation, builder.seekParameters, builder.livePlaybackSpeedControl, builder.releaseTimeoutMs, builder.pauseAtEndOfMediaItems, builder.clock, builder.looper, this, additionalPermanentAvailableCommands);
            this.player.addListener(this.componentListener);
            this.player.addAudioOffloadListener(this.componentListener);
            if (builder.foregroundModeTimeoutMs > 0L) {
                this.player.experimentalSetForegroundModeTimeoutMs(builder.foregroundModeTimeoutMs);
            }
            this.audioBecomingNoisyManager = new AudioBecomingNoisyManager(builder.context, eventHandler, this.componentListener);
            this.audioBecomingNoisyManager.setEnabled(builder.handleAudioBecomingNoisy);
            this.audioFocusManager = new AudioFocusManager(builder.context, eventHandler, this.componentListener);
            this.audioFocusManager.setAudioAttributes(builder.handleAudioFocus ? this.audioAttributes : null);
            this.streamVolumeManager = new StreamVolumeManager(builder.context, eventHandler, this.componentListener);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage((int)this.audioAttributes.usage));
            this.wakeLockManager = new WakeLockManager(builder.context);
            this.wakeLockManager.setEnabled(builder.wakeMode != 0);
            this.wifiLockManager = new WifiLockManager(builder.context);
            this.wifiLockManager.setEnabled(builder.wakeMode == 2);
            this.deviceInfo = SimpleExoPlayer.createDeviceInfo(this.streamVolumeManager);
            this.videoSize = VideoSize.UNKNOWN;
            this.sendRendererMessage(1, 102, this.audioSessionId);
            this.sendRendererMessage(2, 102, this.audioSessionId);
            this.sendRendererMessage(1, 3, this.audioAttributes);
            this.sendRendererMessage(2, 4, this.videoScalingMode);
            this.sendRendererMessage(1, 101, this.skipSilenceEnabled);
            this.sendRendererMessage(2, 6, this.frameMetadataListener);
            this.sendRendererMessage(6, 7, this.frameMetadataListener);
        }
        finally {
            this.constructorFinished.open();
        }
    }

    @Override
    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.verifyApplicationThread();
        this.player.experimentalSetOffloadSchedulingEnabled(offloadSchedulingEnabled);
    }

    @Override
    public boolean experimentalIsSleepingForOffload() {
        this.verifyApplicationThread();
        return this.player.experimentalIsSleepingForOffload();
    }

    @Override
    @Nullable
    public ExoPlayer.AudioComponent getAudioComponent() {
        return this;
    }

    @Override
    @Nullable
    public ExoPlayer.VideoComponent getVideoComponent() {
        return this;
    }

    @Override
    @Nullable
    public ExoPlayer.TextComponent getTextComponent() {
        return this;
    }

    @Override
    @Nullable
    public ExoPlayer.MetadataComponent getMetadataComponent() {
        return this;
    }

    @Override
    @Nullable
    public ExoPlayer.DeviceComponent getDeviceComponent() {
        return this;
    }

    @Override
    public void setVideoScalingMode(int videoScalingMode) {
        this.verifyApplicationThread();
        this.videoScalingMode = videoScalingMode;
        this.sendRendererMessage(2, 4, videoScalingMode);
    }

    @Override
    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    @Override
    public VideoSize getVideoSize() {
        return this.videoSize;
    }

    @Override
    public void clearVideoSurface() {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoOutputInternal(null);
        this.maybeNotifySurfaceSizeChanged(0, 0);
    }

    @Override
    public void clearVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        if (surface != null && surface == this.videoOutput) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoOutputInternal(surface);
        int newSurfaceSize = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(newSurfaceSize, newSurfaceSize);
    }

    @Override
    public void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder == null) {
            this.clearVideoSurface();
        } else {
            this.removeSurfaceCallbacks();
            this.surfaceHolderSurfaceIsVideoOutput = true;
            this.surfaceHolder = surfaceHolder;
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoOutputInternal(surface);
                Rect surfaceSize = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
            } else {
                this.setVideoOutputInternal(null);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    @Override
    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.verifyApplicationThread();
        if (surfaceView instanceof VideoDecoderOutputBufferRenderer) {
            this.removeSurfaceCallbacks();
            this.setVideoOutputInternal(surfaceView);
            this.setNonVideoOutputSurfaceHolderInternal(surfaceView.getHolder());
        } else if (surfaceView instanceof SphericalGLSurfaceView) {
            this.removeSurfaceCallbacks();
            this.sphericalGLSurfaceView = (SphericalGLSurfaceView)surfaceView;
            this.player.createMessage(this.frameMetadataListener).setType(10000).setPayload((Object)this.sphericalGLSurfaceView).send();
            this.sphericalGLSurfaceView.addVideoSurfaceListener(this.componentListener);
            this.setVideoOutputInternal(this.sphericalGLSurfaceView.getVideoSurface());
            this.setNonVideoOutputSurfaceHolderInternal(surfaceView.getHolder());
        } else {
            this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
        }
    }

    @Override
    public void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.verifyApplicationThread();
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void setVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView == null) {
            this.clearVideoSurface();
        } else {
            SurfaceTexture surfaceTexture;
            this.removeSurfaceCallbacks();
            this.textureView = textureView;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoOutputInternal(null);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setSurfaceTextureInternal(surfaceTexture);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    @Override
    public void clearVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView != null && textureView == this.textureView) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void addAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.player.addAudioOffloadListener(listener);
    }

    @Override
    public void removeAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.player.removeAudioOffloadListener(listener);
    }

    @Override
    public void addAudioListener(AudioListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.audioListeners.add(listener);
    }

    @Override
    public void removeAudioListener(AudioListener listener) {
        this.audioListeners.remove(listener);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        if (!Util.areEqual((Object)this.audioAttributes, (Object)audioAttributes)) {
            this.audioAttributes = audioAttributes;
            this.sendRendererMessage(1, 3, audioAttributes);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage((int)audioAttributes.usage));
            this.analyticsCollector.onAudioAttributesChanged(audioAttributes);
            for (AudioListener audioListener : this.audioListeners) {
                audioListener.onAudioAttributesChanged(audioAttributes);
            }
        }
        this.audioFocusManager.setAudioAttributes((AudioAttributes)(handleAudioFocus ? audioAttributes : null));
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        this.verifyApplicationThread();
        if (this.audioSessionId == audioSessionId) {
            return;
        }
        if (audioSessionId == 0) {
            audioSessionId = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : C.generateAudioSessionIdV21((Context)this.applicationContext);
        } else if (Util.SDK_INT < 21) {
            this.initializeKeepSessionIdAudioTrack(audioSessionId);
        }
        this.audioSessionId = audioSessionId;
        this.sendRendererMessage(1, 102, audioSessionId);
        this.sendRendererMessage(2, 102, audioSessionId);
        this.analyticsCollector.onAudioSessionIdChanged(audioSessionId);
        for (AudioListener audioListener : this.audioListeners) {
            audioListener.onAudioSessionIdChanged(audioSessionId);
        }
    }

    @Override
    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        this.verifyApplicationThread();
        this.sendRendererMessage(1, 5, auxEffectInfo);
    }

    @Override
    public void clearAuxEffectInfo() {
        this.setAuxEffectInfo(new AuxEffectInfo(0, 0.0f));
    }

    @Override
    public void setVolume(float audioVolume) {
        this.verifyApplicationThread();
        audioVolume = Util.constrainValue((float)audioVolume, (float)0.0f, (float)1.0f);
        if (this.audioVolume == audioVolume) {
            return;
        }
        this.audioVolume = audioVolume;
        this.sendVolumeToRenderers();
        this.analyticsCollector.onVolumeChanged(audioVolume);
        for (AudioListener audioListener : this.audioListeners) {
            audioListener.onVolumeChanged(audioVolume);
        }
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.skipSilenceEnabled;
    }

    @Override
    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
        this.verifyApplicationThread();
        if (this.skipSilenceEnabled == skipSilenceEnabled) {
            return;
        }
        this.skipSilenceEnabled = skipSilenceEnabled;
        this.sendRendererMessage(1, 101, skipSilenceEnabled);
        this.notifySkipSilenceEnabledChanged();
    }

    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(AnalyticsListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.analyticsCollector.addListener(listener);
    }

    public void removeAnalyticsListener(AnalyticsListener listener) {
        this.analyticsCollector.removeListener(listener);
    }

    public void setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        this.audioBecomingNoisyManager.setEnabled(handleAudioBecomingNoisy);
    }

    public void setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
        this.verifyApplicationThread();
        if (Util.areEqual((Object)this.priorityTaskManager, (Object)priorityTaskManager)) {
            return;
        }
        if (this.isPriorityTaskManagerRegistered) {
            ((PriorityTaskManager)Assertions.checkNotNull((Object)this.priorityTaskManager)).remove(0);
        }
        if (priorityTaskManager != null && this.isLoading()) {
            priorityTaskManager.add(0);
            this.isPriorityTaskManagerRegistered = true;
        } else {
            this.isPriorityTaskManagerRegistered = false;
        }
        this.priorityTaskManager = priorityTaskManager;
    }

    @Nullable
    public Format getVideoFormat() {
        return this.videoFormat;
    }

    @Nullable
    public Format getAudioFormat() {
        return this.audioFormat;
    }

    @Nullable
    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    @Nullable
    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    @Override
    public void addVideoListener(VideoListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.videoListeners.add(listener);
    }

    @Override
    public void removeVideoListener(VideoListener listener) {
        this.videoListeners.remove(listener);
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        this.videoFrameMetadataListener = listener;
        this.player.createMessage(this.frameMetadataListener).setType(6).setPayload(listener).send();
    }

    @Override
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        if (this.videoFrameMetadataListener != listener) {
            return;
        }
        this.player.createMessage(this.frameMetadataListener).setType(6).setPayload(null).send();
    }

    @Override
    public void setCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        this.cameraMotionListener = listener;
        this.player.createMessage(this.frameMetadataListener).setType(7).setPayload(listener).send();
    }

    @Override
    public void clearCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        if (this.cameraMotionListener != listener) {
            return;
        }
        this.player.createMessage(this.frameMetadataListener).setType(7).setPayload(null).send();
    }

    @Override
    public void addTextOutput(TextOutput listener) {
        Assertions.checkNotNull((Object)listener);
        this.textOutputs.add(listener);
    }

    @Override
    public void removeTextOutput(TextOutput listener) {
        this.textOutputs.remove(listener);
    }

    @Override
    public List<Cue> getCurrentCues() {
        this.verifyApplicationThread();
        return this.currentCues;
    }

    @Override
    public void addMetadataOutput(MetadataOutput listener) {
        Assertions.checkNotNull((Object)listener);
        this.metadataOutputs.add(listener);
    }

    @Override
    public void removeMetadataOutput(MetadataOutput listener) {
        this.metadataOutputs.remove(listener);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    public Clock getClock() {
        return this.player.getClock();
    }

    public void addListener(Player.Listener listener) {
        Assertions.checkNotNull((Object)listener);
        this.addAudioListener((AudioListener)listener);
        this.addVideoListener((VideoListener)listener);
        this.addTextOutput((TextOutput)listener);
        this.addMetadataOutput((MetadataOutput)listener);
        this.addDeviceListener((DeviceListener)listener);
        Player.Listener eventListener = listener;
        this.addListener((Player.EventListener)eventListener);
    }

    public void addListener(Player.EventListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.player.addListener(listener);
    }

    public void removeListener(Player.Listener listener) {
        Assertions.checkNotNull((Object)listener);
        this.removeAudioListener((AudioListener)listener);
        this.removeVideoListener((VideoListener)listener);
        this.removeTextOutput((TextOutput)listener);
        this.removeMetadataOutput((MetadataOutput)listener);
        this.removeDeviceListener((DeviceListener)listener);
        Player.Listener eventListener = listener;
        this.removeListener((Player.EventListener)eventListener);
    }

    public void removeListener(Player.EventListener listener) {
        this.player.removeListener(listener);
    }

    public int getPlaybackState() {
        this.verifyApplicationThread();
        return this.player.getPlaybackState();
    }

    public int getPlaybackSuppressionReason() {
        this.verifyApplicationThread();
        return this.player.getPlaybackSuppressionReason();
    }

    @Nullable
    public ExoPlaybackException getPlayerError() {
        this.verifyApplicationThread();
        return this.player.getPlayerError();
    }

    @Override
    @Deprecated
    public void retry() {
        this.verifyApplicationThread();
        this.prepare();
    }

    public Player.Commands getAvailableCommands() {
        this.verifyApplicationThread();
        return this.player.getAvailableCommands();
    }

    public void prepare() {
        this.verifyApplicationThread();
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, 2);
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        this.player.prepare();
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.verifyApplicationThread();
        this.setMediaSources(Collections.singletonList(mediaSource), resetPosition);
        this.prepare();
    }

    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.verifyApplicationThread();
        this.player.setMediaItems(mediaItems, resetPosition);
    }

    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.player.setMediaItems(mediaItems, startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.player.setMediaSources(mediaSources);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, boolean resetPosition) {
        this.verifyApplicationThread();
        this.player.setMediaSources(mediaSources, resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.player.setMediaSources(mediaSources, startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.setMediaSource(mediaSource);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, boolean resetPosition) {
        this.verifyApplicationThread();
        this.player.setMediaSource(mediaSource, resetPosition);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, long startPositionMs) {
        this.verifyApplicationThread();
        this.player.setMediaSource(mediaSource, startPositionMs);
    }

    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.verifyApplicationThread();
        this.player.addMediaItems(index, mediaItems);
    }

    @Override
    public void addMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(mediaSource);
    }

    @Override
    public void addMediaSource(int index, MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(index, mediaSource);
    }

    @Override
    public void addMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.player.addMediaSources(mediaSources);
    }

    @Override
    public void addMediaSources(int index, List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.player.addMediaSources(index, mediaSources);
    }

    public void moveMediaItems(int fromIndex, int toIndex, int newIndex) {
        this.verifyApplicationThread();
        this.player.moveMediaItems(fromIndex, toIndex, newIndex);
    }

    public void removeMediaItems(int fromIndex, int toIndex) {
        this.verifyApplicationThread();
        this.player.removeMediaItems(fromIndex, toIndex);
    }

    @Override
    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.verifyApplicationThread();
        this.player.setShuffleOrder(shuffleOrder);
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.verifyApplicationThread();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
    }

    public boolean getPlayWhenReady() {
        this.verifyApplicationThread();
        return this.player.getPlayWhenReady();
    }

    @Override
    public void setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
        this.verifyApplicationThread();
        this.player.setPauseAtEndOfMediaItems(pauseAtEndOfMediaItems);
    }

    @Override
    public boolean getPauseAtEndOfMediaItems() {
        this.verifyApplicationThread();
        return this.player.getPauseAtEndOfMediaItems();
    }

    public int getRepeatMode() {
        this.verifyApplicationThread();
        return this.player.getRepeatMode();
    }

    public void setRepeatMode(int repeatMode) {
        this.verifyApplicationThread();
        this.player.setRepeatMode(repeatMode);
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.verifyApplicationThread();
        this.player.setShuffleModeEnabled(shuffleModeEnabled);
    }

    public boolean getShuffleModeEnabled() {
        this.verifyApplicationThread();
        return this.player.getShuffleModeEnabled();
    }

    public boolean isLoading() {
        this.verifyApplicationThread();
        return this.player.isLoading();
    }

    public void seekTo(int windowIndex, long positionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(windowIndex, positionMs);
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.verifyApplicationThread();
        this.player.setPlaybackParameters(playbackParameters);
    }

    public PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThread();
        return this.player.getPlaybackParameters();
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        this.verifyApplicationThread();
        this.player.setSeekParameters(seekParameters);
    }

    @Override
    public SeekParameters getSeekParameters() {
        this.verifyApplicationThread();
        return this.player.getSeekParameters();
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        this.verifyApplicationThread();
        this.player.setForegroundMode(foregroundMode);
    }

    public void stop(boolean reset) {
        this.verifyApplicationThread();
        this.audioFocusManager.updateAudioFocus(this.getPlayWhenReady(), 1);
        this.player.stop(reset);
        this.currentCues = Collections.emptyList();
    }

    public void release() {
        this.verifyApplicationThread();
        if (Util.SDK_INT < 21 && this.keepSessionIdAudioTrack != null) {
            this.keepSessionIdAudioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        this.audioBecomingNoisyManager.setEnabled(false);
        this.streamVolumeManager.release();
        this.wakeLockManager.setStayAwake(false);
        this.wifiLockManager.setStayAwake(false);
        this.audioFocusManager.release();
        this.player.release();
        this.analyticsCollector.release();
        this.removeSurfaceCallbacks();
        if (this.ownedSurface != null) {
            this.ownedSurface.release();
            this.ownedSurface = null;
        }
        if (this.isPriorityTaskManagerRegistered) {
            ((PriorityTaskManager)Assertions.checkNotNull((Object)this.priorityTaskManager)).remove(0);
            this.isPriorityTaskManagerRegistered = false;
        }
        this.currentCues = Collections.emptyList();
        this.playerReleased = true;
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        this.verifyApplicationThread();
        return this.player.createMessage(target);
    }

    @Override
    public int getRendererCount() {
        this.verifyApplicationThread();
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int index) {
        this.verifyApplicationThread();
        return this.player.getRendererType(index);
    }

    @Override
    @Nullable
    public TrackSelector getTrackSelector() {
        this.verifyApplicationThread();
        return this.player.getTrackSelector();
    }

    public TrackGroupArray getCurrentTrackGroups() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackGroups();
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackSelections();
    }

    public List<Metadata> getCurrentStaticMetadata() {
        this.verifyApplicationThread();
        return this.player.getCurrentStaticMetadata();
    }

    public MediaMetadata getMediaMetadata() {
        return this.player.getMediaMetadata();
    }

    public Timeline getCurrentTimeline() {
        this.verifyApplicationThread();
        return this.player.getCurrentTimeline();
    }

    public int getCurrentPeriodIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentPeriodIndex();
    }

    public int getCurrentWindowIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentWindowIndex();
    }

    public long getDuration() {
        this.verifyApplicationThread();
        return this.player.getDuration();
    }

    public long getCurrentPosition() {
        this.verifyApplicationThread();
        return this.player.getCurrentPosition();
    }

    public long getBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getBufferedPosition();
    }

    public long getTotalBufferedDuration() {
        this.verifyApplicationThread();
        return this.player.getTotalBufferedDuration();
    }

    public boolean isPlayingAd() {
        this.verifyApplicationThread();
        return this.player.isPlayingAd();
    }

    public int getCurrentAdGroupIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdGroupIndex();
    }

    public int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdIndexInAdGroup();
    }

    public long getContentPosition() {
        this.verifyApplicationThread();
        return this.player.getContentPosition();
    }

    public long getContentBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getContentBufferedPosition();
    }

    @Deprecated
    public void setHandleWakeLock(boolean handleWakeLock) {
        this.setWakeMode(handleWakeLock ? 1 : 0);
    }

    public void setWakeMode(int wakeMode) {
        this.verifyApplicationThread();
        switch (wakeMode) {
            case 0: {
                this.wakeLockManager.setEnabled(false);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 1: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 2: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void addDeviceListener(DeviceListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.deviceListeners.add(listener);
    }

    @Override
    public void removeDeviceListener(DeviceListener listener) {
        this.deviceListeners.remove(listener);
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        this.verifyApplicationThread();
        return this.deviceInfo;
    }

    @Override
    public int getDeviceVolume() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.getVolume();
    }

    @Override
    public boolean isDeviceMuted() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.isMuted();
    }

    @Override
    public void setDeviceVolume(int volume) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setVolume(volume);
    }

    @Override
    public void increaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.increaseVolume();
    }

    @Override
    public void decreaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.decreaseVolume();
    }

    @Override
    public void setDeviceMuted(boolean muted) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setMuted(muted);
    }

    @Deprecated
    public void setThrowsWhenUsingWrongThread(boolean throwsWhenUsingWrongThread) {
        this.throwsWhenUsingWrongThread = throwsWhenUsingWrongThread;
    }

    private void removeSurfaceCallbacks() {
        if (this.sphericalGLSurfaceView != null) {
            this.player.createMessage(this.frameMetadataListener).setType(10000).setPayload(null).send();
            this.sphericalGLSurfaceView.removeVideoSurfaceListener(this.componentListener);
            this.sphericalGLSurfaceView = null;
        }
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setSurfaceTextureInternal(SurfaceTexture surfaceTexture) {
        Surface surface = new Surface(surfaceTexture);
        this.setVideoOutputInternal(surface);
        this.ownedSurface = surface;
    }

    private void setVideoOutputInternal(@Nullable Object videoOutput) {
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages.add(this.player.createMessage(renderer).setType(1).setPayload(videoOutput).send());
        }
        if (this.videoOutput != null && this.videoOutput != videoOutput) {
            try {
                for (PlayerMessage message : messages) {
                    message.blockUntilDelivered(this.detachSurfaceTimeoutMs);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                this.player.stop(false, ExoPlaybackException.createForRenderer((Exception)new ExoTimeoutException(3)));
            }
            if (this.videoOutput == this.ownedSurface) {
                this.ownedSurface.release();
                this.ownedSurface = null;
            }
        }
        this.videoOutput = videoOutput;
    }

    private void setNonVideoOutputSurfaceHolderInternal(SurfaceHolder nonVideoOutputSurfaceHolder) {
        this.surfaceHolderSurfaceIsVideoOutput = false;
        this.surfaceHolder = nonVideoOutputSurfaceHolder;
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
        Surface surface = this.surfaceHolder.getSurface();
        if (surface != null && surface.isValid()) {
            Rect surfaceSize = this.surfaceHolder.getSurfaceFrame();
            this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
        } else {
            this.maybeNotifySurfaceSizeChanged(0, 0);
        }
    }

    private void maybeNotifySurfaceSizeChanged(int width, int height) {
        if (width != this.surfaceWidth || height != this.surfaceHeight) {
            this.surfaceWidth = width;
            this.surfaceHeight = height;
            this.analyticsCollector.onSurfaceSizeChanged(width, height);
            for (VideoListener videoListener : this.videoListeners) {
                videoListener.onSurfaceSizeChanged(width, height);
            }
        }
    }

    private void sendVolumeToRenderers() {
        float scaledVolume = this.audioVolume * this.audioFocusManager.getVolumeMultiplier();
        this.sendRendererMessage(1, 2, Float.valueOf(scaledVolume));
    }

    private void notifySkipSilenceEnabledChanged() {
        this.analyticsCollector.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        for (AudioListener listener : this.audioListeners) {
            listener.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        }
    }

    private void updatePlayWhenReady(boolean playWhenReady, int playerCommand, int playWhenReadyChangeReason) {
        playWhenReady = playWhenReady && playerCommand != -1;
        int playbackSuppressionReason = playWhenReady && playerCommand != 1 ? 1 : 0;
        this.player.setPlayWhenReady(playWhenReady, playbackSuppressionReason, playWhenReadyChangeReason);
    }

    private void updateWakeAndWifiLock() {
        int playbackState = this.getPlaybackState();
        switch (playbackState) {
            case 2: 
            case 3: {
                boolean isSleeping = this.experimentalIsSleepingForOffload();
                this.wakeLockManager.setStayAwake(this.getPlayWhenReady() && !isSleeping);
                this.wifiLockManager.setStayAwake(this.getPlayWhenReady());
                break;
            }
            case 1: 
            case 4: {
                this.wakeLockManager.setStayAwake(false);
                this.wifiLockManager.setStayAwake(false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void verifyApplicationThread() {
        this.constructorFinished.blockUninterruptible();
        if (Thread.currentThread() != this.getApplicationLooper().getThread()) {
            String message = Util.formatInvariant((String)"Player is accessed on the wrong thread.\nCurrent thread: '%s'\nExpected thread: '%s'\nSee https://exoplayer.dev/issues/player-accessed-on-wrong-thread", (Object[])new Object[]{Thread.currentThread().getName(), this.getApplicationLooper().getThread().getName()});
            if (this.throwsWhenUsingWrongThread) {
                throw new IllegalStateException(message);
            }
            Log.w((String)TAG, (String)message, (Throwable)(this.hasNotifiedFullWrongThreadWarning ? null : new IllegalStateException()));
            this.hasNotifiedFullWrongThreadWarning = true;
        }
    }

    private void sendRendererMessage(int trackType, int messageType, @Nullable Object payload) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != trackType) continue;
            this.player.createMessage(renderer).setType(messageType).setPayload(payload).send();
        }
    }

    private int initializeKeepSessionIdAudioTrack(int audioSessionId) {
        if (this.keepSessionIdAudioTrack != null && this.keepSessionIdAudioTrack.getAudioSessionId() != audioSessionId) {
            this.keepSessionIdAudioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        if (this.keepSessionIdAudioTrack == null) {
            int sampleRate = 4000;
            int channelConfig = 4;
            int encoding = 2;
            int bufferSize = 2;
            this.keepSessionIdAudioTrack = new AudioTrack(3, sampleRate, channelConfig, encoding, bufferSize, 0, audioSessionId);
        }
        return this.keepSessionIdAudioTrack.getAudioSessionId();
    }

    private static DeviceInfo createDeviceInfo(StreamVolumeManager streamVolumeManager) {
        return new DeviceInfo(0, streamVolumeManager.getMinVolume(), streamVolumeManager.getMaxVolume());
    }

    private static int getPlayWhenReadyChangeReason(boolean playWhenReady, int playerCommand) {
        return playWhenReady && playerCommand != 1 ? 2 : 1;
    }

    private static final class FrameMetadataListener
    implements VideoFrameMetadataListener,
    CameraMotionListener,
    PlayerMessage.Target {
        public static final int MSG_SET_VIDEO_FRAME_METADATA_LISTENER = 6;
        public static final int MSG_SET_CAMERA_MOTION_LISTENER = 7;
        public static final int MSG_SET_SPHERICAL_SURFACE_VIEW = 10000;
        @Nullable
        private VideoFrameMetadataListener videoFrameMetadataListener;
        @Nullable
        private CameraMotionListener cameraMotionListener;
        @Nullable
        private VideoFrameMetadataListener internalVideoFrameMetadataListener;
        @Nullable
        private CameraMotionListener internalCameraMotionListener;

        private FrameMetadataListener() {
        }

        @Override
        public void handleMessage(int messageType, @Nullable Object payload) {
            switch (messageType) {
                case 6: {
                    this.videoFrameMetadataListener = (VideoFrameMetadataListener)payload;
                    break;
                }
                case 7: {
                    this.cameraMotionListener = (CameraMotionListener)payload;
                    break;
                }
                case 10000: {
                    SphericalGLSurfaceView surfaceView = (SphericalGLSurfaceView)((Object)payload);
                    if (surfaceView == null) {
                        this.internalVideoFrameMetadataListener = null;
                        this.internalCameraMotionListener = null;
                        break;
                    }
                    this.internalVideoFrameMetadataListener = surfaceView.getVideoFrameMetadataListener();
                    this.internalCameraMotionListener = surfaceView.getCameraMotionListener();
                    break;
                }
            }
        }

        @Override
        public void onVideoFrameAboutToBeRendered(long presentationTimeUs, long releaseTimeNs, Format format, @Nullable MediaFormat mediaFormat) {
            if (this.internalVideoFrameMetadataListener != null) {
                this.internalVideoFrameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, mediaFormat);
            }
            if (this.videoFrameMetadataListener != null) {
                this.videoFrameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, mediaFormat);
            }
        }

        @Override
        public void onCameraMotion(long timeUs, float[] rotation) {
            if (this.internalCameraMotionListener != null) {
                this.internalCameraMotionListener.onCameraMotion(timeUs, rotation);
            }
            if (this.cameraMotionListener != null) {
                this.cameraMotionListener.onCameraMotion(timeUs, rotation);
            }
        }

        @Override
        public void onCameraMotionReset() {
            if (this.internalCameraMotionListener != null) {
                this.internalCameraMotionListener.onCameraMotionReset();
            }
            if (this.cameraMotionListener != null) {
                this.cameraMotionListener.onCameraMotionReset();
            }
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    SphericalGLSurfaceView.VideoSurfaceListener,
    AudioFocusManager.PlayerControl,
    AudioBecomingNoisyManager.EventListener,
    StreamVolumeManager.Listener,
    Player.EventListener,
    ExoPlayer.AudioOffloadListener {
        private ComponentListener() {
        }

        @Override
        public void onVideoEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.videoDecoderCounters = counters;
            SimpleExoPlayer.this.analyticsCollector.onVideoEnabled(counters);
        }

        @Override
        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        @Override
        public void onVideoInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            SimpleExoPlayer.this.videoFormat = format;
            SimpleExoPlayer.this.analyticsCollector.onVideoInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onDroppedFrames(int count, long elapsed) {
            SimpleExoPlayer.this.analyticsCollector.onDroppedFrames(count, elapsed);
        }

        @Override
        public void onVideoSizeChanged(VideoSize videoSize) {
            SimpleExoPlayer.this.videoSize = videoSize;
            SimpleExoPlayer.this.analyticsCollector.onVideoSizeChanged(videoSize);
            for (VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                videoListener.onVideoSizeChanged(videoSize);
                videoListener.onVideoSizeChanged(videoSize.width, videoSize.height, videoSize.unappliedRotationDegrees, videoSize.pixelWidthHeightRatio);
            }
        }

        @Override
        public void onRenderedFirstFrame(Object output, long renderTimeMs) {
            SimpleExoPlayer.this.analyticsCollector.onRenderedFirstFrame(output, renderTimeMs);
            if (SimpleExoPlayer.this.videoOutput == output) {
                for (VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                    videoListener.onRenderedFirstFrame();
                }
            }
        }

        @Override
        public void onVideoDecoderReleased(String decoderName) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDecoderReleased(decoderName);
        }

        @Override
        public void onVideoDisabled(DecoderCounters counters) {
            SimpleExoPlayer.this.analyticsCollector.onVideoDisabled(counters);
            SimpleExoPlayer.this.videoFormat = null;
            SimpleExoPlayer.this.videoDecoderCounters = null;
        }

        @Override
        public void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
            SimpleExoPlayer.this.analyticsCollector.onVideoFrameProcessingOffset(totalProcessingOffsetUs, frameCount);
        }

        @Override
        public void onVideoCodecError(Exception videoCodecError) {
            SimpleExoPlayer.this.analyticsCollector.onVideoCodecError(videoCodecError);
        }

        @Override
        public void onAudioEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.audioDecoderCounters = counters;
            SimpleExoPlayer.this.analyticsCollector.onAudioEnabled(counters);
        }

        @Override
        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        @Override
        public void onAudioInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            SimpleExoPlayer.this.audioFormat = format;
            SimpleExoPlayer.this.analyticsCollector.onAudioInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
            SimpleExoPlayer.this.analyticsCollector.onAudioPositionAdvancing(playoutStartSystemTimeMs);
        }

        @Override
        public void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            SimpleExoPlayer.this.analyticsCollector.onAudioUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }

        @Override
        public void onAudioDecoderReleased(String decoderName) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDecoderReleased(decoderName);
        }

        @Override
        public void onAudioDisabled(DecoderCounters counters) {
            SimpleExoPlayer.this.analyticsCollector.onAudioDisabled(counters);
            SimpleExoPlayer.this.audioFormat = null;
            SimpleExoPlayer.this.audioDecoderCounters = null;
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            if (SimpleExoPlayer.this.skipSilenceEnabled == skipSilenceEnabled) {
                return;
            }
            SimpleExoPlayer.this.skipSilenceEnabled = skipSilenceEnabled;
            SimpleExoPlayer.this.notifySkipSilenceEnabledChanged();
        }

        @Override
        public void onAudioSinkError(Exception audioSinkError) {
            SimpleExoPlayer.this.analyticsCollector.onAudioSinkError(audioSinkError);
        }

        @Override
        public void onAudioCodecError(Exception audioCodecError) {
            SimpleExoPlayer.this.analyticsCollector.onAudioCodecError(audioCodecError);
        }

        public void onCues(List<Cue> cues) {
            SimpleExoPlayer.this.currentCues = cues;
            for (TextOutput textOutput : SimpleExoPlayer.this.textOutputs) {
                textOutput.onCues(cues);
            }
        }

        public void onMetadata(Metadata metadata) {
            SimpleExoPlayer.this.analyticsCollector.onMetadata(metadata);
            SimpleExoPlayer.this.player.onMetadata(metadata);
            for (MetadataOutput metadataOutput : SimpleExoPlayer.this.metadataOutputs) {
                metadataOutput.onMetadata(metadata);
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (SimpleExoPlayer.this.surfaceHolderSurfaceIsVideoOutput) {
                SimpleExoPlayer.this.setVideoOutputInternal(holder.getSurface());
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (SimpleExoPlayer.this.surfaceHolderSurfaceIsVideoOutput) {
                SimpleExoPlayer.this.setVideoOutputInternal(null);
            }
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.setSurfaceTextureInternal(surfaceTexture);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoOutputInternal(null);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void onVideoSurfaceCreated(Surface surface) {
            SimpleExoPlayer.this.setVideoOutputInternal(surface);
        }

        @Override
        public void onVideoSurfaceDestroyed(Surface surface) {
            SimpleExoPlayer.this.setVideoOutputInternal(null);
        }

        @Override
        public void setVolumeMultiplier(float volumeMultiplier) {
            SimpleExoPlayer.this.sendVolumeToRenderers();
        }

        @Override
        public void executePlayerCommand(int playerCommand) {
            boolean playWhenReady = SimpleExoPlayer.this.getPlayWhenReady();
            SimpleExoPlayer.this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        }

        @Override
        public void onAudioBecomingNoisy() {
            SimpleExoPlayer.this.updatePlayWhenReady(false, -1, 3);
        }

        @Override
        public void onStreamTypeChanged(int streamType) {
            DeviceInfo deviceInfo = SimpleExoPlayer.createDeviceInfo(SimpleExoPlayer.this.streamVolumeManager);
            if (!deviceInfo.equals((Object)SimpleExoPlayer.this.deviceInfo)) {
                SimpleExoPlayer.this.deviceInfo = deviceInfo;
                for (DeviceListener deviceListener : SimpleExoPlayer.this.deviceListeners) {
                    deviceListener.onDeviceInfoChanged(deviceInfo);
                }
            }
        }

        @Override
        public void onStreamVolumeChanged(int streamVolume, boolean streamMuted) {
            for (DeviceListener deviceListener : SimpleExoPlayer.this.deviceListeners) {
                deviceListener.onDeviceVolumeChanged(streamVolume, streamMuted);
            }
        }

        public void onIsLoadingChanged(boolean isLoading) {
            if (SimpleExoPlayer.this.priorityTaskManager != null) {
                if (isLoading && !SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.add(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = true;
                } else if (!isLoading && SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.remove(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = false;
                }
            }
        }

        public void onPlaybackStateChanged(int playbackState) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        @Override
        public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }
    }

    public static final class Builder {
        private final Context context;
        private final RenderersFactory renderersFactory;
        private Clock clock;
        private long foregroundModeTimeoutMs;
        private TrackSelector trackSelector;
        private MediaSourceFactory mediaSourceFactory;
        private LoadControl loadControl;
        private BandwidthMeter bandwidthMeter;
        private AnalyticsCollector analyticsCollector;
        private Looper looper;
        @Nullable
        private PriorityTaskManager priorityTaskManager;
        private AudioAttributes audioAttributes;
        private boolean handleAudioFocus;
        private int wakeMode;
        private boolean handleAudioBecomingNoisy;
        private boolean skipSilenceEnabled;
        private int videoScalingMode;
        private boolean useLazyPreparation;
        private SeekParameters seekParameters;
        private LivePlaybackSpeedControl livePlaybackSpeedControl;
        private long releaseTimeoutMs;
        private long detachSurfaceTimeoutMs;
        private boolean pauseAtEndOfMediaItems;
        private boolean buildCalled;

        public Builder(Context context) {
            this(context, new DefaultRenderersFactory(context), (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Builder(Context context, RenderersFactory renderersFactory) {
            this(context, renderersFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Builder(Context context, ExtractorsFactory extractorsFactory) {
            this(context, new DefaultRenderersFactory(context), extractorsFactory);
        }

        public Builder(Context context, RenderersFactory renderersFactory, ExtractorsFactory extractorsFactory) {
            this(context, renderersFactory, new DefaultTrackSelector(context), new DefaultMediaSourceFactory(context, extractorsFactory), new DefaultLoadControl(), DefaultBandwidthMeter.getSingletonInstance(context), new AnalyticsCollector(Clock.DEFAULT));
        }

        public Builder(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector) {
            this.context = context;
            this.renderersFactory = renderersFactory;
            this.trackSelector = trackSelector;
            this.mediaSourceFactory = mediaSourceFactory;
            this.loadControl = loadControl;
            this.bandwidthMeter = bandwidthMeter;
            this.analyticsCollector = analyticsCollector;
            this.looper = Util.getCurrentOrMainLooper();
            this.audioAttributes = AudioAttributes.DEFAULT;
            this.wakeMode = 0;
            this.videoScalingMode = 1;
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.livePlaybackSpeedControl = new DefaultLivePlaybackSpeedControl.Builder().build();
            this.clock = Clock.DEFAULT;
            this.releaseTimeoutMs = 500L;
            this.detachSurfaceTimeoutMs = 2000L;
        }

        public Builder experimentalSetForegroundModeTimeoutMs(long timeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.foregroundModeTimeoutMs = timeoutMs;
            return this;
        }

        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.trackSelector = trackSelector;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.loadControl = loadControl;
            return this;
        }

        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.bandwidthMeter = bandwidthMeter;
            return this;
        }

        public Builder setLooper(Looper looper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.looper = looper;
            return this;
        }

        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.analyticsCollector = analyticsCollector;
            return this;
        }

        public Builder setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.priorityTaskManager = priorityTaskManager;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.audioAttributes = audioAttributes;
            this.handleAudioFocus = handleAudioFocus;
            return this;
        }

        public Builder setWakeMode(int wakeMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.wakeMode = wakeMode;
            return this;
        }

        public Builder setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.handleAudioBecomingNoisy = handleAudioBecomingNoisy;
            return this;
        }

        public Builder setSkipSilenceEnabled(boolean skipSilenceEnabled) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.skipSilenceEnabled = skipSilenceEnabled;
            return this;
        }

        public Builder setVideoScalingMode(int videoScalingMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.videoScalingMode = videoScalingMode;
            return this;
        }

        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekParameters = seekParameters;
            return this;
        }

        public Builder setReleaseTimeoutMs(long releaseTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.releaseTimeoutMs = releaseTimeoutMs;
            return this;
        }

        public Builder setDetachSurfaceTimeoutMs(long detachSurfaceTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.detachSurfaceTimeoutMs = detachSurfaceTimeoutMs;
            return this;
        }

        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        public Builder setLivePlaybackSpeedControl(LivePlaybackSpeedControl livePlaybackSpeedControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.livePlaybackSpeedControl = livePlaybackSpeedControl;
            return this;
        }

        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.clock = clock;
            return this;
        }

        public SimpleExoPlayer build() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            return new SimpleExoPlayer(this);
        }
    }
}

