/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.analytics;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ExoFlags;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface AnalyticsListener {
    public static final int EVENT_TIMELINE_CHANGED = 0;
    public static final int EVENT_MEDIA_ITEM_TRANSITION = 1;
    public static final int EVENT_TRACKS_CHANGED = 2;
    public static final int EVENT_STATIC_METADATA_CHANGED = 3;
    public static final int EVENT_IS_LOADING_CHANGED = 4;
    public static final int EVENT_PLAYBACK_STATE_CHANGED = 5;
    public static final int EVENT_PLAY_WHEN_READY_CHANGED = 6;
    public static final int EVENT_PLAYBACK_SUPPRESSION_REASON_CHANGED = 7;
    public static final int EVENT_IS_PLAYING_CHANGED = 8;
    public static final int EVENT_REPEAT_MODE_CHANGED = 9;
    public static final int EVENT_SHUFFLE_MODE_ENABLED_CHANGED = 10;
    public static final int EVENT_PLAYER_ERROR = 11;
    public static final int EVENT_POSITION_DISCONTINUITY = 12;
    public static final int EVENT_PLAYBACK_PARAMETERS_CHANGED = 13;
    public static final int EVENT_MEDIA_METADATA_CHANGED = 15;
    public static final int EVENT_LOAD_STARTED = 1000;
    public static final int EVENT_LOAD_COMPLETED = 1001;
    public static final int EVENT_LOAD_CANCELED = 1002;
    public static final int EVENT_LOAD_ERROR = 1003;
    public static final int EVENT_DOWNSTREAM_FORMAT_CHANGED = 1004;
    public static final int EVENT_UPSTREAM_DISCARDED = 1005;
    public static final int EVENT_BANDWIDTH_ESTIMATE = 1006;
    public static final int EVENT_METADATA = 1007;
    public static final int EVENT_AUDIO_ENABLED = 1008;
    public static final int EVENT_AUDIO_DECODER_INITIALIZED = 1009;
    public static final int EVENT_AUDIO_INPUT_FORMAT_CHANGED = 1010;
    public static final int EVENT_AUDIO_POSITION_ADVANCING = 1011;
    public static final int EVENT_AUDIO_UNDERRUN = 1012;
    public static final int EVENT_AUDIO_DECODER_RELEASED = 1013;
    public static final int EVENT_AUDIO_DISABLED = 1014;
    public static final int EVENT_AUDIO_SESSION_ID = 1015;
    public static final int EVENT_AUDIO_ATTRIBUTES_CHANGED = 1016;
    public static final int EVENT_SKIP_SILENCE_ENABLED_CHANGED = 1017;
    public static final int EVENT_AUDIO_SINK_ERROR = 1018;
    public static final int EVENT_VOLUME_CHANGED = 1019;
    public static final int EVENT_VIDEO_ENABLED = 1020;
    public static final int EVENT_VIDEO_DECODER_INITIALIZED = 1021;
    public static final int EVENT_VIDEO_INPUT_FORMAT_CHANGED = 1022;
    public static final int EVENT_DROPPED_VIDEO_FRAMES = 1023;
    public static final int EVENT_VIDEO_DECODER_RELEASED = 1024;
    public static final int EVENT_VIDEO_DISABLED = 1025;
    public static final int EVENT_VIDEO_FRAME_PROCESSING_OFFSET = 1026;
    public static final int EVENT_RENDERED_FIRST_FRAME = 1027;
    public static final int EVENT_VIDEO_SIZE_CHANGED = 1028;
    public static final int EVENT_SURFACE_SIZE_CHANGED = 1029;
    public static final int EVENT_DRM_SESSION_ACQUIRED = 1030;
    public static final int EVENT_DRM_KEYS_LOADED = 1031;
    public static final int EVENT_DRM_SESSION_MANAGER_ERROR = 1032;
    public static final int EVENT_DRM_KEYS_RESTORED = 1033;
    public static final int EVENT_DRM_KEYS_REMOVED = 1034;
    public static final int EVENT_DRM_SESSION_RELEASED = 1035;
    public static final int EVENT_PLAYER_RELEASED = 1036;
    public static final int EVENT_AUDIO_CODEC_ERROR = 1037;
    public static final int EVENT_VIDEO_CODEC_ERROR = 1038;

    @Deprecated
    default public void onPlayerStateChanged(EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    default public void onPlaybackStateChanged(EventTime eventTime, int state) {
    }

    default public void onPlayWhenReadyChanged(EventTime eventTime, boolean playWhenReady, int reason) {
    }

    default public void onPlaybackSuppressionReasonChanged(EventTime eventTime, int playbackSuppressionReason) {
    }

    default public void onIsPlayingChanged(EventTime eventTime, boolean isPlaying) {
    }

    default public void onTimelineChanged(EventTime eventTime, int reason) {
    }

    default public void onMediaItemTransition(EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
    }

    @Deprecated
    default public void onPositionDiscontinuity(EventTime eventTime, int reason) {
    }

    default public void onPositionDiscontinuity(EventTime eventTime, Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
    }

    @Deprecated
    default public void onSeekStarted(EventTime eventTime) {
    }

    @Deprecated
    default public void onSeekProcessed(EventTime eventTime) {
    }

    default public void onPlaybackParametersChanged(EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    default public void onRepeatModeChanged(EventTime eventTime, int repeatMode) {
    }

    default public void onShuffleModeChanged(EventTime eventTime, boolean shuffleModeEnabled) {
    }

    default public void onIsLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    @Deprecated
    default public void onLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    default public void onPlayerError(EventTime eventTime, ExoPlaybackException error) {
    }

    default public void onTracksChanged(EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    default public void onStaticMetadataChanged(EventTime eventTime, List<Metadata> metadataList) {
    }

    default public void onMediaMetadataChanged(EventTime eventTime, MediaMetadata mediaMetadata) {
    }

    default public void onLoadStarted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCompleted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCanceled(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadError(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    default public void onDownstreamFormatChanged(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    default public void onUpstreamDiscarded(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    default public void onBandwidthEstimate(EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    default public void onMetadata(EventTime eventTime, Metadata metadata) {
    }

    @Deprecated
    default public void onDecoderEnabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    @Deprecated
    default public void onDecoderInitialized(EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    default public void onDecoderInputFormatChanged(EventTime eventTime, int trackType, Format format) {
    }

    @Deprecated
    default public void onDecoderDisabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    default public void onAudioEnabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onAudioDecoderInitialized(EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    default public void onAudioDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    default public void onAudioInputFormatChanged(EventTime eventTime, Format format) {
    }

    default public void onAudioInputFormatChanged(EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    default public void onAudioPositionAdvancing(EventTime eventTime, long playoutStartSystemTimeMs) {
    }

    default public void onAudioUnderrun(EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onAudioDecoderReleased(EventTime eventTime, String decoderName) {
    }

    default public void onAudioDisabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onAudioSessionIdChanged(EventTime eventTime, int audioSessionId) {
    }

    default public void onAudioAttributesChanged(EventTime eventTime, AudioAttributes audioAttributes) {
    }

    default public void onSkipSilenceEnabledChanged(EventTime eventTime, boolean skipSilenceEnabled) {
    }

    default public void onAudioSinkError(EventTime eventTime, Exception audioSinkError) {
    }

    default public void onAudioCodecError(EventTime eventTime, Exception audioCodecError) {
    }

    default public void onVolumeChanged(EventTime eventTime, float volume) {
    }

    default public void onVideoEnabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onVideoDecoderInitialized(EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    default public void onVideoDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    default public void onVideoInputFormatChanged(EventTime eventTime, Format format) {
    }

    default public void onVideoInputFormatChanged(EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    default public void onDroppedVideoFrames(EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    default public void onVideoDecoderReleased(EventTime eventTime, String decoderName) {
    }

    default public void onVideoDisabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onVideoFrameProcessingOffset(EventTime eventTime, long totalProcessingOffsetUs, int frameCount) {
    }

    default public void onVideoCodecError(EventTime eventTime, Exception videoCodecError) {
    }

    default public void onRenderedFirstFrame(EventTime eventTime, Object output, long renderTimeMs) {
    }

    default public void onVideoSizeChanged(EventTime eventTime, VideoSize videoSize) {
    }

    @Deprecated
    default public void onVideoSizeChanged(EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
    }

    default public void onSurfaceSizeChanged(EventTime eventTime, int width, int height) {
    }

    @Deprecated
    default public void onDrmSessionAcquired(EventTime eventTime) {
    }

    default public void onDrmSessionAcquired(EventTime eventTime, int state) {
    }

    default public void onDrmKeysLoaded(EventTime eventTime) {
    }

    default public void onDrmSessionManagerError(EventTime eventTime, Exception error) {
    }

    default public void onDrmKeysRestored(EventTime eventTime) {
    }

    default public void onDrmKeysRemoved(EventTime eventTime) {
    }

    default public void onDrmSessionReleased(EventTime eventTime) {
    }

    default public void onPlayerReleased(EventTime eventTime) {
    }

    default public void onEvents(Player player, Events events) {
    }

    public static final class EventTime {
        public final long realtimeMs;
        public final Timeline timeline;
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final long eventPlaybackPositionMs;
        public final Timeline currentTimeline;
        public final int currentWindowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId currentMediaPeriodId;
        public final long currentPlaybackPositionMs;
        public final long totalBufferedDurationMs;

        public EventTime(long realtimeMs, Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long eventPlaybackPositionMs, Timeline currentTimeline, int currentWindowIndex, @Nullable MediaSource.MediaPeriodId currentMediaPeriodId, long currentPlaybackPositionMs, long totalBufferedDurationMs) {
            this.realtimeMs = realtimeMs;
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
            this.eventPlaybackPositionMs = eventPlaybackPositionMs;
            this.currentTimeline = currentTimeline;
            this.currentWindowIndex = currentWindowIndex;
            this.currentMediaPeriodId = currentMediaPeriodId;
            this.currentPlaybackPositionMs = currentPlaybackPositionMs;
            this.totalBufferedDurationMs = totalBufferedDurationMs;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTime eventTime = (EventTime)o;
            return this.realtimeMs == eventTime.realtimeMs && this.windowIndex == eventTime.windowIndex && this.eventPlaybackPositionMs == eventTime.eventPlaybackPositionMs && this.currentWindowIndex == eventTime.currentWindowIndex && this.currentPlaybackPositionMs == eventTime.currentPlaybackPositionMs && this.totalBufferedDurationMs == eventTime.totalBufferedDurationMs && Objects.equal((Object)this.timeline, (Object)eventTime.timeline) && Objects.equal((Object)((Object)this.mediaPeriodId), (Object)((Object)eventTime.mediaPeriodId)) && Objects.equal((Object)this.currentTimeline, (Object)eventTime.currentTimeline) && Objects.equal((Object)((Object)this.currentMediaPeriodId), (Object)((Object)eventTime.currentMediaPeriodId));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.realtimeMs, this.timeline, this.windowIndex, this.mediaPeriodId, this.eventPlaybackPositionMs, this.currentTimeline, this.currentWindowIndex, this.currentMediaPeriodId, this.currentPlaybackPositionMs, this.totalBufferedDurationMs});
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventFlags {
    }

    public static final class Events {
        private final ExoFlags flags;
        private final SparseArray<EventTime> eventTimes;

        public Events(ExoFlags flags, SparseArray<EventTime> eventTimes) {
            this.flags = flags;
            SparseArray flagsToTimes = new SparseArray(flags.size());
            for (int i = 0; i < flags.size(); ++i) {
                int eventFlag = flags.get(i);
                flagsToTimes.append(eventFlag, (Object)((EventTime)Assertions.checkNotNull((Object)((EventTime)eventTimes.get(eventFlag)))));
            }
            this.eventTimes = flagsToTimes;
        }

        public EventTime getEventTime(int event) {
            return (EventTime)Assertions.checkNotNull((Object)((EventTime)this.eventTimes.get(event)));
        }

        public boolean contains(int event) {
            return this.flags.contains(event);
        }

        public boolean containsAny(int ... events) {
            return this.flags.containsAny(events);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }
    }
}

