/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.analytics;

import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.analytics.DefaultPlaybackSessionManager;
import com.google.android.exoplayer2.analytics.PlaybackSessionManager;
import com.google.android.exoplayer2.analytics.PlaybackStats;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PlaybackStatsListener
implements AnalyticsListener,
PlaybackSessionManager.Listener {
    private final PlaybackSessionManager sessionManager;
    private final Map<String, PlaybackStatsTracker> playbackStatsTrackers;
    private final Map<String, AnalyticsListener.EventTime> sessionStartEventTimes;
    @Nullable
    private final Callback callback;
    private final boolean keepHistory;
    private final Timeline.Period period;
    private PlaybackStats finishedPlaybackStats;
    @Nullable
    private String discontinuityFromSession;
    private long discontinuityFromPositionMs;
    private int discontinuityReason;
    private int droppedFrames;
    @Nullable
    private Exception nonFatalException;
    private long bandwidthTimeMs;
    private long bandwidthBytes;
    @Nullable
    private Format videoFormat;
    @Nullable
    private Format audioFormat;
    private VideoSize videoSize;

    public PlaybackStatsListener(boolean keepHistory, @Nullable Callback callback) {
        this.callback = callback;
        this.keepHistory = keepHistory;
        this.sessionManager = new DefaultPlaybackSessionManager();
        this.playbackStatsTrackers = new HashMap<String, PlaybackStatsTracker>();
        this.sessionStartEventTimes = new HashMap<String, AnalyticsListener.EventTime>();
        this.finishedPlaybackStats = PlaybackStats.EMPTY;
        this.period = new Timeline.Period();
        this.videoSize = VideoSize.UNKNOWN;
        this.sessionManager.setListener(this);
    }

    public PlaybackStats getCombinedPlaybackStats() {
        PlaybackStats[] allPendingPlaybackStats = new PlaybackStats[this.playbackStatsTrackers.size() + 1];
        allPendingPlaybackStats[0] = this.finishedPlaybackStats;
        int index = 1;
        for (PlaybackStatsTracker tracker : this.playbackStatsTrackers.values()) {
            allPendingPlaybackStats[index++] = tracker.build(false);
        }
        return PlaybackStats.merge(allPendingPlaybackStats);
    }

    @Nullable
    public PlaybackStats getPlaybackStats() {
        String activeSessionId = this.sessionManager.getActiveSessionId();
        PlaybackStatsTracker activeStatsTracker = activeSessionId == null ? null : this.playbackStatsTrackers.get(activeSessionId);
        return activeStatsTracker == null ? null : activeStatsTracker.build(false);
    }

    @Override
    public void onSessionCreated(AnalyticsListener.EventTime eventTime, String session) {
        PlaybackStatsTracker tracker = new PlaybackStatsTracker(this.keepHistory, eventTime);
        this.playbackStatsTrackers.put(session, tracker);
        this.sessionStartEventTimes.put(session, eventTime);
    }

    @Override
    public void onSessionActive(AnalyticsListener.EventTime eventTime, String session) {
        ((PlaybackStatsTracker)Assertions.checkNotNull((Object)this.playbackStatsTrackers.get(session))).onForeground();
    }

    @Override
    public void onAdPlaybackStarted(AnalyticsListener.EventTime eventTime, String contentSession, String adSession) {
        ((PlaybackStatsTracker)Assertions.checkNotNull((Object)this.playbackStatsTrackers.get(contentSession))).onInterruptedByAd();
    }

    @Override
    public void onSessionFinished(AnalyticsListener.EventTime eventTime, String session, boolean automaticTransition) {
        PlaybackStatsTracker tracker = (PlaybackStatsTracker)Assertions.checkNotNull((Object)this.playbackStatsTrackers.remove(session));
        AnalyticsListener.EventTime startEventTime = (AnalyticsListener.EventTime)Assertions.checkNotNull((Object)this.sessionStartEventTimes.remove(session));
        long discontinuityFromPositionMs = session.equals(this.discontinuityFromSession) ? this.discontinuityFromPositionMs : -9223372036854775807L;
        tracker.onFinished(eventTime, automaticTransition, discontinuityFromPositionMs);
        PlaybackStats playbackStats = tracker.build(true);
        this.finishedPlaybackStats = PlaybackStats.merge(this.finishedPlaybackStats, playbackStats);
        if (this.callback != null) {
            this.callback.onPlaybackStatsReady(startEventTime, playbackStats);
        }
    }

    @Override
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, Player.PositionInfo oldPositionInfo, Player.PositionInfo newPositionInfo, int reason) {
        if (this.discontinuityFromSession == null) {
            this.discontinuityFromSession = this.sessionManager.getActiveSessionId();
            this.discontinuityFromPositionMs = oldPositionInfo.positionMs;
        }
        this.discontinuityReason = reason;
    }

    @Override
    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        this.droppedFrames = droppedFrames;
    }

    @Override
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.nonFatalException = error;
    }

    @Override
    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
        this.nonFatalException = error;
    }

    @Override
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        this.bandwidthTimeMs = totalLoadTimeMs;
        this.bandwidthBytes = totalBytesLoaded;
    }

    @Override
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        if (mediaLoadData.trackType == 2 || mediaLoadData.trackType == 0) {
            this.videoFormat = mediaLoadData.trackFormat;
        } else if (mediaLoadData.trackType == 1) {
            this.audioFormat = mediaLoadData.trackFormat;
        }
    }

    @Override
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, VideoSize videoSize) {
        this.videoSize = videoSize;
    }

    @Override
    public void onEvents(Player player, AnalyticsListener.Events events) {
        if (events.size() == 0) {
            return;
        }
        this.maybeAddSessions(events);
        for (String session : this.playbackStatsTrackers.keySet()) {
            Pair<AnalyticsListener.EventTime, Boolean> eventTimeAndBelongsToPlayback = this.findBestEventTime(events, session);
            PlaybackStatsTracker tracker = this.playbackStatsTrackers.get(session);
            boolean hasDiscontinuityToPlayback = this.hasEvent(events, session, 12);
            boolean hasDroppedFrames = this.hasEvent(events, session, 1023);
            boolean hasAudioUnderrun = this.hasEvent(events, session, 1012);
            boolean startedLoading = this.hasEvent(events, session, 1000);
            boolean hasFatalError = this.hasEvent(events, session, 11);
            boolean hasNonFatalException = this.hasEvent(events, session, 1003) || this.hasEvent(events, session, 1032);
            boolean hasBandwidthData = this.hasEvent(events, session, 1006);
            boolean hasFormatData = this.hasEvent(events, session, 1004);
            boolean hasVideoSize = this.hasEvent(events, session, 1028);
            tracker.onEvents(player, (AnalyticsListener.EventTime)eventTimeAndBelongsToPlayback.first, (Boolean)eventTimeAndBelongsToPlayback.second, session.equals(this.discontinuityFromSession) ? this.discontinuityFromPositionMs : -9223372036854775807L, hasDiscontinuityToPlayback, hasDroppedFrames ? this.droppedFrames : 0, hasAudioUnderrun, startedLoading, hasFatalError ? player.getPlayerError() : null, hasNonFatalException ? this.nonFatalException : null, hasBandwidthData ? this.bandwidthTimeMs : 0L, hasBandwidthData ? this.bandwidthBytes : 0L, hasFormatData ? this.videoFormat : null, hasFormatData ? this.audioFormat : null, hasVideoSize ? this.videoSize : null);
        }
        this.videoFormat = null;
        this.audioFormat = null;
        this.discontinuityFromSession = null;
        if (events.contains(1036)) {
            this.sessionManager.finishAllSessions(events.getEventTime(1036));
        }
    }

    private void maybeAddSessions(AnalyticsListener.Events events) {
        for (int i = 0; i < events.size(); ++i) {
            int event = events.get(i);
            AnalyticsListener.EventTime eventTime = events.getEventTime(event);
            if (event == 0) {
                this.sessionManager.updateSessionsWithTimelineChange(eventTime);
                continue;
            }
            if (event == 12) {
                this.sessionManager.updateSessionsWithDiscontinuity(eventTime, this.discontinuityReason);
                continue;
            }
            this.sessionManager.updateSessions(eventTime);
        }
    }

    private Pair<AnalyticsListener.EventTime, Boolean> findBestEventTime(AnalyticsListener.Events events, String session) {
        AnalyticsListener.EventTime eventTime = null;
        boolean belongsToPlayback = false;
        for (int i = 0; i < events.size(); ++i) {
            int event = events.get(i);
            AnalyticsListener.EventTime newEventTime = events.getEventTime(event);
            boolean newBelongsToPlayback = this.sessionManager.belongsToSession(newEventTime, session);
            if (eventTime != null && (!newBelongsToPlayback || belongsToPlayback) && (newBelongsToPlayback != belongsToPlayback || newEventTime.realtimeMs <= eventTime.realtimeMs)) continue;
            eventTime = newEventTime;
            belongsToPlayback = newBelongsToPlayback;
        }
        Assertions.checkNotNull(eventTime);
        if (!belongsToPlayback && eventTime.mediaPeriodId != null && eventTime.mediaPeriodId.isAd()) {
            long contentPeriodPositionUs = eventTime.timeline.getPeriodByUid(eventTime.mediaPeriodId.periodUid, this.period).getAdGroupTimeUs(eventTime.mediaPeriodId.adGroupIndex);
            if (contentPeriodPositionUs == Long.MIN_VALUE) {
                contentPeriodPositionUs = this.period.durationUs;
            }
            long contentWindowPositionUs = contentPeriodPositionUs + this.period.getPositionInWindowUs();
            eventTime = new AnalyticsListener.EventTime(eventTime.realtimeMs, eventTime.timeline, eventTime.windowIndex, new MediaSource.MediaPeriodId(eventTime.mediaPeriodId.periodUid, eventTime.mediaPeriodId.windowSequenceNumber, eventTime.mediaPeriodId.adGroupIndex), C.usToMs((long)contentWindowPositionUs), eventTime.timeline, eventTime.currentWindowIndex, eventTime.currentMediaPeriodId, eventTime.currentPlaybackPositionMs, eventTime.totalBufferedDurationMs);
            belongsToPlayback = this.sessionManager.belongsToSession(eventTime, session);
        }
        return Pair.create(eventTime, (Object)belongsToPlayback);
    }

    private boolean hasEvent(AnalyticsListener.Events events, String session, int event) {
        return events.contains(event) && this.sessionManager.belongsToSession(events.getEventTime(event), session);
    }

    private static final class PlaybackStatsTracker {
        private final boolean keepHistory;
        private final long[] playbackStateDurationsMs;
        private final List<PlaybackStats.EventTimeAndPlaybackState> playbackStateHistory;
        private final List<long[]> mediaTimeHistory;
        private final List<PlaybackStats.EventTimeAndFormat> videoFormatHistory;
        private final List<PlaybackStats.EventTimeAndFormat> audioFormatHistory;
        private final List<PlaybackStats.EventTimeAndException> fatalErrorHistory;
        private final List<PlaybackStats.EventTimeAndException> nonFatalErrorHistory;
        private final boolean isAd;
        private long firstReportedTimeMs;
        private boolean hasBeenReady;
        private boolean hasEnded;
        private boolean isJoinTimeInvalid;
        private int pauseCount;
        private int pauseBufferCount;
        private int seekCount;
        private int rebufferCount;
        private long maxRebufferTimeMs;
        private int initialVideoFormatHeight;
        private long initialVideoFormatBitrate;
        private long initialAudioFormatBitrate;
        private long videoFormatHeightTimeMs;
        private long videoFormatHeightTimeProduct;
        private long videoFormatBitrateTimeMs;
        private long videoFormatBitrateTimeProduct;
        private long audioFormatTimeMs;
        private long audioFormatBitrateTimeProduct;
        private long bandwidthTimeMs;
        private long bandwidthBytes;
        private long droppedFrames;
        private long audioUnderruns;
        private int fatalErrorCount;
        private int nonFatalErrorCount;
        private int currentPlaybackState;
        private long currentPlaybackStateStartTimeMs;
        private boolean isSeeking;
        private boolean isForeground;
        private boolean isInterruptedByAd;
        private boolean hasFatalError;
        private boolean startedLoading;
        private long lastRebufferStartTimeMs;
        @Nullable
        private Format currentVideoFormat;
        @Nullable
        private Format currentAudioFormat;
        private long lastVideoFormatStartTimeMs;
        private long lastAudioFormatStartTimeMs;
        private float currentPlaybackSpeed;

        public PlaybackStatsTracker(boolean keepHistory, AnalyticsListener.EventTime startTime) {
            this.keepHistory = keepHistory;
            this.playbackStateDurationsMs = new long[16];
            this.playbackStateHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.mediaTimeHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.videoFormatHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.audioFormatHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.fatalErrorHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.nonFatalErrorHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.currentPlaybackState = 0;
            this.currentPlaybackStateStartTimeMs = startTime.realtimeMs;
            this.firstReportedTimeMs = -9223372036854775807L;
            this.maxRebufferTimeMs = -9223372036854775807L;
            this.isAd = startTime.mediaPeriodId != null && startTime.mediaPeriodId.isAd();
            this.initialAudioFormatBitrate = -1L;
            this.initialVideoFormatBitrate = -1L;
            this.initialVideoFormatHeight = -1;
            this.currentPlaybackSpeed = 1.0f;
        }

        public void onForeground() {
            this.isForeground = true;
        }

        public void onInterruptedByAd() {
            this.isInterruptedByAd = true;
            this.isSeeking = false;
        }

        public void onFinished(AnalyticsListener.EventTime eventTime, boolean automaticTransition, long discontinuityFromPositionMs) {
            int finalPlaybackState = this.currentPlaybackState == 11 || automaticTransition ? 11 : 15;
            this.maybeUpdateMediaTimeHistory(eventTime.realtimeMs, discontinuityFromPositionMs);
            this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
            this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            this.updatePlaybackState(finalPlaybackState, eventTime);
        }

        public void onEvents(Player player, AnalyticsListener.EventTime eventTime, boolean belongsToPlayback, long discontinuityFromPositionMs, boolean hasDiscontinuity, int droppedFrameCount, boolean hasAudioUnderun, boolean startedLoading, @Nullable ExoPlaybackException fatalError, @Nullable Exception nonFatalException, long bandwidthTimeMs, long bandwidthBytes, @Nullable Format videoFormat, @Nullable Format audioFormat, @Nullable VideoSize videoSize) {
            int playerPlaybackState;
            if (discontinuityFromPositionMs != -9223372036854775807L) {
                this.maybeUpdateMediaTimeHistory(eventTime.realtimeMs, discontinuityFromPositionMs);
                this.isSeeking = true;
            }
            if (player.getPlaybackState() != 2) {
                this.isSeeking = false;
            }
            if ((playerPlaybackState = player.getPlaybackState()) == 1 || playerPlaybackState == 4 || hasDiscontinuity) {
                this.isInterruptedByAd = false;
            }
            if (fatalError != null) {
                this.hasFatalError = true;
                ++this.fatalErrorCount;
                if (this.keepHistory) {
                    this.fatalErrorHistory.add(new PlaybackStats.EventTimeAndException(eventTime, (Exception)((Object)fatalError)));
                }
            } else if (player.getPlayerError() == null) {
                this.hasFatalError = false;
            }
            if (this.isForeground && !this.isInterruptedByAd) {
                boolean videoEnabled = false;
                boolean audioEnabled = false;
                for (TrackSelection trackSelection : player.getCurrentTrackSelections().getAll()) {
                    if (trackSelection == null || trackSelection.length() <= 0) continue;
                    int trackType = MimeTypes.getTrackType((String)trackSelection.getFormat((int)0).sampleMimeType);
                    if (trackType == 2) {
                        videoEnabled = true;
                        continue;
                    }
                    if (trackType != 1) continue;
                    audioEnabled = true;
                }
                if (!videoEnabled) {
                    this.maybeUpdateVideoFormat(eventTime, null);
                }
                if (!audioEnabled) {
                    this.maybeUpdateAudioFormat(eventTime, null);
                }
            }
            if (videoFormat != null) {
                this.maybeUpdateVideoFormat(eventTime, videoFormat);
            }
            if (audioFormat != null) {
                this.maybeUpdateAudioFormat(eventTime, audioFormat);
            }
            if (this.currentVideoFormat != null && this.currentVideoFormat.height == -1 && videoSize != null) {
                Format formatWithHeightAndWidth = this.currentVideoFormat.buildUpon().setWidth(videoSize.width).setHeight(videoSize.height).build();
                this.maybeUpdateVideoFormat(eventTime, formatWithHeightAndWidth);
            }
            if (startedLoading) {
                this.startedLoading = true;
            }
            if (hasAudioUnderun) {
                ++this.audioUnderruns;
            }
            this.droppedFrames += (long)droppedFrameCount;
            this.bandwidthTimeMs += bandwidthTimeMs;
            this.bandwidthBytes += bandwidthBytes;
            if (nonFatalException != null) {
                ++this.nonFatalErrorCount;
                if (this.keepHistory) {
                    this.nonFatalErrorHistory.add(new PlaybackStats.EventTimeAndException(eventTime, nonFatalException));
                }
            }
            int newPlaybackState = this.resolveNewPlaybackState(player);
            float newPlaybackSpeed = player.getPlaybackParameters().speed;
            if (this.currentPlaybackState != newPlaybackState || this.currentPlaybackSpeed != newPlaybackSpeed) {
                this.maybeUpdateMediaTimeHistory(eventTime.realtimeMs, belongsToPlayback ? eventTime.eventPlaybackPositionMs : -9223372036854775807L);
                this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
                this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            }
            this.currentPlaybackSpeed = newPlaybackSpeed;
            if (this.currentPlaybackState != newPlaybackState) {
                this.updatePlaybackState(newPlaybackState, eventTime);
            }
        }

        public PlaybackStats build(boolean isFinal) {
            long[] playbackStateDurationsMs = this.playbackStateDurationsMs;
            List<long[]> mediaTimeHistory = this.mediaTimeHistory;
            if (!isFinal) {
                long buildTimeMs = SystemClock.elapsedRealtime();
                playbackStateDurationsMs = Arrays.copyOf(this.playbackStateDurationsMs, 16);
                long lastStateDurationMs = Math.max(0L, buildTimeMs - this.currentPlaybackStateStartTimeMs);
                int n = this.currentPlaybackState;
                playbackStateDurationsMs[n] = playbackStateDurationsMs[n] + lastStateDurationMs;
                this.maybeUpdateMaxRebufferTimeMs(buildTimeMs);
                this.maybeRecordVideoFormatTime(buildTimeMs);
                this.maybeRecordAudioFormatTime(buildTimeMs);
                mediaTimeHistory = new ArrayList<long[]>(this.mediaTimeHistory);
                if (this.keepHistory && this.currentPlaybackState == 3) {
                    mediaTimeHistory.add(this.guessMediaTimeBasedOnElapsedRealtime(buildTimeMs));
                }
            }
            boolean isJoinTimeInvalid = this.isJoinTimeInvalid || !this.hasBeenReady;
            long validJoinTimeMs = isJoinTimeInvalid ? -9223372036854775807L : playbackStateDurationsMs[2];
            boolean hasBackgroundJoin = playbackStateDurationsMs[1] > 0L;
            ArrayList<PlaybackStats.EventTimeAndFormat> videoHistory = isFinal ? this.videoFormatHistory : new ArrayList<PlaybackStats.EventTimeAndFormat>(this.videoFormatHistory);
            ArrayList<PlaybackStats.EventTimeAndFormat> audioHistory = isFinal ? this.audioFormatHistory : new ArrayList<PlaybackStats.EventTimeAndFormat>(this.audioFormatHistory);
            return new PlaybackStats(1, playbackStateDurationsMs, isFinal ? this.playbackStateHistory : new ArrayList<PlaybackStats.EventTimeAndPlaybackState>(this.playbackStateHistory), mediaTimeHistory, this.firstReportedTimeMs, this.isForeground ? 1 : 0, this.hasBeenReady ? 0 : 1, this.hasEnded ? 1 : 0, hasBackgroundJoin ? 1 : 0, validJoinTimeMs, isJoinTimeInvalid ? 0 : 1, this.pauseCount, this.pauseBufferCount, this.seekCount, this.rebufferCount, this.maxRebufferTimeMs, this.isAd ? 1 : 0, videoHistory, audioHistory, this.videoFormatHeightTimeMs, this.videoFormatHeightTimeProduct, this.videoFormatBitrateTimeMs, this.videoFormatBitrateTimeProduct, this.audioFormatTimeMs, this.audioFormatBitrateTimeProduct, this.initialVideoFormatHeight == -1 ? 0 : 1, this.initialVideoFormatBitrate == -1L ? 0 : 1, this.initialVideoFormatHeight, this.initialVideoFormatBitrate, this.initialAudioFormatBitrate == -1L ? 0 : 1, this.initialAudioFormatBitrate, this.bandwidthTimeMs, this.bandwidthBytes, this.droppedFrames, this.audioUnderruns, this.fatalErrorCount > 0 ? 1 : 0, this.fatalErrorCount, this.nonFatalErrorCount, this.fatalErrorHistory, this.nonFatalErrorHistory);
        }

        private void updatePlaybackState(int newPlaybackState, AnalyticsListener.EventTime eventTime) {
            Assertions.checkArgument((eventTime.realtimeMs >= this.currentPlaybackStateStartTimeMs ? 1 : 0) != 0);
            long stateDurationMs = eventTime.realtimeMs - this.currentPlaybackStateStartTimeMs;
            int n = this.currentPlaybackState;
            this.playbackStateDurationsMs[n] = this.playbackStateDurationsMs[n] + stateDurationMs;
            if (this.firstReportedTimeMs == -9223372036854775807L) {
                this.firstReportedTimeMs = eventTime.realtimeMs;
            }
            this.isJoinTimeInvalid |= PlaybackStatsTracker.isInvalidJoinTransition(this.currentPlaybackState, newPlaybackState);
            this.hasBeenReady |= PlaybackStatsTracker.isReadyState(newPlaybackState);
            this.hasEnded |= newPlaybackState == 11;
            if (!PlaybackStatsTracker.isPausedState(this.currentPlaybackState) && PlaybackStatsTracker.isPausedState(newPlaybackState)) {
                ++this.pauseCount;
            }
            if (newPlaybackState == 5) {
                ++this.seekCount;
            }
            if (!PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState) && PlaybackStatsTracker.isRebufferingState(newPlaybackState)) {
                ++this.rebufferCount;
                this.lastRebufferStartTimeMs = eventTime.realtimeMs;
            }
            if (PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState) && this.currentPlaybackState != 7 && newPlaybackState == 7) {
                ++this.pauseBufferCount;
            }
            this.maybeUpdateMaxRebufferTimeMs(eventTime.realtimeMs);
            this.currentPlaybackState = newPlaybackState;
            this.currentPlaybackStateStartTimeMs = eventTime.realtimeMs;
            if (this.keepHistory) {
                this.playbackStateHistory.add(new PlaybackStats.EventTimeAndPlaybackState(eventTime, this.currentPlaybackState));
            }
        }

        private int resolveNewPlaybackState(Player player) {
            int playerPlaybackState = player.getPlaybackState();
            if (this.isSeeking && this.isForeground) {
                return 5;
            }
            if (this.hasFatalError) {
                return 13;
            }
            if (!this.isForeground) {
                return this.startedLoading ? 1 : 0;
            }
            if (this.isInterruptedByAd) {
                return 14;
            }
            if (playerPlaybackState == 4) {
                return 11;
            }
            if (playerPlaybackState == 2) {
                if (this.currentPlaybackState == 0 || this.currentPlaybackState == 1 || this.currentPlaybackState == 2 || this.currentPlaybackState == 14) {
                    return 2;
                }
                if (!player.getPlayWhenReady()) {
                    return 7;
                }
                return player.getPlaybackSuppressionReason() != 0 ? 10 : 6;
            }
            if (playerPlaybackState == 3) {
                if (!player.getPlayWhenReady()) {
                    return 4;
                }
                return player.getPlaybackSuppressionReason() != 0 ? 9 : 3;
            }
            if (playerPlaybackState == 1 && this.currentPlaybackState != 0) {
                return 12;
            }
            return this.currentPlaybackState;
        }

        private void maybeUpdateMaxRebufferTimeMs(long nowMs) {
            if (PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState)) {
                long rebufferDurationMs = nowMs - this.lastRebufferStartTimeMs;
                if (this.maxRebufferTimeMs == -9223372036854775807L || rebufferDurationMs > this.maxRebufferTimeMs) {
                    this.maxRebufferTimeMs = rebufferDurationMs;
                }
            }
        }

        private void maybeUpdateMediaTimeHistory(long realtimeMs, long mediaTimeMs) {
            long[] lArray;
            if (!this.keepHistory) {
                return;
            }
            if (this.currentPlaybackState != 3) {
                long previousMediaTimeMs;
                if (mediaTimeMs == -9223372036854775807L) {
                    return;
                }
                if (!this.mediaTimeHistory.isEmpty() && (previousMediaTimeMs = this.mediaTimeHistory.get(this.mediaTimeHistory.size() - 1)[1]) != mediaTimeMs) {
                    this.mediaTimeHistory.add(new long[]{realtimeMs, previousMediaTimeMs});
                }
            }
            if (mediaTimeMs == -9223372036854775807L) {
                lArray = this.guessMediaTimeBasedOnElapsedRealtime(realtimeMs);
            } else {
                long[] lArray2 = new long[2];
                lArray2[0] = realtimeMs;
                lArray = lArray2;
                lArray2[1] = mediaTimeMs;
            }
            this.mediaTimeHistory.add(lArray);
        }

        private long[] guessMediaTimeBasedOnElapsedRealtime(long realtimeMs) {
            long[] previousKnownMediaTimeHistory = this.mediaTimeHistory.get(this.mediaTimeHistory.size() - 1);
            long previousRealtimeMs = previousKnownMediaTimeHistory[0];
            long previousMediaTimeMs = previousKnownMediaTimeHistory[1];
            long elapsedMediaTimeEstimateMs = (long)((float)(realtimeMs - previousRealtimeMs) * this.currentPlaybackSpeed);
            long mediaTimeEstimateMs = previousMediaTimeMs + elapsedMediaTimeEstimateMs;
            return new long[]{realtimeMs, mediaTimeEstimateMs};
        }

        private void maybeUpdateVideoFormat(AnalyticsListener.EventTime eventTime, @Nullable Format newFormat) {
            if (Util.areEqual((Object)this.currentVideoFormat, (Object)newFormat)) {
                return;
            }
            this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
            if (newFormat != null) {
                if (this.initialVideoFormatHeight == -1 && newFormat.height != -1) {
                    this.initialVideoFormatHeight = newFormat.height;
                }
                if (this.initialVideoFormatBitrate == -1L && newFormat.bitrate != -1) {
                    this.initialVideoFormatBitrate = newFormat.bitrate;
                }
            }
            this.currentVideoFormat = newFormat;
            if (this.keepHistory) {
                this.videoFormatHistory.add(new PlaybackStats.EventTimeAndFormat(eventTime, this.currentVideoFormat));
            }
        }

        private void maybeUpdateAudioFormat(AnalyticsListener.EventTime eventTime, @Nullable Format newFormat) {
            if (Util.areEqual((Object)this.currentAudioFormat, (Object)newFormat)) {
                return;
            }
            this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            if (newFormat != null && this.initialAudioFormatBitrate == -1L && newFormat.bitrate != -1) {
                this.initialAudioFormatBitrate = newFormat.bitrate;
            }
            this.currentAudioFormat = newFormat;
            if (this.keepHistory) {
                this.audioFormatHistory.add(new PlaybackStats.EventTimeAndFormat(eventTime, this.currentAudioFormat));
            }
        }

        private void maybeRecordVideoFormatTime(long nowMs) {
            if (this.currentPlaybackState == 3 && this.currentVideoFormat != null) {
                long mediaDurationMs = (long)((float)(nowMs - this.lastVideoFormatStartTimeMs) * this.currentPlaybackSpeed);
                if (this.currentVideoFormat.height != -1) {
                    this.videoFormatHeightTimeMs += mediaDurationMs;
                    this.videoFormatHeightTimeProduct += mediaDurationMs * (long)this.currentVideoFormat.height;
                }
                if (this.currentVideoFormat.bitrate != -1) {
                    this.videoFormatBitrateTimeMs += mediaDurationMs;
                    this.videoFormatBitrateTimeProduct += mediaDurationMs * (long)this.currentVideoFormat.bitrate;
                }
            }
            this.lastVideoFormatStartTimeMs = nowMs;
        }

        private void maybeRecordAudioFormatTime(long nowMs) {
            if (this.currentPlaybackState == 3 && this.currentAudioFormat != null && this.currentAudioFormat.bitrate != -1) {
                long mediaDurationMs = (long)((float)(nowMs - this.lastAudioFormatStartTimeMs) * this.currentPlaybackSpeed);
                this.audioFormatTimeMs += mediaDurationMs;
                this.audioFormatBitrateTimeProduct += mediaDurationMs * (long)this.currentAudioFormat.bitrate;
            }
            this.lastAudioFormatStartTimeMs = nowMs;
        }

        private static boolean isReadyState(int state) {
            return state == 3 || state == 4 || state == 9;
        }

        private static boolean isPausedState(int state) {
            return state == 4 || state == 7;
        }

        private static boolean isRebufferingState(int state) {
            return state == 6 || state == 7 || state == 10;
        }

        private static boolean isInvalidJoinTransition(int oldState, int newState) {
            if (oldState != 1 && oldState != 2 && oldState != 14) {
                return false;
            }
            return newState != 1 && newState != 2 && newState != 14 && newState != 3 && newState != 4 && newState != 9 && newState != 11;
        }
    }

    public static interface Callback {
        public void onPlaybackStatsReady(AnalyticsListener.EventTime var1, PlaybackStats var2);
    }
}

