/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public interface AudioSink {
    public static final int SINK_FORMAT_SUPPORTED_DIRECTLY = 2;
    public static final int SINK_FORMAT_SUPPORTED_WITH_TRANSCODING = 1;
    public static final int SINK_FORMAT_UNSUPPORTED = 0;
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;

    public void setListener(Listener var1);

    public boolean supportsFormat(Format var1);

    public int getFormatSupport(Format var1);

    public long getCurrentPositionUs(boolean var1);

    public void configure(Format var1, int var2, @Nullable int[] var3) throws ConfigurationException;

    public void play();

    public void handleDiscontinuity();

    public boolean handleBuffer(ByteBuffer var1, long var2, int var4) throws InitializationException, WriteException;

    public void playToEndOfStream() throws WriteException;

    public boolean isEnded();

    public boolean hasPendingData();

    public void setPlaybackParameters(PlaybackParameters var1);

    public PlaybackParameters getPlaybackParameters();

    public void setSkipSilenceEnabled(boolean var1);

    public boolean getSkipSilenceEnabled();

    public void setAudioAttributes(AudioAttributes var1);

    public void setAudioSessionId(int var1);

    public void setAuxEffectInfo(AuxEffectInfo var1);

    public void enableTunnelingV21();

    public void disableTunneling();

    public void setVolume(float var1);

    public void pause();

    public void flush();

    public void experimentalFlushWithoutAudioTrackRelease();

    public void reset();

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SinkFormatSupport {
    }

    public static final class UnexpectedDiscontinuityException
    extends Exception {
        public final long actualPresentationTimeUs;
        public final long expectedPresentationTimeUs;

        public UnexpectedDiscontinuityException(long actualPresentationTimeUs, long expectedPresentationTimeUs) {
            super(new StringBuilder(103).append("Unexpected audio track timestamp discontinuity: expected ").append(expectedPresentationTimeUs).append(", got ").append(actualPresentationTimeUs).toString());
            this.actualPresentationTimeUs = actualPresentationTimeUs;
            this.expectedPresentationTimeUs = expectedPresentationTimeUs;
        }
    }

    public static final class WriteException
    extends Exception {
        public final int errorCode;
        public final boolean isRecoverable;
        public final Format format;

        public WriteException(int errorCode, Format format, boolean isRecoverable) {
            super(new StringBuilder(36).append("AudioTrack write failed: ").append(errorCode).toString());
            this.isRecoverable = isRecoverable;
            this.errorCode = errorCode;
            this.format = format;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;
        public final boolean isRecoverable;
        public final Format format;

        public InitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize, Format format, boolean isRecoverable, @Nullable Exception audioTrackException) {
            String string = isRecoverable ? " (recoverable)" : "";
            super(new StringBuilder(80 + String.valueOf(string).length()).append("AudioTrack init failed ").append(audioTrackState).append(" ").append("Config(").append(sampleRate).append(", ").append(channelConfig).append(", ").append(bufferSize).append(")").append(string).toString(), audioTrackException);
            this.audioTrackState = audioTrackState;
            this.isRecoverable = isRecoverable;
            this.format = format;
        }
    }

    public static final class ConfigurationException
    extends Exception {
        public final Format format;

        public ConfigurationException(Throwable cause, Format format) {
            super(cause);
            this.format = format;
        }

        public ConfigurationException(String message, Format format) {
            super(message);
            this.format = format;
        }
    }

    public static interface Listener {
        public void onPositionDiscontinuity();

        default public void onPositionAdvancing(long playoutStartSystemTimeMs) {
        }

        public void onUnderrun(int var1, long var2, long var4);

        public void onSkipSilenceEnabledChanged(boolean var1);

        default public void onOffloadBufferEmptying() {
        }

        default public void onOffloadBufferFull(long bufferEmptyingDeadlineMs) {
        }

        default public void onAudioSinkError(Exception audioSinkError) {
        }
    }
}

