/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.audio.DefaultAudioSink;
import com.google.android.exoplayer2.decoder.Decoder;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderException;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.decoder.SimpleOutputBuffer;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;

public abstract class DecoderAudioRenderer<T extends Decoder<DecoderInputBuffer, ? extends SimpleOutputBuffer, ? extends DecoderException>>
extends BaseRenderer
implements MediaClock {
    private static final String TAG = "DecoderAudioRenderer";
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 2;
    private final AudioRendererEventListener.EventDispatcher eventDispatcher;
    private final AudioSink audioSink;
    private final DecoderInputBuffer flagsOnlyBuffer;
    private DecoderCounters decoderCounters;
    private Format inputFormat;
    private int encoderDelay;
    private int encoderPadding;
    private boolean experimentalKeepAudioTrackOnSeek;
    @Nullable
    private T decoder;
    @Nullable
    private DecoderInputBuffer inputBuffer;
    @Nullable
    private SimpleOutputBuffer outputBuffer;
    @Nullable
    private DrmSession decoderDrmSession;
    @Nullable
    private DrmSession sourceDrmSession;
    private int decoderReinitializationState;
    private boolean decoderReceivedBuffers;
    private boolean audioTrackNeedsConfigure;
    private long currentPositionUs;
    private boolean allowFirstBufferPositionDiscontinuity;
    private boolean allowPositionDiscontinuity;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;

    public DecoderAudioRenderer() {
        this(null, null, new AudioProcessor[0]);
    }

    public DecoderAudioRenderer(@Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioProcessor ... audioProcessors) {
        this(eventHandler, eventListener, (AudioCapabilities)null, audioProcessors);
    }

    public DecoderAudioRenderer(@Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, @Nullable AudioCapabilities audioCapabilities, AudioProcessor ... audioProcessors) {
        this(eventHandler, eventListener, new DefaultAudioSink(audioCapabilities, audioProcessors));
    }

    public DecoderAudioRenderer(@Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        super(1);
        this.eventDispatcher = new AudioRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.audioSink = audioSink;
        audioSink.setListener(new AudioSinkListener());
        this.flagsOnlyBuffer = DecoderInputBuffer.newNoDataInstance();
        this.decoderReinitializationState = 0;
        this.audioTrackNeedsConfigure = true;
    }

    public void experimentalSetEnableKeepAudioTrackOnSeek(boolean enableKeepAudioTrackOnSeek) {
        this.experimentalKeepAudioTrackOnSeek = enableKeepAudioTrackOnSeek;
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return this;
    }

    @Override
    public final int supportsFormat(Format format) {
        if (!MimeTypes.isAudio((String)format.sampleMimeType)) {
            return RendererCapabilities.create(0);
        }
        int formatSupport = this.supportsFormatInternal(format);
        if (formatSupport <= 2) {
            return RendererCapabilities.create(formatSupport);
        }
        int tunnelingSupport = Util.SDK_INT >= 21 ? 32 : 0;
        return RendererCapabilities.create(formatSupport, 8, tunnelingSupport);
    }

    protected abstract int supportsFormatInternal(Format var1);

    protected final boolean sinkSupportsFormat(Format format) {
        return this.audioSink.supportsFormat(format);
    }

    protected final int getSinkFormatSupport(Format format) {
        return this.audioSink.getFormatSupport(format);
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            try {
                this.audioSink.playToEndOfStream();
            }
            catch (AudioSink.WriteException e) {
                throw this.createRendererException(e, e.format, e.isRecoverable);
            }
            return;
        }
        if (this.inputFormat == null) {
            FormatHolder formatHolder = this.getFormatHolder();
            this.flagsOnlyBuffer.clear();
            int result = this.readSource(formatHolder, this.flagsOnlyBuffer, 2);
            if (result == -5) {
                this.onInputFormatChanged(formatHolder);
            } else {
                if (result == -4) {
                    Assertions.checkState((boolean)this.flagsOnlyBuffer.isEndOfStream());
                    this.inputStreamEnded = true;
                    try {
                        this.processEndOfStream();
                    }
                    catch (AudioSink.WriteException e) {
                        throw this.createRendererException(e, null);
                    }
                    return;
                }
                return;
            }
        }
        this.maybeInitDecoder();
        if (this.decoder != null) {
            try {
                TraceUtil.beginSection((String)"drainAndFeed");
                while (this.drainOutputBuffer()) {
                }
                while (this.feedInputBuffer()) {
                }
                TraceUtil.endSection();
            }
            catch (DecoderException e) {
                Log.e((String)TAG, (String)"Audio codec error", (Throwable)e);
                this.eventDispatcher.audioCodecError(e);
                throw this.createRendererException(e, this.inputFormat);
            }
            catch (AudioSink.ConfigurationException e) {
                throw this.createRendererException(e, e.format);
            }
            catch (AudioSink.InitializationException e) {
                throw this.createRendererException(e, e.format, e.isRecoverable);
            }
            catch (AudioSink.WriteException e) {
                throw this.createRendererException(e, e.format, e.isRecoverable);
            }
            this.decoderCounters.ensureUpdated();
        }
    }

    @CallSuper
    protected void onPositionDiscontinuity() {
        this.allowPositionDiscontinuity = true;
    }

    protected abstract T createDecoder(Format var1, @Nullable ExoMediaCrypto var2) throws DecoderException;

    protected abstract Format getOutputFormat(T var1);

    protected DecoderReuseEvaluation canReuseDecoder(String decoderName, Format oldFormat, Format newFormat) {
        return new DecoderReuseEvaluation(decoderName, oldFormat, newFormat, 0, 1);
    }

    private boolean drainOutputBuffer() throws ExoPlaybackException, DecoderException, AudioSink.ConfigurationException, AudioSink.InitializationException, AudioSink.WriteException {
        if (this.outputBuffer == null) {
            this.outputBuffer = (SimpleOutputBuffer)((Object)this.decoder.dequeueOutputBuffer());
            if (this.outputBuffer == null) {
                return false;
            }
            if (this.outputBuffer.skippedOutputBufferCount > 0) {
                this.decoderCounters.skippedOutputBufferCount += this.outputBuffer.skippedOutputBufferCount;
                this.audioSink.handleDiscontinuity();
            }
        }
        if (this.outputBuffer.isEndOfStream()) {
            if (this.decoderReinitializationState == 2) {
                this.releaseDecoder();
                this.maybeInitDecoder();
                this.audioTrackNeedsConfigure = true;
            } else {
                this.outputBuffer.release();
                this.outputBuffer = null;
                try {
                    this.processEndOfStream();
                }
                catch (AudioSink.WriteException e) {
                    throw this.createRendererException(e, e.format, e.isRecoverable);
                }
            }
            return false;
        }
        if (this.audioTrackNeedsConfigure) {
            Format outputFormat = this.getOutputFormat(this.decoder).buildUpon().setEncoderDelay(this.encoderDelay).setEncoderPadding(this.encoderPadding).build();
            this.audioSink.configure(outputFormat, 0, null);
            this.audioTrackNeedsConfigure = false;
        }
        if (this.audioSink.handleBuffer(this.outputBuffer.data, this.outputBuffer.timeUs, 1)) {
            ++this.decoderCounters.renderedOutputBufferCount;
            this.outputBuffer.release();
            this.outputBuffer = null;
            return true;
        }
        return false;
    }

    private boolean feedInputBuffer() throws DecoderException, ExoPlaybackException {
        if (this.decoder == null || this.decoderReinitializationState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputBuffer == null) {
            this.inputBuffer = (DecoderInputBuffer)this.decoder.dequeueInputBuffer();
            if (this.inputBuffer == null) {
                return false;
            }
        }
        if (this.decoderReinitializationState == 1) {
            this.inputBuffer.setFlags(4);
            this.decoder.queueInputBuffer((DecoderInputBuffer)this.inputBuffer);
            this.inputBuffer = null;
            this.decoderReinitializationState = 2;
            return false;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        switch (this.readSource(formatHolder, this.inputBuffer, 0)) {
            case -3: {
                return false;
            }
            case -5: {
                this.onInputFormatChanged(formatHolder);
                return true;
            }
            case -4: {
                if (this.inputBuffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                    this.decoder.queueInputBuffer((DecoderInputBuffer)this.inputBuffer);
                    this.inputBuffer = null;
                    return false;
                }
                this.inputBuffer.flip();
                this.onQueueInputBuffer(this.inputBuffer);
                this.decoder.queueInputBuffer((DecoderInputBuffer)this.inputBuffer);
                this.decoderReceivedBuffers = true;
                ++this.decoderCounters.inputBufferCount;
                this.inputBuffer = null;
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void processEndOfStream() throws AudioSink.WriteException {
        this.outputStreamEnded = true;
        this.audioSink.playToEndOfStream();
    }

    private void flushDecoder() throws ExoPlaybackException {
        if (this.decoderReinitializationState != 0) {
            this.releaseDecoder();
            this.maybeInitDecoder();
        } else {
            this.inputBuffer = null;
            if (this.outputBuffer != null) {
                this.outputBuffer.release();
                this.outputBuffer = null;
            }
            this.decoder.flush();
            this.decoderReceivedBuffers = false;
        }
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded && this.audioSink.isEnded();
    }

    @Override
    public boolean isReady() {
        return this.audioSink.hasPendingData() || this.inputFormat != null && (this.isSourceReady() || this.outputBuffer != null);
    }

    @Override
    public long getPositionUs() {
        if (this.getState() == 2) {
            this.updateCurrentPosition();
        }
        return this.currentPositionUs;
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.audioSink.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.audioSink.getPlaybackParameters();
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
        this.eventDispatcher.enabled(this.decoderCounters);
        if (this.getConfiguration().tunneling) {
            this.audioSink.enableTunnelingV21();
        } else {
            this.audioSink.disableTunneling();
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        if (this.experimentalKeepAudioTrackOnSeek) {
            this.audioSink.experimentalFlushWithoutAudioTrackRelease();
        } else {
            this.audioSink.flush();
        }
        this.currentPositionUs = positionUs;
        this.allowFirstBufferPositionDiscontinuity = true;
        this.allowPositionDiscontinuity = true;
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        if (this.decoder != null) {
            this.flushDecoder();
        }
    }

    @Override
    protected void onStarted() {
        this.audioSink.play();
    }

    @Override
    protected void onStopped() {
        this.updateCurrentPosition();
        this.audioSink.pause();
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        this.audioTrackNeedsConfigure = true;
        try {
            this.setSourceDrmSession(null);
            this.releaseDecoder();
            this.audioSink.reset();
        }
        finally {
            this.eventDispatcher.disabled(this.decoderCounters);
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 2: {
                this.audioSink.setVolume(((Float)message).floatValue());
                break;
            }
            case 3: {
                AudioAttributes audioAttributes = (AudioAttributes)message;
                this.audioSink.setAudioAttributes(audioAttributes);
                break;
            }
            case 5: {
                AuxEffectInfo auxEffectInfo = (AuxEffectInfo)message;
                this.audioSink.setAuxEffectInfo(auxEffectInfo);
                break;
            }
            case 101: {
                this.audioSink.setSkipSilenceEnabled((Boolean)message);
                break;
            }
            case 102: {
                this.audioSink.setAudioSessionId((Integer)message);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    private void maybeInitDecoder() throws ExoPlaybackException {
        DrmSession.DrmSessionException drmError;
        if (this.decoder != null) {
            return;
        }
        this.setDecoderDrmSession(this.sourceDrmSession);
        ExoMediaCrypto mediaCrypto = null;
        if (this.decoderDrmSession != null && (mediaCrypto = this.decoderDrmSession.getMediaCrypto()) == null && (drmError = this.decoderDrmSession.getError()) == null) {
            return;
        }
        try {
            long codecInitializingTimestamp = SystemClock.elapsedRealtime();
            TraceUtil.beginSection((String)"createAudioDecoder");
            this.decoder = this.createDecoder(this.inputFormat, mediaCrypto);
            TraceUtil.endSection();
            long codecInitializedTimestamp = SystemClock.elapsedRealtime();
            this.eventDispatcher.decoderInitialized(this.decoder.getName(), codecInitializedTimestamp, codecInitializedTimestamp - codecInitializingTimestamp);
            ++this.decoderCounters.decoderInitCount;
        }
        catch (DecoderException e) {
            Log.e((String)TAG, (String)"Audio codec error", (Throwable)e);
            this.eventDispatcher.audioCodecError(e);
            throw this.createRendererException(e, this.inputFormat);
        }
        catch (OutOfMemoryError e) {
            throw this.createRendererException(e, this.inputFormat);
        }
    }

    private void releaseDecoder() {
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.decoderReinitializationState = 0;
        this.decoderReceivedBuffers = false;
        if (this.decoder != null) {
            ++this.decoderCounters.decoderReleaseCount;
            this.decoder.release();
            this.eventDispatcher.decoderReleased(this.decoder.getName());
            this.decoder = null;
        }
        this.setDecoderDrmSession(null);
    }

    private void setSourceDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.sourceDrmSession, session);
        this.sourceDrmSession = session;
    }

    private void setDecoderDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.decoderDrmSession, session);
        this.decoderDrmSession = session;
    }

    private void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        Format newFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        this.setSourceDrmSession(formatHolder.drmSession);
        Format oldFormat = this.inputFormat;
        this.inputFormat = newFormat;
        this.encoderDelay = newFormat.encoderDelay;
        this.encoderPadding = newFormat.encoderPadding;
        if (this.decoder == null) {
            this.maybeInitDecoder();
            this.eventDispatcher.inputFormatChanged(this.inputFormat, null);
            return;
        }
        DecoderReuseEvaluation evaluation = this.sourceDrmSession != this.decoderDrmSession ? new DecoderReuseEvaluation(this.decoder.getName(), oldFormat, newFormat, 0, 128) : this.canReuseDecoder(this.decoder.getName(), oldFormat, newFormat);
        if (evaluation.result == 0) {
            if (this.decoderReceivedBuffers) {
                this.decoderReinitializationState = 1;
            } else {
                this.releaseDecoder();
                this.maybeInitDecoder();
                this.audioTrackNeedsConfigure = true;
            }
        }
        this.eventDispatcher.inputFormatChanged(this.inputFormat, evaluation);
    }

    protected void onQueueInputBuffer(DecoderInputBuffer buffer) {
        if (this.allowFirstBufferPositionDiscontinuity && !buffer.isDecodeOnly()) {
            if (Math.abs(buffer.timeUs - this.currentPositionUs) > 500000L) {
                this.currentPositionUs = buffer.timeUs;
            }
            this.allowFirstBufferPositionDiscontinuity = false;
        }
    }

    private void updateCurrentPosition() {
        long newCurrentPositionUs = this.audioSink.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
    }

    private final class AudioSinkListener
    implements AudioSink.Listener {
        private AudioSinkListener() {
        }

        @Override
        public void onPositionDiscontinuity() {
            DecoderAudioRenderer.this.onPositionDiscontinuity();
        }

        @Override
        public void onPositionAdvancing(long playoutStartSystemTimeMs) {
            DecoderAudioRenderer.this.eventDispatcher.positionAdvancing(playoutStartSystemTimeMs);
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            DecoderAudioRenderer.this.eventDispatcher.underrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            DecoderAudioRenderer.this.eventDispatcher.skipSilenceEnabledChanged(skipSilenceEnabled);
        }

        @Override
        public void onAudioSinkError(Exception audioSinkError) {
            Log.e((String)DecoderAudioRenderer.TAG, (String)"Audio sink error", (Throwable)audioSinkError);
            DecoderAudioRenderer.this.eventDispatcher.audioSinkError(audioSinkError);
        }
    }
}

