/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.media.ResourceBusyException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DefaultDrmSession;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ErrorStateDrmSession;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedMediaCrypto;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=18)
public class DefaultDrmSessionManager
implements DrmSessionManager {
    public static final String PLAYREADY_CUSTOM_DATA_KEY = "PRCustomData";
    public static final int MODE_PLAYBACK = 0;
    public static final int MODE_QUERY = 1;
    public static final int MODE_DOWNLOAD = 2;
    public static final int MODE_RELEASE = 3;
    public static final int INITIAL_DRM_REQUEST_RETRY_COUNT = 3;
    public static final long DEFAULT_SESSION_KEEPALIVE_MS = 300000L;
    private static final String TAG = "DefaultDrmSessionMgr";
    private final UUID uuid;
    private final ExoMediaDrm.Provider exoMediaDrmProvider;
    private final MediaDrmCallback callback;
    private final HashMap<String, String> keyRequestParameters;
    private final boolean multiSession;
    private final int[] useDrmSessionsForClearContentTrackTypes;
    private final boolean playClearSamplesWithoutKeys;
    private final ProvisioningManagerImpl provisioningManagerImpl;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final ReferenceCountListenerImpl referenceCountListener;
    private final long sessionKeepaliveMs;
    private final List<DefaultDrmSession> sessions;
    private final List<DefaultDrmSession> provisioningSessions;
    private final Set<PreacquiredSessionReference> preacquiredSessionReferences;
    private final Set<DefaultDrmSession> keepaliveSessions;
    private int prepareCallsCount;
    @Nullable
    private ExoMediaDrm exoMediaDrm;
    @Nullable
    private DefaultDrmSession placeholderDrmSession;
    @Nullable
    private DefaultDrmSession noMultiSessionDrmSession;
    private @MonotonicNonNull Looper playbackLooper;
    private @MonotonicNonNull Handler playbackHandler;
    private int mode;
    @Nullable
    private byte[] offlineLicenseKeySetId;
    @Nullable
    volatile MediaDrmHandler mediaDrmHandler;

    @Deprecated
    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm exoMediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> keyRequestParameters) {
        this(uuid, exoMediaDrm, callback, keyRequestParameters == null ? new HashMap<String, String>() : keyRequestParameters, false, 3);
    }

    @Deprecated
    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm exoMediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> keyRequestParameters, boolean multiSession) {
        this(uuid, exoMediaDrm, callback, keyRequestParameters == null ? new HashMap<String, String>() : keyRequestParameters, multiSession, 3);
    }

    @Deprecated
    public DefaultDrmSessionManager(UUID uuid, ExoMediaDrm exoMediaDrm, MediaDrmCallback callback, @Nullable HashMap<String, String> keyRequestParameters, boolean multiSession, int initialDrmRequestRetryCount) {
        this(uuid, new ExoMediaDrm.AppManagedProvider(exoMediaDrm), callback, keyRequestParameters == null ? new HashMap<String, String>() : keyRequestParameters, multiSession, new int[0], false, new DefaultLoadErrorHandlingPolicy(initialDrmRequestRetryCount), 300000L);
    }

    private DefaultDrmSessionManager(UUID uuid, ExoMediaDrm.Provider exoMediaDrmProvider, MediaDrmCallback callback, HashMap<String, String> keyRequestParameters, boolean multiSession, int[] useDrmSessionsForClearContentTrackTypes, boolean playClearSamplesWithoutKeys, LoadErrorHandlingPolicy loadErrorHandlingPolicy, long sessionKeepaliveMs) {
        Assertions.checkNotNull((Object)uuid);
        Assertions.checkArgument((!C.COMMON_PSSH_UUID.equals(uuid) ? 1 : 0) != 0, (Object)"Use C.CLEARKEY_UUID instead");
        this.uuid = uuid;
        this.exoMediaDrmProvider = exoMediaDrmProvider;
        this.callback = callback;
        this.keyRequestParameters = keyRequestParameters;
        this.multiSession = multiSession;
        this.useDrmSessionsForClearContentTrackTypes = useDrmSessionsForClearContentTrackTypes;
        this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.provisioningManagerImpl = new ProvisioningManagerImpl();
        this.referenceCountListener = new ReferenceCountListenerImpl();
        this.mode = 0;
        this.sessions = new ArrayList<DefaultDrmSession>();
        this.provisioningSessions = new ArrayList<DefaultDrmSession>();
        this.preacquiredSessionReferences = Sets.newIdentityHashSet();
        this.keepaliveSessions = Sets.newIdentityHashSet();
        this.sessionKeepaliveMs = sessionKeepaliveMs;
    }

    public void setMode(int mode, @Nullable byte[] offlineLicenseKeySetId) {
        Assertions.checkState((boolean)this.sessions.isEmpty());
        if (mode == 1 || mode == 3) {
            Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        }
        this.mode = mode;
        this.offlineLicenseKeySetId = offlineLicenseKeySetId;
    }

    @Override
    public final void prepare() {
        if (this.prepareCallsCount++ != 0) {
            return;
        }
        if (this.exoMediaDrm == null) {
            this.exoMediaDrm = this.exoMediaDrmProvider.acquireExoMediaDrm(this.uuid);
            this.exoMediaDrm.setOnEventListener(new MediaDrmEventListener());
        } else if (this.sessionKeepaliveMs != -9223372036854775807L) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                this.sessions.get(i).acquire(null);
            }
        }
    }

    @Override
    public final void release() {
        if (--this.prepareCallsCount != 0) {
            return;
        }
        if (this.sessionKeepaliveMs != -9223372036854775807L) {
            ArrayList<DefaultDrmSession> sessions = new ArrayList<DefaultDrmSession>(this.sessions);
            for (int i = 0; i < sessions.size(); ++i) {
                ((DefaultDrmSession)sessions.get(i)).release(null);
            }
        }
        this.releaseAllPreacquiredSessions();
        this.maybeReleaseMediaDrm();
    }

    @Override
    public DrmSessionManager.DrmSessionReference preacquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
        Assertions.checkState((this.prepareCallsCount > 0 ? 1 : 0) != 0);
        this.initPlaybackLooper(playbackLooper);
        PreacquiredSessionReference preacquiredSessionReference = new PreacquiredSessionReference(eventDispatcher);
        preacquiredSessionReference.acquire(format);
        return preacquiredSessionReference;
    }

    @Override
    @Nullable
    public DrmSession acquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
        Assertions.checkState((this.prepareCallsCount > 0 ? 1 : 0) != 0);
        this.initPlaybackLooper(playbackLooper);
        return this.acquireSession(playbackLooper, eventDispatcher, format, true);
    }

    @Nullable
    private DrmSession acquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format, boolean shouldReleasePreacquiredSessionsBeforeRetrying) {
        DefaultDrmSession session;
        this.maybeCreateMediaDrmHandler(playbackLooper);
        if (format.drmInitData == null) {
            return this.maybeAcquirePlaceholderSession(MimeTypes.getTrackType((String)format.sampleMimeType), shouldReleasePreacquiredSessionsBeforeRetrying);
        }
        List<DrmInitData.SchemeData> schemeDatas = null;
        if (this.offlineLicenseKeySetId == null && (schemeDatas = DefaultDrmSessionManager.getSchemeDatas((DrmInitData)Assertions.checkNotNull((Object)format.drmInitData), this.uuid, false)).isEmpty()) {
            MissingSchemeDataException error = new MissingSchemeDataException(this.uuid);
            Log.e((String)TAG, (String)"DRM error", (Throwable)error);
            if (eventDispatcher != null) {
                eventDispatcher.drmSessionManagerError(error);
            }
            return new ErrorStateDrmSession(new DrmSession.DrmSessionException(error));
        }
        if (!this.multiSession) {
            session = this.noMultiSessionDrmSession;
        } else {
            session = null;
            for (DefaultDrmSession existingSession : this.sessions) {
                if (!Util.areEqual(existingSession.schemeDatas, schemeDatas)) continue;
                session = existingSession;
                break;
            }
        }
        if (session == null) {
            session = this.createAndAcquireSessionWithRetry(schemeDatas, false, eventDispatcher, shouldReleasePreacquiredSessionsBeforeRetrying);
            if (!this.multiSession) {
                this.noMultiSessionDrmSession = session;
            }
            this.sessions.add(session);
        } else {
            session.acquire(eventDispatcher);
        }
        return session;
    }

    @Override
    @Nullable
    public Class<? extends ExoMediaCrypto> getExoMediaCryptoType(Format format) {
        Class<? extends ExoMediaCrypto> exoMediaCryptoType = ((ExoMediaDrm)Assertions.checkNotNull((Object)this.exoMediaDrm)).getExoMediaCryptoType();
        if (format.drmInitData == null) {
            int trackType = MimeTypes.getTrackType((String)format.sampleMimeType);
            return Util.linearSearch((int[])this.useDrmSessionsForClearContentTrackTypes, (int)trackType) != -1 ? exoMediaCryptoType : null;
        }
        return this.canAcquireSession(format.drmInitData) ? exoMediaCryptoType : UnsupportedMediaCrypto.class;
    }

    @Nullable
    private DrmSession maybeAcquirePlaceholderSession(int trackType, boolean shouldReleasePreacquiredSessionsBeforeRetrying) {
        boolean avoidPlaceholderDrmSessions;
        ExoMediaDrm exoMediaDrm = (ExoMediaDrm)Assertions.checkNotNull((Object)this.exoMediaDrm);
        boolean bl = avoidPlaceholderDrmSessions = FrameworkMediaCrypto.class.equals(exoMediaDrm.getExoMediaCryptoType()) && FrameworkMediaCrypto.WORKAROUND_DEVICE_NEEDS_KEYS_TO_CONFIGURE_CODEC;
        if (avoidPlaceholderDrmSessions || Util.linearSearch((int[])this.useDrmSessionsForClearContentTrackTypes, (int)trackType) == -1 || UnsupportedMediaCrypto.class.equals(exoMediaDrm.getExoMediaCryptoType())) {
            return null;
        }
        if (this.placeholderDrmSession == null) {
            DefaultDrmSession placeholderDrmSession = this.createAndAcquireSessionWithRetry((List<DrmInitData.SchemeData>)ImmutableList.of(), true, null, shouldReleasePreacquiredSessionsBeforeRetrying);
            this.sessions.add(placeholderDrmSession);
            this.placeholderDrmSession = placeholderDrmSession;
        } else {
            this.placeholderDrmSession.acquire(null);
        }
        return this.placeholderDrmSession;
    }

    private boolean canAcquireSession(DrmInitData drmInitData) {
        String schemeType;
        if (this.offlineLicenseKeySetId != null) {
            return true;
        }
        List<DrmInitData.SchemeData> schemeDatas = DefaultDrmSessionManager.getSchemeDatas(drmInitData, this.uuid, true);
        if (schemeDatas.isEmpty()) {
            if (drmInitData.schemeDataCount == 1 && drmInitData.get(0).matches(C.COMMON_PSSH_UUID)) {
                String string = String.valueOf(this.uuid);
                Log.w((String)TAG, (String)new StringBuilder(72 + String.valueOf(string).length()).append("DrmInitData only contains common PSSH SchemeData. Assuming support for: ").append(string).toString());
            } else {
                return false;
            }
        }
        if ((schemeType = drmInitData.schemeType) == null || "cenc".equals(schemeType)) {
            return true;
        }
        if ("cbcs".equals(schemeType)) {
            return Util.SDK_INT >= 25;
        }
        return !"cbc1".equals(schemeType) && !"cens".equals(schemeType);
    }

    @EnsuresNonNull(value={"this.playbackLooper", "this.playbackHandler"})
    private synchronized void initPlaybackLooper(Looper playbackLooper) {
        if (this.playbackLooper == null) {
            this.playbackLooper = playbackLooper;
            this.playbackHandler = new Handler(playbackLooper);
        } else {
            Assertions.checkState((this.playbackLooper == playbackLooper ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)this.playbackHandler);
        }
    }

    private void maybeCreateMediaDrmHandler(Looper playbackLooper) {
        if (this.mediaDrmHandler == null) {
            this.mediaDrmHandler = new MediaDrmHandler(playbackLooper);
        }
    }

    private DefaultDrmSession createAndAcquireSessionWithRetry(@Nullable List<DrmInitData.SchemeData> schemeDatas, boolean isPlaceholderSession, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, boolean shouldReleasePreacquiredSessionsBeforeRetrying) {
        DefaultDrmSession session = this.createAndAcquireSession(schemeDatas, isPlaceholderSession, eventDispatcher);
        if (DefaultDrmSessionManager.acquisitionFailedIndicatingResourceShortage(session) && !this.keepaliveSessions.isEmpty()) {
            ImmutableSet keepaliveSessions = ImmutableSet.copyOf(this.keepaliveSessions);
            for (DrmSession keepaliveSession : keepaliveSessions) {
                keepaliveSession.release(null);
            }
            this.undoAcquisition(session, eventDispatcher);
            session = this.createAndAcquireSession(schemeDatas, isPlaceholderSession, eventDispatcher);
        }
        if (DefaultDrmSessionManager.acquisitionFailedIndicatingResourceShortage(session) && shouldReleasePreacquiredSessionsBeforeRetrying && !this.preacquiredSessionReferences.isEmpty()) {
            this.releaseAllPreacquiredSessions();
            this.undoAcquisition(session, eventDispatcher);
            session = this.createAndAcquireSession(schemeDatas, isPlaceholderSession, eventDispatcher);
        }
        return session;
    }

    private static boolean acquisitionFailedIndicatingResourceShortage(DrmSession session) {
        return session.getState() == 1 && (Util.SDK_INT < 19 || ((DrmSession.DrmSessionException)Assertions.checkNotNull((Object)session.getError())).getCause() instanceof ResourceBusyException);
    }

    private void undoAcquisition(DrmSession session, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        session.release(eventDispatcher);
        if (this.sessionKeepaliveMs != -9223372036854775807L) {
            session.release(null);
        }
    }

    private void releaseAllPreacquiredSessions() {
        ImmutableSet preacquiredSessionReferences = ImmutableSet.copyOf(this.preacquiredSessionReferences);
        for (PreacquiredSessionReference preacquiredSessionReference : preacquiredSessionReferences) {
            preacquiredSessionReference.release();
        }
    }

    private DefaultDrmSession createAndAcquireSession(@Nullable List<DrmInitData.SchemeData> schemeDatas, boolean isPlaceholderSession, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        Assertions.checkNotNull((Object)this.exoMediaDrm);
        boolean playClearSamplesWithoutKeys = this.playClearSamplesWithoutKeys | isPlaceholderSession;
        DefaultDrmSession session = new DefaultDrmSession(this.uuid, this.exoMediaDrm, this.provisioningManagerImpl, this.referenceCountListener, schemeDatas, this.mode, playClearSamplesWithoutKeys, isPlaceholderSession, this.offlineLicenseKeySetId, this.keyRequestParameters, this.callback, (Looper)Assertions.checkNotNull((Object)this.playbackLooper), this.loadErrorHandlingPolicy);
        session.acquire(eventDispatcher);
        if (this.sessionKeepaliveMs != -9223372036854775807L) {
            session.acquire(null);
        }
        return session;
    }

    private void maybeReleaseMediaDrm() {
        if (this.exoMediaDrm != null && this.prepareCallsCount == 0 && this.sessions.isEmpty() && this.preacquiredSessionReferences.isEmpty()) {
            ((ExoMediaDrm)Assertions.checkNotNull((Object)this.exoMediaDrm)).release();
            this.exoMediaDrm = null;
        }
    }

    private static List<DrmInitData.SchemeData> getSchemeDatas(DrmInitData drmInitData, UUID uuid, boolean allowMissingData) {
        ArrayList<DrmInitData.SchemeData> matchingSchemeDatas = new ArrayList<DrmInitData.SchemeData>(drmInitData.schemeDataCount);
        for (int i = 0; i < drmInitData.schemeDataCount; ++i) {
            boolean uuidMatches;
            DrmInitData.SchemeData schemeData = drmInitData.get(i);
            boolean bl = uuidMatches = schemeData.matches(uuid) || C.CLEARKEY_UUID.equals(uuid) && schemeData.matches(C.COMMON_PSSH_UUID);
            if (!uuidMatches || schemeData.data == null && !allowMissingData) continue;
            matchingSchemeDatas.add(schemeData);
        }
        return matchingSchemeDatas;
    }

    private class PreacquiredSessionReference
    implements DrmSessionManager.DrmSessionReference {
        @Nullable
        private final DrmSessionEventListener.EventDispatcher eventDispatcher;
        @Nullable
        private DrmSession session;
        private boolean isReleased;

        public PreacquiredSessionReference(DrmSessionEventListener.EventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        public void acquire(Format format) {
            ((Handler)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackHandler)).post(() -> {
                if (DefaultDrmSessionManager.this.prepareCallsCount == 0 || this.isReleased) {
                    return;
                }
                this.session = DefaultDrmSessionManager.this.acquireSession((Looper)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackLooper), this.eventDispatcher, format, false);
                DefaultDrmSessionManager.this.preacquiredSessionReferences.add(this);
            });
        }

        @Override
        public void release() {
            Util.postOrRun((Handler)((Handler)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackHandler)), () -> {
                if (this.isReleased) {
                    return;
                }
                if (this.session != null) {
                    this.session.release(this.eventDispatcher);
                }
                DefaultDrmSessionManager.this.preacquiredSessionReferences.remove(this);
                this.isReleased = true;
            });
        }
    }

    private class MediaDrmEventListener
    implements ExoMediaDrm.OnEventListener {
        private MediaDrmEventListener() {
        }

        @Override
        public void onEvent(ExoMediaDrm md, @Nullable byte[] sessionId, int event, int extra, @Nullable byte[] data) {
            ((MediaDrmHandler)((Object)Assertions.checkNotNull((Object)((Object)DefaultDrmSessionManager.this.mediaDrmHandler)))).obtainMessage(event, sessionId).sendToTarget();
        }
    }

    private class ReferenceCountListenerImpl
    implements DefaultDrmSession.ReferenceCountListener {
        private ReferenceCountListenerImpl() {
        }

        @Override
        public void onReferenceCountIncremented(DefaultDrmSession session, int newReferenceCount) {
            if (DefaultDrmSessionManager.this.sessionKeepaliveMs != -9223372036854775807L) {
                DefaultDrmSessionManager.this.keepaliveSessions.remove(session);
                ((Handler)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackHandler)).removeCallbacksAndMessages((Object)session);
            }
        }

        @Override
        public void onReferenceCountDecremented(DefaultDrmSession session, int newReferenceCount) {
            if (newReferenceCount == 1 && DefaultDrmSessionManager.this.sessionKeepaliveMs != -9223372036854775807L) {
                DefaultDrmSessionManager.this.keepaliveSessions.add(session);
                ((Handler)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackHandler)).postAtTime(() -> session.release(null), (Object)session, SystemClock.uptimeMillis() + DefaultDrmSessionManager.this.sessionKeepaliveMs);
            } else if (newReferenceCount == 0) {
                DefaultDrmSessionManager.this.sessions.remove(session);
                if (DefaultDrmSessionManager.this.placeholderDrmSession == session) {
                    DefaultDrmSessionManager.this.placeholderDrmSession = null;
                }
                if (DefaultDrmSessionManager.this.noMultiSessionDrmSession == session) {
                    DefaultDrmSessionManager.this.noMultiSessionDrmSession = null;
                }
                if (DefaultDrmSessionManager.this.provisioningSessions.size() > 1 && DefaultDrmSessionManager.this.provisioningSessions.get(0) == session) {
                    ((DefaultDrmSession)DefaultDrmSessionManager.this.provisioningSessions.get(1)).provision();
                }
                DefaultDrmSessionManager.this.provisioningSessions.remove(session);
                if (DefaultDrmSessionManager.this.sessionKeepaliveMs != -9223372036854775807L) {
                    ((Handler)Assertions.checkNotNull((Object)DefaultDrmSessionManager.this.playbackHandler)).removeCallbacksAndMessages((Object)session);
                    DefaultDrmSessionManager.this.keepaliveSessions.remove(session);
                }
            }
            DefaultDrmSessionManager.this.maybeReleaseMediaDrm();
        }
    }

    private class ProvisioningManagerImpl
    implements DefaultDrmSession.ProvisioningManager {
        private ProvisioningManagerImpl() {
        }

        @Override
        public void provisionRequired(DefaultDrmSession session) {
            if (DefaultDrmSessionManager.this.provisioningSessions.contains(session)) {
                return;
            }
            DefaultDrmSessionManager.this.provisioningSessions.add(session);
            if (DefaultDrmSessionManager.this.provisioningSessions.size() == 1) {
                session.provision();
            }
        }

        @Override
        public void onProvisionCompleted() {
            for (DefaultDrmSession session : DefaultDrmSessionManager.this.provisioningSessions) {
                session.onProvisionCompleted();
            }
            DefaultDrmSessionManager.this.provisioningSessions.clear();
        }

        @Override
        public void onProvisionError(Exception error) {
            for (DefaultDrmSession session : DefaultDrmSessionManager.this.provisioningSessions) {
                session.onProvisionError(error);
            }
            DefaultDrmSessionManager.this.provisioningSessions.clear();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            byte[] sessionId = (byte[])msg.obj;
            if (sessionId == null) {
                return;
            }
            for (DefaultDrmSession session : DefaultDrmSessionManager.this.sessions) {
                if (!session.hasSessionId(sessionId)) continue;
                session.onMediaDrmEvent(msg.what);
                return;
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    public static final class MissingSchemeDataException
    extends Exception {
        private MissingSchemeDataException(UUID uuid) {
            String string = String.valueOf(uuid);
            super(new StringBuilder(29 + String.valueOf(string).length()).append("Media does not support uuid: ").append(string).toString());
        }
    }

    public static final class Builder {
        private final HashMap<String, String> keyRequestParameters = new HashMap();
        private UUID uuid = C.WIDEVINE_UUID;
        private ExoMediaDrm.Provider exoMediaDrmProvider = FrameworkMediaDrm.DEFAULT_PROVIDER;
        private boolean multiSession;
        private int[] useDrmSessionsForClearContentTrackTypes;
        private boolean playClearSamplesWithoutKeys;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
        private long sessionKeepaliveMs = 300000L;

        public Builder() {
            this.useDrmSessionsForClearContentTrackTypes = new int[0];
        }

        public Builder setKeyRequestParameters(@Nullable Map<String, String> keyRequestParameters) {
            this.keyRequestParameters.clear();
            if (keyRequestParameters != null) {
                this.keyRequestParameters.putAll(keyRequestParameters);
            }
            return this;
        }

        public Builder setUuidAndExoMediaDrmProvider(UUID uuid, ExoMediaDrm.Provider exoMediaDrmProvider) {
            this.uuid = (UUID)Assertions.checkNotNull((Object)uuid);
            this.exoMediaDrmProvider = (ExoMediaDrm.Provider)Assertions.checkNotNull((Object)exoMediaDrmProvider);
            return this;
        }

        public Builder setMultiSession(boolean multiSession) {
            this.multiSession = multiSession;
            return this;
        }

        public Builder setUseDrmSessionsForClearContent(int ... useDrmSessionsForClearContentTrackTypes) {
            for (int trackType : useDrmSessionsForClearContentTrackTypes) {
                Assertions.checkArgument((trackType == 2 || trackType == 1 ? 1 : 0) != 0);
            }
            this.useDrmSessionsForClearContentTrackTypes = (int[])useDrmSessionsForClearContentTrackTypes.clone();
            return this;
        }

        public Builder setPlayClearSamplesWithoutKeys(boolean playClearSamplesWithoutKeys) {
            this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
            return this;
        }

        public Builder setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = (LoadErrorHandlingPolicy)Assertions.checkNotNull((Object)loadErrorHandlingPolicy);
            return this;
        }

        public Builder setSessionKeepaliveMs(long sessionKeepaliveMs) {
            Assertions.checkArgument((sessionKeepaliveMs > 0L || sessionKeepaliveMs == -9223372036854775807L ? 1 : 0) != 0);
            this.sessionKeepaliveMs = sessionKeepaliveMs;
            return this;
        }

        public DefaultDrmSessionManager build(MediaDrmCallback mediaDrmCallback) {
            return new DefaultDrmSessionManager(this.uuid, this.exoMediaDrmProvider, mediaDrmCallback, this.keyRequestParameters, this.multiSession, this.useDrmSessionsForClearContentTrackTypes, this.playClearSamplesWithoutKeys, this.loadErrorHandlingPolicy, this.sessionKeepaliveMs);
        }
    }
}

