/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.ErrorStateDrmSession;
import com.google.android.exoplayer2.drm.ExoMediaCrypto;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.drm.UnsupportedMediaCrypto;

public interface DrmSessionManager {
    public static final DrmSessionManager DRM_UNSUPPORTED;
    @Deprecated
    public static final DrmSessionManager DUMMY;

    @Deprecated
    public static DrmSessionManager getDummyDrmSessionManager() {
        return DRM_UNSUPPORTED;
    }

    default public void prepare() {
    }

    default public void release() {
    }

    default public DrmSessionReference preacquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
        return DrmSessionReference.EMPTY;
    }

    @Nullable
    public DrmSession acquireSession(Looper var1, @Nullable DrmSessionEventListener.EventDispatcher var2, Format var3);

    @Nullable
    public Class<? extends ExoMediaCrypto> getExoMediaCryptoType(Format var1);

    static {
        DUMMY = DRM_UNSUPPORTED = new DrmSessionManager(){

            @Override
            @Nullable
            public DrmSession acquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
                if (format.drmInitData == null) {
                    return null;
                }
                return new ErrorStateDrmSession(new DrmSession.DrmSessionException(new UnsupportedDrmException(1)));
            }

            @Nullable
            public Class<UnsupportedMediaCrypto> getExoMediaCryptoType(Format format) {
                return format.drmInitData != null ? UnsupportedMediaCrypto.class : null;
            }
        };
    }

    public static interface DrmSessionReference {
        public static final DrmSessionReference EMPTY = () -> {};

        public void release();
    }
}

