/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.media.DeniedByServerException;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.PersistableBundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.drm.ClearKeyUtil;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DummyExoMediaDrm;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@RequiresApi(value=18)
public final class FrameworkMediaDrm
implements ExoMediaDrm {
    private static final String TAG = "FrameworkMediaDrm";
    public static final ExoMediaDrm.Provider DEFAULT_PROVIDER = uuid -> {
        try {
            return FrameworkMediaDrm.newInstance(uuid);
        }
        catch (UnsupportedDrmException e) {
            String string = String.valueOf(uuid);
            Log.e((String)TAG, (String)new StringBuilder(53 + String.valueOf(string).length()).append("Failed to instantiate a FrameworkMediaDrm for uuid: ").append(string).append(".").toString());
            return new DummyExoMediaDrm();
        }
    };
    private static final String CENC_SCHEME_MIME_TYPE = "cenc";
    private static final String MOCK_LA_URL_VALUE = "https://x";
    private static final String MOCK_LA_URL = "<LA_URL>https://x</LA_URL>";
    private static final int UTF_16_BYTES_PER_CHARACTER = 2;
    private final UUID uuid;
    private final MediaDrm mediaDrm;
    private int referenceCount;

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupported((UUID)FrameworkMediaDrm.adjustUuid(uuid));
    }

    public static FrameworkMediaDrm newInstance(UUID uuid) throws UnsupportedDrmException {
        try {
            return new FrameworkMediaDrm(uuid);
        }
        catch (UnsupportedSchemeException e) {
            throw new UnsupportedDrmException(1, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new UnsupportedDrmException(2, e);
        }
    }

    private FrameworkMediaDrm(UUID uuid) throws UnsupportedSchemeException {
        Assertions.checkNotNull((Object)uuid);
        Assertions.checkArgument((!C.COMMON_PSSH_UUID.equals(uuid) ? 1 : 0) != 0, (Object)"Use C.CLEARKEY_UUID instead");
        this.uuid = uuid;
        this.mediaDrm = new MediaDrm(FrameworkMediaDrm.adjustUuid(uuid));
        this.referenceCount = 1;
        if (C.WIDEVINE_UUID.equals(uuid) && FrameworkMediaDrm.needsForceWidevineL3Workaround()) {
            FrameworkMediaDrm.forceWidevineL3(this.mediaDrm);
        }
    }

    @Override
    public void setOnEventListener(@Nullable ExoMediaDrm.OnEventListener listener) {
        this.mediaDrm.setOnEventListener(listener == null ? null : (mediaDrm, sessionId, event, extra, data) -> listener.onEvent(this, sessionId, event, extra, data));
    }

    @Override
    @RequiresApi(value=23)
    public void setOnKeyStatusChangeListener(@Nullable ExoMediaDrm.OnKeyStatusChangeListener listener) {
        if (Util.SDK_INT < 23) {
            throw new UnsupportedOperationException();
        }
        this.mediaDrm.setOnKeyStatusChangeListener(listener == null ? null : (mediaDrm, sessionId, keyInfo, hasNewUsableKey) -> {
            ArrayList<ExoMediaDrm.KeyStatus> exoKeyInfo = new ArrayList<ExoMediaDrm.KeyStatus>();
            for (MediaDrm.KeyStatus keyStatus : keyInfo) {
                exoKeyInfo.add(new ExoMediaDrm.KeyStatus(keyStatus.getStatusCode(), keyStatus.getKeyId()));
            }
            listener.onKeyStatusChange(this, sessionId, exoKeyInfo, hasNewUsableKey);
        }, null);
    }

    @Override
    @RequiresApi(value=23)
    public void setOnExpirationUpdateListener(@Nullable ExoMediaDrm.OnExpirationUpdateListener listener) {
        if (Util.SDK_INT < 23) {
            throw new UnsupportedOperationException();
        }
        this.mediaDrm.setOnExpirationUpdateListener(listener == null ? null : (mediaDrm, sessionId, expirationTimeMs) -> listener.onExpirationUpdate(this, sessionId, expirationTimeMs), null);
    }

    @Override
    public byte[] openSession() throws MediaDrmException {
        return this.mediaDrm.openSession();
    }

    @Override
    public void closeSession(byte[] sessionId) {
        this.mediaDrm.closeSession(sessionId);
    }

    @Override
    public ExoMediaDrm.KeyRequest getKeyRequest(byte[] scope, @Nullable List<DrmInitData.SchemeData> schemeDatas, int keyType, @Nullable HashMap<String, String> optionalParameters) throws NotProvisionedException {
        DrmInitData.SchemeData schemeData = null;
        byte[] initData = null;
        String mimeType = null;
        if (schemeDatas != null) {
            schemeData = FrameworkMediaDrm.getSchemeData(this.uuid, schemeDatas);
            initData = FrameworkMediaDrm.adjustRequestInitData(this.uuid, (byte[])Assertions.checkNotNull((Object)schemeData.data));
            mimeType = FrameworkMediaDrm.adjustRequestMimeType(this.uuid, schemeData.mimeType);
        }
        MediaDrm.KeyRequest request = this.mediaDrm.getKeyRequest(scope, initData, mimeType, keyType, optionalParameters);
        byte[] requestData = FrameworkMediaDrm.adjustRequestData(this.uuid, request.getData());
        String licenseServerUrl = request.getDefaultUrl();
        if (MOCK_LA_URL_VALUE.equals(licenseServerUrl)) {
            licenseServerUrl = "";
        }
        if (TextUtils.isEmpty((CharSequence)licenseServerUrl) && schemeData != null && !TextUtils.isEmpty((CharSequence)schemeData.licenseServerUrl)) {
            licenseServerUrl = schemeData.licenseServerUrl;
        }
        int requestType = Util.SDK_INT >= 23 ? request.getRequestType() : Integer.MIN_VALUE;
        return new ExoMediaDrm.KeyRequest(requestData, licenseServerUrl, requestType);
    }

    @Override
    @Nullable
    public byte[] provideKeyResponse(byte[] scope, byte[] response) throws NotProvisionedException, DeniedByServerException {
        if (C.CLEARKEY_UUID.equals(this.uuid)) {
            response = ClearKeyUtil.adjustResponseData(response);
        }
        return this.mediaDrm.provideKeyResponse(scope, response);
    }

    @Override
    public ExoMediaDrm.ProvisionRequest getProvisionRequest() {
        MediaDrm.ProvisionRequest request = this.mediaDrm.getProvisionRequest();
        return new ExoMediaDrm.ProvisionRequest(request.getData(), request.getDefaultUrl());
    }

    @Override
    public void provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.mediaDrm.provideProvisionResponse(response);
    }

    @Override
    public Map<String, String> queryKeyStatus(byte[] sessionId) {
        return this.mediaDrm.queryKeyStatus(sessionId);
    }

    @Override
    public synchronized void acquire() {
        Assertions.checkState((this.referenceCount > 0 ? 1 : 0) != 0);
        ++this.referenceCount;
    }

    @Override
    public synchronized void release() {
        if (--this.referenceCount == 0) {
            this.mediaDrm.release();
        }
    }

    @Override
    public void restoreKeys(byte[] sessionId, byte[] keySetId) {
        this.mediaDrm.restoreKeys(sessionId, keySetId);
    }

    @Override
    @Nullable
    public PersistableBundle getMetrics() {
        if (Util.SDK_INT < 28) {
            return null;
        }
        return this.mediaDrm.getMetrics();
    }

    @Override
    public String getPropertyString(String propertyName) {
        return this.mediaDrm.getPropertyString(propertyName);
    }

    @Override
    public byte[] getPropertyByteArray(String propertyName) {
        return this.mediaDrm.getPropertyByteArray(propertyName);
    }

    @Override
    public void setPropertyString(String propertyName, String value) {
        this.mediaDrm.setPropertyString(propertyName, value);
    }

    @Override
    public void setPropertyByteArray(String propertyName, byte[] value) {
        this.mediaDrm.setPropertyByteArray(propertyName, value);
    }

    @Override
    public FrameworkMediaCrypto createMediaCrypto(byte[] initData) throws MediaCryptoException {
        boolean forceAllowInsecureDecoderComponents = Util.SDK_INT < 21 && C.WIDEVINE_UUID.equals(this.uuid) && "L3".equals(this.getPropertyString("securityLevel"));
        return new FrameworkMediaCrypto(FrameworkMediaDrm.adjustUuid(this.uuid), initData, forceAllowInsecureDecoderComponents);
    }

    public Class<FrameworkMediaCrypto> getExoMediaCryptoType() {
        return FrameworkMediaCrypto.class;
    }

    private static DrmInitData.SchemeData getSchemeData(UUID uuid, List<DrmInitData.SchemeData> schemeDatas) {
        if (!C.WIDEVINE_UUID.equals(uuid)) {
            return schemeDatas.get(0);
        }
        if (Util.SDK_INT >= 28 && schemeDatas.size() > 1) {
            DrmInitData.SchemeData firstSchemeData = schemeDatas.get(0);
            int concatenatedDataLength = 0;
            boolean canConcatenateData = true;
            for (int i = 0; i < schemeDatas.size(); ++i) {
                DrmInitData.SchemeData schemeData = schemeDatas.get(i);
                byte[] schemeDataData = (byte[])Assertions.checkNotNull((Object)schemeData.data);
                if (Util.areEqual((Object)schemeData.mimeType, (Object)firstSchemeData.mimeType) && Util.areEqual((Object)schemeData.licenseServerUrl, (Object)firstSchemeData.licenseServerUrl) && PsshAtomUtil.isPsshAtom((byte[])schemeDataData)) {
                    concatenatedDataLength += schemeDataData.length;
                    continue;
                }
                canConcatenateData = false;
                break;
            }
            if (canConcatenateData) {
                byte[] concatenatedData = new byte[concatenatedDataLength];
                int concatenatedDataPosition = 0;
                for (int i = 0; i < schemeDatas.size(); ++i) {
                    DrmInitData.SchemeData schemeData = schemeDatas.get(i);
                    byte[] schemeDataData = (byte[])Assertions.checkNotNull((Object)schemeData.data);
                    int schemeDataLength = schemeDataData.length;
                    System.arraycopy(schemeDataData, 0, concatenatedData, concatenatedDataPosition, schemeDataLength);
                    concatenatedDataPosition += schemeDataLength;
                }
                return firstSchemeData.copyWithData(concatenatedData);
            }
        }
        for (int i = 0; i < schemeDatas.size(); ++i) {
            DrmInitData.SchemeData schemeData = schemeDatas.get(i);
            int version = PsshAtomUtil.parseVersion((byte[])((byte[])Assertions.checkNotNull((Object)schemeData.data)));
            if (Util.SDK_INT < 23 && version == 0) {
                return schemeData;
            }
            if (Util.SDK_INT < 23 || version != 1) continue;
            return schemeData;
        }
        return schemeDatas.get(0);
    }

    private static UUID adjustUuid(UUID uuid) {
        return Util.SDK_INT < 27 && C.CLEARKEY_UUID.equals(uuid) ? C.COMMON_PSSH_UUID : uuid;
    }

    private static byte[] adjustRequestInitData(UUID uuid, byte[] initData) {
        byte[] psshData;
        if (C.PLAYREADY_UUID.equals(uuid)) {
            byte[] schemeSpecificData = PsshAtomUtil.parseSchemeSpecificData((byte[])initData, (UUID)uuid);
            if (schemeSpecificData == null) {
                schemeSpecificData = initData;
            }
            initData = PsshAtomUtil.buildPsshAtom((UUID)C.PLAYREADY_UUID, (byte[])FrameworkMediaDrm.addLaUrlAttributeIfMissing(schemeSpecificData));
        }
        if ((Util.SDK_INT < 23 && C.WIDEVINE_UUID.equals(uuid) || C.PLAYREADY_UUID.equals(uuid) && "Amazon".equals(Util.MANUFACTURER) && ("AFTB".equals(Util.MODEL) || "AFTS".equals(Util.MODEL) || "AFTM".equals(Util.MODEL) || "AFTT".equals(Util.MODEL))) && (psshData = PsshAtomUtil.parseSchemeSpecificData((byte[])initData, (UUID)uuid)) != null) {
            return psshData;
        }
        return initData;
    }

    private static String adjustRequestMimeType(UUID uuid, String mimeType) {
        if (Util.SDK_INT < 26 && C.CLEARKEY_UUID.equals(uuid) && ("video/mp4".equals(mimeType) || "audio/mp4".equals(mimeType))) {
            return CENC_SCHEME_MIME_TYPE;
        }
        return mimeType;
    }

    private static byte[] adjustRequestData(UUID uuid, byte[] requestData) {
        if (C.CLEARKEY_UUID.equals(uuid)) {
            return ClearKeyUtil.adjustRequestData(requestData);
        }
        return requestData;
    }

    @SuppressLint(value={"WrongConstant"})
    private static void forceWidevineL3(MediaDrm mediaDrm) {
        mediaDrm.setPropertyString("securityLevel", "L3");
    }

    private static boolean needsForceWidevineL3Workaround() {
        return "ASUS_Z00AD".equals(Util.MODEL);
    }

    private static byte[] addLaUrlAttributeIfMissing(byte[] data) {
        ParsableByteArray byteArray = new ParsableByteArray(data);
        int length = byteArray.readLittleEndianInt();
        short objectRecordCount = byteArray.readLittleEndianShort();
        short recordType = byteArray.readLittleEndianShort();
        if (objectRecordCount != 1 || recordType != 1) {
            Log.i((String)TAG, (String)"Unexpected record count or type. Skipping LA_URL workaround.");
            return data;
        }
        short recordLength = byteArray.readLittleEndianShort();
        String xml = byteArray.readString((int)recordLength, Charsets.UTF_16LE);
        if (xml.contains("<LA_URL>")) {
            return data;
        }
        int endOfDataTagIndex = xml.indexOf("</DATA>");
        if (endOfDataTagIndex == -1) {
            Log.w((String)TAG, (String)"Could not find the </DATA> tag. Skipping LA_URL workaround.");
        }
        String string = xml.substring(0, endOfDataTagIndex);
        String string2 = xml.substring(endOfDataTagIndex);
        String xmlWithMockLaUrl = new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(MOCK_LA_URL).append(string2).toString();
        int extraBytes = MOCK_LA_URL.length() * 2;
        ByteBuffer newData = ByteBuffer.allocate(length + extraBytes);
        newData.order(ByteOrder.LITTLE_ENDIAN);
        newData.putInt(length + extraBytes);
        newData.putShort(objectRecordCount);
        newData.putShort(recordType);
        newData.putShort((short)(xmlWithMockLaUrl.length() * 2));
        newData.put(xmlWithMockLaUrl.getBytes(Charsets.UTF_16LE));
        return newData.array();
    }
}

