/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;

public final class MediaCodecInfo {
    public static final String TAG = "MediaCodecInfo";
    public static final int MAX_SUPPORTED_INSTANCES_UNKNOWN = -1;
    public final String name;
    public final String mimeType;
    public final String codecMimeType;
    @Nullable
    public final MediaCodecInfo.CodecCapabilities capabilities;
    public final boolean adaptive;
    public final boolean tunneling;
    public final boolean secure;
    public final boolean hardwareAccelerated;
    public final boolean softwareOnly;
    public final boolean vendor;
    private final boolean isVideo;

    public static MediaCodecInfo newInstance(String name, String mimeType, String codecMimeType, @Nullable MediaCodecInfo.CodecCapabilities capabilities, boolean hardwareAccelerated, boolean softwareOnly, boolean vendor, boolean forceDisableAdaptive, boolean forceSecure) {
        return new MediaCodecInfo(name, mimeType, codecMimeType, capabilities, hardwareAccelerated, softwareOnly, vendor, !forceDisableAdaptive && capabilities != null && MediaCodecInfo.isAdaptive(capabilities) && !MediaCodecInfo.needsDisableAdaptationWorkaround(name), capabilities != null && MediaCodecInfo.isTunneling(capabilities), forceSecure || capabilities != null && MediaCodecInfo.isSecure(capabilities));
    }

    @VisibleForTesting
    MediaCodecInfo(String name, String mimeType, String codecMimeType, @Nullable MediaCodecInfo.CodecCapabilities capabilities, boolean hardwareAccelerated, boolean softwareOnly, boolean vendor, boolean adaptive, boolean tunneling, boolean secure) {
        this.name = (String)Assertions.checkNotNull((Object)name);
        this.mimeType = mimeType;
        this.codecMimeType = codecMimeType;
        this.capabilities = capabilities;
        this.hardwareAccelerated = hardwareAccelerated;
        this.softwareOnly = softwareOnly;
        this.vendor = vendor;
        this.adaptive = adaptive;
        this.tunneling = tunneling;
        this.secure = secure;
        this.isVideo = MimeTypes.isVideo((String)mimeType);
    }

    public String toString() {
        return this.name;
    }

    public MediaCodecInfo.CodecProfileLevel[] getProfileLevels() {
        return this.capabilities == null || this.capabilities.profileLevels == null ? new MediaCodecInfo.CodecProfileLevel[]{} : this.capabilities.profileLevels;
    }

    public int getMaxSupportedInstances() {
        if (Util.SDK_INT < 23 || this.capabilities == null) {
            return -1;
        }
        return MediaCodecInfo.getMaxSupportedInstancesV23(this.capabilities);
    }

    public boolean isFormatSupported(Format format) throws MediaCodecUtil.DecoderQueryException {
        if (!this.isCodecSupported(format)) {
            return false;
        }
        if (this.isVideo) {
            boolean isFormatSupported;
            if (format.width <= 0 || format.height <= 0) {
                return true;
            }
            if (Util.SDK_INT >= 21) {
                return this.isVideoSizeAndRateSupportedV21(format.width, format.height, format.frameRate);
            }
            boolean bl = isFormatSupported = format.width * format.height <= MediaCodecUtil.maxH264DecodableFrameSize();
            if (!isFormatSupported) {
                int n = format.width;
                int n2 = format.height;
                this.logNoSupport(new StringBuilder(40).append("legacyFrameSize, ").append(n).append("x").append(n2).toString());
            }
            return isFormatSupported;
        }
        return Util.SDK_INT < 21 || (format.sampleRate == -1 || this.isAudioSampleRateSupportedV21(format.sampleRate)) && (format.channelCount == -1 || this.isAudioChannelCountSupportedV21(format.channelCount));
    }

    public boolean isCodecSupported(Format format) {
        if (format.codecs == null || this.mimeType == null) {
            return true;
        }
        String codecMimeType = MimeTypes.getMediaMimeType((String)format.codecs);
        if (codecMimeType == null) {
            return true;
        }
        if (!this.mimeType.equals(codecMimeType)) {
            String string = format.codecs;
            this.logNoSupport(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(codecMimeType).length()).append("codec.mime ").append(string).append(", ").append(codecMimeType).toString());
            return false;
        }
        Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
        if (codecProfileAndLevel == null) {
            return true;
        }
        int profile = (Integer)codecProfileAndLevel.first;
        int level = (Integer)codecProfileAndLevel.second;
        if (!this.isVideo && profile != 42) {
            return true;
        }
        MediaCodecInfo.CodecProfileLevel[] profileLevels = this.getProfileLevels();
        if (Util.SDK_INT <= 23 && "video/x-vnd.on2.vp9".equals(this.mimeType) && profileLevels.length == 0) {
            profileLevels = MediaCodecInfo.estimateLegacyVp9ProfileLevels(this.capabilities);
        }
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            if (profileLevel.profile != profile || profileLevel.level < level) continue;
            return true;
        }
        String string = format.codecs;
        this.logNoSupport(new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(codecMimeType).length()).append("codec.profileLevel, ").append(string).append(", ").append(codecMimeType).toString());
        return false;
    }

    public boolean isHdr10PlusOutOfBandMetadataSupported() {
        if (Util.SDK_INT >= 29 && "video/x-vnd.on2.vp9".equals(this.mimeType)) {
            for (MediaCodecInfo.CodecProfileLevel capabilities : this.getProfileLevels()) {
                if (capabilities.profile != 16384) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSeamlessAdaptationSupported(Format format) {
        if (this.isVideo) {
            return this.adaptive;
        }
        Pair<Integer, Integer> profileLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
        return profileLevel != null && (Integer)profileLevel.first == 42;
    }

    @Deprecated
    public boolean isSeamlessAdaptationSupported(Format oldFormat, Format newFormat, boolean isNewFormatComplete) {
        int reuseResult;
        if (!isNewFormatComplete && oldFormat.colorInfo != null && newFormat.colorInfo == null) {
            newFormat = newFormat.buildUpon().setColorInfo(oldFormat.colorInfo).build();
        }
        return (reuseResult = this.canReuseCodec((Format)oldFormat, (Format)newFormat).result) == 2 || reuseResult == 3;
    }

    public DecoderReuseEvaluation canReuseCodec(Format oldFormat, Format newFormat) {
        int discardReasons = 0;
        if (!Util.areEqual((Object)oldFormat.sampleMimeType, (Object)newFormat.sampleMimeType)) {
            discardReasons |= 8;
        }
        if (this.isVideo) {
            if (oldFormat.rotationDegrees != newFormat.rotationDegrees) {
                discardReasons |= 0x400;
            }
            if (!(this.adaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height)) {
                discardReasons |= 0x200;
            }
            if (!Util.areEqual((Object)oldFormat.colorInfo, (Object)newFormat.colorInfo)) {
                discardReasons |= 0x800;
            }
            if (MediaCodecInfo.needsAdaptationReconfigureWorkaround(this.name) && !oldFormat.initializationDataEquals(newFormat)) {
                discardReasons |= 2;
            }
            if (discardReasons == 0) {
                return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, oldFormat.initializationDataEquals(newFormat) ? 3 : 2, 0);
            }
        } else {
            if (oldFormat.channelCount != newFormat.channelCount) {
                discardReasons |= 0x1000;
            }
            if (oldFormat.sampleRate != newFormat.sampleRate) {
                discardReasons |= 0x2000;
            }
            if (oldFormat.pcmEncoding != newFormat.pcmEncoding) {
                discardReasons |= 0x4000;
            }
            if (discardReasons == 0 && "audio/mp4a-latm".equals(this.mimeType)) {
                Pair<Integer, Integer> oldCodecProfileLevel = MediaCodecUtil.getCodecProfileAndLevel(oldFormat);
                Pair<Integer, Integer> newCodecProfileLevel = MediaCodecUtil.getCodecProfileAndLevel(newFormat);
                if (oldCodecProfileLevel != null && newCodecProfileLevel != null) {
                    int oldProfile = (Integer)oldCodecProfileLevel.first;
                    int newProfile = (Integer)newCodecProfileLevel.first;
                    if (oldProfile == 42 && newProfile == 42) {
                        return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 3, 0);
                    }
                }
            }
            if (!oldFormat.initializationDataEquals(newFormat)) {
                discardReasons |= 0x20;
            }
            if (MediaCodecInfo.needsAdaptationFlushWorkaround(this.mimeType)) {
                discardReasons |= 2;
            }
            if (discardReasons == 0) {
                return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 1, 0);
            }
        }
        return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 0, discardReasons);
    }

    @RequiresApi(value=21)
    public boolean isVideoSizeAndRateSupportedV21(int width, int height, double frameRate) {
        if (this.capabilities == null) {
            this.logNoSupport("sizeAndRate.caps");
            return false;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            this.logNoSupport("sizeAndRate.vCaps");
            return false;
        }
        if (!MediaCodecInfo.areSizeAndRateSupportedV21(videoCapabilities, width, height, frameRate)) {
            if (width >= height || !MediaCodecInfo.needsRotatedVerticalResolutionWorkaround(this.name) || !MediaCodecInfo.areSizeAndRateSupportedV21(videoCapabilities, height, width, frameRate)) {
                this.logNoSupport(new StringBuilder(69).append("sizeAndRate.support, ").append(width).append("x").append(height).append("x").append(frameRate).toString());
                return false;
            }
            this.logAssumedSupport(new StringBuilder(69).append("sizeAndRate.rotated, ").append(width).append("x").append(height).append("x").append(frameRate).toString());
        }
        return true;
    }

    @Nullable
    @RequiresApi(value=21)
    public Point alignVideoSizeV21(int width, int height) {
        if (this.capabilities == null) {
            return null;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return null;
        }
        return MediaCodecInfo.alignVideoSizeV21(videoCapabilities, width, height);
    }

    @RequiresApi(value=21)
    public boolean isAudioSampleRateSupportedV21(int sampleRate) {
        if (this.capabilities == null) {
            this.logNoSupport("sampleRate.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.logNoSupport("sampleRate.aCaps");
            return false;
        }
        if (!audioCapabilities.isSampleRateSupported(sampleRate)) {
            this.logNoSupport(new StringBuilder(31).append("sampleRate.support, ").append(sampleRate).toString());
            return false;
        }
        return true;
    }

    @RequiresApi(value=21)
    public boolean isAudioChannelCountSupportedV21(int channelCount) {
        if (this.capabilities == null) {
            this.logNoSupport("channelCount.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.logNoSupport("channelCount.aCaps");
            return false;
        }
        int maxInputChannelCount = MediaCodecInfo.adjustMaxInputChannelCount(this.name, this.mimeType, audioCapabilities.getMaxInputChannelCount());
        if (maxInputChannelCount < channelCount) {
            this.logNoSupport(new StringBuilder(33).append("channelCount.support, ").append(channelCount).toString());
            return false;
        }
        return true;
    }

    private void logNoSupport(String message) {
        String string = this.name;
        String string2 = this.mimeType;
        String string3 = Util.DEVICE_DEBUG_INFO;
        Log.d((String)TAG, (String)new StringBuilder(20 + String.valueOf(message).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("NoSupport [").append(message).append("] [").append(string).append(", ").append(string2).append("] [").append(string3).append("]").toString());
    }

    private void logAssumedSupport(String message) {
        String string = this.name;
        String string2 = this.mimeType;
        String string3 = Util.DEVICE_DEBUG_INFO;
        Log.d((String)TAG, (String)new StringBuilder(25 + String.valueOf(message).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AssumedSupport [").append(message).append("] [").append(string).append(", ").append(string2).append("] [").append(string3).append("]").toString());
    }

    private static int adjustMaxInputChannelCount(String name, String mimeType, int maxChannelCount) {
        if (maxChannelCount > 1 || Util.SDK_INT >= 26 && maxChannelCount > 0) {
            return maxChannelCount;
        }
        if ("audio/mpeg".equals(mimeType) || "audio/3gpp".equals(mimeType) || "audio/amr-wb".equals(mimeType) || "audio/mp4a-latm".equals(mimeType) || "audio/vorbis".equals(mimeType) || "audio/opus".equals(mimeType) || "audio/raw".equals(mimeType) || "audio/flac".equals(mimeType) || "audio/g711-alaw".equals(mimeType) || "audio/g711-mlaw".equals(mimeType) || "audio/gsm".equals(mimeType)) {
            return maxChannelCount;
        }
        int assumedMaxChannelCount = "audio/ac3".equals(mimeType) ? 6 : ("audio/eac3".equals(mimeType) ? 16 : 30);
        Log.w((String)TAG, (String)new StringBuilder(59 + String.valueOf(name).length()).append("AssumedMaxChannelAdjustment: ").append(name).append(", [").append(maxChannelCount).append(" to ").append(assumedMaxChannelCount).append("]").toString());
        return assumedMaxChannelCount;
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 19 && MediaCodecInfo.isAdaptiveV19(capabilities);
    }

    @RequiresApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }

    private static boolean isTunneling(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 21 && MediaCodecInfo.isTunnelingV21(capabilities);
    }

    @RequiresApi(value=21)
    private static boolean isTunnelingV21(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("tunneled-playback");
    }

    private static boolean isSecure(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 21 && MediaCodecInfo.isSecureV21(capabilities);
    }

    @RequiresApi(value=21)
    private static boolean isSecureV21(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("secure-playback");
    }

    @RequiresApi(value=21)
    private static boolean areSizeAndRateSupportedV21(MediaCodecInfo.VideoCapabilities capabilities, int width, int height, double frameRate) {
        Point alignedSize = MediaCodecInfo.alignVideoSizeV21(capabilities, width, height);
        width = alignedSize.x;
        height = alignedSize.y;
        if (frameRate == -1.0 || frameRate < 1.0) {
            return capabilities.isSizeSupported(width, height);
        }
        double floorFrameRate = Math.floor(frameRate);
        return capabilities.areSizeAndRateSupported(width, height, floorFrameRate);
    }

    @RequiresApi(value=21)
    private static Point alignVideoSizeV21(MediaCodecInfo.VideoCapabilities capabilities, int width, int height) {
        int widthAlignment = capabilities.getWidthAlignment();
        int heightAlignment = capabilities.getHeightAlignment();
        return new Point(Util.ceilDivide((int)width, (int)widthAlignment) * widthAlignment, Util.ceilDivide((int)height, (int)heightAlignment) * heightAlignment);
    }

    @RequiresApi(value=23)
    private static int getMaxSupportedInstancesV23(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.getMaxSupportedInstances();
    }

    private static MediaCodecInfo.CodecProfileLevel[] estimateLegacyVp9ProfileLevels(@Nullable MediaCodecInfo.CodecCapabilities capabilities) {
        MediaCodecInfo.VideoCapabilities videoCapabilities;
        int maxBitrate = 0;
        if (capabilities != null && (videoCapabilities = capabilities.getVideoCapabilities()) != null) {
            maxBitrate = (Integer)videoCapabilities.getBitrateRange().getUpper();
        }
        int level = maxBitrate >= 180000000 ? 1024 : (maxBitrate >= 120000000 ? 512 : (maxBitrate >= 60000000 ? 256 : (maxBitrate >= 30000000 ? 128 : (maxBitrate >= 18000000 ? 64 : (maxBitrate >= 12000000 ? 32 : (maxBitrate >= 0x6DDD00 ? 16 : (maxBitrate >= 3600000 ? 8 : (maxBitrate >= 1800000 ? 4 : (maxBitrate >= 800000 ? 2 : 1)))))))));
        MediaCodecInfo.CodecProfileLevel profileLevel = new MediaCodecInfo.CodecProfileLevel();
        profileLevel.profile = 1;
        profileLevel.level = level;
        return new MediaCodecInfo.CodecProfileLevel[]{profileLevel};
    }

    private static boolean needsDisableAdaptationWorkaround(String name) {
        return !(Util.SDK_INT > 22 || !"ODROID-XU3".equals(Util.MODEL) && !"Nexus 10".equals(Util.MODEL) || !"OMX.Exynos.AVC.Decoder".equals(name) && !"OMX.Exynos.AVC.Decoder.secure".equals(name));
    }

    private static boolean needsAdaptationReconfigureWorkaround(String name) {
        return Util.MODEL.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(name);
    }

    private static boolean needsAdaptationFlushWorkaround(String mimeType) {
        return "audio/opus".equals(mimeType);
    }

    private static final boolean needsRotatedVerticalResolutionWorkaround(String name) {
        return !"OMX.MTK.VIDEO.DECODER.HEVC".equals(name) || !"mcv5a".equals(Util.DEVICE);
    }
}

