/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SynchronousMediaCodecAdapter
implements MediaCodecAdapter {
    private final MediaCodec codec;
    @Nullable
    private ByteBuffer[] inputByteBuffers;
    @Nullable
    private ByteBuffer[] outputByteBuffers;

    private SynchronousMediaCodecAdapter(MediaCodec mediaCodec) {
        this.codec = mediaCodec;
        if (Util.SDK_INT < 21) {
            this.inputByteBuffers = this.codec.getInputBuffers();
            this.outputByteBuffers = this.codec.getOutputBuffers();
        }
    }

    @Override
    public int dequeueInputBufferIndex() {
        return this.codec.dequeueInputBuffer(0L);
    }

    @Override
    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        int index;
        do {
            if ((index = this.codec.dequeueOutputBuffer(bufferInfo, 0L)) != -3 || Util.SDK_INT >= 21) continue;
            this.outputByteBuffers = this.codec.getOutputBuffers();
        } while (index == -3);
        return index;
    }

    @Override
    public MediaFormat getOutputFormat() {
        return this.codec.getOutputFormat();
    }

    @Override
    @Nullable
    public ByteBuffer getInputBuffer(int index) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getInputBuffer(index);
        }
        return ((ByteBuffer[])Util.castNonNull((Object)this.inputByteBuffers))[index];
    }

    @Override
    @Nullable
    public ByteBuffer getOutputBuffer(int index) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getOutputBuffer(index);
        }
        return ((ByteBuffer[])Util.castNonNull((Object)this.outputByteBuffers))[index];
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.codec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.codec.queueSecureInputBuffer(index, offset, info.getFrameworkCryptoInfo(), presentationTimeUs, flags);
    }

    @Override
    public void releaseOutputBuffer(int index, boolean render) {
        this.codec.releaseOutputBuffer(index, render);
    }

    @Override
    @RequiresApi(value=21)
    public void releaseOutputBuffer(int index, long renderTimeStampNs) {
        this.codec.releaseOutputBuffer(index, renderTimeStampNs);
    }

    @Override
    public void flush() {
        this.codec.flush();
    }

    @Override
    public void release() {
        this.inputByteBuffers = null;
        this.outputByteBuffers = null;
        this.codec.release();
    }

    @Override
    @RequiresApi(value=23)
    public void setOnFrameRenderedListener(MediaCodecAdapter.OnFrameRenderedListener listener, Handler handler) {
        this.codec.setOnFrameRenderedListener((codec, presentationTimeUs, nanoTime) -> listener.onFrameRendered(this, presentationTimeUs, nanoTime), handler);
    }

    @Override
    @RequiresApi(value=23)
    public void setOutputSurface(Surface surface) {
        this.codec.setOutputSurface(surface);
    }

    @Override
    @RequiresApi(value=19)
    public void setParameters(Bundle params) {
        this.codec.setParameters(params);
    }

    @Override
    public void setVideoScalingMode(int scalingMode) {
        this.codec.setVideoScalingMode(scalingMode);
    }

    public static class Factory
    implements MediaCodecAdapter.Factory {
        @Override
        public MediaCodecAdapter createAdapter(MediaCodecAdapter.Configuration configuration) throws IOException {
            MediaCodec codec = null;
            try {
                codec = this.createCodec(configuration);
                TraceUtil.beginSection((String)"configureCodec");
                codec.configure(configuration.mediaFormat, configuration.surface, configuration.crypto, configuration.flags);
                TraceUtil.endSection();
                TraceUtil.beginSection((String)"startCodec");
                codec.start();
                TraceUtil.endSection();
                return new SynchronousMediaCodecAdapter(codec);
            }
            catch (IOException | RuntimeException e) {
                if (codec != null) {
                    codec.release();
                }
                throw e;
            }
        }

        protected MediaCodec createCodec(MediaCodecAdapter.Configuration configuration) throws IOException {
            Assertions.checkNotNull((Object)configuration.codecInfo);
            String codecName = configuration.codecInfo.name;
            String string = String.valueOf(codecName);
            TraceUtil.beginSection((String)(string.length() != 0 ? "createCodec:".concat(string) : new String("createCodec:")));
            MediaCodec mediaCodec = MediaCodec.createByCodecName((String)codecName);
            TraceUtil.endSection();
            return mediaCodec;
        }
    }
}

