/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.MetadataDecoderFactory;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class MetadataRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final String TAG = "MetadataRenderer";
    private static final int MSG_INVOKE_RENDERER = 0;
    private final MetadataDecoderFactory decoderFactory;
    private final MetadataOutput output;
    @Nullable
    private final Handler outputHandler;
    private final MetadataInputBuffer buffer;
    @Nullable
    private MetadataDecoder decoder;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private long subsampleOffsetUs;
    private long pendingMetadataTimestampUs;
    @Nullable
    private Metadata pendingMetadata;

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper) {
        this(output, outputLooper, MetadataDecoderFactory.DEFAULT);
    }

    public MetadataRenderer(MetadataOutput output, @Nullable Looper outputLooper, MetadataDecoderFactory decoderFactory) {
        super(5);
        this.output = (MetadataOutput)Assertions.checkNotNull((Object)output);
        this.outputHandler = outputLooper == null ? null : Util.createHandler((Looper)outputLooper, (Handler.Callback)this);
        this.decoderFactory = (MetadataDecoderFactory)Assertions.checkNotNull((Object)decoderFactory);
        this.buffer = new MetadataInputBuffer();
        this.pendingMetadataTimestampUs = -9223372036854775807L;
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        if (this.decoderFactory.supportsFormat(format)) {
            return RendererCapabilities.create(format.exoMediaCryptoType == null ? 4 : 2);
        }
        return RendererCapabilities.create(0);
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.decoder = this.decoderFactory.createDecoder(formats[0]);
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.pendingMetadata = null;
        this.pendingMetadataTimestampUs = -9223372036854775807L;
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) {
        boolean working = true;
        while (working) {
            this.readMetadata();
            working = this.outputMetadata(positionUs);
        }
    }

    private void decodeWrappedMetadata(Metadata metadata, List<Metadata.Entry> decodedEntries) {
        for (int i = 0; i < metadata.length(); ++i) {
            Format wrappedMetadataFormat = metadata.get(i).getWrappedMetadataFormat();
            if (wrappedMetadataFormat != null && this.decoderFactory.supportsFormat(wrappedMetadataFormat)) {
                MetadataDecoder wrappedMetadataDecoder = this.decoderFactory.createDecoder(wrappedMetadataFormat);
                byte[] wrappedMetadataBytes = (byte[])Assertions.checkNotNull((Object)metadata.get(i).getWrappedMetadataBytes());
                this.buffer.clear();
                this.buffer.ensureSpaceForWrite(wrappedMetadataBytes.length);
                ((ByteBuffer)Util.castNonNull((Object)this.buffer.data)).put(wrappedMetadataBytes);
                this.buffer.flip();
                Metadata innerMetadata = wrappedMetadataDecoder.decode(this.buffer);
                if (innerMetadata == null) continue;
                this.decodeWrappedMetadata(innerMetadata, decodedEntries);
                continue;
            }
            decodedEntries.add(metadata.get(i));
        }
    }

    @Override
    protected void onDisabled() {
        this.pendingMetadata = null;
        this.pendingMetadataTimestampUs = -9223372036854775807L;
        this.decoder = null;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal((Metadata)msg.obj);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void readMetadata() {
        if (!this.inputStreamEnded && this.pendingMetadata == null) {
            this.buffer.clear();
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, (DecoderInputBuffer)this.buffer, 0);
            if (result == -4) {
                if (this.buffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                } else {
                    this.buffer.subsampleOffsetUs = this.subsampleOffsetUs;
                    this.buffer.flip();
                    Metadata metadata = ((MetadataDecoder)Util.castNonNull((Object)this.decoder)).decode(this.buffer);
                    if (metadata != null) {
                        ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>(metadata.length());
                        this.decodeWrappedMetadata(metadata, entries);
                        if (!entries.isEmpty()) {
                            Metadata expandedMetadata;
                            this.pendingMetadata = expandedMetadata = new Metadata(entries);
                            this.pendingMetadataTimestampUs = this.buffer.timeUs;
                        }
                    }
                }
            } else if (result == -5) {
                this.subsampleOffsetUs = ((Format)Assertions.checkNotNull((Object)formatHolder.format)).subsampleOffsetUs;
            }
        }
    }

    private boolean outputMetadata(long positionUs) {
        boolean didOutput = false;
        if (this.pendingMetadata != null && this.pendingMetadataTimestampUs <= positionUs) {
            this.invokeRenderer(this.pendingMetadata);
            this.pendingMetadata = null;
            this.pendingMetadataTimestampUs = -9223372036854775807L;
            didOutput = true;
        }
        if (this.inputStreamEnded && this.pendingMetadata == null) {
            this.outputStreamEnded = true;
        }
        return didOutput;
    }

    private void invokeRenderer(Metadata metadata) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, (Object)metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    private void invokeRendererInternal(Metadata metadata) {
        this.output.onMetadata(metadata);
    }
}

