/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.net.Uri;
import android.util.SparseArray;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.offline.Downloader;
import com.google.android.exoplayer2.offline.DownloaderFactory;
import com.google.android.exoplayer2.offline.ProgressiveDownloader;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;

public class DefaultDownloaderFactory
implements DownloaderFactory {
    private static final SparseArray<Constructor<? extends Downloader>> CONSTRUCTORS = DefaultDownloaderFactory.createDownloaderConstructors();
    private final CacheDataSource.Factory cacheDataSourceFactory;
    private final Executor executor;

    @Deprecated
    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory) {
        this(cacheDataSourceFactory, Runnable::run);
    }

    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this.cacheDataSourceFactory = (CacheDataSource.Factory)Assertions.checkNotNull((Object)cacheDataSourceFactory);
        this.executor = (Executor)Assertions.checkNotNull((Object)executor);
    }

    @Override
    public Downloader createDownloader(DownloadRequest request) {
        int contentType = Util.inferContentTypeForUriAndMimeType((Uri)request.uri, (String)request.mimeType);
        switch (contentType) {
            case 0: 
            case 1: 
            case 2: {
                return this.createDownloader(request, contentType);
            }
            case 4: {
                return new ProgressiveDownloader(new MediaItem.Builder().setUri(request.uri).setCustomCacheKey(request.customCacheKey).build(), this.cacheDataSourceFactory, this.executor);
            }
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported type: ").append(contentType).toString());
    }

    private Downloader createDownloader(DownloadRequest request, int contentType) {
        Constructor constructor = (Constructor)CONSTRUCTORS.get(contentType);
        if (constructor == null) {
            throw new IllegalStateException(new StringBuilder(43).append("Module missing for content type ").append(contentType).toString());
        }
        MediaItem mediaItem = new MediaItem.Builder().setUri(request.uri).setStreamKeys(request.streamKeys).setCustomCacheKey(request.customCacheKey).setDrmKeySetId(request.keySetId).build();
        try {
            return (Downloader)constructor.newInstance(mediaItem, this.cacheDataSourceFactory, this.executor);
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(61).append("Failed to instantiate downloader for content type ").append(contentType).toString());
        }
    }

    private static SparseArray<Constructor<? extends Downloader>> createDownloaderConstructors() {
        SparseArray array = new SparseArray();
        try {
            array.put(0, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.dash.offline.DashDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(2, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.hls.offline.HlsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(1, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.google.android.exoplayer2.source.smoothstreaming.offline.SsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return array;
    }

    private static Constructor<? extends Downloader> getDownloaderConstructor(Class<?> clazz) {
        try {
            return clazz.asSubclass(Downloader.class).getConstructor(MediaItem.class, CacheDataSource.Factory.class, Executor.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Downloader constructor missing", e);
        }
    }
}

