/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.offline.Downloader;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheWriter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.RunnableFutureTask;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class ProgressiveDownloader
implements Downloader {
    private final Executor executor;
    private final DataSpec dataSpec;
    private final CacheDataSource dataSource;
    private final CacheWriter cacheWriter;
    @Nullable
    private final PriorityTaskManager priorityTaskManager;
    @Nullable
    private Downloader.ProgressListener progressListener;
    private volatile @MonotonicNonNull RunnableFutureTask<Void, IOException> downloadRunnable;
    private volatile boolean isCanceled;

    @Deprecated
    public ProgressiveDownloader(Uri uri, @Nullable String customCacheKey, CacheDataSource.Factory cacheDataSourceFactory) {
        this(uri, customCacheKey, cacheDataSourceFactory, Runnable::run);
    }

    public ProgressiveDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    @Deprecated
    public ProgressiveDownloader(Uri uri, @Nullable String customCacheKey, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(new MediaItem.Builder().setUri(uri).setCustomCacheKey(customCacheKey).build(), cacheDataSourceFactory, executor);
    }

    public ProgressiveDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this.executor = (Executor)Assertions.checkNotNull((Object)executor);
        Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        this.dataSpec = new DataSpec.Builder().setUri(mediaItem.playbackProperties.uri).setKey(mediaItem.playbackProperties.customCacheKey).setFlags(4).build();
        this.dataSource = cacheDataSourceFactory.createDataSourceForDownloading();
        CacheWriter.ProgressListener progressListener = this::onProgress;
        this.cacheWriter = new CacheWriter(this.dataSource, this.dataSpec, null, progressListener);
        this.priorityTaskManager = cacheDataSourceFactory.getUpstreamPriorityTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(@Nullable Downloader.ProgressListener progressListener) throws IOException, InterruptedException {
        this.progressListener = progressListener;
        this.downloadRunnable = new RunnableFutureTask<Void, IOException>(){

            @Override
            protected Void doWork() throws IOException {
                ProgressiveDownloader.this.cacheWriter.cache();
                return null;
            }

            @Override
            protected void cancelWork() {
                ProgressiveDownloader.this.cacheWriter.cancel();
            }
        };
        if (this.priorityTaskManager != null) {
            this.priorityTaskManager.add(-1000);
        }
        try {
            boolean finished = false;
            while (!finished && !this.isCanceled) {
                if (this.priorityTaskManager != null) {
                    this.priorityTaskManager.proceed(-1000);
                }
                this.executor.execute(this.downloadRunnable);
                try {
                    this.downloadRunnable.get();
                    finished = true;
                }
                catch (ExecutionException e) {
                    Throwable cause = (Throwable)Assertions.checkNotNull((Object)e.getCause());
                    if (cause instanceof PriorityTaskManager.PriorityTooLowException) continue;
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    Util.sneakyThrow((Throwable)cause);
                }
            }
        }
        finally {
            this.downloadRunnable.blockUntilFinished();
            if (this.priorityTaskManager != null) {
                this.priorityTaskManager.remove(-1000);
            }
        }
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
        RunnableFutureTask<Void, IOException> downloadRunnable = this.downloadRunnable;
        if (downloadRunnable != null) {
            downloadRunnable.cancel(true);
        }
    }

    @Override
    public void remove() {
        this.dataSource.getCache().removeResource(this.dataSource.getCacheKeyFactory().buildCacheKey(this.dataSpec));
    }

    private void onProgress(long contentLength, long bytesCached, long newBytesCached) {
        if (this.progressListener == null) {
            return;
        }
        float percentDownloaded = contentLength == -1L || contentLength == 0L ? -1.0f : (float)bytesCached * 100.0f / (float)contentLength;
        this.progressListener.onProgress(contentLength, bytesCached, percentDownloaded);
    }
}

