/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.content.Context;
import android.net.Uri;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.ClippingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.MergingMediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.ui.AdViewProvider;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.List;

public final class DefaultMediaSourceFactory
implements MediaSourceFactory {
    private static final String TAG = "DefaultMediaSourceFactory";
    private final DataSource.Factory dataSourceFactory;
    private final SparseArray<MediaSourceFactory> mediaSourceFactories;
    private final int[] supportedTypes;
    @Nullable
    private AdsLoaderProvider adsLoaderProvider;
    @Nullable
    private AdViewProvider adViewProvider;
    @Nullable
    private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private long liveTargetOffsetMs;
    private long liveMinOffsetMs;
    private long liveMaxOffsetMs;
    private float liveMinSpeed;
    private float liveMaxSpeed;

    public DefaultMediaSourceFactory(Context context) {
        this(new DefaultDataSourceFactory(context));
    }

    public DefaultMediaSourceFactory(Context context, ExtractorsFactory extractorsFactory) {
        this(new DefaultDataSourceFactory(context), extractorsFactory);
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory) {
        this(dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.mediaSourceFactories = DefaultMediaSourceFactory.loadDelegates(dataSourceFactory, extractorsFactory);
        this.supportedTypes = new int[this.mediaSourceFactories.size()];
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            this.supportedTypes[i] = this.mediaSourceFactories.keyAt(i);
        }
        this.liveTargetOffsetMs = -9223372036854775807L;
        this.liveMinOffsetMs = -9223372036854775807L;
        this.liveMaxOffsetMs = -9223372036854775807L;
        this.liveMinSpeed = -3.4028235E38f;
        this.liveMaxSpeed = -3.4028235E38f;
    }

    public DefaultMediaSourceFactory setAdsLoaderProvider(@Nullable AdsLoaderProvider adsLoaderProvider) {
        this.adsLoaderProvider = adsLoaderProvider;
        return this;
    }

    public DefaultMediaSourceFactory setAdViewProvider(@Nullable AdViewProvider adViewProvider) {
        this.adViewProvider = adViewProvider;
        return this;
    }

    public DefaultMediaSourceFactory setLiveTargetOffsetMs(long liveTargetOffsetMs) {
        this.liveTargetOffsetMs = liveTargetOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMinOffsetMs(long liveMinOffsetMs) {
        this.liveMinOffsetMs = liveMinOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMaxOffsetMs(long liveMaxOffsetMs) {
        this.liveMaxOffsetMs = liveMaxOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMinSpeed(float minSpeed) {
        this.liveMinSpeed = minSpeed;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMaxSpeed(float maxSpeed) {
        this.liveMaxSpeed = maxSpeed;
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
        }
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmUserAgent(@Nullable String userAgent) {
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setDrmUserAgent(userAgent);
        }
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setDrmSessionManager(drmSessionManager);
        }
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setDrmSessionManagerProvider(drmSessionManagerProvider);
        }
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
        }
        return this;
    }

    @Override
    @Deprecated
    public DefaultMediaSourceFactory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            ((MediaSourceFactory)this.mediaSourceFactories.valueAt(i)).setStreamKeys(streamKeys);
        }
        return this;
    }

    @Override
    public int[] getSupportedTypes() {
        return Arrays.copyOf(this.supportedTypes, this.supportedTypes.length);
    }

    @Override
    public MediaSource createMediaSource(MediaItem mediaItem) {
        Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        int type = Util.inferContentTypeForUriAndMimeType((Uri)mediaItem.playbackProperties.uri, (String)mediaItem.playbackProperties.mimeType);
        MediaSourceFactory mediaSourceFactory = (MediaSourceFactory)this.mediaSourceFactories.get(type);
        Assertions.checkNotNull((Object)mediaSourceFactory, (Object)new StringBuilder(68).append("No suitable media source factory found for content type: ").append(type).toString());
        if (mediaItem.liveConfiguration.targetOffsetMs == -9223372036854775807L && this.liveTargetOffsetMs != -9223372036854775807L || mediaItem.liveConfiguration.minPlaybackSpeed == -3.4028235E38f && this.liveMinSpeed != -3.4028235E38f || mediaItem.liveConfiguration.maxPlaybackSpeed == -3.4028235E38f && this.liveMaxSpeed != -3.4028235E38f || mediaItem.liveConfiguration.minOffsetMs == -9223372036854775807L && this.liveMinOffsetMs != -9223372036854775807L || mediaItem.liveConfiguration.maxOffsetMs == -9223372036854775807L && this.liveMaxOffsetMs != -9223372036854775807L) {
            mediaItem = mediaItem.buildUpon().setLiveTargetOffsetMs(mediaItem.liveConfiguration.targetOffsetMs == -9223372036854775807L ? this.liveTargetOffsetMs : mediaItem.liveConfiguration.targetOffsetMs).setLiveMinPlaybackSpeed(mediaItem.liveConfiguration.minPlaybackSpeed == -3.4028235E38f ? this.liveMinSpeed : mediaItem.liveConfiguration.minPlaybackSpeed).setLiveMaxPlaybackSpeed(mediaItem.liveConfiguration.maxPlaybackSpeed == -3.4028235E38f ? this.liveMaxSpeed : mediaItem.liveConfiguration.maxPlaybackSpeed).setLiveMinOffsetMs(mediaItem.liveConfiguration.minOffsetMs == -9223372036854775807L ? this.liveMinOffsetMs : mediaItem.liveConfiguration.minOffsetMs).setLiveMaxOffsetMs(mediaItem.liveConfiguration.maxOffsetMs == -9223372036854775807L ? this.liveMaxOffsetMs : mediaItem.liveConfiguration.maxOffsetMs).build();
        }
        MediaSource mediaSource = mediaSourceFactory.createMediaSource(mediaItem);
        List subtitles = ((MediaItem.PlaybackProperties)Util.castNonNull((Object)mediaItem.playbackProperties)).subtitles;
        if (!subtitles.isEmpty()) {
            MediaSource[] mediaSources = new MediaSource[subtitles.size() + 1];
            mediaSources[0] = mediaSource;
            SingleSampleMediaSource.Factory singleSampleSourceFactory = new SingleSampleMediaSource.Factory(this.dataSourceFactory).setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
            for (int i = 0; i < subtitles.size(); ++i) {
                mediaSources[i + 1] = singleSampleSourceFactory.createMediaSource((MediaItem.Subtitle)subtitles.get(i), -9223372036854775807L);
            }
            mediaSource = new MergingMediaSource(mediaSources);
        }
        return this.maybeWrapWithAdsMediaSource(mediaItem, DefaultMediaSourceFactory.maybeClipMediaSource(mediaItem, mediaSource));
    }

    private static MediaSource maybeClipMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        if (mediaItem.clippingProperties.startPositionMs == 0L && mediaItem.clippingProperties.endPositionMs == Long.MIN_VALUE && !mediaItem.clippingProperties.relativeToDefaultPosition) {
            return mediaSource;
        }
        return new ClippingMediaSource(mediaSource, C.msToUs((long)mediaItem.clippingProperties.startPositionMs), C.msToUs((long)mediaItem.clippingProperties.endPositionMs), !mediaItem.clippingProperties.startsAtKeyFrame, mediaItem.clippingProperties.relativeToLiveWindow, mediaItem.clippingProperties.relativeToDefaultPosition);
    }

    private MediaSource maybeWrapWithAdsMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        MediaItem.AdsConfiguration adsConfiguration = mediaItem.playbackProperties.adsConfiguration;
        if (adsConfiguration == null) {
            return mediaSource;
        }
        AdsLoaderProvider adsLoaderProvider = this.adsLoaderProvider;
        AdViewProvider adViewProvider = this.adViewProvider;
        if (adsLoaderProvider == null || adViewProvider == null) {
            Log.w((String)TAG, (String)"Playing media without ads. Configure ad support by calling setAdsLoaderProvider and setAdViewProvider.");
            return mediaSource;
        }
        AdsLoader adsLoader = adsLoaderProvider.getAdsLoader(adsConfiguration);
        if (adsLoader == null) {
            Log.w((String)TAG, (String)"Playing media without ads, as no AdsLoader was provided.");
            return mediaSource;
        }
        return new AdsMediaSource(mediaSource, new DataSpec(adsConfiguration.adTagUri), adsConfiguration.adsId != null ? adsConfiguration.adsId : Pair.create((Object)mediaItem.mediaId, (Object)adsConfiguration.adTagUri), this, adsLoader, adViewProvider);
    }

    private static SparseArray<MediaSourceFactory> loadDelegates(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
        Class<MediaSourceFactory> factoryClazz2;
        SparseArray factories = new SparseArray();
        try {
            factoryClazz2 = Class.forName("com.google.android.exoplayer2.source.dash.DashMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(0, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception factoryClazz2) {
            // empty catch block
        }
        try {
            factoryClazz2 = Class.forName("com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(1, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception factoryClazz3) {
            // empty catch block
        }
        try {
            factoryClazz2 = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(2, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception factoryClazz4) {
            // empty catch block
        }
        try {
            factoryClazz2 = Class.forName("com.google.android.exoplayer2.source.rtsp.RtspMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(3, (Object)factoryClazz2.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        factories.put(4, (Object)new ProgressiveMediaSource.Factory(dataSourceFactory, extractorsFactory));
        return factories;
    }

    public static interface AdsLoaderProvider {
        @Nullable
        public AdsLoader getAdsLoader(MediaItem.AdsConfiguration var1);
    }
}

