/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManagerProvider;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.BundledExtractorsAdapter;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ProgressiveMediaExtractor;
import com.google.android.exoplayer2.source.ProgressiveMediaPeriod;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;

public final class ProgressiveMediaSource
extends BaseMediaSource
implements ProgressiveMediaPeriod.Listener {
    public static final int DEFAULT_LOADING_CHECK_INTERVAL_BYTES = 0x100000;
    private final MediaItem mediaItem;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final DataSource.Factory dataSourceFactory;
    private final ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy;
    private final int continueLoadingCheckIntervalBytes;
    private boolean timelineIsPlaceholder;
    private long timelineDurationUs;
    private boolean timelineIsSeekable;
    private boolean timelineIsLive;
    @Nullable
    private TransferListener transferListener;

    private ProgressiveMediaSource(MediaItem mediaItem, DataSource.Factory dataSourceFactory, ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy, int continueLoadingCheckIntervalBytes) {
        this.playbackProperties = (MediaItem.PlaybackProperties)Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        this.mediaItem = mediaItem;
        this.dataSourceFactory = dataSourceFactory;
        this.progressiveMediaExtractorFactory = progressiveMediaExtractorFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadableLoadErrorHandlingPolicy = loadableLoadErrorHandlingPolicy;
        this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        this.timelineIsPlaceholder = true;
        this.timelineDurationUs = -9223372036854775807L;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.transferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        this.notifySourceInfoRefreshed();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        DataSource dataSource = this.dataSourceFactory.createDataSource();
        if (this.transferListener != null) {
            dataSource.addTransferListener(this.transferListener);
        }
        return new ProgressiveMediaPeriod(this.playbackProperties.uri, dataSource, this.progressiveMediaExtractorFactory.createProgressiveMediaExtractor(), this.drmSessionManager, this.createDrmEventDispatcher(id), this.loadableLoadErrorHandlingPolicy, this.createEventDispatcher(id), this, allocator, this.playbackProperties.customCacheKey, this.continueLoadingCheckIntervalBytes);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((ProgressiveMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
        this.drmSessionManager.release();
    }

    @Override
    public void onSourceInfoRefreshed(long durationUs, boolean isSeekable, boolean isLive) {
        long l = durationUs = durationUs == -9223372036854775807L ? this.timelineDurationUs : durationUs;
        if (!this.timelineIsPlaceholder && this.timelineDurationUs == durationUs && this.timelineIsSeekable == isSeekable && this.timelineIsLive == isLive) {
            return;
        }
        this.timelineDurationUs = durationUs;
        this.timelineIsSeekable = isSeekable;
        this.timelineIsLive = isLive;
        this.timelineIsPlaceholder = false;
        this.notifySourceInfoRefreshed();
    }

    private void notifySourceInfoRefreshed() {
        Timeline timeline = new SinglePeriodTimeline(this.timelineDurationUs, this.timelineIsSeekable, false, this.timelineIsLive, (Object)null, this.mediaItem);
        if (this.timelineIsPlaceholder) {
            timeline = new ForwardingTimeline(this, timeline){

                @Override
                public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
                    super.getWindow(windowIndex, window, defaultPositionProjectionUs);
                    window.isPlaceholder = true;
                    return window;
                }

                @Override
                public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
                    super.getPeriod(periodIndex, period, setIds);
                    period.isPlaceholder = true;
                    return period;
                }
            };
        }
        this.refreshSourceInfo(timeline);
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final DataSource.Factory dataSourceFactory;
        private ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory;
        private boolean usingCustomDrmSessionManagerProvider;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private int continueLoadingCheckIntervalBytes;
        @Nullable
        private String customCacheKey;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Factory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
            this(dataSourceFactory, () -> new BundledExtractorsAdapter(extractorsFactory));
        }

        public Factory(DataSource.Factory dataSourceFactory, ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory) {
            this.dataSourceFactory = dataSourceFactory;
            this.progressiveMediaExtractorFactory = progressiveMediaExtractorFactory;
            this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.continueLoadingCheckIntervalBytes = 0x100000;
        }

        @Deprecated
        public Factory setExtractorsFactory(@Nullable ExtractorsFactory extractorsFactory) {
            this.progressiveMediaExtractorFactory = () -> new BundledExtractorsAdapter((ExtractorsFactory)(extractorsFactory != null ? extractorsFactory : new DefaultExtractorsFactory()));
            return this;
        }

        @Deprecated
        public Factory setCustomCacheKey(@Nullable String customCacheKey) {
            this.customCacheKey = customCacheKey;
            return this;
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        public Factory setContinueLoadingCheckIntervalBytes(int continueLoadingCheckIntervalBytes) {
            this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
            return this;
        }

        @Override
        public Factory setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
            if (drmSessionManagerProvider != null) {
                this.drmSessionManagerProvider = drmSessionManagerProvider;
                this.usingCustomDrmSessionManagerProvider = true;
            } else {
                this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
                this.usingCustomDrmSessionManagerProvider = false;
            }
            return this;
        }

        @Override
        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            if (drmSessionManager == null) {
                this.setDrmSessionManagerProvider(null);
            } else {
                this.setDrmSessionManagerProvider(unusedMediaItem -> drmSessionManager);
            }
            return this;
        }

        @Override
        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            }
            return this;
        }

        @Override
        public Factory setDrmUserAgent(@Nullable String userAgent) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmUserAgent(userAgent);
            }
            return this;
        }

        @Override
        @Deprecated
        public ProgressiveMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).build());
        }

        @Override
        public ProgressiveMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsCustomCacheKey;
            Assertions.checkNotNull((Object)mediaItem.playbackProperties);
            boolean needsTag = mediaItem.playbackProperties.tag == null && this.tag != null;
            boolean bl = needsCustomCacheKey = mediaItem.playbackProperties.customCacheKey == null && this.customCacheKey != null;
            if (needsTag && needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setCustomCacheKey(this.customCacheKey).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setCustomCacheKey(this.customCacheKey).build();
            }
            return new ProgressiveMediaSource(mediaItem, this.dataSourceFactory, this.progressiveMediaExtractorFactory, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.continueLoadingCheckIntervalBytes);
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{4};
        }
    }
}

