/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Looper;
import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.SampleDataQueue;
import com.google.android.exoplayer2.source.SpannedData;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class SampleQueue
implements TrackOutput {
    @VisibleForTesting
    static final int SAMPLE_CAPACITY_INCREMENT = 1000;
    private static final String TAG = "SampleQueue";
    private final SampleDataQueue sampleDataQueue;
    private final SampleExtrasHolder extrasHolder;
    private final SpannedData<SharedSampleMetadata> sharedSampleMetadata;
    @Nullable
    private final DrmSessionManager drmSessionManager;
    @Nullable
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    @Nullable
    private final Looper playbackLooper;
    @Nullable
    private UpstreamFormatChangedListener upstreamFormatChangeListener;
    @Nullable
    private Format downstreamFormat;
    @Nullable
    private DrmSession currentDrmSession;
    private int capacity;
    private int[] sourceIds;
    private long[] offsets;
    private int[] sizes;
    private int[] flags;
    private long[] timesUs;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NullableType TrackOutput.CryptoData[] cryptoDatas;
    private int length;
    private int absoluteFirstIndex;
    private int relativeFirstIndex;
    private int readPosition;
    private long startTimeUs;
    private long largestDiscardedTimestampUs;
    private long largestQueuedTimestampUs;
    private boolean isLastSampleQueued;
    private boolean upstreamKeyframeRequired;
    private boolean upstreamFormatRequired;
    private boolean upstreamFormatAdjustmentRequired;
    @Nullable
    private Format unadjustedUpstreamFormat;
    @Nullable
    private Format upstreamFormat;
    private int upstreamSourceId;
    private boolean upstreamAllSamplesAreSyncSamples;
    private boolean loggedUnexpectedNonSyncSample;
    private long sampleOffsetUs;
    private boolean pendingSplice;

    public static SampleQueue createWithoutDrm(Allocator allocator) {
        return new SampleQueue(allocator, null, null, null);
    }

    public static SampleQueue createWithDrm(Allocator allocator, Looper playbackLooper, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher) {
        return new SampleQueue(allocator, (Looper)Assertions.checkNotNull((Object)playbackLooper), (DrmSessionManager)Assertions.checkNotNull((Object)drmSessionManager), (DrmSessionEventListener.EventDispatcher)Assertions.checkNotNull((Object)drmEventDispatcher));
    }

    protected SampleQueue(Allocator allocator, @Nullable Looper playbackLooper, @Nullable DrmSessionManager drmSessionManager, @Nullable DrmSessionEventListener.EventDispatcher drmEventDispatcher) {
        this.playbackLooper = playbackLooper;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.sampleDataQueue = new SampleDataQueue(allocator);
        this.extrasHolder = new SampleExtrasHolder();
        this.capacity = 1000;
        this.sourceIds = new int[this.capacity];
        this.offsets = new long[this.capacity];
        this.timesUs = new long[this.capacity];
        this.flags = new int[this.capacity];
        this.sizes = new int[this.capacity];
        this.cryptoDatas = new TrackOutput.CryptoData[this.capacity];
        this.sharedSampleMetadata = new SpannedData(metadata -> metadata.drmSessionReference.release());
        this.startTimeUs = Long.MIN_VALUE;
        this.largestDiscardedTimestampUs = Long.MIN_VALUE;
        this.largestQueuedTimestampUs = Long.MIN_VALUE;
        this.upstreamFormatRequired = true;
        this.upstreamKeyframeRequired = true;
    }

    @CallSuper
    public void release() {
        this.reset(true);
        this.releaseDrmSessionReferences();
    }

    public final void reset() {
        this.reset(false);
    }

    @CallSuper
    public void reset(boolean resetUpstreamFormat) {
        this.sampleDataQueue.reset();
        this.length = 0;
        this.absoluteFirstIndex = 0;
        this.relativeFirstIndex = 0;
        this.readPosition = 0;
        this.upstreamKeyframeRequired = true;
        this.startTimeUs = Long.MIN_VALUE;
        this.largestDiscardedTimestampUs = Long.MIN_VALUE;
        this.largestQueuedTimestampUs = Long.MIN_VALUE;
        this.isLastSampleQueued = false;
        this.sharedSampleMetadata.clear();
        if (resetUpstreamFormat) {
            this.unadjustedUpstreamFormat = null;
            this.upstreamFormat = null;
            this.upstreamFormatRequired = true;
        }
    }

    public final void setStartTimeUs(long startTimeUs) {
        this.startTimeUs = startTimeUs;
    }

    public final void sourceId(int sourceId) {
        this.upstreamSourceId = sourceId;
    }

    public final void splice() {
        this.pendingSplice = true;
    }

    public final int getWriteIndex() {
        return this.absoluteFirstIndex + this.length;
    }

    public final void discardUpstreamSamples(int discardFromIndex) {
        this.sampleDataQueue.discardUpstreamSampleBytes(this.discardUpstreamSampleMetadata(discardFromIndex));
    }

    public final void discardUpstreamFrom(long timeUs) {
        if (this.length == 0) {
            return;
        }
        Assertions.checkArgument((timeUs > this.getLargestReadTimestampUs() ? 1 : 0) != 0);
        int retainCount = this.countUnreadSamplesBefore(timeUs);
        this.discardUpstreamSamples(this.absoluteFirstIndex + retainCount);
    }

    @CallSuper
    public void preRelease() {
        this.discardToEnd();
        this.releaseDrmSessionReferences();
    }

    @CallSuper
    public void maybeThrowError() throws IOException {
        if (this.currentDrmSession != null && this.currentDrmSession.getState() == 1) {
            throw (DrmSession.DrmSessionException)Assertions.checkNotNull((Object)this.currentDrmSession.getError());
        }
    }

    public final int getFirstIndex() {
        return this.absoluteFirstIndex;
    }

    public final int getReadIndex() {
        return this.absoluteFirstIndex + this.readPosition;
    }

    public final synchronized int peekSourceId() {
        int relativeReadIndex = this.getRelativeIndex(this.readPosition);
        return this.hasNextSample() ? this.sourceIds[relativeReadIndex] : this.upstreamSourceId;
    }

    @Nullable
    public final synchronized Format getUpstreamFormat() {
        return this.upstreamFormatRequired ? null : this.upstreamFormat;
    }

    public final synchronized long getLargestQueuedTimestampUs() {
        return this.largestQueuedTimestampUs;
    }

    public final synchronized long getLargestReadTimestampUs() {
        return Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(this.readPosition));
    }

    public final synchronized boolean isLastSampleQueued() {
        return this.isLastSampleQueued;
    }

    public final synchronized long getFirstTimestampUs() {
        return this.length == 0 ? Long.MIN_VALUE : this.timesUs[this.relativeFirstIndex];
    }

    @CallSuper
    public synchronized boolean isReady(boolean loadingFinished) {
        if (!this.hasNextSample()) {
            return loadingFinished || this.isLastSampleQueued || this.upstreamFormat != null && this.upstreamFormat != this.downstreamFormat;
        }
        if (this.sharedSampleMetadata.get((int)this.getReadIndex()).format != this.downstreamFormat) {
            return true;
        }
        return this.mayReadSample(this.getRelativeIndex(this.readPosition));
    }

    @CallSuper
    public int read(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags, boolean loadingFinished) {
        int result = this.peekSampleMetadata(formatHolder, buffer, (readFlags & 2) != 0, loadingFinished, this.extrasHolder);
        if (result == -4 && !buffer.isEndOfStream()) {
            boolean peek;
            boolean bl = peek = (readFlags & 1) != 0;
            if ((readFlags & 4) == 0) {
                if (peek) {
                    this.sampleDataQueue.peekToBuffer(buffer, this.extrasHolder);
                } else {
                    this.sampleDataQueue.readToBuffer(buffer, this.extrasHolder);
                }
            }
            if (!peek) {
                ++this.readPosition;
            }
        }
        return result;
    }

    public final synchronized boolean seekTo(int sampleIndex) {
        this.rewind();
        if (sampleIndex < this.absoluteFirstIndex || sampleIndex > this.absoluteFirstIndex + this.length) {
            return false;
        }
        this.startTimeUs = Long.MIN_VALUE;
        this.readPosition = sampleIndex - this.absoluteFirstIndex;
        return true;
    }

    public final synchronized boolean seekTo(long timeUs, boolean allowTimeBeyondBuffer) {
        this.rewind();
        int relativeReadIndex = this.getRelativeIndex(this.readPosition);
        if (!this.hasNextSample() || timeUs < this.timesUs[relativeReadIndex] || timeUs > this.largestQueuedTimestampUs && !allowTimeBeyondBuffer) {
            return false;
        }
        int offset = this.findSampleBefore(relativeReadIndex, this.length - this.readPosition, timeUs, true);
        if (offset == -1) {
            return false;
        }
        this.startTimeUs = timeUs;
        this.readPosition += offset;
        return true;
    }

    public final synchronized int getSkipCount(long timeUs, boolean allowEndOfQueue) {
        int relativeReadIndex = this.getRelativeIndex(this.readPosition);
        if (!this.hasNextSample() || timeUs < this.timesUs[relativeReadIndex]) {
            return 0;
        }
        if (timeUs > this.largestQueuedTimestampUs && allowEndOfQueue) {
            return this.length - this.readPosition;
        }
        int offset = this.findSampleBefore(relativeReadIndex, this.length - this.readPosition, timeUs, true);
        if (offset == -1) {
            return 0;
        }
        return offset;
    }

    public final synchronized void skip(int count) {
        Assertions.checkArgument((count >= 0 && this.readPosition + count <= this.length ? 1 : 0) != 0);
        this.readPosition += count;
    }

    public final void discardTo(long timeUs, boolean toKeyframe, boolean stopAtReadPosition) {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataTo(timeUs, toKeyframe, stopAtReadPosition));
    }

    public final void discardToRead() {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataToRead());
    }

    public final void discardToEnd() {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataToEnd());
    }

    public final void setSampleOffsetUs(long sampleOffsetUs) {
        if (this.sampleOffsetUs != sampleOffsetUs) {
            this.sampleOffsetUs = sampleOffsetUs;
            this.invalidateUpstreamFormatAdjustment();
        }
    }

    public final void setUpstreamFormatChangeListener(@Nullable UpstreamFormatChangedListener listener) {
        this.upstreamFormatChangeListener = listener;
    }

    public final void format(Format unadjustedUpstreamFormat) {
        Format adjustedUpstreamFormat = this.getAdjustedUpstreamFormat(unadjustedUpstreamFormat);
        this.upstreamFormatAdjustmentRequired = false;
        this.unadjustedUpstreamFormat = unadjustedUpstreamFormat;
        boolean upstreamFormatChanged = this.setUpstreamFormat(adjustedUpstreamFormat);
        if (this.upstreamFormatChangeListener != null && upstreamFormatChanged) {
            this.upstreamFormatChangeListener.onUpstreamFormatChanged(adjustedUpstreamFormat);
        }
    }

    public final int sampleData(DataReader input, int length, boolean allowEndOfInput, int sampleDataPart) throws IOException {
        return this.sampleDataQueue.sampleData(input, length, allowEndOfInput);
    }

    public final void sampleData(ParsableByteArray buffer, int length, int sampleDataPart) {
        this.sampleDataQueue.sampleData(buffer, length);
    }

    public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
        boolean isKeyframe;
        if (this.upstreamFormatAdjustmentRequired) {
            this.format((Format)Assertions.checkStateNotNull((Object)this.unadjustedUpstreamFormat));
        }
        boolean bl = isKeyframe = (flags & 1) != 0;
        if (this.upstreamKeyframeRequired) {
            if (!isKeyframe) {
                return;
            }
            this.upstreamKeyframeRequired = false;
        }
        timeUs += this.sampleOffsetUs;
        if (this.upstreamAllSamplesAreSyncSamples) {
            if (timeUs < this.startTimeUs) {
                return;
            }
            if ((flags & 1) == 0) {
                if (!this.loggedUnexpectedNonSyncSample) {
                    String string = String.valueOf(this.upstreamFormat);
                    Log.w((String)TAG, (String)new StringBuilder(50 + String.valueOf(string).length()).append("Overriding unexpected non-sync sample for format: ").append(string).toString());
                    this.loggedUnexpectedNonSyncSample = true;
                }
                flags |= 1;
            }
        }
        if (this.pendingSplice) {
            if (!isKeyframe || !this.attemptSplice(timeUs)) {
                return;
            }
            this.pendingSplice = false;
        }
        long absoluteOffset = this.sampleDataQueue.getTotalBytesWritten() - (long)size - (long)offset;
        this.commitSample(timeUs, flags, absoluteOffset, size, cryptoData);
    }

    protected final void invalidateUpstreamFormatAdjustment() {
        this.upstreamFormatAdjustmentRequired = true;
    }

    @CallSuper
    protected Format getAdjustedUpstreamFormat(Format format) {
        if (this.sampleOffsetUs != 0L && format.subsampleOffsetUs != Long.MAX_VALUE) {
            format = format.buildUpon().setSubsampleOffsetUs(format.subsampleOffsetUs + this.sampleOffsetUs).build();
        }
        return format;
    }

    private synchronized void rewind() {
        this.readPosition = 0;
        this.sampleDataQueue.rewind();
    }

    private synchronized int peekSampleMetadata(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired, boolean loadingFinished, SampleExtrasHolder extrasHolder) {
        buffer.waitingForKeys = false;
        if (!this.hasNextSample()) {
            if (loadingFinished || this.isLastSampleQueued) {
                buffer.setFlags(4);
                return -4;
            }
            if (this.upstreamFormat != null && (formatRequired || this.upstreamFormat != this.downstreamFormat)) {
                this.onFormatResult((Format)Assertions.checkNotNull((Object)this.upstreamFormat), formatHolder);
                return -5;
            }
            return -3;
        }
        Format format = this.sharedSampleMetadata.get((int)this.getReadIndex()).format;
        if (formatRequired || format != this.downstreamFormat) {
            this.onFormatResult(format, formatHolder);
            return -5;
        }
        int relativeReadIndex = this.getRelativeIndex(this.readPosition);
        if (!this.mayReadSample(relativeReadIndex)) {
            buffer.waitingForKeys = true;
            return -3;
        }
        buffer.setFlags(this.flags[relativeReadIndex]);
        buffer.timeUs = this.timesUs[relativeReadIndex];
        if (buffer.timeUs < this.startTimeUs) {
            buffer.addFlag(Integer.MIN_VALUE);
        }
        extrasHolder.size = this.sizes[relativeReadIndex];
        extrasHolder.offset = this.offsets[relativeReadIndex];
        extrasHolder.cryptoData = this.cryptoDatas[relativeReadIndex];
        return -4;
    }

    private synchronized boolean setUpstreamFormat(Format format) {
        this.upstreamFormatRequired = false;
        if (Util.areEqual((Object)format, (Object)this.upstreamFormat)) {
            return false;
        }
        this.upstreamFormat = !this.sharedSampleMetadata.isEmpty() && this.sharedSampleMetadata.getEndValue().format.equals((Object)format) ? this.sharedSampleMetadata.getEndValue().format : format;
        this.upstreamAllSamplesAreSyncSamples = MimeTypes.allSamplesAreSyncSamples((String)this.upstreamFormat.sampleMimeType, (String)this.upstreamFormat.codecs);
        this.loggedUnexpectedNonSyncSample = false;
        return true;
    }

    private synchronized long discardSampleMetadataTo(long timeUs, boolean toKeyframe, boolean stopAtReadPosition) {
        if (this.length == 0 || timeUs < this.timesUs[this.relativeFirstIndex]) {
            return -1L;
        }
        int searchLength = stopAtReadPosition && this.readPosition != this.length ? this.readPosition + 1 : this.length;
        int discardCount = this.findSampleBefore(this.relativeFirstIndex, searchLength, timeUs, toKeyframe);
        if (discardCount == -1) {
            return -1L;
        }
        return this.discardSamples(discardCount);
    }

    public synchronized long discardSampleMetadataToRead() {
        if (this.readPosition == 0) {
            return -1L;
        }
        return this.discardSamples(this.readPosition);
    }

    private synchronized long discardSampleMetadataToEnd() {
        if (this.length == 0) {
            return -1L;
        }
        return this.discardSamples(this.length);
    }

    private void releaseDrmSessionReferences() {
        if (this.currentDrmSession != null) {
            this.currentDrmSession.release(this.drmEventDispatcher);
            this.currentDrmSession = null;
            this.downstreamFormat = null;
        }
    }

    private synchronized void commitSample(long timeUs, int sampleFlags, long offset, int size, @Nullable TrackOutput.CryptoData cryptoData) {
        if (this.length > 0) {
            int previousSampleRelativeIndex = this.getRelativeIndex(this.length - 1);
            Assertions.checkArgument((this.offsets[previousSampleRelativeIndex] + (long)this.sizes[previousSampleRelativeIndex] <= offset ? 1 : 0) != 0);
        }
        this.isLastSampleQueued = (sampleFlags & 0x20000000) != 0;
        this.largestQueuedTimestampUs = Math.max(this.largestQueuedTimestampUs, timeUs);
        int relativeEndIndex = this.getRelativeIndex(this.length);
        this.timesUs[relativeEndIndex] = timeUs;
        this.offsets[relativeEndIndex] = offset;
        this.sizes[relativeEndIndex] = size;
        this.flags[relativeEndIndex] = sampleFlags;
        this.cryptoDatas[relativeEndIndex] = cryptoData;
        this.sourceIds[relativeEndIndex] = this.upstreamSourceId;
        if (this.sharedSampleMetadata.isEmpty() || !this.sharedSampleMetadata.getEndValue().format.equals((Object)this.upstreamFormat)) {
            DrmSessionManager.DrmSessionReference drmSessionReference = this.drmSessionManager != null ? this.drmSessionManager.preacquireSession((Looper)Assertions.checkNotNull((Object)this.playbackLooper), this.drmEventDispatcher, this.upstreamFormat) : DrmSessionManager.DrmSessionReference.EMPTY;
            this.sharedSampleMetadata.appendSpan(this.getWriteIndex(), new SharedSampleMetadata((Format)Assertions.checkNotNull((Object)this.upstreamFormat), drmSessionReference));
        }
        ++this.length;
        if (this.length == this.capacity) {
            int newCapacity = this.capacity + 1000;
            int[] newSourceIds = new int[newCapacity];
            long[] newOffsets = new long[newCapacity];
            long[] newTimesUs = new long[newCapacity];
            int[] newFlags = new int[newCapacity];
            int[] newSizes = new int[newCapacity];
            TrackOutput.CryptoData[] newCryptoDatas = new TrackOutput.CryptoData[newCapacity];
            int beforeWrap = this.capacity - this.relativeFirstIndex;
            System.arraycopy(this.offsets, this.relativeFirstIndex, newOffsets, 0, beforeWrap);
            System.arraycopy(this.timesUs, this.relativeFirstIndex, newTimesUs, 0, beforeWrap);
            System.arraycopy(this.flags, this.relativeFirstIndex, newFlags, 0, beforeWrap);
            System.arraycopy(this.sizes, this.relativeFirstIndex, newSizes, 0, beforeWrap);
            System.arraycopy(this.cryptoDatas, this.relativeFirstIndex, newCryptoDatas, 0, beforeWrap);
            System.arraycopy(this.sourceIds, this.relativeFirstIndex, newSourceIds, 0, beforeWrap);
            int afterWrap = this.relativeFirstIndex;
            System.arraycopy(this.offsets, 0, newOffsets, beforeWrap, afterWrap);
            System.arraycopy(this.timesUs, 0, newTimesUs, beforeWrap, afterWrap);
            System.arraycopy(this.flags, 0, newFlags, beforeWrap, afterWrap);
            System.arraycopy(this.sizes, 0, newSizes, beforeWrap, afterWrap);
            System.arraycopy(this.cryptoDatas, 0, newCryptoDatas, beforeWrap, afterWrap);
            System.arraycopy(this.sourceIds, 0, newSourceIds, beforeWrap, afterWrap);
            this.offsets = newOffsets;
            this.timesUs = newTimesUs;
            this.flags = newFlags;
            this.sizes = newSizes;
            this.cryptoDatas = newCryptoDatas;
            this.sourceIds = newSourceIds;
            this.relativeFirstIndex = 0;
            this.capacity = newCapacity;
        }
    }

    private synchronized boolean attemptSplice(long timeUs) {
        if (this.length == 0) {
            return timeUs > this.largestDiscardedTimestampUs;
        }
        if (this.getLargestReadTimestampUs() >= timeUs) {
            return false;
        }
        int retainCount = this.countUnreadSamplesBefore(timeUs);
        this.discardUpstreamSampleMetadata(this.absoluteFirstIndex + retainCount);
        return true;
    }

    private long discardUpstreamSampleMetadata(int discardFromIndex) {
        int discardCount = this.getWriteIndex() - discardFromIndex;
        Assertions.checkArgument((0 <= discardCount && discardCount <= this.length - this.readPosition ? 1 : 0) != 0);
        this.length -= discardCount;
        this.largestQueuedTimestampUs = Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(this.length));
        this.isLastSampleQueued = discardCount == 0 && this.isLastSampleQueued;
        this.sharedSampleMetadata.discardFrom(discardFromIndex);
        if (this.length != 0) {
            int relativeLastWriteIndex = this.getRelativeIndex(this.length - 1);
            return this.offsets[relativeLastWriteIndex] + (long)this.sizes[relativeLastWriteIndex];
        }
        return 0L;
    }

    private boolean hasNextSample() {
        return this.readPosition != this.length;
    }

    private void onFormatResult(Format newFormat, FormatHolder outputFormatHolder) {
        boolean isFirstFormat = this.downstreamFormat == null;
        DrmInitData oldDrmInitData = isFirstFormat ? null : this.downstreamFormat.drmInitData;
        this.downstreamFormat = newFormat;
        DrmInitData newDrmInitData = newFormat.drmInitData;
        outputFormatHolder.format = this.drmSessionManager != null ? newFormat.copyWithExoMediaCryptoType(this.drmSessionManager.getExoMediaCryptoType(newFormat)) : newFormat;
        outputFormatHolder.drmSession = this.currentDrmSession;
        if (this.drmSessionManager == null) {
            return;
        }
        if (!isFirstFormat && Util.areEqual((Object)oldDrmInitData, (Object)newDrmInitData)) {
            return;
        }
        DrmSession previousSession = this.currentDrmSession;
        outputFormatHolder.drmSession = this.currentDrmSession = this.drmSessionManager.acquireSession((Looper)Assertions.checkNotNull((Object)this.playbackLooper), this.drmEventDispatcher, newFormat);
        if (previousSession != null) {
            previousSession.release(this.drmEventDispatcher);
        }
    }

    private boolean mayReadSample(int relativeReadIndex) {
        return this.currentDrmSession == null || this.currentDrmSession.getState() == 4 || (this.flags[relativeReadIndex] & 0x40000000) == 0 && this.currentDrmSession.playClearSamplesWithoutKeys();
    }

    private int findSampleBefore(int relativeStartIndex, int length, long timeUs, boolean keyframe) {
        int sampleCountToTarget = -1;
        int searchIndex = relativeStartIndex;
        for (int i = 0; i < length && this.timesUs[searchIndex] <= timeUs; ++i) {
            if (!keyframe || (this.flags[searchIndex] & 1) != 0) {
                sampleCountToTarget = i;
                if (this.timesUs[searchIndex] == timeUs) break;
            }
            if (++searchIndex != this.capacity) continue;
            searchIndex = 0;
        }
        return sampleCountToTarget;
    }

    private int countUnreadSamplesBefore(long timeUs) {
        int count;
        int relativeSampleIndex = this.getRelativeIndex(this.length - 1);
        for (count = this.length; count > this.readPosition && this.timesUs[relativeSampleIndex] >= timeUs; --count) {
            if (--relativeSampleIndex != -1) continue;
            relativeSampleIndex = this.capacity - 1;
        }
        return count;
    }

    @GuardedBy(value="this")
    private long discardSamples(int discardCount) {
        this.largestDiscardedTimestampUs = Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(discardCount));
        this.length -= discardCount;
        this.absoluteFirstIndex += discardCount;
        this.relativeFirstIndex += discardCount;
        if (this.relativeFirstIndex >= this.capacity) {
            this.relativeFirstIndex -= this.capacity;
        }
        this.readPosition -= discardCount;
        if (this.readPosition < 0) {
            this.readPosition = 0;
        }
        this.sharedSampleMetadata.discardTo(this.absoluteFirstIndex);
        if (this.length == 0) {
            int relativeLastDiscardIndex = (this.relativeFirstIndex == 0 ? this.capacity : this.relativeFirstIndex) - 1;
            return this.offsets[relativeLastDiscardIndex] + (long)this.sizes[relativeLastDiscardIndex];
        }
        return this.offsets[this.relativeFirstIndex];
    }

    private long getLargestTimestamp(int length) {
        if (length == 0) {
            return Long.MIN_VALUE;
        }
        long largestTimestampUs = Long.MIN_VALUE;
        int relativeSampleIndex = this.getRelativeIndex(length - 1);
        for (int i = 0; i < length; ++i) {
            largestTimestampUs = Math.max(largestTimestampUs, this.timesUs[relativeSampleIndex]);
            if ((this.flags[relativeSampleIndex] & 1) != 0) break;
            if (--relativeSampleIndex != -1) continue;
            relativeSampleIndex = this.capacity - 1;
        }
        return largestTimestampUs;
    }

    private int getRelativeIndex(int offset) {
        int relativeIndex = this.relativeFirstIndex + offset;
        return relativeIndex < this.capacity ? relativeIndex : relativeIndex - this.capacity;
    }

    private static final class SharedSampleMetadata {
        public final Format format;
        public final DrmSessionManager.DrmSessionReference drmSessionReference;

        private SharedSampleMetadata(Format format, DrmSessionManager.DrmSessionReference drmSessionReference) {
            this.format = format;
            this.drmSessionReference = drmSessionReference;
        }
    }

    static final class SampleExtrasHolder {
        public int size;
        public long offset;
        @Nullable
        public TrackOutput.CryptoData cryptoData;

        SampleExtrasHolder() {
        }
    }

    public static interface UpstreamFormatChangedListener {
        public void onUpstreamFormatChanged(Format var1);
    }
}

