/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleDecoderFactory;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import java.util.List;

public final class TextRenderer
extends BaseRenderer
implements Handler.Callback {
    private static final String TAG = "TextRenderer";
    private static final int REPLACEMENT_STATE_NONE = 0;
    private static final int REPLACEMENT_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int REPLACEMENT_STATE_WAIT_END_OF_STREAM = 2;
    private static final int MSG_UPDATE_OUTPUT = 0;
    @Nullable
    private final Handler outputHandler;
    private final TextOutput output;
    private final SubtitleDecoderFactory decoderFactory;
    private final FormatHolder formatHolder;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeyFrame;
    private int decoderReplacementState;
    @Nullable
    private Format streamFormat;
    @Nullable
    private SubtitleDecoder decoder;
    @Nullable
    private SubtitleInputBuffer nextInputBuffer;
    @Nullable
    private SubtitleOutputBuffer subtitle;
    @Nullable
    private SubtitleOutputBuffer nextSubtitle;
    private int nextSubtitleEventIndex;
    private long finalStreamEndPositionUs;

    public TextRenderer(TextOutput output, @Nullable Looper outputLooper) {
        this(output, outputLooper, SubtitleDecoderFactory.DEFAULT);
    }

    public TextRenderer(TextOutput output, @Nullable Looper outputLooper, SubtitleDecoderFactory decoderFactory) {
        super(3);
        this.output = (TextOutput)Assertions.checkNotNull((Object)output);
        this.outputHandler = outputLooper == null ? null : Util.createHandler((Looper)outputLooper, (Handler.Callback)this);
        this.decoderFactory = decoderFactory;
        this.formatHolder = new FormatHolder();
        this.finalStreamEndPositionUs = -9223372036854775807L;
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        if (this.decoderFactory.supportsFormat(format)) {
            return RendererCapabilities.create(format.exoMediaCryptoType == null ? 4 : 2);
        }
        if (MimeTypes.isText((String)format.sampleMimeType)) {
            return RendererCapabilities.create(1);
        }
        return RendererCapabilities.create(0);
    }

    public void setFinalStreamEndPositionUs(long streamEndPositionUs) {
        Assertions.checkState((boolean)this.isCurrentStreamFinal());
        this.finalStreamEndPositionUs = streamEndPositionUs;
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.streamFormat = formats[0];
        if (this.decoder != null) {
            this.decoderReplacementState = 1;
        } else {
            this.initDecoder();
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.clearOutput();
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.finalStreamEndPositionUs = -9223372036854775807L;
        if (this.decoderReplacementState != 0) {
            this.replaceDecoder();
        } else {
            this.releaseBuffers();
            ((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).flush();
        }
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) {
        if (this.isCurrentStreamFinal() && this.finalStreamEndPositionUs != -9223372036854775807L && positionUs >= this.finalStreamEndPositionUs) {
            this.releaseBuffers();
            this.outputStreamEnded = true;
        }
        if (this.outputStreamEnded) {
            return;
        }
        if (this.nextSubtitle == null) {
            ((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).setPositionUs(positionUs);
            try {
                this.nextSubtitle = (SubtitleOutputBuffer)((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).dequeueOutputBuffer();
            }
            catch (SubtitleDecoderException e) {
                this.handleDecoderError(e);
                return;
            }
        }
        if (this.getState() != 2) {
            return;
        }
        boolean textRendererNeedsUpdate = false;
        if (this.subtitle != null) {
            long subtitleNextEventTimeUs = this.getNextEventTime();
            while (subtitleNextEventTimeUs <= positionUs) {
                ++this.nextSubtitleEventIndex;
                subtitleNextEventTimeUs = this.getNextEventTime();
                textRendererNeedsUpdate = true;
            }
        }
        if (this.nextSubtitle != null) {
            SubtitleOutputBuffer nextSubtitle = this.nextSubtitle;
            if (nextSubtitle.isEndOfStream()) {
                if (!textRendererNeedsUpdate && this.getNextEventTime() == Long.MAX_VALUE) {
                    if (this.decoderReplacementState == 2) {
                        this.replaceDecoder();
                    } else {
                        this.releaseBuffers();
                        this.outputStreamEnded = true;
                    }
                }
            } else if (nextSubtitle.timeUs <= positionUs) {
                if (this.subtitle != null) {
                    this.subtitle.release();
                }
                this.nextSubtitleEventIndex = nextSubtitle.getNextEventTimeIndex(positionUs);
                this.subtitle = nextSubtitle;
                this.nextSubtitle = null;
                textRendererNeedsUpdate = true;
            }
        }
        if (textRendererNeedsUpdate) {
            Assertions.checkNotNull((Object)this.subtitle);
            this.updateOutput(this.subtitle.getCues(positionUs));
        }
        if (this.decoderReplacementState == 2) {
            return;
        }
        try {
            while (!this.inputStreamEnded) {
                SubtitleInputBuffer nextInputBuffer = this.nextInputBuffer;
                if (nextInputBuffer == null) {
                    nextInputBuffer = (SubtitleInputBuffer)((Object)((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).dequeueInputBuffer());
                    if (nextInputBuffer == null) {
                        return;
                    }
                    this.nextInputBuffer = nextInputBuffer;
                }
                if (this.decoderReplacementState == 1) {
                    nextInputBuffer.setFlags(4);
                    ((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).queueInputBuffer(nextInputBuffer);
                    this.nextInputBuffer = null;
                    this.decoderReplacementState = 2;
                    return;
                }
                int result = this.readSource(this.formatHolder, nextInputBuffer, 0);
                if (result == -4) {
                    if (nextInputBuffer.isEndOfStream()) {
                        this.inputStreamEnded = true;
                        this.waitingForKeyFrame = false;
                    } else {
                        Format format = this.formatHolder.format;
                        if (format == null) {
                            return;
                        }
                        nextInputBuffer.subsampleOffsetUs = format.subsampleOffsetUs;
                        nextInputBuffer.flip();
                        this.waitingForKeyFrame &= !nextInputBuffer.isKeyFrame();
                    }
                    if (this.waitingForKeyFrame) continue;
                    ((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).queueInputBuffer(nextInputBuffer);
                    this.nextInputBuffer = null;
                    continue;
                }
                if (result != -3) continue;
                return;
            }
        }
        catch (SubtitleDecoderException e) {
            this.handleDecoderError(e);
        }
    }

    @Override
    protected void onDisabled() {
        this.streamFormat = null;
        this.finalStreamEndPositionUs = -9223372036854775807L;
        this.clearOutput();
        this.releaseDecoder();
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void releaseBuffers() {
        this.nextInputBuffer = null;
        this.nextSubtitleEventIndex = -1;
        if (this.subtitle != null) {
            this.subtitle.release();
            this.subtitle = null;
        }
        if (this.nextSubtitle != null) {
            this.nextSubtitle.release();
            this.nextSubtitle = null;
        }
    }

    private void releaseDecoder() {
        this.releaseBuffers();
        ((SubtitleDecoder)Assertions.checkNotNull((Object)this.decoder)).release();
        this.decoder = null;
        this.decoderReplacementState = 0;
    }

    private void initDecoder() {
        this.waitingForKeyFrame = true;
        this.decoder = this.decoderFactory.createDecoder((Format)Assertions.checkNotNull((Object)this.streamFormat));
    }

    private void replaceDecoder() {
        this.releaseDecoder();
        this.initDecoder();
    }

    private long getNextEventTime() {
        if (this.nextSubtitleEventIndex == -1) {
            return Long.MAX_VALUE;
        }
        Assertions.checkNotNull((Object)this.subtitle);
        return this.nextSubtitleEventIndex >= this.subtitle.getEventTimeCount() ? Long.MAX_VALUE : this.subtitle.getEventTime(this.nextSubtitleEventIndex);
    }

    private void updateOutput(List<Cue> cues) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, cues).sendToTarget();
        } else {
            this.invokeUpdateOutputInternal(cues);
        }
    }

    private void clearOutput() {
        this.updateOutput(Collections.emptyList());
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeUpdateOutputInternal((List)msg.obj);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void invokeUpdateOutputInternal(List<Cue> cues) {
        this.output.onCues(cues);
    }

    private void handleDecoderError(SubtitleDecoderException e) {
        String string = String.valueOf(this.streamFormat);
        Log.e((String)TAG, (String)new StringBuilder(39 + String.valueOf(string).length()).append("Subtitle decoding failed. streamFormat=").append(string).toString(), (Throwable)e);
        this.clearOutput();
        this.replaceDecoder();
    }
}

