/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ssa;

import android.graphics.Color;
import android.graphics.PointF;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.primitives.Ints;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SsaStyle {
    private static final String TAG = "SsaStyle";
    public static final int SSA_ALIGNMENT_UNKNOWN = -1;
    public static final int SSA_ALIGNMENT_BOTTOM_LEFT = 1;
    public static final int SSA_ALIGNMENT_BOTTOM_CENTER = 2;
    public static final int SSA_ALIGNMENT_BOTTOM_RIGHT = 3;
    public static final int SSA_ALIGNMENT_MIDDLE_LEFT = 4;
    public static final int SSA_ALIGNMENT_MIDDLE_CENTER = 5;
    public static final int SSA_ALIGNMENT_MIDDLE_RIGHT = 6;
    public static final int SSA_ALIGNMENT_TOP_LEFT = 7;
    public static final int SSA_ALIGNMENT_TOP_CENTER = 8;
    public static final int SSA_ALIGNMENT_TOP_RIGHT = 9;
    public final String name;
    public final int alignment;
    @Nullable
    @ColorInt
    public final Integer primaryColor;
    public final float fontSize;
    public final boolean bold;
    public final boolean italic;
    public final boolean underline;
    public final boolean strikeout;

    private SsaStyle(String name, int alignment, @Nullable @ColorInt Integer primaryColor, float fontSize, boolean bold, boolean italic, boolean underline, boolean strikeout) {
        this.name = name;
        this.alignment = alignment;
        this.primaryColor = primaryColor;
        this.fontSize = fontSize;
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikeout = strikeout;
    }

    @Nullable
    public static SsaStyle fromStyleLine(String styleLine, Format format) {
        Assertions.checkArgument((boolean)styleLine.startsWith("Style:"));
        String[] styleValues = TextUtils.split((String)styleLine.substring("Style:".length()), (String)",");
        if (styleValues.length != format.length) {
            Log.w((String)TAG, (String)Util.formatInvariant((String)"Skipping malformed 'Style:' line (expected %s values, found %s): '%s'", (Object[])new Object[]{format.length, styleValues.length, styleLine}));
            return null;
        }
        try {
            return new SsaStyle(styleValues[format.nameIndex].trim(), format.alignmentIndex != -1 ? SsaStyle.parseAlignment(styleValues[format.alignmentIndex].trim()) : -1, format.primaryColorIndex != -1 ? SsaStyle.parseColor(styleValues[format.primaryColorIndex].trim()) : null, format.fontSizeIndex != -1 ? SsaStyle.parseFontSize(styleValues[format.fontSizeIndex].trim()) : -3.4028235E38f, format.boldIndex != -1 ? SsaStyle.parseBooleanValue(styleValues[format.boldIndex].trim()) : false, format.italicIndex != -1 ? SsaStyle.parseBooleanValue(styleValues[format.italicIndex].trim()) : false, format.underlineIndex != -1 ? SsaStyle.parseBooleanValue(styleValues[format.underlineIndex].trim()) : false, format.strikeoutIndex != -1 ? SsaStyle.parseBooleanValue(styleValues[format.strikeoutIndex].trim()) : false);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)new StringBuilder(36 + String.valueOf(styleLine).length()).append("Skipping malformed 'Style:' line: '").append(styleLine).append("'").toString(), (Throwable)e);
            return null;
        }
    }

    private static int parseAlignment(String alignmentStr) {
        try {
            int alignment = Integer.parseInt(alignmentStr.trim());
            if (SsaStyle.isValidAlignment(alignment)) {
                return alignment;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string = String.valueOf(alignmentStr);
        Log.w((String)TAG, (String)(string.length() != 0 ? "Ignoring unknown alignment: ".concat(string) : new String("Ignoring unknown alignment: ")));
        return -1;
    }

    private static boolean isValidAlignment(int alignment) {
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    @ColorInt
    public static Integer parseColor(String ssaColorExpression) {
        long abgr;
        try {
            abgr = ssaColorExpression.startsWith("&H") ? Long.parseLong(ssaColorExpression.substring(2), 16) : Long.parseLong(ssaColorExpression);
            Assertions.checkArgument((abgr <= 0xFFFFFFFFL ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)new StringBuilder(36 + String.valueOf(ssaColorExpression).length()).append("Failed to parse color expression: '").append(ssaColorExpression).append("'").toString(), (Throwable)e);
            return null;
        }
        int a = Ints.checkedCast((long)(abgr >> 24 & 0xFFL ^ 0xFFL));
        int b = Ints.checkedCast((long)(abgr >> 16 & 0xFFL));
        int g = Ints.checkedCast((long)(abgr >> 8 & 0xFFL));
        int r = Ints.checkedCast((long)(abgr & 0xFFL));
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private static float parseFontSize(String fontSize) {
        try {
            return Float.parseFloat(fontSize);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)new StringBuilder(29 + String.valueOf(fontSize).length()).append("Failed to parse font size: '").append(fontSize).append("'").toString(), (Throwable)e);
            return -3.4028235E38f;
        }
    }

    private static boolean parseBooleanValue(String booleanValue) {
        try {
            int value = Integer.parseInt(booleanValue);
            return value == 1 || value == -1;
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)new StringBuilder(33 + String.valueOf(booleanValue).length()).append("Failed to parse boolean value: '").append(booleanValue).append("'").toString(), (Throwable)e);
            return false;
        }
    }

    static final class Overrides {
        private static final String TAG = "SsaStyle.Overrides";
        private static final Pattern BRACES_PATTERN = Pattern.compile("\\{([^}]*)\\}");
        private static final String PADDED_DECIMAL_PATTERN = "\\s*\\d+(?:\\.\\d+)?\\s*";
        private static final Pattern POSITION_PATTERN = Pattern.compile(Util.formatInvariant((String)"\\\\pos\\((%1$s),(%1$s)\\)", (Object[])new Object[]{"\\s*\\d+(?:\\.\\d+)?\\s*"}));
        private static final Pattern MOVE_PATTERN = Pattern.compile(Util.formatInvariant((String)"\\\\move\\(%1$s,%1$s,(%1$s),(%1$s)(?:,%1$s,%1$s)?\\)", (Object[])new Object[]{"\\s*\\d+(?:\\.\\d+)?\\s*"}));
        private static final Pattern ALIGNMENT_OVERRIDE_PATTERN = Pattern.compile("\\\\an(\\d+)");
        public final int alignment;
        @Nullable
        public final PointF position;

        private Overrides(int alignment, @Nullable PointF position) {
            this.alignment = alignment;
            this.position = position;
        }

        public static Overrides parseFromDialogue(String text) {
            int alignment = -1;
            PointF position = null;
            Matcher matcher = BRACES_PATTERN.matcher(text);
            while (matcher.find()) {
                String braceContents = (String)Assertions.checkNotNull((Object)matcher.group(1));
                try {
                    PointF parsedPosition = Overrides.parsePosition(braceContents);
                    if (parsedPosition != null) {
                        position = parsedPosition;
                    }
                }
                catch (RuntimeException parsedPosition) {
                    // empty catch block
                }
                try {
                    int parsedAlignment = Overrides.parseAlignmentOverride(braceContents);
                    if (parsedAlignment == -1) continue;
                    alignment = parsedAlignment;
                }
                catch (RuntimeException runtimeException) {}
            }
            return new Overrides(alignment, position);
        }

        public static String stripStyleOverrides(String dialogueLine) {
            return BRACES_PATTERN.matcher(dialogueLine).replaceAll("");
        }

        @Nullable
        private static PointF parsePosition(String styleOverride) {
            String y;
            String x;
            Matcher positionMatcher = POSITION_PATTERN.matcher(styleOverride);
            Matcher moveMatcher = MOVE_PATTERN.matcher(styleOverride);
            boolean hasPosition = positionMatcher.find();
            boolean hasMove = moveMatcher.find();
            if (hasPosition) {
                if (hasMove) {
                    Log.i((String)TAG, (String)new StringBuilder(82 + String.valueOf(styleOverride).length()).append("Override has both \\pos(x,y) and \\move(x1,y1,x2,y2); using \\pos values. override='").append(styleOverride).append("'").toString());
                }
                x = positionMatcher.group(1);
                y = positionMatcher.group(2);
            } else if (hasMove) {
                x = moveMatcher.group(1);
                y = moveMatcher.group(2);
            } else {
                return null;
            }
            return new PointF(Float.parseFloat(((String)Assertions.checkNotNull((Object)x)).trim()), Float.parseFloat(((String)Assertions.checkNotNull((Object)y)).trim()));
        }

        private static int parseAlignmentOverride(String braceContents) {
            Matcher matcher = ALIGNMENT_OVERRIDE_PATTERN.matcher(braceContents);
            return matcher.find() ? SsaStyle.parseAlignment((String)Assertions.checkNotNull((Object)matcher.group(1))) : -1;
        }
    }

    static final class Format {
        public final int nameIndex;
        public final int alignmentIndex;
        public final int primaryColorIndex;
        public final int fontSizeIndex;
        public final int boldIndex;
        public final int italicIndex;
        public final int underlineIndex;
        public final int strikeoutIndex;
        public final int length;

        private Format(int nameIndex, int alignmentIndex, int primaryColorIndex, int fontSizeIndex, int boldIndex, int italicIndex, int underlineIndex, int strikeoutIndex, int length) {
            this.nameIndex = nameIndex;
            this.alignmentIndex = alignmentIndex;
            this.primaryColorIndex = primaryColorIndex;
            this.fontSizeIndex = fontSizeIndex;
            this.boldIndex = boldIndex;
            this.italicIndex = italicIndex;
            this.underlineIndex = underlineIndex;
            this.strikeoutIndex = strikeoutIndex;
            this.length = length;
        }

        @Nullable
        public static Format fromFormatLine(String styleFormatLine) {
            int nameIndex = -1;
            int alignmentIndex = -1;
            int primaryColorIndex = -1;
            int fontSizeIndex = -1;
            int boldIndex = -1;
            int italicIndex = -1;
            int underlineIndex = -1;
            int strikeoutIndex = -1;
            String[] keys = TextUtils.split((String)styleFormatLine.substring("Format:".length()), (String)",");
            block20: for (int i = 0; i < keys.length; ++i) {
                switch (Ascii.toLowerCase((String)keys[i].trim())) {
                    case "name": {
                        nameIndex = i;
                        continue block20;
                    }
                    case "alignment": {
                        alignmentIndex = i;
                        continue block20;
                    }
                    case "primarycolour": {
                        primaryColorIndex = i;
                        continue block20;
                    }
                    case "fontsize": {
                        fontSizeIndex = i;
                        continue block20;
                    }
                    case "bold": {
                        boldIndex = i;
                        continue block20;
                    }
                    case "italic": {
                        italicIndex = i;
                        continue block20;
                    }
                    case "underline": {
                        underlineIndex = i;
                        continue block20;
                    }
                    case "strikeout": {
                        strikeoutIndex = i;
                    }
                }
            }
            return nameIndex != -1 ? new Format(nameIndex, alignmentIndex, primaryColorIndex, fontSizeIndex, boldIndex, italicIndex, underlineIndex, strikeoutIndex, keys.length) : null;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SsaAlignment {
    }
}

