/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Locale;

public class TrackSelectionParameters
implements Parcelable {
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    @Deprecated
    public static final TrackSelectionParameters DEFAULT;
    public final ImmutableList<String> preferredAudioLanguages;
    public final int preferredAudioRoleFlags;
    public final ImmutableList<String> preferredTextLanguages;
    public final int preferredTextRoleFlags;
    public final boolean selectUndeterminedTextLanguage;
    public final int disabledTextTrackSelectionFlags;
    public static final Parcelable.Creator<TrackSelectionParameters> CREATOR;

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    TrackSelectionParameters(ImmutableList<String> preferredAudioLanguages, int preferredAudioRoleFlags, ImmutableList<String> preferredTextLanguages, int preferredTextRoleFlags, boolean selectUndeterminedTextLanguage, int disabledTextTrackSelectionFlags) {
        this.preferredAudioLanguages = preferredAudioLanguages;
        this.preferredAudioRoleFlags = preferredAudioRoleFlags;
        this.preferredTextLanguages = preferredTextLanguages;
        this.preferredTextRoleFlags = preferredTextRoleFlags;
        this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
        this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
    }

    TrackSelectionParameters(Parcel in) {
        ArrayList preferredAudioLanguages = new ArrayList();
        in.readList(preferredAudioLanguages, null);
        this.preferredAudioLanguages = ImmutableList.copyOf(preferredAudioLanguages);
        this.preferredAudioRoleFlags = in.readInt();
        ArrayList preferredTextLanguages = new ArrayList();
        in.readList(preferredTextLanguages, null);
        this.preferredTextLanguages = ImmutableList.copyOf(preferredTextLanguages);
        this.preferredTextRoleFlags = in.readInt();
        this.selectUndeterminedTextLanguage = Util.readBoolean((Parcel)in);
        this.disabledTextTrackSelectionFlags = in.readInt();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return this.preferredAudioLanguages.equals(other.preferredAudioLanguages) && this.preferredAudioRoleFlags == other.preferredAudioRoleFlags && this.preferredTextLanguages.equals(other.preferredTextLanguages) && this.preferredTextRoleFlags == other.preferredTextRoleFlags && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.disabledTextTrackSelectionFlags == other.disabledTextTrackSelectionFlags;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.preferredAudioLanguages.hashCode();
        result = 31 * result + this.preferredAudioRoleFlags;
        result = 31 * result + this.preferredTextLanguages.hashCode();
        result = 31 * result + this.preferredTextRoleFlags;
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + this.disabledTextTrackSelectionFlags;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.preferredAudioLanguages);
        dest.writeInt(this.preferredAudioRoleFlags);
        dest.writeList(this.preferredTextLanguages);
        dest.writeInt(this.preferredTextRoleFlags);
        Util.writeBoolean((Parcel)dest, (boolean)this.selectUndeterminedTextLanguage);
        dest.writeInt(this.disabledTextTrackSelectionFlags);
    }

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        CREATOR = new Parcelable.Creator<TrackSelectionParameters>(){

            public TrackSelectionParameters createFromParcel(Parcel in) {
                return new TrackSelectionParameters(in);
            }

            public TrackSelectionParameters[] newArray(int size) {
                return new TrackSelectionParameters[size];
            }
        };
    }

    public static class Builder {
        ImmutableList<String> preferredAudioLanguages;
        int preferredAudioRoleFlags;
        ImmutableList<String> preferredTextLanguages;
        int preferredTextRoleFlags;
        boolean selectUndeterminedTextLanguage;
        int disabledTextTrackSelectionFlags;

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
        }

        @Deprecated
        public Builder() {
            this.preferredAudioLanguages = ImmutableList.of();
            this.preferredAudioRoleFlags = 0;
            this.preferredTextLanguages = ImmutableList.of();
            this.preferredTextRoleFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.disabledTextTrackSelectionFlags = 0;
        }

        Builder(TrackSelectionParameters initialValues) {
            this.preferredAudioLanguages = initialValues.preferredAudioLanguages;
            this.preferredAudioRoleFlags = initialValues.preferredAudioRoleFlags;
            this.preferredTextLanguages = initialValues.preferredTextLanguages;
            this.preferredTextRoleFlags = initialValues.preferredTextRoleFlags;
            this.selectUndeterminedTextLanguage = initialValues.selectUndeterminedTextLanguage;
            this.disabledTextTrackSelectionFlags = initialValues.disabledTextTrackSelectionFlags;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            return preferredAudioLanguage == null ? this.setPreferredAudioLanguages(new String[0]) : this.setPreferredAudioLanguages(preferredAudioLanguage);
        }

        public Builder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : (String[])Assertions.checkNotNull((Object)preferredAudioLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode((String)((String)Assertions.checkNotNull((Object)language))));
            }
            this.preferredAudioLanguages = listBuilder.build();
            return this;
        }

        public Builder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            this.preferredAudioRoleFlags = preferredAudioRoleFlags;
            return this;
        }

        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            return preferredTextLanguage == null ? this.setPreferredTextLanguages(new String[0]) : this.setPreferredTextLanguages(preferredTextLanguage);
        }

        public Builder setPreferredTextLanguages(String ... preferredTextLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : (String[])Assertions.checkNotNull((Object)preferredTextLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode((String)((String)Assertions.checkNotNull((Object)language))));
            }
            this.preferredTextLanguages = listBuilder.build();
            return this;
        }

        public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.preferredTextRoleFlags = preferredTextRoleFlags;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        public Builder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this.preferredAudioLanguages, this.preferredAudioRoleFlags, this.preferredTextLanguages, this.preferredTextRoleFlags, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags);
        }

        @RequiresApi(value=19)
        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context context) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
            if (captioningManager == null || !captioningManager.isEnabled()) {
                return;
            }
            this.preferredTextRoleFlags = 1088;
            Locale preferredLocale = captioningManager.getLocale();
            if (preferredLocale != null) {
                this.preferredTextLanguages = ImmutableList.of((Object)Util.getLocaleLanguageTag((Locale)preferredLocale));
            }
        }
    }
}

