/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.MimeTypes;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class TrackSelectionUtil {
    private TrackSelectionUtil() {
    }

    public static @NullableType ExoTrackSelection[] createTrackSelectionsForDefinitions(@NullableType ExoTrackSelection.Definition[] definitions, AdaptiveTrackSelectionFactory adaptiveTrackSelectionFactory) {
        ExoTrackSelection[] selections = new ExoTrackSelection[definitions.length];
        boolean createdAdaptiveTrackSelection = false;
        for (int i = 0; i < definitions.length; ++i) {
            ExoTrackSelection.Definition definition = definitions[i];
            if (definition == null) continue;
            if (definition.tracks.length > 1 && !createdAdaptiveTrackSelection) {
                createdAdaptiveTrackSelection = true;
                selections[i] = adaptiveTrackSelectionFactory.createAdaptiveTrackSelection(definition);
                continue;
            }
            selections[i] = new FixedTrackSelection(definition.group, definition.tracks[0], definition.type);
        }
        return selections;
    }

    public static DefaultTrackSelector.Parameters updateParametersWithOverride(DefaultTrackSelector.Parameters parameters, int rendererIndex, TrackGroupArray trackGroupArray, boolean isDisabled, @Nullable DefaultTrackSelector.SelectionOverride override) {
        DefaultTrackSelector.ParametersBuilder builder = parameters.buildUpon().clearSelectionOverrides(rendererIndex).setRendererDisabled(rendererIndex, isDisabled);
        if (override != null) {
            builder.setSelectionOverride(rendererIndex, trackGroupArray, override);
        }
        return builder.build();
    }

    public static boolean hasTrackOfType(TrackSelectionArray trackSelections, int trackType) {
        for (int i = 0; i < trackSelections.length; ++i) {
            TrackSelection trackSelection = trackSelections.get(i);
            if (trackSelection == null) continue;
            for (int j = 0; j < trackSelection.length(); ++j) {
                if (MimeTypes.getTrackType((String)trackSelection.getFormat((int)j).sampleMimeType) != trackType) continue;
                return true;
            }
        }
        return false;
    }

    public static interface AdaptiveTrackSelectionFactory {
        public ExoTrackSelection createAdaptiveTrackSelection(ExoTrackSelection.Definition var1);
    }
}

