/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class ContentDataSource
extends BaseDataSource {
    private final ContentResolver resolver;
    @Nullable
    private Uri uri;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private FileInputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        super(false);
        this.resolver = context.getContentResolver();
    }

    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            FileInputStream inputStream;
            AssetFileDescriptor assetFileDescriptor;
            Uri uri;
            this.uri = uri = dataSpec.uri;
            this.transferInitializing(dataSpec);
            this.assetFileDescriptor = assetFileDescriptor = this.resolver.openAssetFileDescriptor(uri, "r");
            if (assetFileDescriptor == null) {
                String string = String.valueOf(uri);
                throw new FileNotFoundException(new StringBuilder(36 + String.valueOf(string).length()).append("Could not open file descriptor for: ").append(string).toString());
            }
            long assetFileDescriptorLength = assetFileDescriptor.getLength();
            this.inputStream = inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
            if (assetFileDescriptorLength != -1L && dataSpec.position > assetFileDescriptorLength) {
                throw new DataSourceException(0);
            }
            long assetFileDescriptorOffset = assetFileDescriptor.getStartOffset();
            long skipped = inputStream.skip(assetFileDescriptorOffset + dataSpec.position) - assetFileDescriptorOffset;
            if (skipped != dataSpec.position) {
                throw new DataSourceException(0);
            }
            if (assetFileDescriptorLength == -1L) {
                FileChannel channel = inputStream.getChannel();
                long channelSize = channel.size();
                if (channelSize == 0L) {
                    this.bytesRemaining = -1L;
                } else {
                    this.bytesRemaining = channelSize - channel.position();
                    if (this.bytesRemaining < 0L) {
                        throw new DataSourceException(0);
                    }
                }
            } else {
                this.bytesRemaining = assetFileDescriptorLength - skipped;
                if (this.bytesRemaining < 0L) {
                    throw new DataSourceException(0);
                }
            }
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int readLength) throws ContentDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = ((FileInputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        if (bytesRead == -1) {
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws ContentDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new ContentDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    public static class ContentDataSourceException
    extends IOException {
        public ContentDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

