/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLDecoder;

public final class DataSchemeDataSource
extends BaseDataSource {
    public static final String SCHEME_DATA = "data";
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private byte[] data;
    private int readPosition;
    private int bytesRemaining;

    public DataSchemeDataSource() {
        super(false);
    }

    public long open(DataSpec dataSpec) throws IOException {
        this.transferInitializing(dataSpec);
        this.dataSpec = dataSpec;
        Uri uri = dataSpec.uri;
        String scheme = uri.getScheme();
        if (!SCHEME_DATA.equals(scheme)) {
            String string = String.valueOf(scheme);
            throw new ParserException(string.length() != 0 ? "Unsupported scheme: ".concat(string) : new String("Unsupported scheme: "));
        }
        String[] uriParts = Util.split((String)uri.getSchemeSpecificPart(), (String)",");
        if (uriParts.length != 2) {
            String string = String.valueOf(uri);
            throw new ParserException(new StringBuilder(23 + String.valueOf(string).length()).append("Unexpected URI format: ").append(string).toString());
        }
        String dataString = uriParts[1];
        if (uriParts[0].contains(";base64")) {
            try {
                this.data = Base64.decode((String)dataString, (int)0);
            }
            catch (IllegalArgumentException e) {
                String string = String.valueOf(dataString);
                throw new ParserException(string.length() != 0 ? "Error while parsing Base64 encoded string: ".concat(string) : new String("Error while parsing Base64 encoded string: "), (Throwable)e);
            }
        } else {
            this.data = Util.getUtf8Bytes((String)URLDecoder.decode(dataString, Charsets.US_ASCII.name()));
        }
        if (dataSpec.position > (long)this.data.length) {
            this.data = null;
            throw new DataSourceException(0);
        }
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = this.data.length - this.readPosition;
        if (dataSpec.length != -1L) {
            this.bytesRemaining = (int)Math.min((long)this.bytesRemaining, dataSpec.length);
        }
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : (long)this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int readLength) {
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        readLength = Math.min(readLength, this.bytesRemaining);
        System.arraycopy(Util.castNonNull((Object)this.data), this.readPosition, buffer, offset, readLength);
        this.readPosition += readLength;
        this.bytesRemaining -= readLength;
        this.bytesTransferred(readLength);
        return readLength;
    }

    @Nullable
    public Uri getUri() {
        return this.dataSpec != null ? this.dataSpec.uri : null;
    }

    public void close() {
        if (this.data != null) {
            this.data = null;
            this.transferEnded();
        }
        this.dataSpec = null;
    }
}

