/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.NetworkTypeObserver;
import com.google.android.exoplayer2.util.SlidingPercentile;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public final class DefaultBandwidthMeter
implements BandwidthMeter,
TransferListener {
    public static final ImmutableListMultimap<String, Integer> DEFAULT_INITIAL_BITRATE_COUNTRY_GROUPS = DefaultBandwidthMeter.createInitialBitrateCountryGroupAssignment();
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI = ImmutableList.of((Object)6200000L, (Object)3900000L, (Object)2300000L, (Object)1300000L, (Object)620000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_2G = ImmutableList.of((Object)248000L, (Object)160000L, (Object)142000L, (Object)127000L, (Object)113000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_3G = ImmutableList.of((Object)2200000L, (Object)1300000L, (Object)950000L, (Object)760000L, (Object)520000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_4G = ImmutableList.of((Object)4400000L, (Object)2300000L, (Object)1500000L, (Object)1100000L, (Object)640000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_NSA = ImmutableList.of((Object)10000000L, (Object)0x6DDD00L, (Object)5000000L, (Object)2700000L, (Object)1600000L);
    public static final ImmutableList<Long> DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_SA = ImmutableList.of((Object)2600000L, (Object)2200000L, (Object)2000000L, (Object)1500000L, (Object)470000L);
    public static final long DEFAULT_INITIAL_BITRATE_ESTIMATE = 1000000L;
    public static final int DEFAULT_SLIDING_WINDOW_MAX_WEIGHT = 2000;
    private static final int COUNTRY_GROUP_INDEX_WIFI = 0;
    private static final int COUNTRY_GROUP_INDEX_2G = 1;
    private static final int COUNTRY_GROUP_INDEX_3G = 2;
    private static final int COUNTRY_GROUP_INDEX_4G = 3;
    private static final int COUNTRY_GROUP_INDEX_5G_NSA = 4;
    private static final int COUNTRY_GROUP_INDEX_5G_SA = 5;
    @Nullable
    private static DefaultBandwidthMeter singletonInstance;
    private static final int ELAPSED_MILLIS_FOR_ESTIMATE = 2000;
    private static final int BYTES_TRANSFERRED_FOR_ESTIMATE = 524288;
    private final ImmutableMap<Integer, Long> initialBitrateEstimates;
    private final BandwidthMeter.EventListener.EventDispatcher eventDispatcher;
    private final SlidingPercentile slidingPercentile;
    private final Clock clock;
    private final boolean resetOnNetworkTypeChange;
    private int streamCount;
    private long sampleStartTimeMs;
    private long sampleBytesTransferred;
    private int networkType;
    private long totalElapsedTimeMs;
    private long totalBytesTransferred;
    private long bitrateEstimate;
    private long lastReportedBitrateEstimate;
    private boolean networkTypeOverrideSet;
    private int networkTypeOverride;

    public static synchronized DefaultBandwidthMeter getSingletonInstance(Context context) {
        if (singletonInstance == null) {
            singletonInstance = new Builder(context).build();
        }
        return singletonInstance;
    }

    @Deprecated
    public DefaultBandwidthMeter() {
        this(null, (Map<Integer, Long>)ImmutableMap.of(), 2000, Clock.DEFAULT, false);
    }

    private DefaultBandwidthMeter(@Nullable Context context, Map<Integer, Long> initialBitrateEstimates, int maxWeight, Clock clock, boolean resetOnNetworkTypeChange) {
        this.initialBitrateEstimates = ImmutableMap.copyOf(initialBitrateEstimates);
        this.eventDispatcher = new BandwidthMeter.EventListener.EventDispatcher();
        this.slidingPercentile = new SlidingPercentile(maxWeight);
        this.clock = clock;
        this.resetOnNetworkTypeChange = resetOnNetworkTypeChange;
        if (context != null) {
            NetworkTypeObserver networkTypeObserver = NetworkTypeObserver.getInstance(context);
            this.networkType = networkTypeObserver.getNetworkType();
            this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(this.networkType);
            networkTypeObserver.register(this::onNetworkTypeChanged);
        } else {
            this.networkType = 0;
            this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(0);
        }
    }

    public synchronized void setNetworkTypeOverride(int networkType) {
        this.networkTypeOverride = networkType;
        this.networkTypeOverrideSet = true;
        this.onNetworkTypeChanged(networkType);
    }

    @Override
    public synchronized long getBitrateEstimate() {
        return this.bitrateEstimate;
    }

    @Override
    public TransferListener getTransferListener() {
        return this;
    }

    @Override
    public void addEventListener(Handler eventHandler, BandwidthMeter.EventListener eventListener) {
        Assertions.checkNotNull((Object)eventHandler);
        Assertions.checkNotNull((Object)eventListener);
        this.eventDispatcher.addListener(eventHandler, eventListener);
    }

    @Override
    public void removeEventListener(BandwidthMeter.EventListener eventListener) {
        this.eventDispatcher.removeListener(eventListener);
    }

    public void onTransferInitializing(DataSource source, DataSpec dataSpec, boolean isNetwork) {
    }

    public synchronized void onTransferStart(DataSource source, DataSpec dataSpec, boolean isNetwork) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        if (this.streamCount == 0) {
            this.sampleStartTimeMs = this.clock.elapsedRealtime();
        }
        ++this.streamCount;
    }

    public synchronized void onBytesTransferred(DataSource source, DataSpec dataSpec, boolean isNetwork, int bytes) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        this.sampleBytesTransferred += (long)bytes;
    }

    public synchronized void onTransferEnd(DataSource source, DataSpec dataSpec, boolean isNetwork) {
        if (!DefaultBandwidthMeter.isTransferAtFullNetworkSpeed(dataSpec, isNetwork)) {
            return;
        }
        Assertions.checkState((this.streamCount > 0 ? 1 : 0) != 0);
        long nowMs = this.clock.elapsedRealtime();
        int sampleElapsedTimeMs = (int)(nowMs - this.sampleStartTimeMs);
        this.totalElapsedTimeMs += (long)sampleElapsedTimeMs;
        this.totalBytesTransferred += this.sampleBytesTransferred;
        if (sampleElapsedTimeMs > 0) {
            float bitsPerSecond = (float)this.sampleBytesTransferred * 8000.0f / (float)sampleElapsedTimeMs;
            this.slidingPercentile.addSample((int)Math.sqrt(this.sampleBytesTransferred), bitsPerSecond);
            if (this.totalElapsedTimeMs >= 2000L || this.totalBytesTransferred >= 524288L) {
                this.bitrateEstimate = (long)this.slidingPercentile.getPercentile(0.5f);
            }
            this.maybeNotifyBandwidthSample(sampleElapsedTimeMs, this.sampleBytesTransferred, this.bitrateEstimate);
            this.sampleStartTimeMs = nowMs;
            this.sampleBytesTransferred = 0L;
        }
        --this.streamCount;
    }

    private synchronized void onNetworkTypeChanged(int networkType) {
        if (this.networkType != 0 && !this.resetOnNetworkTypeChange) {
            return;
        }
        if (this.networkTypeOverrideSet) {
            networkType = this.networkTypeOverride;
        }
        if (this.networkType == networkType) {
            return;
        }
        this.networkType = networkType;
        if (networkType == 1 || networkType == 0 || networkType == 8) {
            return;
        }
        this.bitrateEstimate = this.getInitialBitrateEstimateForNetworkType(networkType);
        long nowMs = this.clock.elapsedRealtime();
        int sampleElapsedTimeMs = this.streamCount > 0 ? (int)(nowMs - this.sampleStartTimeMs) : 0;
        this.maybeNotifyBandwidthSample(sampleElapsedTimeMs, this.sampleBytesTransferred, this.bitrateEstimate);
        this.sampleStartTimeMs = nowMs;
        this.sampleBytesTransferred = 0L;
        this.totalBytesTransferred = 0L;
        this.totalElapsedTimeMs = 0L;
        this.slidingPercentile.reset();
    }

    private void maybeNotifyBandwidthSample(int elapsedMs, long bytesTransferred, long bitrateEstimate) {
        if (elapsedMs == 0 && bytesTransferred == 0L && bitrateEstimate == this.lastReportedBitrateEstimate) {
            return;
        }
        this.lastReportedBitrateEstimate = bitrateEstimate;
        this.eventDispatcher.bandwidthSample(elapsedMs, bytesTransferred, bitrateEstimate);
    }

    private long getInitialBitrateEstimateForNetworkType(int networkType) {
        Long initialBitrateEstimate = (Long)this.initialBitrateEstimates.get((Object)networkType);
        if (initialBitrateEstimate == null) {
            initialBitrateEstimate = (Long)this.initialBitrateEstimates.get((Object)0);
        }
        if (initialBitrateEstimate == null) {
            initialBitrateEstimate = 1000000L;
        }
        return initialBitrateEstimate;
    }

    private static boolean isTransferAtFullNetworkSpeed(DataSpec dataSpec, boolean isNetwork) {
        return isNetwork && !dataSpec.isFlagSet(8);
    }

    private static ImmutableListMultimap<String, Integer> createInitialBitrateCountryGroupAssignment() {
        return ImmutableListMultimap.builder().putAll((Object)"AD", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"AE", (Object[])new Integer[]{1, 4, 4, 4, 2, 2}).putAll((Object)"AF", (Object[])new Integer[]{4, 4, 3, 4, 2, 2}).putAll((Object)"AG", (Object[])new Integer[]{4, 2, 1, 4, 2, 2}).putAll((Object)"AI", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"AL", (Object[])new Integer[]{1, 1, 1, 1, 2, 2}).putAll((Object)"AM", (Object[])new Integer[]{2, 2, 1, 3, 2, 2}).putAll((Object)"AO", (Object[])new Integer[]{3, 4, 3, 1, 2, 2}).putAll((Object)"AR", (Object[])new Integer[]{2, 4, 2, 1, 2, 2}).putAll((Object)"AS", (Object[])new Integer[]{2, 2, 3, 3, 2, 2}).putAll((Object)"AT", (Object[])new Integer[]{0, 1, 0, 0, 0, 2}).putAll((Object)"AU", (Object[])new Integer[]{0, 2, 0, 1, 1, 2}).putAll((Object)"AW", (Object[])new Integer[]{1, 2, 0, 4, 2, 2}).putAll((Object)"AX", (Object[])new Integer[]{0, 2, 2, 2, 2, 2}).putAll((Object)"AZ", (Object[])new Integer[]{3, 3, 3, 4, 4, 2}).putAll((Object)"BA", (Object[])new Integer[]{1, 1, 0, 1, 2, 2}).putAll((Object)"BB", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"BD", (Object[])new Integer[]{2, 0, 3, 3, 2, 2}).putAll((Object)"BE", (Object[])new Integer[]{0, 0, 2, 3, 2, 2}).putAll((Object)"BF", (Object[])new Integer[]{4, 4, 4, 2, 2, 2}).putAll((Object)"BG", (Object[])new Integer[]{0, 1, 0, 0, 2, 2}).putAll((Object)"BH", (Object[])new Integer[]{1, 0, 2, 4, 2, 2}).putAll((Object)"BI", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"BJ", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"BL", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"BM", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"BN", (Object[])new Integer[]{3, 2, 1, 0, 2, 2}).putAll((Object)"BO", (Object[])new Integer[]{1, 2, 4, 2, 2, 2}).putAll((Object)"BQ", (Object[])new Integer[]{1, 2, 1, 2, 2, 2}).putAll((Object)"BR", (Object[])new Integer[]{2, 4, 3, 2, 2, 2}).putAll((Object)"BS", (Object[])new Integer[]{2, 2, 1, 3, 2, 2}).putAll((Object)"BT", (Object[])new Integer[]{3, 0, 3, 2, 2, 2}).putAll((Object)"BW", (Object[])new Integer[]{3, 4, 1, 1, 2, 2}).putAll((Object)"BY", (Object[])new Integer[]{1, 1, 1, 2, 2, 2}).putAll((Object)"BZ", (Object[])new Integer[]{2, 2, 2, 2, 2, 2}).putAll((Object)"CA", (Object[])new Integer[]{0, 3, 1, 2, 4, 2}).putAll((Object)"CD", (Object[])new Integer[]{4, 2, 2, 1, 2, 2}).putAll((Object)"CF", (Object[])new Integer[]{4, 2, 3, 2, 2, 2}).putAll((Object)"CG", (Object[])new Integer[]{3, 4, 2, 2, 2, 2}).putAll((Object)"CH", (Object[])new Integer[]{0, 0, 0, 0, 1, 2}).putAll((Object)"CI", (Object[])new Integer[]{3, 3, 3, 3, 2, 2}).putAll((Object)"CK", (Object[])new Integer[]{2, 2, 3, 0, 2, 2}).putAll((Object)"CL", (Object[])new Integer[]{1, 1, 2, 2, 2, 2}).putAll((Object)"CM", (Object[])new Integer[]{3, 4, 3, 2, 2, 2}).putAll((Object)"CN", (Object[])new Integer[]{2, 2, 2, 1, 3, 2}).putAll((Object)"CO", (Object[])new Integer[]{2, 3, 4, 2, 2, 2}).putAll((Object)"CR", (Object[])new Integer[]{2, 3, 4, 4, 2, 2}).putAll((Object)"CU", (Object[])new Integer[]{4, 4, 2, 2, 2, 2}).putAll((Object)"CV", (Object[])new Integer[]{2, 3, 1, 0, 2, 2}).putAll((Object)"CW", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"CY", (Object[])new Integer[]{1, 1, 0, 0, 2, 2}).putAll((Object)"CZ", (Object[])new Integer[]{0, 1, 0, 0, 1, 2}).putAll((Object)"DE", (Object[])new Integer[]{0, 0, 1, 1, 0, 2}).putAll((Object)"DJ", (Object[])new Integer[]{4, 0, 4, 4, 2, 2}).putAll((Object)"DK", (Object[])new Integer[]{0, 0, 1, 0, 0, 2}).putAll((Object)"DM", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"DO", (Object[])new Integer[]{3, 4, 4, 4, 2, 2}).putAll((Object)"DZ", (Object[])new Integer[]{3, 3, 4, 4, 2, 4}).putAll((Object)"EC", (Object[])new Integer[]{2, 4, 3, 1, 2, 2}).putAll((Object)"EE", (Object[])new Integer[]{0, 1, 0, 0, 2, 2}).putAll((Object)"EG", (Object[])new Integer[]{3, 4, 3, 3, 2, 2}).putAll((Object)"EH", (Object[])new Integer[]{2, 2, 2, 2, 2, 2}).putAll((Object)"ER", (Object[])new Integer[]{4, 2, 2, 2, 2, 2}).putAll((Object)"ES", (Object[])new Integer[]{0, 1, 1, 1, 2, 2}).putAll((Object)"ET", (Object[])new Integer[]{4, 4, 4, 1, 2, 2}).putAll((Object)"FI", (Object[])new Integer[]{0, 0, 0, 0, 0, 2}).putAll((Object)"FJ", (Object[])new Integer[]{3, 0, 2, 3, 2, 2}).putAll((Object)"FK", (Object[])new Integer[]{4, 2, 2, 2, 2, 2}).putAll((Object)"FM", (Object[])new Integer[]{3, 2, 4, 4, 2, 2}).putAll((Object)"FO", (Object[])new Integer[]{1, 2, 0, 1, 2, 2}).putAll((Object)"FR", (Object[])new Integer[]{1, 1, 2, 0, 1, 2}).putAll((Object)"GA", (Object[])new Integer[]{3, 4, 1, 1, 2, 2}).putAll((Object)"GB", (Object[])new Integer[]{0, 0, 1, 1, 1, 2}).putAll((Object)"GD", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"GE", (Object[])new Integer[]{1, 1, 1, 2, 2, 2}).putAll((Object)"GF", (Object[])new Integer[]{2, 2, 2, 3, 2, 2}).putAll((Object)"GG", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"GH", (Object[])new Integer[]{3, 1, 3, 2, 2, 2}).putAll((Object)"GI", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"GL", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"GM", (Object[])new Integer[]{4, 3, 2, 4, 2, 2}).putAll((Object)"GN", (Object[])new Integer[]{4, 3, 4, 2, 2, 2}).putAll((Object)"GP", (Object[])new Integer[]{2, 1, 2, 3, 2, 2}).putAll((Object)"GQ", (Object[])new Integer[]{4, 2, 2, 4, 2, 2}).putAll((Object)"GR", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"GT", (Object[])new Integer[]{3, 2, 3, 1, 2, 2}).putAll((Object)"GU", (Object[])new Integer[]{1, 2, 3, 4, 2, 2}).putAll((Object)"GW", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"GY", (Object[])new Integer[]{3, 3, 3, 4, 2, 2}).putAll((Object)"HK", (Object[])new Integer[]{0, 1, 2, 3, 2, 0}).putAll((Object)"HN", (Object[])new Integer[]{3, 1, 3, 3, 2, 2}).putAll((Object)"HR", (Object[])new Integer[]{1, 1, 0, 0, 3, 2}).putAll((Object)"HT", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"HU", (Object[])new Integer[]{0, 0, 0, 0, 0, 2}).putAll((Object)"ID", (Object[])new Integer[]{3, 2, 3, 3, 2, 2}).putAll((Object)"IE", (Object[])new Integer[]{0, 0, 1, 1, 3, 2}).putAll((Object)"IL", (Object[])new Integer[]{1, 0, 2, 3, 4, 2}).putAll((Object)"IM", (Object[])new Integer[]{0, 2, 0, 1, 2, 2}).putAll((Object)"IN", (Object[])new Integer[]{2, 1, 3, 3, 2, 2}).putAll((Object)"IO", (Object[])new Integer[]{4, 2, 2, 4, 2, 2}).putAll((Object)"IQ", (Object[])new Integer[]{3, 3, 4, 4, 2, 2}).putAll((Object)"IR", (Object[])new Integer[]{3, 2, 3, 2, 2, 2}).putAll((Object)"IS", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"IT", (Object[])new Integer[]{0, 4, 0, 1, 2, 2}).putAll((Object)"JE", (Object[])new Integer[]{2, 2, 1, 2, 2, 2}).putAll((Object)"JM", (Object[])new Integer[]{3, 3, 4, 4, 2, 2}).putAll((Object)"JO", (Object[])new Integer[]{2, 2, 1, 1, 2, 2}).putAll((Object)"JP", (Object[])new Integer[]{0, 0, 0, 0, 2, 1}).putAll((Object)"KE", (Object[])new Integer[]{3, 4, 2, 2, 2, 2}).putAll((Object)"KG", (Object[])new Integer[]{2, 0, 1, 1, 2, 2}).putAll((Object)"KH", (Object[])new Integer[]{1, 0, 4, 3, 2, 2}).putAll((Object)"KI", (Object[])new Integer[]{4, 2, 4, 3, 2, 2}).putAll((Object)"KM", (Object[])new Integer[]{4, 3, 2, 3, 2, 2}).putAll((Object)"KN", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"KP", (Object[])new Integer[]{4, 2, 2, 2, 2, 2}).putAll((Object)"KR", (Object[])new Integer[]{0, 0, 1, 3, 1, 2}).putAll((Object)"KW", (Object[])new Integer[]{1, 3, 1, 1, 1, 2}).putAll((Object)"KY", (Object[])new Integer[]{1, 2, 0, 2, 2, 2}).putAll((Object)"KZ", (Object[])new Integer[]{2, 2, 2, 3, 2, 2}).putAll((Object)"LA", (Object[])new Integer[]{1, 2, 1, 1, 2, 2}).putAll((Object)"LB", (Object[])new Integer[]{3, 2, 0, 0, 2, 2}).putAll((Object)"LC", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"LI", (Object[])new Integer[]{0, 2, 2, 2, 2, 2}).putAll((Object)"LK", (Object[])new Integer[]{2, 0, 2, 3, 2, 2}).putAll((Object)"LR", (Object[])new Integer[]{3, 4, 4, 3, 2, 2}).putAll((Object)"LS", (Object[])new Integer[]{3, 3, 2, 3, 2, 2}).putAll((Object)"LT", (Object[])new Integer[]{0, 0, 0, 0, 2, 2}).putAll((Object)"LU", (Object[])new Integer[]{1, 0, 1, 1, 2, 2}).putAll((Object)"LV", (Object[])new Integer[]{0, 0, 0, 0, 2, 2}).putAll((Object)"LY", (Object[])new Integer[]{4, 2, 4, 3, 2, 2}).putAll((Object)"MA", (Object[])new Integer[]{3, 2, 2, 1, 2, 2}).putAll((Object)"MC", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"MD", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"ME", (Object[])new Integer[]{1, 2, 0, 1, 2, 2}).putAll((Object)"MF", (Object[])new Integer[]{2, 2, 1, 1, 2, 2}).putAll((Object)"MG", (Object[])new Integer[]{3, 4, 2, 2, 2, 2}).putAll((Object)"MH", (Object[])new Integer[]{4, 2, 2, 4, 2, 2}).putAll((Object)"MK", (Object[])new Integer[]{1, 1, 0, 0, 2, 2}).putAll((Object)"ML", (Object[])new Integer[]{4, 4, 2, 2, 2, 2}).putAll((Object)"MM", (Object[])new Integer[]{2, 3, 3, 3, 2, 2}).putAll((Object)"MN", (Object[])new Integer[]{2, 4, 2, 2, 2, 2}).putAll((Object)"MO", (Object[])new Integer[]{0, 2, 4, 4, 2, 2}).putAll((Object)"MP", (Object[])new Integer[]{0, 2, 2, 2, 2, 2}).putAll((Object)"MQ", (Object[])new Integer[]{2, 2, 2, 3, 2, 2}).putAll((Object)"MR", (Object[])new Integer[]{3, 0, 4, 3, 2, 2}).putAll((Object)"MS", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"MT", (Object[])new Integer[]{0, 2, 0, 0, 2, 2}).putAll((Object)"MU", (Object[])new Integer[]{2, 1, 1, 2, 2, 2}).putAll((Object)"MV", (Object[])new Integer[]{4, 3, 2, 4, 2, 2}).putAll((Object)"MW", (Object[])new Integer[]{4, 2, 1, 0, 2, 2}).putAll((Object)"MX", (Object[])new Integer[]{2, 4, 4, 4, 4, 2}).putAll((Object)"MY", (Object[])new Integer[]{1, 0, 3, 2, 2, 2}).putAll((Object)"MZ", (Object[])new Integer[]{3, 3, 2, 1, 2, 2}).putAll((Object)"NA", (Object[])new Integer[]{4, 3, 3, 2, 2, 2}).putAll((Object)"NC", (Object[])new Integer[]{3, 0, 4, 4, 2, 2}).putAll((Object)"NE", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"NF", (Object[])new Integer[]{2, 2, 2, 2, 2, 2}).putAll((Object)"NG", (Object[])new Integer[]{3, 3, 2, 3, 2, 2}).putAll((Object)"NI", (Object[])new Integer[]{2, 1, 4, 4, 2, 2}).putAll((Object)"NL", (Object[])new Integer[]{0, 2, 3, 2, 0, 2}).putAll((Object)"NO", (Object[])new Integer[]{0, 1, 2, 0, 0, 2}).putAll((Object)"NP", (Object[])new Integer[]{2, 0, 4, 2, 2, 2}).putAll((Object)"NR", (Object[])new Integer[]{3, 2, 3, 1, 2, 2}).putAll((Object)"NU", (Object[])new Integer[]{4, 2, 2, 2, 2, 2}).putAll((Object)"NZ", (Object[])new Integer[]{0, 2, 1, 2, 4, 2}).putAll((Object)"OM", (Object[])new Integer[]{2, 2, 1, 3, 3, 2}).putAll((Object)"PA", (Object[])new Integer[]{1, 3, 3, 3, 2, 2}).putAll((Object)"PE", (Object[])new Integer[]{2, 3, 4, 4, 2, 2}).putAll((Object)"PF", (Object[])new Integer[]{2, 2, 2, 1, 2, 2}).putAll((Object)"PG", (Object[])new Integer[]{4, 4, 3, 2, 2, 2}).putAll((Object)"PH", (Object[])new Integer[]{2, 1, 3, 3, 3, 2}).putAll((Object)"PK", (Object[])new Integer[]{3, 2, 3, 3, 2, 2}).putAll((Object)"PL", (Object[])new Integer[]{1, 0, 1, 2, 3, 2}).putAll((Object)"PM", (Object[])new Integer[]{0, 2, 2, 2, 2, 2}).putAll((Object)"PR", (Object[])new Integer[]{2, 1, 2, 2, 4, 3}).putAll((Object)"PS", (Object[])new Integer[]{3, 3, 2, 2, 2, 2}).putAll((Object)"PT", (Object[])new Integer[]{0, 1, 1, 0, 2, 2}).putAll((Object)"PW", (Object[])new Integer[]{1, 2, 4, 1, 2, 2}).putAll((Object)"PY", (Object[])new Integer[]{2, 0, 3, 2, 2, 2}).putAll((Object)"QA", (Object[])new Integer[]{2, 3, 1, 2, 3, 2}).putAll((Object)"RE", (Object[])new Integer[]{1, 0, 2, 2, 2, 2}).putAll((Object)"RO", (Object[])new Integer[]{0, 1, 0, 1, 0, 2}).putAll((Object)"RS", (Object[])new Integer[]{1, 2, 0, 0, 2, 2}).putAll((Object)"RU", (Object[])new Integer[]{0, 1, 0, 1, 4, 2}).putAll((Object)"RW", (Object[])new Integer[]{3, 3, 3, 1, 2, 2}).putAll((Object)"SA", (Object[])new Integer[]{2, 2, 2, 1, 1, 2}).putAll((Object)"SB", (Object[])new Integer[]{4, 2, 3, 2, 2, 2}).putAll((Object)"SC", (Object[])new Integer[]{4, 2, 1, 3, 2, 2}).putAll((Object)"SD", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"SE", (Object[])new Integer[]{0, 0, 0, 0, 0, 2}).putAll((Object)"SG", (Object[])new Integer[]{1, 0, 1, 2, 3, 2}).putAll((Object)"SH", (Object[])new Integer[]{4, 2, 2, 2, 2, 2}).putAll((Object)"SI", (Object[])new Integer[]{0, 0, 0, 0, 2, 2}).putAll((Object)"SJ", (Object[])new Integer[]{2, 2, 2, 2, 2, 2}).putAll((Object)"SK", (Object[])new Integer[]{0, 1, 0, 0, 2, 2}).putAll((Object)"SL", (Object[])new Integer[]{4, 3, 4, 0, 2, 2}).putAll((Object)"SM", (Object[])new Integer[]{0, 2, 2, 2, 2, 2}).putAll((Object)"SN", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"SO", (Object[])new Integer[]{3, 3, 3, 4, 2, 2}).putAll((Object)"SR", (Object[])new Integer[]{3, 2, 2, 2, 2, 2}).putAll((Object)"SS", (Object[])new Integer[]{4, 4, 3, 3, 2, 2}).putAll((Object)"ST", (Object[])new Integer[]{2, 2, 1, 2, 2, 2}).putAll((Object)"SV", (Object[])new Integer[]{2, 1, 4, 3, 2, 2}).putAll((Object)"SX", (Object[])new Integer[]{2, 2, 1, 0, 2, 2}).putAll((Object)"SY", (Object[])new Integer[]{4, 3, 3, 2, 2, 2}).putAll((Object)"SZ", (Object[])new Integer[]{3, 3, 2, 4, 2, 2}).putAll((Object)"TC", (Object[])new Integer[]{2, 2, 2, 0, 2, 2}).putAll((Object)"TD", (Object[])new Integer[]{4, 3, 4, 4, 2, 2}).putAll((Object)"TG", (Object[])new Integer[]{3, 2, 2, 4, 2, 2}).putAll((Object)"TH", (Object[])new Integer[]{0, 3, 2, 3, 2, 2}).putAll((Object)"TJ", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"TL", (Object[])new Integer[]{4, 0, 4, 4, 2, 2}).putAll((Object)"TM", (Object[])new Integer[]{4, 2, 4, 3, 2, 2}).putAll((Object)"TN", (Object[])new Integer[]{2, 1, 1, 2, 2, 2}).putAll((Object)"TO", (Object[])new Integer[]{3, 3, 4, 3, 2, 2}).putAll((Object)"TR", (Object[])new Integer[]{1, 2, 1, 1, 2, 2}).putAll((Object)"TT", (Object[])new Integer[]{1, 4, 0, 1, 2, 2}).putAll((Object)"TV", (Object[])new Integer[]{3, 2, 2, 4, 2, 2}).putAll((Object)"TW", (Object[])new Integer[]{0, 0, 0, 0, 1, 0}).putAll((Object)"TZ", (Object[])new Integer[]{3, 3, 3, 2, 2, 2}).putAll((Object)"UA", (Object[])new Integer[]{0, 3, 1, 1, 2, 2}).putAll((Object)"UG", (Object[])new Integer[]{3, 2, 3, 3, 2, 2}).putAll((Object)"US", (Object[])new Integer[]{1, 1, 2, 2, 4, 2}).putAll((Object)"UY", (Object[])new Integer[]{2, 2, 1, 1, 2, 2}).putAll((Object)"UZ", (Object[])new Integer[]{2, 1, 3, 4, 2, 2}).putAll((Object)"VC", (Object[])new Integer[]{1, 2, 2, 2, 2, 2}).putAll((Object)"VE", (Object[])new Integer[]{4, 4, 4, 4, 2, 2}).putAll((Object)"VG", (Object[])new Integer[]{2, 2, 1, 1, 2, 2}).putAll((Object)"VI", (Object[])new Integer[]{1, 2, 1, 2, 2, 2}).putAll((Object)"VN", (Object[])new Integer[]{0, 1, 3, 4, 2, 2}).putAll((Object)"VU", (Object[])new Integer[]{4, 0, 3, 1, 2, 2}).putAll((Object)"WF", (Object[])new Integer[]{4, 2, 2, 4, 2, 2}).putAll((Object)"WS", (Object[])new Integer[]{3, 1, 3, 1, 2, 2}).putAll((Object)"XK", (Object[])new Integer[]{0, 1, 1, 0, 2, 2}).putAll((Object)"YE", (Object[])new Integer[]{4, 4, 4, 3, 2, 2}).putAll((Object)"YT", (Object[])new Integer[]{4, 2, 2, 3, 2, 2}).putAll((Object)"ZA", (Object[])new Integer[]{3, 3, 2, 1, 2, 2}).putAll((Object)"ZM", (Object[])new Integer[]{3, 2, 3, 3, 2, 2}).putAll((Object)"ZW", (Object[])new Integer[]{3, 2, 4, 3, 2, 2}).build();
    }

    public static final class Builder {
        @Nullable
        private final Context context;
        private Map<Integer, Long> initialBitrateEstimates;
        private int slidingWindowMaxWeight;
        private Clock clock;
        private boolean resetOnNetworkTypeChange;

        public Builder(Context context) {
            this.context = context == null ? null : context.getApplicationContext();
            this.initialBitrateEstimates = Builder.getInitialBitrateEstimatesForCountry(Util.getCountryCode((Context)context));
            this.slidingWindowMaxWeight = 2000;
            this.clock = Clock.DEFAULT;
            this.resetOnNetworkTypeChange = true;
        }

        public Builder setSlidingWindowMaxWeight(int slidingWindowMaxWeight) {
            this.slidingWindowMaxWeight = slidingWindowMaxWeight;
            return this;
        }

        public Builder setInitialBitrateEstimate(long initialBitrateEstimate) {
            for (Integer networkType : this.initialBitrateEstimates.keySet()) {
                this.setInitialBitrateEstimate(networkType, initialBitrateEstimate);
            }
            return this;
        }

        public Builder setInitialBitrateEstimate(int networkType, long initialBitrateEstimate) {
            this.initialBitrateEstimates.put(networkType, initialBitrateEstimate);
            return this;
        }

        public Builder setInitialBitrateEstimate(String countryCode) {
            this.initialBitrateEstimates = Builder.getInitialBitrateEstimatesForCountry(Ascii.toUpperCase((String)countryCode));
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setResetOnNetworkTypeChange(boolean resetOnNetworkTypeChange) {
            this.resetOnNetworkTypeChange = resetOnNetworkTypeChange;
            return this;
        }

        public DefaultBandwidthMeter build() {
            return new DefaultBandwidthMeter(this.context, this.initialBitrateEstimates, this.slidingWindowMaxWeight, this.clock, this.resetOnNetworkTypeChange);
        }

        private static Map<Integer, Long> getInitialBitrateEstimatesForCountry(String countryCode) {
            ImmutableList<Integer> groupIndices = Builder.getCountryGroupIndices(countryCode);
            HashMap<Integer, Long> result = new HashMap<Integer, Long>(8);
            result.put(0, 1000000L);
            result.put(2, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI.get(((Integer)groupIndices.get(0)).intValue()));
            result.put(3, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_2G.get(((Integer)groupIndices.get(1)).intValue()));
            result.put(4, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_3G.get(((Integer)groupIndices.get(2)).intValue()));
            result.put(5, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_4G.get(((Integer)groupIndices.get(3)).intValue()));
            result.put(10, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_NSA.get(((Integer)groupIndices.get(4)).intValue()));
            result.put(9, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_5G_SA.get(((Integer)groupIndices.get(5)).intValue()));
            result.put(7, (Long)DEFAULT_INITIAL_BITRATE_ESTIMATES_WIFI.get(((Integer)groupIndices.get(0)).intValue()));
            return result;
        }

        private static ImmutableList<Integer> getCountryGroupIndices(String countryCode) {
            ImmutableList groupIndices = DEFAULT_INITIAL_BITRATE_COUNTRY_GROUPS.get((Object)countryCode);
            return groupIndices.isEmpty() ? ImmutableList.of((Object)2, (Object)2, (Object)2, (Object)2, (Object)2, (Object)2) : groupIndices;
        }
    }
}

