/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DefaultLoadErrorHandlingPolicy
implements LoadErrorHandlingPolicy {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_PROGRESSIVE_LIVE = 6;
    public static final long DEFAULT_TRACK_BLACKLIST_MS = 60000L;
    private static final int DEFAULT_BEHAVIOR_MIN_LOADABLE_RETRY_COUNT = -1;
    private final int minimumLoadableRetryCount;

    public DefaultLoadErrorHandlingPolicy() {
        this(-1);
    }

    public DefaultLoadErrorHandlingPolicy(int minimumLoadableRetryCount) {
        this.minimumLoadableRetryCount = minimumLoadableRetryCount;
    }

    @Override
    public long getBlacklistDurationMsFor(LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo) {
        IOException exception = loadErrorInfo.exception;
        if (exception instanceof HttpDataSource.InvalidResponseCodeException) {
            int responseCode = ((HttpDataSource.InvalidResponseCodeException)exception).responseCode;
            return responseCode == 403 || responseCode == 404 || responseCode == 410 || responseCode == 416 || responseCode == 500 || responseCode == 503 ? 60000L : -9223372036854775807L;
        }
        return -9223372036854775807L;
    }

    @Override
    public long getRetryDelayMsFor(LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo) {
        IOException exception = loadErrorInfo.exception;
        return exception instanceof ParserException || exception instanceof FileNotFoundException || exception instanceof HttpDataSource.CleartextNotPermittedException || exception instanceof Loader.UnexpectedLoaderException ? -9223372036854775807L : (long)Math.min((loadErrorInfo.errorCount - 1) * 1000, 5000);
    }

    @Override
    public int getMinimumLoadableRetryCount(int dataType) {
        if (this.minimumLoadableRetryCount == -1) {
            return dataType == 7 ? 6 : 3;
        }
        return this.minimumLoadableRetryCount;
    }
}

