/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileDataSource
extends BaseDataSource {
    @Nullable
    private RandomAccessFile file;
    @Nullable
    private Uri uri;
    private long bytesRemaining;
    private boolean opened;

    public FileDataSource() {
        super(false);
    }

    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            Uri uri;
            this.uri = uri = dataSpec.uri;
            this.transferInitializing(dataSpec);
            this.file = FileDataSource.openLocalFile(uri);
            this.file.seek(dataSpec.position);
            long l = this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            if (this.bytesRemaining < 0L) {
                throw new DataSourceException(0);
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int readLength) throws FileDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            bytesRead = ((RandomAccessFile)Util.castNonNull((Object)this.file)).read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)readLength));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        if (bytesRead > 0) {
            this.bytesRemaining -= (long)bytesRead;
            this.bytesTransferred(bytesRead);
        }
        return bytesRead;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    public void close() throws FileDataSourceException {
        this.uri = null;
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        finally {
            this.file = null;
            if (this.opened) {
                this.opened = false;
                this.transferEnded();
            }
        }
    }

    private static RandomAccessFile openLocalFile(Uri uri) throws FileDataSourceException {
        try {
            return new RandomAccessFile((String)Assertions.checkNotNull((Object)uri.getPath()), "r");
        }
        catch (FileNotFoundException e) {
            if (!TextUtils.isEmpty((CharSequence)uri.getQuery()) || !TextUtils.isEmpty((CharSequence)uri.getFragment())) {
                throw new FileDataSourceException(String.format("uri has query and/or fragment, which are not supported. Did you call Uri.parse() on a string containing '?' or '#'? Use Uri.fromFile(new File(path)) to avoid this. path=%s,query=%s,fragment=%s", uri.getPath(), uri.getQuery(), uri.getFragment()), e);
            }
            throw new FileDataSourceException(e);
        }
    }

    public static final class Factory
    implements DataSource.Factory {
        @Nullable
        private TransferListener listener;

        public Factory setListener(@Nullable TransferListener listener) {
            this.listener = listener;
            return this;
        }

        public FileDataSource createDataSource() {
            FileDataSource dataSource = new FileDataSource();
            if (this.listener != null) {
                dataSource.addTransferListener(this.listener);
            }
            return dataSource;
        }
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException cause) {
            super(cause);
        }

        public FileDataSourceException(String message, IOException cause) {
            super(message, cause);
        }
    }
}

