/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public final class RawResourceDataSource
extends BaseDataSource {
    public static final String RAW_RESOURCE_SCHEME = "rawresource";
    private final Resources resources;
    private final String packageName;
    @Nullable
    private Uri uri;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public static Uri buildRawResourceUri(int rawResourceId) {
        return Uri.parse((String)new StringBuilder(26).append("rawresource:///").append(rawResourceId).toString());
    }

    public RawResourceDataSource(Context context) {
        super(false);
        this.resources = context.getResources();
        this.packageName = context.getPackageName();
    }

    public long open(DataSpec dataSpec) throws RawResourceDataSourceException {
        AssetFileDescriptor assetFileDescriptor;
        int resourceId;
        Uri uri;
        this.uri = uri = dataSpec.uri;
        if (TextUtils.equals((CharSequence)RAW_RESOURCE_SCHEME, (CharSequence)uri.getScheme()) || TextUtils.equals((CharSequence)"android.resource", (CharSequence)uri.getScheme()) && uri.getPathSegments().size() == 1 && ((String)Assertions.checkNotNull((Object)uri.getLastPathSegment())).matches("\\d+")) {
            try {
                resourceId = Integer.parseInt((String)Assertions.checkNotNull((Object)uri.getLastPathSegment()));
            }
            catch (NumberFormatException e) {
                throw new RawResourceDataSourceException("Resource identifier must be an integer.");
            }
        } else if (TextUtils.equals((CharSequence)"android.resource", (CharSequence)uri.getScheme())) {
            String host;
            String path = (String)Assertions.checkNotNull((Object)uri.getPath());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String string = String.valueOf(TextUtils.isEmpty((CharSequence)(host = uri.getHost())) ? "" : String.valueOf(host).concat(":"));
            String string2 = String.valueOf(path);
            String resourceName = string2.length() != 0 ? string.concat(string2) : new String(string);
            resourceId = this.resources.getIdentifier(resourceName, "raw", this.packageName);
            if (resourceId == 0) {
                throw new RawResourceDataSourceException("Resource not found.");
            }
        } else {
            throw new RawResourceDataSourceException("URI must either use scheme rawresource or android.resource");
        }
        this.transferInitializing(dataSpec);
        try {
            assetFileDescriptor = this.resources.openRawResourceFd(resourceId);
        }
        catch (Resources.NotFoundException e) {
            throw new RawResourceDataSourceException(e);
        }
        this.assetFileDescriptor = assetFileDescriptor;
        if (assetFileDescriptor == null) {
            String e = String.valueOf(uri);
            throw new RawResourceDataSourceException(new StringBuilder(24 + String.valueOf(e).length()).append("Resource is compressed: ").append(e).toString());
        }
        long assetFileDescriptorLength = assetFileDescriptor.getLength();
        FileInputStream inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
        this.inputStream = inputStream;
        try {
            if (assetFileDescriptorLength != -1L && dataSpec.position > assetFileDescriptorLength) {
                throw new DataSourceException(0);
            }
            long assetFileDescriptorOffset = assetFileDescriptor.getStartOffset();
            long skipped = inputStream.skip(assetFileDescriptorOffset + dataSpec.position) - assetFileDescriptorOffset;
            if (skipped != dataSpec.position) {
                throw new DataSourceException(0);
            }
            if (assetFileDescriptorLength == -1L) {
                FileChannel channel = inputStream.getChannel();
                if (channel.size() == 0L) {
                    this.bytesRemaining = -1L;
                } else {
                    this.bytesRemaining = channel.size() - channel.position();
                    if (this.bytesRemaining < 0L) {
                        throw new DataSourceException(0);
                    }
                }
            } else {
                this.bytesRemaining = assetFileDescriptorLength - skipped;
                if (this.bytesRemaining < 0L) {
                    throw new DataSourceException(0);
                }
            }
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int readLength) throws RawResourceDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = ((InputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new RawResourceDataSourceException(new EOFException());
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws RawResourceDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new RawResourceDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    public static class RawResourceDataSourceException
    extends IOException {
        public RawResourceDataSourceException(String message) {
            super(message);
        }

        public RawResourceDataSourceException(Throwable e) {
            super(e);
        }
    }
}

