/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.video.VideoDecoderOutputBuffer;
import com.google.android.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class VideoDecoderGLSurfaceView
extends GLSurfaceView
implements VideoDecoderOutputBufferRenderer {
    private final Renderer renderer = new Renderer(this);

    public VideoDecoderGLSurfaceView(Context context) {
        this(context, null);
    }

    public VideoDecoderGLSurfaceView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setPreserveEGLContextOnPause(true);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.renderer);
        this.setRenderMode(0);
    }

    @Override
    public void setOutputBuffer(VideoDecoderOutputBuffer outputBuffer) {
        this.renderer.setOutputBuffer(outputBuffer);
    }

    @Deprecated
    public VideoDecoderOutputBufferRenderer getVideoDecoderOutputBufferRenderer() {
        return this;
    }

    private static final class Renderer
    implements GLSurfaceView.Renderer {
        private static final float[] kColorConversion601 = new float[]{1.164f, 1.164f, 1.164f, 0.0f, -0.392f, 2.017f, 1.596f, -0.813f, 0.0f};
        private static final float[] kColorConversion709 = new float[]{1.164f, 1.164f, 1.164f, 0.0f, -0.213f, 2.112f, 1.793f, -0.533f, 0.0f};
        private static final float[] kColorConversion2020 = new float[]{1.168f, 1.168f, 1.168f, 0.0f, -0.188f, 2.148f, 1.683f, -0.652f, 0.0f};
        private static final String VERTEX_SHADER = "varying vec2 interp_tc_y;\nvarying vec2 interp_tc_u;\nvarying vec2 interp_tc_v;\nattribute vec4 in_pos;\nattribute vec2 in_tc_y;\nattribute vec2 in_tc_u;\nattribute vec2 in_tc_v;\nvoid main() {\n  gl_Position = in_pos;\n  interp_tc_y = in_tc_y;\n  interp_tc_u = in_tc_u;\n  interp_tc_v = in_tc_v;\n}\n";
        private static final String[] TEXTURE_UNIFORMS = new String[]{"y_tex", "u_tex", "v_tex"};
        private static final String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 interp_tc_y;\nvarying vec2 interp_tc_u;\nvarying vec2 interp_tc_v;\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\nuniform mat3 mColorConversion;\nvoid main() {\n  vec3 yuv;\n  yuv.x = texture2D(y_tex, interp_tc_y).r - 0.0625;\n  yuv.y = texture2D(u_tex, interp_tc_u).r - 0.5;\n  yuv.z = texture2D(v_tex, interp_tc_v).r - 0.5;\n  gl_FragColor = vec4(mColorConversion * yuv, 1.0);\n}\n";
        private static final FloatBuffer TEXTURE_VERTICES = GlUtil.createBuffer((float[])new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f});
        private final GLSurfaceView surfaceView;
        private final int[] yuvTextures;
        private final int[] texLocations;
        private final int[] previousWidths;
        private final int[] previousStrides;
        private final AtomicReference<@NullableType VideoDecoderOutputBuffer> pendingOutputBufferReference;
        private final FloatBuffer[] textureCoords;
        private int program;
        private int colorMatrixLocation;
        private @MonotonicNonNull VideoDecoderOutputBuffer renderedOutputBuffer;

        public Renderer(GLSurfaceView surfaceView) {
            this.surfaceView = surfaceView;
            this.yuvTextures = new int[3];
            this.texLocations = new int[3];
            this.previousWidths = new int[3];
            this.previousStrides = new int[3];
            this.pendingOutputBufferReference = new AtomicReference();
            this.textureCoords = new FloatBuffer[3];
            for (int i = 0; i < 3; ++i) {
                this.previousStrides[i] = -1;
                this.previousWidths[i] = -1;
            }
        }

        public void onSurfaceCreated(GL10 unused, EGLConfig config) {
            this.program = GlUtil.compileProgram((String)VERTEX_SHADER, (String)FRAGMENT_SHADER);
            GLES20.glUseProgram((int)this.program);
            int posLocation = GLES20.glGetAttribLocation((int)this.program, (String)"in_pos");
            GLES20.glEnableVertexAttribArray((int)posLocation);
            GLES20.glVertexAttribPointer((int)posLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)TEXTURE_VERTICES);
            this.texLocations[0] = GLES20.glGetAttribLocation((int)this.program, (String)"in_tc_y");
            GLES20.glEnableVertexAttribArray((int)this.texLocations[0]);
            this.texLocations[1] = GLES20.glGetAttribLocation((int)this.program, (String)"in_tc_u");
            GLES20.glEnableVertexAttribArray((int)this.texLocations[1]);
            this.texLocations[2] = GLES20.glGetAttribLocation((int)this.program, (String)"in_tc_v");
            GLES20.glEnableVertexAttribArray((int)this.texLocations[2]);
            GlUtil.checkGlError();
            this.colorMatrixLocation = GLES20.glGetUniformLocation((int)this.program, (String)"mColorConversion");
            GlUtil.checkGlError();
            this.setupTextures();
            GlUtil.checkGlError();
        }

        public void onSurfaceChanged(GL10 unused, int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        }

        public void onDrawFrame(GL10 unused) {
            VideoDecoderOutputBuffer pendingOutputBuffer = this.pendingOutputBufferReference.getAndSet(null);
            if (pendingOutputBuffer == null && this.renderedOutputBuffer == null) {
                return;
            }
            if (pendingOutputBuffer != null) {
                if (this.renderedOutputBuffer != null) {
                    this.renderedOutputBuffer.release();
                }
                this.renderedOutputBuffer = pendingOutputBuffer;
            }
            VideoDecoderOutputBuffer outputBuffer = (VideoDecoderOutputBuffer)((Object)Assertions.checkNotNull((Object)((Object)this.renderedOutputBuffer)));
            float[] colorConversion = kColorConversion709;
            switch (outputBuffer.colorspace) {
                case 1: {
                    colorConversion = kColorConversion601;
                    break;
                }
                case 3: {
                    colorConversion = kColorConversion2020;
                    break;
                }
            }
            GLES20.glUniformMatrix3fv((int)this.colorMatrixLocation, (int)1, (boolean)false, (float[])colorConversion, (int)0);
            int[] yuvStrides = (int[])Assertions.checkNotNull((Object)outputBuffer.yuvStrides);
            ByteBuffer[] yuvPlanes = (ByteBuffer[])Assertions.checkNotNull((Object)outputBuffer.yuvPlanes);
            for (int i = 0; i < 3; ++i) {
                int h = i == 0 ? outputBuffer.height : (outputBuffer.height + 1) / 2;
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[i]);
                GLES20.glPixelStorei((int)3317, (int)1);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)yuvStrides[i], (int)h, (int)0, (int)6409, (int)5121, (Buffer)yuvPlanes[i]);
            }
            int[] widths = new int[3];
            widths[0] = outputBuffer.width;
            widths[1] = widths[2] = (widths[0] + 1) / 2;
            for (int i = 0; i < 3; ++i) {
                if (this.previousWidths[i] == widths[i] && this.previousStrides[i] == yuvStrides[i]) continue;
                Assertions.checkState((yuvStrides[i] != 0 ? 1 : 0) != 0);
                float widthRatio = (float)widths[i] / (float)yuvStrides[i];
                this.textureCoords[i] = GlUtil.createBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f, widthRatio, 0.0f, widthRatio, 1.0f});
                GLES20.glVertexAttribPointer((int)this.texLocations[i], (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.textureCoords[i]);
                this.previousWidths[i] = widths[i];
                this.previousStrides[i] = yuvStrides[i];
            }
            GLES20.glClear((int)16384);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GlUtil.checkGlError();
        }

        public void setOutputBuffer(VideoDecoderOutputBuffer outputBuffer) {
            VideoDecoderOutputBuffer oldPendingOutputBuffer = this.pendingOutputBufferReference.getAndSet(outputBuffer);
            if (oldPendingOutputBuffer != null) {
                oldPendingOutputBuffer.release();
            }
            this.surfaceView.requestRender();
        }

        private void setupTextures() {
            GLES20.glGenTextures((int)3, (int[])this.yuvTextures, (int)0);
            for (int i = 0; i < 3; ++i) {
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)TEXTURE_UNIFORMS[i]), (int)i);
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[i]);
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            }
            GlUtil.checkGlError();
        }
    }
}

