/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;

public interface VideoRendererEventListener {
    default public void onVideoEnabled(DecoderCounters counters) {
    }

    default public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    default public void onVideoInputFormatChanged(Format format) {
    }

    default public void onVideoInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    default public void onDroppedFrames(int count, long elapsedMs) {
    }

    default public void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
    }

    default public void onVideoSizeChanged(VideoSize videoSize) {
    }

    default public void onRenderedFirstFrame(Object output, long renderTimeMs) {
    }

    default public void onVideoDecoderReleased(String decoderName) {
    }

    default public void onVideoDisabled(DecoderCounters counters) {
    }

    default public void onVideoCodecError(Exception videoCodecError) {
    }

    public static final class EventDispatcher {
        @Nullable
        private final Handler handler;
        @Nullable
        private final VideoRendererEventListener listener;

        public EventDispatcher(@Nullable Handler handler, @Nullable VideoRendererEventListener listener) {
            this.handler = listener != null ? (Handler)Assertions.checkNotNull((Object)handler) : null;
            this.listener = listener;
        }

        public void enabled(DecoderCounters decoderCounters) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoEnabled(decoderCounters));
            }
        }

        public void decoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs));
            }
        }

        public void inputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            if (this.handler != null) {
                this.handler.post(() -> {
                    ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoInputFormatChanged(format);
                    ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoInputFormatChanged(format, decoderReuseEvaluation);
                });
            }
        }

        public void droppedFrames(int droppedFrameCount, long elapsedMs) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onDroppedFrames(droppedFrameCount, elapsedMs));
            }
        }

        public void reportVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoFrameProcessingOffset(totalProcessingOffsetUs, frameCount));
            }
        }

        public void videoSizeChanged(VideoSize videoSize) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoSizeChanged(videoSize));
            }
        }

        public void renderedFirstFrame(Object output) {
            if (this.handler != null) {
                long renderTimeMs = SystemClock.elapsedRealtime();
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onRenderedFirstFrame(output, renderTimeMs));
            }
        }

        public void decoderReleased(String decoderName) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoDecoderReleased(decoderName));
            }
        }

        public void disabled(DecoderCounters counters) {
            counters.ensureUpdated();
            if (this.handler != null) {
                this.handler.post(() -> {
                    counters.ensureUpdated();
                    ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoDisabled(counters);
                });
            }
        }

        public void videoCodecError(Exception videoCodecError) {
            if (this.handler != null) {
                this.handler.post(() -> ((VideoRendererEventListener)Util.castNonNull((Object)this.listener)).onVideoCodecError(videoCodecError));
            }
        }
    }
}

