/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video.spherical;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.view.Display;
import androidx.annotation.BinderThread;
import com.google.android.exoplayer2.video.spherical.FrameRotationQueue;

final class OrientationListener
implements SensorEventListener {
    private final float[] deviceOrientationMatrix4x4 = new float[16];
    private final float[] tempMatrix4x4 = new float[16];
    private final float[] recenterMatrix4x4 = new float[16];
    private final float[] angles = new float[3];
    private final Display display;
    private final Listener[] listeners;
    private boolean recenterMatrixComputed;

    public OrientationListener(Display display, Listener ... listeners) {
        this.display = display;
        this.listeners = listeners;
    }

    @BinderThread
    public void onSensorChanged(SensorEvent event) {
        SensorManager.getRotationMatrixFromVector((float[])this.deviceOrientationMatrix4x4, (float[])event.values);
        this.rotateAroundZ(this.deviceOrientationMatrix4x4, this.display.getRotation());
        float roll = this.extractRoll(this.deviceOrientationMatrix4x4);
        OrientationListener.rotateYtoSky(this.deviceOrientationMatrix4x4);
        this.recenter(this.deviceOrientationMatrix4x4);
        this.notifyListeners(this.deviceOrientationMatrix4x4, roll);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void notifyListeners(float[] deviceOrientationMatrix, float roll) {
        for (Listener listener : this.listeners) {
            listener.onOrientationChange(deviceOrientationMatrix, roll);
        }
    }

    private void recenter(float[] matrix) {
        if (!this.recenterMatrixComputed) {
            FrameRotationQueue.computeRecenterMatrix(this.recenterMatrix4x4, matrix);
            this.recenterMatrixComputed = true;
        }
        System.arraycopy(matrix, 0, this.tempMatrix4x4, 0, this.tempMatrix4x4.length);
        Matrix.multiplyMM((float[])matrix, (int)0, (float[])this.tempMatrix4x4, (int)0, (float[])this.recenterMatrix4x4, (int)0);
    }

    private float extractRoll(float[] matrix) {
        SensorManager.remapCoordinateSystem((float[])matrix, (int)1, (int)131, (float[])this.tempMatrix4x4);
        SensorManager.getOrientation((float[])this.tempMatrix4x4, (float[])this.angles);
        return this.angles[2];
    }

    private void rotateAroundZ(float[] matrix, int rotation) {
        int yAxis;
        int xAxis;
        switch (rotation) {
            case 3: {
                xAxis = 130;
                yAxis = 1;
                break;
            }
            case 2: {
                xAxis = 129;
                yAxis = 130;
                break;
            }
            case 1: {
                xAxis = 2;
                yAxis = 129;
                break;
            }
            case 0: {
                return;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        System.arraycopy(matrix, 0, this.tempMatrix4x4, 0, this.tempMatrix4x4.length);
        SensorManager.remapCoordinateSystem((float[])this.tempMatrix4x4, (int)xAxis, (int)yAxis, (float[])matrix);
    }

    private static void rotateYtoSky(float[] matrix) {
        Matrix.rotateM((float[])matrix, (int)0, (float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static interface Listener {
        public void onOrientationChange(float[] var1, float var2);
    }
}

