/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video.spherical;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.spherical.Projection;
import java.util.ArrayList;
import java.util.zip.Inflater;

final class ProjectionDecoder {
    private static final int TYPE_YTMP = 2037673328;
    private static final int TYPE_MSHP = 1836279920;
    private static final int TYPE_RAW = 1918990112;
    private static final int TYPE_DFL8 = 1684433976;
    private static final int TYPE_MESH = 1835365224;
    private static final int TYPE_PROJ = 1886547818;
    private static final int MAX_COORDINATE_COUNT = 10000;
    private static final int MAX_VERTEX_COUNT = 32000;
    private static final int MAX_TRIANGLE_INDICES = 128000;

    private ProjectionDecoder() {
    }

    @Nullable
    public static Projection decode(byte[] projectionData, int stereoMode) {
        ParsableByteArray input = new ParsableByteArray(projectionData);
        ArrayList<Projection.Mesh> meshes = null;
        try {
            meshes = ProjectionDecoder.isProj(input) ? ProjectionDecoder.parseProj(input) : ProjectionDecoder.parseMshp(input);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (meshes == null) {
            return null;
        }
        switch (meshes.size()) {
            case 1: {
                return new Projection(meshes.get(0), stereoMode);
            }
            case 2: {
                return new Projection(meshes.get(0), meshes.get(1), stereoMode);
            }
        }
        return null;
    }

    private static boolean isProj(ParsableByteArray input) {
        input.skipBytes(4);
        int type = input.readInt();
        input.setPosition(0);
        return type == 1886547818;
    }

    @Nullable
    private static ArrayList<Projection.Mesh> parseProj(ParsableByteArray input) {
        input.skipBytes(8);
        int position = input.getPosition();
        int limit = input.limit();
        while (position < limit) {
            int childEnd = position + input.readInt();
            if (childEnd <= position || childEnd > limit) {
                return null;
            }
            int childAtomType = input.readInt();
            if (childAtomType == 2037673328 || childAtomType == 1836279920) {
                input.setLimit(childEnd);
                return ProjectionDecoder.parseMshp(input);
            }
            position = childEnd;
            input.setPosition(position);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ArrayList<Projection.Mesh> parseMshp(ParsableByteArray input) {
        int version = input.readUnsignedByte();
        if (version != 0) {
            return null;
        }
        input.skipBytes(7);
        int encoding = input.readInt();
        if (encoding == 1684433976) {
            ParsableByteArray output = new ParsableByteArray();
            Inflater inflater = new Inflater(true);
            try {
                if (!Util.inflate((ParsableByteArray)input, (ParsableByteArray)output, (Inflater)inflater)) {
                    ArrayList<Projection.Mesh> arrayList = null;
                    return arrayList;
                }
            }
            finally {
                inflater.end();
            }
            input = output;
        } else if (encoding != 1918990112) {
            return null;
        }
        return ProjectionDecoder.parseRawMshpData(input);
    }

    @Nullable
    private static ArrayList<Projection.Mesh> parseRawMshpData(ParsableByteArray input) {
        ArrayList<Projection.Mesh> meshes = new ArrayList<Projection.Mesh>();
        int position = input.getPosition();
        int limit = input.limit();
        while (position < limit) {
            int childEnd = position + input.readInt();
            if (childEnd <= position || childEnd > limit) {
                return null;
            }
            int childAtomType = input.readInt();
            if (childAtomType == 1835365224) {
                Projection.Mesh mesh = ProjectionDecoder.parseMesh(input);
                if (mesh == null) {
                    return null;
                }
                meshes.add(mesh);
            }
            position = childEnd;
            input.setPosition(position);
        }
        return meshes;
    }

    @Nullable
    private static Projection.Mesh parseMesh(ParsableByteArray input) {
        int coordinateCount = input.readInt();
        if (coordinateCount > 10000) {
            return null;
        }
        float[] coordinates = new float[coordinateCount];
        for (int coordinate = 0; coordinate < coordinateCount; ++coordinate) {
            coordinates[coordinate] = input.readFloat();
        }
        int vertexCount = input.readInt();
        if (vertexCount > 32000) {
            return null;
        }
        double log2 = Math.log(2.0);
        int coordinateCountSizeBits = (int)Math.ceil(Math.log(2.0 * (double)coordinateCount) / log2);
        ParsableBitArray bitInput = new ParsableBitArray(input.getData());
        bitInput.setPosition(input.getPosition() * 8);
        float[] vertices = new float[vertexCount * 5];
        int[] coordinateIndices = new int[5];
        int vertexIndex = 0;
        for (int vertex = 0; vertex < vertexCount; ++vertex) {
            for (int i = 0; i < 5; ++i) {
                int coordinateIndex = coordinateIndices[i] + ProjectionDecoder.decodeZigZag(bitInput.readBits(coordinateCountSizeBits));
                if (coordinateIndex >= coordinateCount || coordinateIndex < 0) {
                    return null;
                }
                vertices[vertexIndex++] = coordinates[coordinateIndex];
                coordinateIndices[i] = coordinateIndex;
            }
        }
        bitInput.setPosition(bitInput.getPosition() + 7 & 0xFFFFFFF8);
        int subMeshCount = bitInput.readBits(32);
        Projection.SubMesh[] subMeshes = new Projection.SubMesh[subMeshCount];
        for (int i = 0; i < subMeshCount; ++i) {
            int textureId = bitInput.readBits(8);
            int drawMode = bitInput.readBits(8);
            int triangleIndexCount = bitInput.readBits(32);
            if (triangleIndexCount > 128000) {
                return null;
            }
            int vertexCountSizeBits = (int)Math.ceil(Math.log(2.0 * (double)vertexCount) / log2);
            int index = 0;
            float[] triangleVertices = new float[triangleIndexCount * 3];
            float[] textureCoords = new float[triangleIndexCount * 2];
            for (int counter = 0; counter < triangleIndexCount; ++counter) {
                if ((index += ProjectionDecoder.decodeZigZag(bitInput.readBits(vertexCountSizeBits))) < 0 || index >= vertexCount) {
                    return null;
                }
                triangleVertices[counter * 3] = vertices[index * 5];
                triangleVertices[counter * 3 + 1] = vertices[index * 5 + 1];
                triangleVertices[counter * 3 + 2] = vertices[index * 5 + 2];
                textureCoords[counter * 2] = vertices[index * 5 + 3];
                textureCoords[counter * 2 + 1] = vertices[index * 5 + 4];
            }
            subMeshes[i] = new Projection.SubMesh(textureId, triangleVertices, textureCoords, drawMode);
        }
        return new Projection.Mesh(subMeshes);
    }

    private static int decodeZigZag(int n) {
        return n >> 1 ^ -(n & 1);
    }
}

