/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.AudioTrack;
import android.media.MediaFormat;
import android.media.metrics.LogSessionId;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.AudioBecomingNoisyManager;
import com.google.android.exoplayer2.AudioFocusManager;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.DeviceInfo;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerImplInternal;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ExoTimeoutException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.MediaSourceInfoHolder;
import com.google.android.exoplayer2.MediaSourceList;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.PlaylistTimeline;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.StreamVolumeManager;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.TracksInfo;
import com.google.android.exoplayer2.WakeLockManager;
import com.google.android.exoplayer2.WifiLockManager;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import com.google.android.exoplayer2.video.spherical.SphericalGLSurfaceView;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;

final class ExoPlayerImpl
extends BasePlayer
implements ExoPlayer,
ExoPlayer.AudioComponent,
ExoPlayer.VideoComponent,
ExoPlayer.TextComponent,
ExoPlayer.DeviceComponent {
    private static final String TAG = "ExoPlayerImpl";
    final TrackSelectorResult emptyTrackSelectorResult;
    final Player.Commands permanentAvailableCommands;
    private final ConditionVariable constructorFinished = new ConditionVariable();
    private final Context applicationContext;
    private final Player wrappingPlayer;
    private final Renderer[] renderers;
    private final TrackSelector trackSelector;
    private final HandlerWrapper playbackInfoUpdateHandler;
    private final ExoPlayerImplInternal.PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final ExoPlayerImplInternal internalPlayer;
    private final ListenerSet<Player.Listener> listeners;
    private final CopyOnWriteArraySet<ExoPlayer.AudioOffloadListener> audioOffloadListeners;
    private final Timeline.Period period;
    private final List<MediaSourceHolderSnapshot> mediaSourceHolderSnapshots;
    private final boolean useLazyPreparation;
    private final MediaSource.Factory mediaSourceFactory;
    private final AnalyticsCollector analyticsCollector;
    private final Looper applicationLooper;
    private final BandwidthMeter bandwidthMeter;
    private final long seekBackIncrementMs;
    private final long seekForwardIncrementMs;
    private final Clock clock;
    private final ComponentListener componentListener;
    private final FrameMetadataListener frameMetadataListener;
    private final AudioBecomingNoisyManager audioBecomingNoisyManager;
    private final AudioFocusManager audioFocusManager;
    private final StreamVolumeManager streamVolumeManager;
    private final WakeLockManager wakeLockManager;
    private final WifiLockManager wifiLockManager;
    private final long detachSurfaceTimeoutMs;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private int pendingOperationAcks;
    private int pendingDiscontinuityReason;
    private boolean pendingDiscontinuity;
    private int pendingPlayWhenReadyChangeReason;
    private boolean foregroundMode;
    private SeekParameters seekParameters;
    private ShuffleOrder shuffleOrder;
    private boolean pauseAtEndOfMediaItems;
    private Player.Commands availableCommands;
    private MediaMetadata mediaMetadata;
    private MediaMetadata playlistMetadata;
    @Nullable
    private Format videoFormat;
    @Nullable
    private Format audioFormat;
    @Nullable
    private AudioTrack keepSessionIdAudioTrack;
    @Nullable
    private Object videoOutput;
    @Nullable
    private Surface ownedSurface;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private SphericalGLSurfaceView sphericalGLSurfaceView;
    private boolean surfaceHolderSurfaceIsVideoOutput;
    @Nullable
    private TextureView textureView;
    private int videoScalingMode;
    private int videoChangeFrameRateStrategy;
    private int surfaceWidth;
    private int surfaceHeight;
    @Nullable
    private DecoderCounters videoDecoderCounters;
    @Nullable
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private AudioAttributes audioAttributes;
    private float volume;
    private boolean skipSilenceEnabled;
    private List<Cue> currentCues;
    @Nullable
    private VideoFrameMetadataListener videoFrameMetadataListener;
    @Nullable
    private CameraMotionListener cameraMotionListener;
    private boolean throwsWhenUsingWrongThread;
    private boolean hasNotifiedFullWrongThreadWarning;
    @Nullable
    private PriorityTaskManager priorityTaskManager;
    private boolean isPriorityTaskManagerRegistered;
    private boolean playerReleased;
    private DeviceInfo deviceInfo;
    private VideoSize videoSize;
    private MediaMetadata staticAndDynamicMediaMetadata;
    private PlaybackInfo playbackInfo;
    private int maskingWindowIndex;
    private int maskingPeriodIndex;
    private long maskingWindowPositionMs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(ExoPlayer.Builder builder, @Nullable Player wrappingPlayer) {
        try {
            String string = Integer.toHexString(System.identityHashCode(this));
            String string2 = Util.DEVICE_DEBUG_INFO;
            Log.i((String)TAG, (String)new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Init ").append(string).append(" [").append("ExoPlayerLib/2.17.1").append("] [").append(string2).append("]").toString());
            this.applicationContext = builder.context.getApplicationContext();
            this.analyticsCollector = (AnalyticsCollector)builder.analyticsCollectorFunction.apply((Object)builder.clock);
            this.priorityTaskManager = builder.priorityTaskManager;
            this.audioAttributes = builder.audioAttributes;
            this.videoScalingMode = builder.videoScalingMode;
            this.videoChangeFrameRateStrategy = builder.videoChangeFrameRateStrategy;
            this.skipSilenceEnabled = builder.skipSilenceEnabled;
            this.detachSurfaceTimeoutMs = builder.detachSurfaceTimeoutMs;
            this.componentListener = new ComponentListener();
            this.frameMetadataListener = new FrameMetadataListener();
            Handler eventHandler = new Handler(builder.looper);
            this.renderers = ((RenderersFactory)builder.renderersFactorySupplier.get()).createRenderers(eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener);
            Assertions.checkState((this.renderers.length > 0 ? 1 : 0) != 0);
            this.trackSelector = (TrackSelector)builder.trackSelectorSupplier.get();
            this.mediaSourceFactory = (MediaSource.Factory)builder.mediaSourceFactorySupplier.get();
            this.bandwidthMeter = (BandwidthMeter)builder.bandwidthMeterSupplier.get();
            this.useLazyPreparation = builder.useLazyPreparation;
            this.seekParameters = builder.seekParameters;
            this.seekBackIncrementMs = builder.seekBackIncrementMs;
            this.seekForwardIncrementMs = builder.seekForwardIncrementMs;
            this.pauseAtEndOfMediaItems = builder.pauseAtEndOfMediaItems;
            this.applicationLooper = builder.looper;
            this.clock = builder.clock;
            this.wrappingPlayer = wrappingPlayer == null ? this : wrappingPlayer;
            this.listeners = new ListenerSet(this.applicationLooper, this.clock, (listener, flags) -> listener.onEvents(this.wrappingPlayer, new Player.Events(flags)));
            this.audioOffloadListeners = new CopyOnWriteArraySet();
            this.mediaSourceHolderSnapshots = new ArrayList<MediaSourceHolderSnapshot>();
            this.shuffleOrder = new ShuffleOrder.DefaultShuffleOrder(0);
            this.emptyTrackSelectorResult = new TrackSelectorResult(new RendererConfiguration[this.renderers.length], new ExoTrackSelection[this.renderers.length], TracksInfo.EMPTY, null);
            this.period = new Timeline.Period();
            this.permanentAvailableCommands = new Player.Commands.Builder().addAll(new int[]{1, 2, 3, 13, 14, 15, 16, 17, 18, 19, 20, 30, 21, 22, 23, 24, 25, 26, 27, 28}).addIf(29, this.trackSelector.isSetParametersSupported()).build();
            this.availableCommands = new Player.Commands.Builder().addAll(this.permanentAvailableCommands).add(4).add(10).build();
            this.playbackInfoUpdateHandler = this.clock.createHandler(this.applicationLooper, null);
            this.playbackInfoUpdateListener = playbackInfoUpdate -> this.playbackInfoUpdateHandler.post(() -> this.handlePlaybackInfo(playbackInfoUpdate));
            this.playbackInfo = PlaybackInfo.createDummy(this.emptyTrackSelectorResult);
            this.analyticsCollector.setPlayer(this.wrappingPlayer, this.applicationLooper);
            PlayerId playerId = Util.SDK_INT < 31 ? new PlayerId() : Api31.createPlayerId();
            this.internalPlayer = new ExoPlayerImplInternal(this.renderers, this.trackSelector, this.emptyTrackSelectorResult, (LoadControl)builder.loadControlSupplier.get(), this.bandwidthMeter, this.repeatMode, this.shuffleModeEnabled, this.analyticsCollector, this.seekParameters, builder.livePlaybackSpeedControl, builder.releaseTimeoutMs, this.pauseAtEndOfMediaItems, this.applicationLooper, this.clock, this.playbackInfoUpdateListener, playerId);
            this.volume = 1.0f;
            this.repeatMode = 0;
            this.mediaMetadata = MediaMetadata.EMPTY;
            this.playlistMetadata = MediaMetadata.EMPTY;
            this.staticAndDynamicMediaMetadata = MediaMetadata.EMPTY;
            this.maskingWindowIndex = -1;
            this.audioSessionId = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : Util.generateAudioSessionIdV21((Context)this.applicationContext);
            this.currentCues = ImmutableList.of();
            this.throwsWhenUsingWrongThread = true;
            this.addListener(this.analyticsCollector);
            this.bandwidthMeter.addEventListener(new Handler(this.applicationLooper), this.analyticsCollector);
            this.addAudioOffloadListener(this.componentListener);
            if (builder.foregroundModeTimeoutMs > 0L) {
                this.internalPlayer.experimentalSetForegroundModeTimeoutMs(builder.foregroundModeTimeoutMs);
            }
            this.audioBecomingNoisyManager = new AudioBecomingNoisyManager(builder.context, eventHandler, this.componentListener);
            this.audioBecomingNoisyManager.setEnabled(builder.handleAudioBecomingNoisy);
            this.audioFocusManager = new AudioFocusManager(builder.context, eventHandler, this.componentListener);
            this.audioFocusManager.setAudioAttributes(builder.handleAudioFocus ? this.audioAttributes : null);
            this.streamVolumeManager = new StreamVolumeManager(builder.context, eventHandler, this.componentListener);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage((int)this.audioAttributes.usage));
            this.wakeLockManager = new WakeLockManager(builder.context);
            this.wakeLockManager.setEnabled(builder.wakeMode != 0);
            this.wifiLockManager = new WifiLockManager(builder.context);
            this.wifiLockManager.setEnabled(builder.wakeMode == 2);
            this.deviceInfo = ExoPlayerImpl.createDeviceInfo(this.streamVolumeManager);
            this.videoSize = VideoSize.UNKNOWN;
            this.sendRendererMessage(1, 10, this.audioSessionId);
            this.sendRendererMessage(2, 10, this.audioSessionId);
            this.sendRendererMessage(1, 3, this.audioAttributes);
            this.sendRendererMessage(2, 4, this.videoScalingMode);
            this.sendRendererMessage(2, 5, this.videoChangeFrameRateStrategy);
            this.sendRendererMessage(1, 9, this.skipSilenceEnabled);
            this.sendRendererMessage(2, 7, this.frameMetadataListener);
            this.sendRendererMessage(6, 8, this.frameMetadataListener);
        }
        finally {
            this.constructorFinished.open();
        }
    }

    @Override
    @Deprecated
    public ExoPlayer.AudioComponent getAudioComponent() {
        this.verifyApplicationThread();
        return this;
    }

    @Override
    @Deprecated
    public ExoPlayer.VideoComponent getVideoComponent() {
        this.verifyApplicationThread();
        return this;
    }

    @Override
    @Deprecated
    public ExoPlayer.TextComponent getTextComponent() {
        this.verifyApplicationThread();
        return this;
    }

    @Override
    @Deprecated
    public ExoPlayer.DeviceComponent getDeviceComponent() {
        this.verifyApplicationThread();
        return this;
    }

    @Override
    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.verifyApplicationThread();
        this.internalPlayer.experimentalSetOffloadSchedulingEnabled(offloadSchedulingEnabled);
    }

    @Override
    public boolean experimentalIsSleepingForOffload() {
        this.verifyApplicationThread();
        return this.playbackInfo.sleepingForOffload;
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    public Looper getApplicationLooper() {
        return this.applicationLooper;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public void addAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.audioOffloadListeners.add(listener);
    }

    @Override
    public void removeAudioOffloadListener(ExoPlayer.AudioOffloadListener listener) {
        this.audioOffloadListeners.remove(listener);
    }

    public Player.Commands getAvailableCommands() {
        this.verifyApplicationThread();
        return this.availableCommands;
    }

    public int getPlaybackState() {
        this.verifyApplicationThread();
        return this.playbackInfo.playbackState;
    }

    public int getPlaybackSuppressionReason() {
        this.verifyApplicationThread();
        return this.playbackInfo.playbackSuppressionReason;
    }

    @Override
    @Nullable
    public ExoPlaybackException getPlayerError() {
        this.verifyApplicationThread();
        return this.playbackInfo.playbackError;
    }

    @Override
    @Deprecated
    public void retry() {
        this.verifyApplicationThread();
        this.prepare();
    }

    public void prepare() {
        this.verifyApplicationThread();
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, 2);
        this.updatePlayWhenReady(playWhenReady, playerCommand, ExoPlayerImpl.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        if (this.playbackInfo.playbackState != 1) {
            return;
        }
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlaybackError(null);
        playbackInfo = playbackInfo.copyWithPlaybackState(playbackInfo.timeline.isEmpty() ? 4 : 2);
        ++this.pendingOperationAcks;
        this.internalPlayer.prepare();
        this.updatePlaybackInfo(playbackInfo, 1, 1, false, false, 5, -9223372036854775807L, -1);
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.setMediaSource(mediaSource);
        this.prepare();
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.verifyApplicationThread();
        this.setMediaSource(mediaSource, resetPosition);
        this.prepare();
    }

    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.verifyApplicationThread();
        this.setMediaSources(this.createMediaSources(mediaItems), resetPosition);
    }

    public void setMediaItems(List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.setMediaSources(this.createMediaSources(mediaItems), startIndex, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.setMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, long startPositionMs) {
        this.verifyApplicationThread();
        this.setMediaSources(Collections.singletonList(mediaSource), 0, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, boolean resetPosition) {
        this.verifyApplicationThread();
        this.setMediaSources(Collections.singletonList(mediaSource), resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.setMediaSources(mediaSources, true);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, boolean resetPosition) {
        this.verifyApplicationThread();
        this.setMediaSourcesInternal(mediaSources, -1, -9223372036854775807L, resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.setMediaSourcesInternal(mediaSources, startWindowIndex, startPositionMs, false);
    }

    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.verifyApplicationThread();
        index = Math.min(index, this.mediaSourceHolderSnapshots.size());
        this.addMediaSources(index, this.createMediaSources(mediaItems));
    }

    @Override
    public void addMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.addMediaSources(Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSource(int index, MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.addMediaSources(index, Collections.singletonList(mediaSource));
    }

    @Override
    public void addMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.addMediaSources(this.mediaSourceHolderSnapshots.size(), mediaSources);
    }

    @Override
    public void addMediaSources(int index, List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        Assertions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(index, mediaSources);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionUsAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.addMediaSources(index, holders, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    public void removeMediaItems(int fromIndex, int toIndex) {
        this.verifyApplicationThread();
        toIndex = Math.min(toIndex, this.mediaSourceHolderSnapshots.size());
        PlaybackInfo newPlaybackInfo = this.removeMediaItemsInternal(fromIndex, toIndex);
        boolean positionDiscontinuity = !newPlaybackInfo.periodId.periodUid.equals(this.playbackInfo.periodId.periodUid);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(newPlaybackInfo), -1);
    }

    public void moveMediaItems(int fromIndex, int toIndex, int newFromIndex) {
        this.verifyApplicationThread();
        Assertions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.mediaSourceHolderSnapshots.size() && newFromIndex >= 0 ? 1 : 0) != 0);
        Timeline oldTimeline = this.getCurrentTimeline();
        ++this.pendingOperationAcks;
        newFromIndex = Math.min(newFromIndex, this.mediaSourceHolderSnapshots.size() - (toIndex - fromIndex));
        Util.moveItems(this.mediaSourceHolderSnapshots, (int)fromIndex, (int)toIndex, (int)newFromIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionUsAfterTimelineChanged(oldTimeline, newTimeline));
        this.internalPlayer.moveMediaSources(fromIndex, toIndex, newFromIndex, this.shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    @Override
    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.verifyApplicationThread();
        Timeline timeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.maskWindowPositionMsOrGetPeriodPositionUs(timeline, this.getCurrentMediaItemIndex(), this.getCurrentPosition()));
        ++this.pendingOperationAcks;
        this.shuffleOrder = shuffleOrder;
        this.internalPlayer.setShuffleOrder(shuffleOrder);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    @Override
    public void setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
        this.verifyApplicationThread();
        if (this.pauseAtEndOfMediaItems == pauseAtEndOfMediaItems) {
            return;
        }
        this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
        this.internalPlayer.setPauseAtEndOfWindow(pauseAtEndOfMediaItems);
    }

    @Override
    public boolean getPauseAtEndOfMediaItems() {
        this.verifyApplicationThread();
        return this.pauseAtEndOfMediaItems;
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.verifyApplicationThread();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, ExoPlayerImpl.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
    }

    public boolean getPlayWhenReady() {
        this.verifyApplicationThread();
        return this.playbackInfo.playWhenReady;
    }

    public void setRepeatMode(int repeatMode) {
        this.verifyApplicationThread();
        if (this.repeatMode != repeatMode) {
            this.repeatMode = repeatMode;
            this.internalPlayer.setRepeatMode(repeatMode);
            this.listeners.queueEvent(8, listener -> listener.onRepeatModeChanged(repeatMode));
            this.updateAvailableCommands();
            this.listeners.flushEvents();
        }
    }

    public int getRepeatMode() {
        this.verifyApplicationThread();
        return this.repeatMode;
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.verifyApplicationThread();
        if (this.shuffleModeEnabled != shuffleModeEnabled) {
            this.shuffleModeEnabled = shuffleModeEnabled;
            this.internalPlayer.setShuffleModeEnabled(shuffleModeEnabled);
            this.listeners.queueEvent(9, listener -> listener.onShuffleModeEnabledChanged(shuffleModeEnabled));
            this.updateAvailableCommands();
            this.listeners.flushEvents();
        }
    }

    public boolean getShuffleModeEnabled() {
        this.verifyApplicationThread();
        return this.shuffleModeEnabled;
    }

    public boolean isLoading() {
        this.verifyApplicationThread();
        return this.playbackInfo.isLoading;
    }

    public void seekTo(int mediaItemIndex, long positionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.notifySeekStarted();
        Timeline timeline = this.playbackInfo.timeline;
        if (mediaItemIndex < 0 || !timeline.isEmpty() && mediaItemIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, mediaItemIndex, positionMs);
        }
        ++this.pendingOperationAcks;
        if (this.isPlayingAd()) {
            Log.w((String)TAG, (String)"seekTo ignored because an ad is playing");
            ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate = new ExoPlayerImplInternal.PlaybackInfoUpdate(this.playbackInfo);
            playbackInfoUpdate.incrementPendingOperationAcks(1);
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(playbackInfoUpdate);
            return;
        }
        int newPlaybackState = this.getPlaybackState() == 1 ? 1 : 2;
        int oldMaskingMediaItemIndex = this.getCurrentMediaItemIndex();
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackState(newPlaybackState);
        newPlaybackInfo = this.maskTimelineAndPosition(newPlaybackInfo, timeline, this.maskWindowPositionMsOrGetPeriodPositionUs(timeline, mediaItemIndex, positionMs));
        this.internalPlayer.seekTo(timeline, mediaItemIndex, Util.msToUs((long)positionMs));
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, true, true, 1, this.getCurrentPositionUsInternal(newPlaybackInfo), oldMaskingMediaItemIndex);
    }

    public long getSeekBackIncrement() {
        this.verifyApplicationThread();
        return this.seekBackIncrementMs;
    }

    public long getSeekForwardIncrement() {
        this.verifyApplicationThread();
        return this.seekForwardIncrementMs;
    }

    public long getMaxSeekToPreviousPosition() {
        this.verifyApplicationThread();
        return 3000L;
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.verifyApplicationThread();
        if (playbackParameters == null) {
            playbackParameters = PlaybackParameters.DEFAULT;
        }
        if (this.playbackInfo.playbackParameters.equals((Object)playbackParameters)) {
            return;
        }
        PlaybackInfo newPlaybackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        ++this.pendingOperationAcks;
        this.internalPlayer.setPlaybackParameters(playbackParameters);
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, false, 5, -9223372036854775807L, -1);
    }

    public PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThread();
        return this.playbackInfo.playbackParameters;
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        this.verifyApplicationThread();
        if (seekParameters == null) {
            seekParameters = SeekParameters.DEFAULT;
        }
        if (!this.seekParameters.equals(seekParameters)) {
            this.seekParameters = seekParameters;
            this.internalPlayer.setSeekParameters(seekParameters);
        }
    }

    @Override
    public SeekParameters getSeekParameters() {
        this.verifyApplicationThread();
        return this.seekParameters;
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        this.verifyApplicationThread();
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!this.internalPlayer.setForegroundMode(foregroundMode)) {
                this.stopInternal(false, ExoPlaybackException.createForUnexpected(new ExoTimeoutException(2), 1003));
            }
        }
    }

    public void stop() {
        this.verifyApplicationThread();
        this.stop(false);
    }

    public void stop(boolean reset) {
        this.verifyApplicationThread();
        this.audioFocusManager.updateAudioFocus(this.getPlayWhenReady(), 1);
        this.stopInternal(reset, null);
        this.currentCues = ImmutableList.of();
    }

    public void release() {
        String string = Integer.toHexString(System.identityHashCode(this));
        String string2 = Util.DEVICE_DEBUG_INFO;
        String string3 = ExoPlayerLibraryInfo.registeredModules();
        Log.i((String)TAG, (String)new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Release ").append(string).append(" [").append("ExoPlayerLib/2.17.1").append("] [").append(string2).append("] [").append(string3).append("]").toString());
        this.verifyApplicationThread();
        if (Util.SDK_INT < 21 && this.keepSessionIdAudioTrack != null) {
            this.keepSessionIdAudioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        this.audioBecomingNoisyManager.setEnabled(false);
        this.streamVolumeManager.release();
        this.wakeLockManager.setStayAwake(false);
        this.wifiLockManager.setStayAwake(false);
        this.audioFocusManager.release();
        if (!this.internalPlayer.release()) {
            this.listeners.sendEvent(10, listener -> listener.onPlayerError((PlaybackException)ExoPlaybackException.createForUnexpected(new ExoTimeoutException(1), 1003)));
        }
        this.listeners.release();
        this.playbackInfoUpdateHandler.removeCallbacksAndMessages(null);
        this.bandwidthMeter.removeEventListener(this.analyticsCollector);
        this.playbackInfo = this.playbackInfo.copyWithPlaybackState(1);
        this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
        this.playbackInfo.bufferedPositionUs = this.playbackInfo.positionUs;
        this.playbackInfo.totalBufferedDurationUs = 0L;
        this.analyticsCollector.release();
        this.removeSurfaceCallbacks();
        if (this.ownedSurface != null) {
            this.ownedSurface.release();
            this.ownedSurface = null;
        }
        if (this.isPriorityTaskManagerRegistered) {
            ((PriorityTaskManager)Assertions.checkNotNull((Object)this.priorityTaskManager)).remove(0);
            this.isPriorityTaskManagerRegistered = false;
        }
        this.currentCues = ImmutableList.of();
        this.playerReleased = true;
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        this.verifyApplicationThread();
        return this.createMessageInternal(target);
    }

    public int getCurrentPeriodIndex() {
        this.verifyApplicationThread();
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingPeriodIndex;
        }
        return this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
    }

    public int getCurrentMediaItemIndex() {
        this.verifyApplicationThread();
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        return currentWindowIndex == -1 ? 0 : currentWindowIndex;
    }

    public long getDuration() {
        this.verifyApplicationThread();
        if (this.isPlayingAd()) {
            MediaSource.MediaPeriodId periodId = this.playbackInfo.periodId;
            this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
            long adDurationUs = this.period.getAdDurationUs(periodId.adGroupIndex, periodId.adIndexInAdGroup);
            return Util.usToMs((long)adDurationUs);
        }
        return this.getContentDuration();
    }

    public long getCurrentPosition() {
        this.verifyApplicationThread();
        return Util.usToMs((long)this.getCurrentPositionUsInternal(this.playbackInfo));
    }

    public long getBufferedPosition() {
        this.verifyApplicationThread();
        if (this.isPlayingAd()) {
            return this.playbackInfo.loadingMediaPeriodId.equals((Object)this.playbackInfo.periodId) ? Util.usToMs((long)this.playbackInfo.bufferedPositionUs) : this.getDuration();
        }
        return this.getContentBufferedPosition();
    }

    public long getTotalBufferedDuration() {
        this.verifyApplicationThread();
        return Util.usToMs((long)this.playbackInfo.totalBufferedDurationUs);
    }

    public boolean isPlayingAd() {
        this.verifyApplicationThread();
        return this.playbackInfo.periodId.isAd();
    }

    public int getCurrentAdGroupIndex() {
        this.verifyApplicationThread();
        return this.isPlayingAd() ? this.playbackInfo.periodId.adGroupIndex : -1;
    }

    public int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThread();
        return this.isPlayingAd() ? this.playbackInfo.periodId.adIndexInAdGroup : -1;
    }

    public long getContentPosition() {
        this.verifyApplicationThread();
        if (this.isPlayingAd()) {
            this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.periodId.periodUid, this.period);
            return this.playbackInfo.requestedContentPositionUs == -9223372036854775807L ? this.playbackInfo.timeline.getWindow(this.getCurrentMediaItemIndex(), this.window).getDefaultPositionMs() : this.period.getPositionInWindowMs() + Util.usToMs((long)this.playbackInfo.requestedContentPositionUs);
        }
        return this.getCurrentPosition();
    }

    public long getContentBufferedPosition() {
        Timeline.Period loadingPeriod;
        this.verifyApplicationThread();
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowPositionMs;
        }
        if (this.playbackInfo.loadingMediaPeriodId.windowSequenceNumber != this.playbackInfo.periodId.windowSequenceNumber) {
            return this.playbackInfo.timeline.getWindow(this.getCurrentMediaItemIndex(), this.window).getDurationMs();
        }
        long contentBufferedPositionUs = this.playbackInfo.bufferedPositionUs;
        if (this.playbackInfo.loadingMediaPeriodId.isAd() && (contentBufferedPositionUs = (loadingPeriod = this.playbackInfo.timeline.getPeriodByUid(this.playbackInfo.loadingMediaPeriodId.periodUid, this.period)).getAdGroupTimeUs(this.playbackInfo.loadingMediaPeriodId.adGroupIndex)) == Long.MIN_VALUE) {
            contentBufferedPositionUs = loadingPeriod.durationUs;
        }
        return Util.usToMs((long)this.periodPositionUsToWindowPositionUs(this.playbackInfo.timeline, this.playbackInfo.loadingMediaPeriodId, contentBufferedPositionUs));
    }

    @Override
    public int getRendererCount() {
        this.verifyApplicationThread();
        return this.renderers.length;
    }

    @Override
    public int getRendererType(int index) {
        this.verifyApplicationThread();
        return this.renderers[index].getTrackType();
    }

    @Override
    public Renderer getRenderer(int index) {
        this.verifyApplicationThread();
        return this.renderers[index];
    }

    @Override
    public TrackSelector getTrackSelector() {
        this.verifyApplicationThread();
        return this.trackSelector;
    }

    public TrackGroupArray getCurrentTrackGroups() {
        this.verifyApplicationThread();
        return this.playbackInfo.trackGroups;
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        this.verifyApplicationThread();
        return new TrackSelectionArray((TrackSelection[])this.playbackInfo.trackSelectorResult.selections);
    }

    public TracksInfo getCurrentTracksInfo() {
        this.verifyApplicationThread();
        return this.playbackInfo.trackSelectorResult.tracksInfo;
    }

    public TrackSelectionParameters getTrackSelectionParameters() {
        this.verifyApplicationThread();
        return this.trackSelector.getParameters();
    }

    public void setTrackSelectionParameters(TrackSelectionParameters parameters) {
        this.verifyApplicationThread();
        if (!this.trackSelector.isSetParametersSupported() || parameters.equals((Object)this.trackSelector.getParameters())) {
            return;
        }
        this.trackSelector.setParameters(parameters);
        this.listeners.sendEvent(19, listener -> listener.onTrackSelectionParametersChanged(parameters));
    }

    public MediaMetadata getMediaMetadata() {
        this.verifyApplicationThread();
        return this.mediaMetadata;
    }

    public MediaMetadata getPlaylistMetadata() {
        this.verifyApplicationThread();
        return this.playlistMetadata;
    }

    public void setPlaylistMetadata(MediaMetadata playlistMetadata) {
        this.verifyApplicationThread();
        Assertions.checkNotNull((Object)playlistMetadata);
        if (playlistMetadata.equals((Object)this.playlistMetadata)) {
            return;
        }
        this.playlistMetadata = playlistMetadata;
        this.listeners.sendEvent(15, listener -> listener.onPlaylistMetadataChanged(this.playlistMetadata));
    }

    public Timeline getCurrentTimeline() {
        this.verifyApplicationThread();
        return this.playbackInfo.timeline;
    }

    @Override
    public void setVideoScalingMode(int videoScalingMode) {
        this.verifyApplicationThread();
        this.videoScalingMode = videoScalingMode;
        this.sendRendererMessage(2, 4, videoScalingMode);
    }

    @Override
    public int getVideoScalingMode() {
        this.verifyApplicationThread();
        return this.videoScalingMode;
    }

    @Override
    public void setVideoChangeFrameRateStrategy(int videoChangeFrameRateStrategy) {
        this.verifyApplicationThread();
        if (this.videoChangeFrameRateStrategy == videoChangeFrameRateStrategy) {
            return;
        }
        this.videoChangeFrameRateStrategy = videoChangeFrameRateStrategy;
        this.sendRendererMessage(2, 5, videoChangeFrameRateStrategy);
    }

    @Override
    public int getVideoChangeFrameRateStrategy() {
        this.verifyApplicationThread();
        return this.videoChangeFrameRateStrategy;
    }

    @Override
    public VideoSize getVideoSize() {
        this.verifyApplicationThread();
        return this.videoSize;
    }

    @Override
    public void clearVideoSurface() {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoOutputInternal(null);
        this.maybeNotifySurfaceSizeChanged(0, 0);
    }

    @Override
    public void clearVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        if (surface != null && surface == this.videoOutput) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoOutputInternal(surface);
        int newSurfaceSize = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(newSurfaceSize, newSurfaceSize);
    }

    @Override
    public void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder == null) {
            this.clearVideoSurface();
        } else {
            this.removeSurfaceCallbacks();
            this.surfaceHolderSurfaceIsVideoOutput = true;
            this.surfaceHolder = surfaceHolder;
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoOutputInternal(surface);
                Rect surfaceSize = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
            } else {
                this.setVideoOutputInternal(null);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    @Override
    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.verifyApplicationThread();
        if (surfaceView instanceof VideoDecoderOutputBufferRenderer) {
            this.removeSurfaceCallbacks();
            this.setVideoOutputInternal(surfaceView);
            this.setNonVideoOutputSurfaceHolderInternal(surfaceView.getHolder());
        } else if (surfaceView instanceof SphericalGLSurfaceView) {
            this.removeSurfaceCallbacks();
            this.sphericalGLSurfaceView = (SphericalGLSurfaceView)surfaceView;
            this.createMessageInternal(this.frameMetadataListener).setType(10000).setPayload((Object)this.sphericalGLSurfaceView).send();
            this.sphericalGLSurfaceView.addVideoSurfaceListener(this.componentListener);
            this.setVideoOutputInternal(this.sphericalGLSurfaceView.getVideoSurface());
            this.setNonVideoOutputSurfaceHolderInternal(surfaceView.getHolder());
        } else {
            this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
        }
    }

    @Override
    public void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.verifyApplicationThread();
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void setVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView == null) {
            this.clearVideoSurface();
        } else {
            SurfaceTexture surfaceTexture;
            this.removeSurfaceCallbacks();
            this.textureView = textureView;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w((String)TAG, (String)"Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoOutputInternal(null);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setSurfaceTextureInternal(surfaceTexture);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    @Override
    public void clearVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView != null && textureView == this.textureView) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setAudioAttributes(AudioAttributes newAudioAttributes, boolean handleAudioFocus) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        if (!Util.areEqual((Object)this.audioAttributes, (Object)newAudioAttributes)) {
            this.audioAttributes = newAudioAttributes;
            this.sendRendererMessage(1, 3, newAudioAttributes);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage((int)newAudioAttributes.usage));
            this.listeners.queueEvent(20, listener -> listener.onAudioAttributesChanged(newAudioAttributes));
        }
        this.audioFocusManager.setAudioAttributes((AudioAttributes)(handleAudioFocus ? newAudioAttributes : null));
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, ExoPlayerImpl.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        this.listeners.flushEvents();
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        this.verifyApplicationThread();
        return this.audioAttributes;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        this.verifyApplicationThread();
        if (this.audioSessionId == audioSessionId) {
            return;
        }
        if (audioSessionId == 0) {
            audioSessionId = Util.SDK_INT < 21 ? this.initializeKeepSessionIdAudioTrack(0) : Util.generateAudioSessionIdV21((Context)this.applicationContext);
        } else if (Util.SDK_INT < 21) {
            this.initializeKeepSessionIdAudioTrack(audioSessionId);
        }
        this.audioSessionId = audioSessionId;
        this.sendRendererMessage(1, 10, audioSessionId);
        this.sendRendererMessage(2, 10, audioSessionId);
        int finalAudioSessionId = audioSessionId;
        this.listeners.sendEvent(21, listener -> listener.onAudioSessionIdChanged(finalAudioSessionId));
    }

    @Override
    public int getAudioSessionId() {
        this.verifyApplicationThread();
        return this.audioSessionId;
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        this.verifyApplicationThread();
        this.sendRendererMessage(1, 6, auxEffectInfo);
    }

    @Override
    public void clearAuxEffectInfo() {
        this.verifyApplicationThread();
        this.setAuxEffectInfo(new AuxEffectInfo(0, 0.0f));
    }

    @Override
    public void setVolume(float volume) {
        this.verifyApplicationThread();
        volume = Util.constrainValue((float)volume, (float)0.0f, (float)1.0f);
        if (this.volume == volume) {
            return;
        }
        this.volume = volume;
        this.sendVolumeToRenderers();
        float finalVolume = volume;
        this.listeners.sendEvent(22, listener -> listener.onVolumeChanged(finalVolume));
    }

    @Override
    public float getVolume() {
        this.verifyApplicationThread();
        return this.volume;
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        this.verifyApplicationThread();
        return this.skipSilenceEnabled;
    }

    @Override
    public void setSkipSilenceEnabled(boolean newSkipSilenceEnabled) {
        this.verifyApplicationThread();
        if (this.skipSilenceEnabled == newSkipSilenceEnabled) {
            return;
        }
        this.skipSilenceEnabled = newSkipSilenceEnabled;
        this.sendRendererMessage(1, 9, newSkipSilenceEnabled);
        this.listeners.sendEvent(23, listener -> listener.onSkipSilenceEnabledChanged(newSkipSilenceEnabled));
    }

    @Override
    public AnalyticsCollector getAnalyticsCollector() {
        this.verifyApplicationThread();
        return this.analyticsCollector;
    }

    @Override
    public void addAnalyticsListener(AnalyticsListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.analyticsCollector.addListener(listener);
    }

    @Override
    public void removeAnalyticsListener(AnalyticsListener listener) {
        this.analyticsCollector.removeListener(listener);
    }

    @Override
    public void setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        this.audioBecomingNoisyManager.setEnabled(handleAudioBecomingNoisy);
    }

    @Override
    public void setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
        this.verifyApplicationThread();
        if (Util.areEqual((Object)this.priorityTaskManager, (Object)priorityTaskManager)) {
            return;
        }
        if (this.isPriorityTaskManagerRegistered) {
            ((PriorityTaskManager)Assertions.checkNotNull((Object)this.priorityTaskManager)).remove(0);
        }
        if (priorityTaskManager != null && this.isLoading()) {
            priorityTaskManager.add(0);
            this.isPriorityTaskManagerRegistered = true;
        } else {
            this.isPriorityTaskManagerRegistered = false;
        }
        this.priorityTaskManager = priorityTaskManager;
    }

    @Override
    @Nullable
    public Format getVideoFormat() {
        this.verifyApplicationThread();
        return this.videoFormat;
    }

    @Override
    @Nullable
    public Format getAudioFormat() {
        this.verifyApplicationThread();
        return this.audioFormat;
    }

    @Override
    @Nullable
    public DecoderCounters getVideoDecoderCounters() {
        this.verifyApplicationThread();
        return this.videoDecoderCounters;
    }

    @Override
    @Nullable
    public DecoderCounters getAudioDecoderCounters() {
        this.verifyApplicationThread();
        return this.audioDecoderCounters;
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        this.videoFrameMetadataListener = listener;
        this.createMessageInternal(this.frameMetadataListener).setType(7).setPayload(listener).send();
    }

    @Override
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        if (this.videoFrameMetadataListener != listener) {
            return;
        }
        this.createMessageInternal(this.frameMetadataListener).setType(7).setPayload(null).send();
    }

    @Override
    public void setCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        this.cameraMotionListener = listener;
        this.createMessageInternal(this.frameMetadataListener).setType(8).setPayload(listener).send();
    }

    @Override
    public void clearCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        if (this.cameraMotionListener != listener) {
            return;
        }
        this.createMessageInternal(this.frameMetadataListener).setType(8).setPayload(null).send();
    }

    @Override
    public List<Cue> getCurrentCues() {
        this.verifyApplicationThread();
        return this.currentCues;
    }

    public void addListener(Player.Listener listener) {
        Assertions.checkNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public void removeListener(Player.Listener listener) {
        Assertions.checkNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    @Override
    public void setHandleWakeLock(boolean handleWakeLock) {
        this.verifyApplicationThread();
        this.setWakeMode(handleWakeLock ? 1 : 0);
    }

    @Override
    public void setWakeMode(int wakeMode) {
        this.verifyApplicationThread();
        switch (wakeMode) {
            case 0: {
                this.wakeLockManager.setEnabled(false);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 1: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 2: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        this.verifyApplicationThread();
        return this.deviceInfo;
    }

    @Override
    public int getDeviceVolume() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.getVolume();
    }

    @Override
    public boolean isDeviceMuted() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.isMuted();
    }

    @Override
    public void setDeviceVolume(int volume) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setVolume(volume);
    }

    @Override
    public void increaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.increaseVolume();
    }

    @Override
    public void decreaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.decreaseVolume();
    }

    @Override
    public void setDeviceMuted(boolean muted) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setMuted(muted);
    }

    void setThrowsWhenUsingWrongThread(boolean throwsWhenUsingWrongThread) {
        this.throwsWhenUsingWrongThread = throwsWhenUsingWrongThread;
    }

    private void stopInternal(boolean reset, @Nullable ExoPlaybackException error) {
        PlaybackInfo playbackInfo;
        if (reset) {
            playbackInfo = this.removeMediaItemsInternal(0, this.mediaSourceHolderSnapshots.size());
            playbackInfo = playbackInfo.copyWithPlaybackError(null);
        } else {
            playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(this.playbackInfo.periodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            playbackInfo.totalBufferedDurationUs = 0L;
        }
        playbackInfo = playbackInfo.copyWithPlaybackState(1);
        if (error != null) {
            playbackInfo = playbackInfo.copyWithPlaybackError(error);
        }
        ++this.pendingOperationAcks;
        this.internalPlayer.stop();
        boolean positionDiscontinuity = playbackInfo.timeline.isEmpty() && !this.playbackInfo.timeline.isEmpty();
        this.updatePlaybackInfo(playbackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(playbackInfo), -1);
    }

    private int getCurrentWindowIndexInternal() {
        if (this.playbackInfo.timeline.isEmpty()) {
            return this.maskingWindowIndex;
        }
        return this.playbackInfo.timeline.getPeriodByUid((Object)this.playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
    }

    private long getCurrentPositionUsInternal(PlaybackInfo playbackInfo) {
        if (playbackInfo.timeline.isEmpty()) {
            return Util.msToUs((long)this.maskingWindowPositionMs);
        }
        if (playbackInfo.periodId.isAd()) {
            return playbackInfo.positionUs;
        }
        return this.periodPositionUsToWindowPositionUs(playbackInfo.timeline, playbackInfo.periodId, playbackInfo.positionUs);
    }

    private List<MediaSource> createMediaSources(List<MediaItem> mediaItems) {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (int i = 0; i < mediaItems.size(); ++i) {
            mediaSources.add(this.mediaSourceFactory.createMediaSource(mediaItems.get(i)));
        }
        return mediaSources;
    }

    private void handlePlaybackInfo(ExoPlayerImplInternal.PlaybackInfoUpdate playbackInfoUpdate) {
        this.pendingOperationAcks -= playbackInfoUpdate.operationAcks;
        if (playbackInfoUpdate.positionDiscontinuity) {
            this.pendingDiscontinuityReason = playbackInfoUpdate.discontinuityReason;
            this.pendingDiscontinuity = true;
        }
        if (playbackInfoUpdate.hasPlayWhenReadyChangeReason) {
            this.pendingPlayWhenReadyChangeReason = playbackInfoUpdate.playWhenReadyChangeReason;
        }
        if (this.pendingOperationAcks == 0) {
            Timeline newTimeline = playbackInfoUpdate.playbackInfo.timeline;
            if (!this.playbackInfo.timeline.isEmpty() && newTimeline.isEmpty()) {
                this.maskingWindowIndex = -1;
                this.maskingWindowPositionMs = 0L;
                this.maskingPeriodIndex = 0;
            }
            if (!newTimeline.isEmpty()) {
                List<Timeline> timelines = ((PlaylistTimeline)newTimeline).getChildTimelines();
                Assertions.checkState((timelines.size() == this.mediaSourceHolderSnapshots.size() ? 1 : 0) != 0);
                for (int i = 0; i < timelines.size(); ++i) {
                    this.mediaSourceHolderSnapshots.get(i).timeline = timelines.get(i);
                }
            }
            boolean positionDiscontinuity = false;
            long discontinuityWindowStartPositionUs = -9223372036854775807L;
            if (this.pendingDiscontinuity) {
                boolean bl = positionDiscontinuity = !playbackInfoUpdate.playbackInfo.periodId.equals((Object)this.playbackInfo.periodId) || playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs != this.playbackInfo.positionUs;
                if (positionDiscontinuity) {
                    discontinuityWindowStartPositionUs = newTimeline.isEmpty() || playbackInfoUpdate.playbackInfo.periodId.isAd() ? playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs : this.periodPositionUsToWindowPositionUs(newTimeline, playbackInfoUpdate.playbackInfo.periodId, playbackInfoUpdate.playbackInfo.discontinuityStartPositionUs);
                }
            }
            this.pendingDiscontinuity = false;
            this.updatePlaybackInfo(playbackInfoUpdate.playbackInfo, 1, this.pendingPlayWhenReadyChangeReason, false, positionDiscontinuity, this.pendingDiscontinuityReason, discontinuityWindowStartPositionUs, -1);
        }
    }

    private void updatePlaybackInfo(PlaybackInfo playbackInfo, int timelineChangeReason, int playWhenReadyChangeReason, boolean seekProcessed, boolean positionDiscontinuity, int positionDiscontinuityReason, long discontinuityWindowStartPositionUs, int oldMaskingMediaItemIndex) {
        boolean isLoadingChanged;
        boolean playbackStateChanged;
        PlaybackInfo previousPlaybackInfo = this.playbackInfo;
        PlaybackInfo newPlaybackInfo = playbackInfo;
        this.playbackInfo = playbackInfo;
        Pair<Boolean, Integer> mediaItemTransitionInfo = this.evaluateMediaItemTransitionReason(newPlaybackInfo, previousPlaybackInfo, positionDiscontinuity, positionDiscontinuityReason, !previousPlaybackInfo.timeline.equals((Object)newPlaybackInfo.timeline));
        boolean mediaItemTransitioned = (Boolean)mediaItemTransitionInfo.first;
        int mediaItemTransitionReason = (Integer)mediaItemTransitionInfo.second;
        MediaMetadata newMediaMetadata = this.mediaMetadata;
        MediaItem mediaItem = null;
        if (mediaItemTransitioned) {
            if (!newPlaybackInfo.timeline.isEmpty()) {
                int windowIndex = newPlaybackInfo.timeline.getPeriodByUid((Object)newPlaybackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
                mediaItem = newPlaybackInfo.timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).mediaItem;
            }
            this.staticAndDynamicMediaMetadata = MediaMetadata.EMPTY;
        }
        if (mediaItemTransitioned || !previousPlaybackInfo.staticMetadata.equals(newPlaybackInfo.staticMetadata)) {
            this.staticAndDynamicMediaMetadata = this.staticAndDynamicMediaMetadata.buildUpon().populateFromMetadata(newPlaybackInfo.staticMetadata).build();
            newMediaMetadata = this.buildUpdatedMediaMetadata();
        }
        boolean metadataChanged = !newMediaMetadata.equals((Object)this.mediaMetadata);
        this.mediaMetadata = newMediaMetadata;
        boolean playWhenReadyChanged = previousPlaybackInfo.playWhenReady != newPlaybackInfo.playWhenReady;
        boolean bl = playbackStateChanged = previousPlaybackInfo.playbackState != newPlaybackInfo.playbackState;
        if (playbackStateChanged || playWhenReadyChanged) {
            this.updateWakeAndWifiLock();
        }
        boolean bl2 = isLoadingChanged = previousPlaybackInfo.isLoading != newPlaybackInfo.isLoading;
        if (isLoadingChanged) {
            this.updatePriorityTaskManagerForIsLoadingChange(newPlaybackInfo.isLoading);
        }
        if (!previousPlaybackInfo.timeline.equals((Object)newPlaybackInfo.timeline)) {
            this.listeners.queueEvent(0, listener -> listener.onTimelineChanged(newPlaybackInfo.timeline, timelineChangeReason));
        }
        if (positionDiscontinuity) {
            Player.PositionInfo previousPositionInfo = this.getPreviousPositionInfo(positionDiscontinuityReason, previousPlaybackInfo, oldMaskingMediaItemIndex);
            Player.PositionInfo positionInfo = this.getPositionInfo(discontinuityWindowStartPositionUs);
            this.listeners.queueEvent(11, listener -> {
                listener.onPositionDiscontinuity(positionDiscontinuityReason);
                listener.onPositionDiscontinuity(previousPositionInfo, positionInfo, positionDiscontinuityReason);
            });
        }
        if (mediaItemTransitioned) {
            MediaItem finalMediaItem = mediaItem;
            this.listeners.queueEvent(1, listener -> listener.onMediaItemTransition(finalMediaItem, mediaItemTransitionReason));
        }
        if (previousPlaybackInfo.playbackError != newPlaybackInfo.playbackError) {
            this.listeners.queueEvent(10, listener -> listener.onPlayerErrorChanged((PlaybackException)newPlaybackInfo.playbackError));
            if (newPlaybackInfo.playbackError != null) {
                this.listeners.queueEvent(10, listener -> listener.onPlayerError((PlaybackException)newPlaybackInfo.playbackError));
            }
        }
        if (previousPlaybackInfo.trackSelectorResult != newPlaybackInfo.trackSelectorResult) {
            this.trackSelector.onSelectionActivated(newPlaybackInfo.trackSelectorResult.info);
            TrackSelectionArray newSelection = new TrackSelectionArray((TrackSelection[])newPlaybackInfo.trackSelectorResult.selections);
            this.listeners.queueEvent(2, listener -> listener.onTracksChanged(newPlaybackInfo.trackGroups, newSelection));
            this.listeners.queueEvent(2, listener -> listener.onTracksInfoChanged(newPlaybackInfo.trackSelectorResult.tracksInfo));
        }
        if (metadataChanged) {
            MediaMetadata finalMediaMetadata = this.mediaMetadata;
            this.listeners.queueEvent(14, listener -> listener.onMediaMetadataChanged(finalMediaMetadata));
        }
        if (isLoadingChanged) {
            this.listeners.queueEvent(3, listener -> {
                listener.onLoadingChanged(newPlaybackInfo.isLoading);
                listener.onIsLoadingChanged(newPlaybackInfo.isLoading);
            });
        }
        if (playbackStateChanged || playWhenReadyChanged) {
            this.listeners.queueEvent(-1, listener -> listener.onPlayerStateChanged(newPlaybackInfo.playWhenReady, newPlaybackInfo.playbackState));
        }
        if (playbackStateChanged) {
            this.listeners.queueEvent(4, listener -> listener.onPlaybackStateChanged(newPlaybackInfo.playbackState));
        }
        if (playWhenReadyChanged) {
            this.listeners.queueEvent(5, listener -> listener.onPlayWhenReadyChanged(newPlaybackInfo.playWhenReady, playWhenReadyChangeReason));
        }
        if (previousPlaybackInfo.playbackSuppressionReason != newPlaybackInfo.playbackSuppressionReason) {
            this.listeners.queueEvent(6, listener -> listener.onPlaybackSuppressionReasonChanged(newPlaybackInfo.playbackSuppressionReason));
        }
        if (ExoPlayerImpl.isPlaying(previousPlaybackInfo) != ExoPlayerImpl.isPlaying(newPlaybackInfo)) {
            this.listeners.queueEvent(7, listener -> listener.onIsPlayingChanged(ExoPlayerImpl.isPlaying(newPlaybackInfo)));
        }
        if (!previousPlaybackInfo.playbackParameters.equals((Object)newPlaybackInfo.playbackParameters)) {
            this.listeners.queueEvent(12, listener -> listener.onPlaybackParametersChanged(newPlaybackInfo.playbackParameters));
        }
        if (seekProcessed) {
            this.listeners.queueEvent(-1, Player.Listener::onSeekProcessed);
        }
        this.updateAvailableCommands();
        this.listeners.flushEvents();
        if (previousPlaybackInfo.offloadSchedulingEnabled != newPlaybackInfo.offloadSchedulingEnabled) {
            for (ExoPlayer.AudioOffloadListener listener2 : this.audioOffloadListeners) {
                listener2.onExperimentalOffloadSchedulingEnabledChanged(newPlaybackInfo.offloadSchedulingEnabled);
            }
        }
        if (previousPlaybackInfo.sleepingForOffload != newPlaybackInfo.sleepingForOffload) {
            for (ExoPlayer.AudioOffloadListener listener2 : this.audioOffloadListeners) {
                listener2.onExperimentalSleepingForOffloadChanged(newPlaybackInfo.sleepingForOffload);
            }
        }
    }

    private Player.PositionInfo getPreviousPositionInfo(int positionDiscontinuityReason, PlaybackInfo oldPlaybackInfo, int oldMaskingMediaItemIndex) {
        long oldContentPositionUs;
        long oldPositionUs;
        Object oldWindowUid = null;
        Object oldPeriodUid = null;
        int oldMediaItemIndex = oldMaskingMediaItemIndex;
        int oldPeriodIndex = -1;
        MediaItem oldMediaItem = null;
        Timeline.Period oldPeriod = new Timeline.Period();
        if (!oldPlaybackInfo.timeline.isEmpty()) {
            oldPeriodUid = oldPlaybackInfo.periodId.periodUid;
            oldPlaybackInfo.timeline.getPeriodByUid(oldPeriodUid, oldPeriod);
            oldMediaItemIndex = oldPeriod.windowIndex;
            oldPeriodIndex = oldPlaybackInfo.timeline.getIndexOfPeriod(oldPeriodUid);
            oldWindowUid = oldPlaybackInfo.timeline.getWindow((int)oldMediaItemIndex, (Timeline.Window)this.window).uid;
            oldMediaItem = this.window.mediaItem;
        }
        if (positionDiscontinuityReason == 0) {
            if (oldPlaybackInfo.periodId.isAd()) {
                oldPositionUs = oldPeriod.getAdDurationUs(oldPlaybackInfo.periodId.adGroupIndex, oldPlaybackInfo.periodId.adIndexInAdGroup);
                oldContentPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(oldPlaybackInfo);
            } else {
                oldContentPositionUs = oldPlaybackInfo.periodId.nextAdGroupIndex != -1 ? (oldPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(this.playbackInfo)) : (oldPositionUs = oldPeriod.positionInWindowUs + oldPeriod.durationUs);
            }
        } else if (oldPlaybackInfo.periodId.isAd()) {
            oldPositionUs = oldPlaybackInfo.positionUs;
            oldContentPositionUs = ExoPlayerImpl.getRequestedContentPositionUs(oldPlaybackInfo);
        } else {
            oldContentPositionUs = oldPositionUs = oldPeriod.positionInWindowUs + oldPlaybackInfo.positionUs;
        }
        return new Player.PositionInfo(oldWindowUid, oldMediaItemIndex, oldMediaItem, oldPeriodUid, oldPeriodIndex, Util.usToMs((long)oldPositionUs), Util.usToMs((long)oldContentPositionUs), oldPlaybackInfo.periodId.adGroupIndex, oldPlaybackInfo.periodId.adIndexInAdGroup);
    }

    private Player.PositionInfo getPositionInfo(long discontinuityWindowStartPositionUs) {
        Object newWindowUid = null;
        Object newPeriodUid = null;
        int newMediaItemIndex = this.getCurrentMediaItemIndex();
        int newPeriodIndex = -1;
        MediaItem newMediaItem = null;
        if (!this.playbackInfo.timeline.isEmpty()) {
            newPeriodUid = this.playbackInfo.periodId.periodUid;
            this.playbackInfo.timeline.getPeriodByUid(newPeriodUid, this.period);
            newPeriodIndex = this.playbackInfo.timeline.getIndexOfPeriod(newPeriodUid);
            newWindowUid = this.playbackInfo.timeline.getWindow((int)newMediaItemIndex, (Timeline.Window)this.window).uid;
            newMediaItem = this.window.mediaItem;
        }
        long positionMs = Util.usToMs((long)discontinuityWindowStartPositionUs);
        return new Player.PositionInfo(newWindowUid, newMediaItemIndex, newMediaItem, newPeriodUid, newPeriodIndex, positionMs, this.playbackInfo.periodId.isAd() ? Util.usToMs((long)ExoPlayerImpl.getRequestedContentPositionUs(this.playbackInfo)) : positionMs, this.playbackInfo.periodId.adGroupIndex, this.playbackInfo.periodId.adIndexInAdGroup);
    }

    private static long getRequestedContentPositionUs(PlaybackInfo playbackInfo) {
        Timeline.Window window = new Timeline.Window();
        Timeline.Period period = new Timeline.Period();
        playbackInfo.timeline.getPeriodByUid(playbackInfo.periodId.periodUid, period);
        return playbackInfo.requestedContentPositionUs == -9223372036854775807L ? playbackInfo.timeline.getWindow(period.windowIndex, window).getDefaultPositionUs() : period.getPositionInWindowUs() + playbackInfo.requestedContentPositionUs;
    }

    private Pair<Boolean, Integer> evaluateMediaItemTransitionReason(PlaybackInfo playbackInfo, PlaybackInfo oldPlaybackInfo, boolean positionDiscontinuity, int positionDiscontinuityReason, boolean timelineChanged) {
        Timeline oldTimeline = oldPlaybackInfo.timeline;
        Timeline newTimeline = playbackInfo.timeline;
        if (newTimeline.isEmpty() && oldTimeline.isEmpty()) {
            return new Pair((Object)false, (Object)-1);
        }
        if (newTimeline.isEmpty() != oldTimeline.isEmpty()) {
            return new Pair((Object)true, (Object)3);
        }
        int oldWindowIndex = oldTimeline.getPeriodByUid((Object)oldPlaybackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object oldWindowUid = oldTimeline.getWindow((int)oldWindowIndex, (Timeline.Window)this.window).uid;
        int newWindowIndex = newTimeline.getPeriodByUid((Object)playbackInfo.periodId.periodUid, (Timeline.Period)this.period).windowIndex;
        Object newWindowUid = newTimeline.getWindow((int)newWindowIndex, (Timeline.Window)this.window).uid;
        if (!oldWindowUid.equals(newWindowUid)) {
            int transitionReason;
            if (positionDiscontinuity && positionDiscontinuityReason == 0) {
                transitionReason = 1;
            } else if (positionDiscontinuity && positionDiscontinuityReason == 1) {
                transitionReason = 2;
            } else if (timelineChanged) {
                transitionReason = 3;
            } else {
                throw new IllegalStateException();
            }
            return new Pair((Object)true, (Object)transitionReason);
        }
        if (positionDiscontinuity && positionDiscontinuityReason == 0 && oldPlaybackInfo.periodId.windowSequenceNumber < playbackInfo.periodId.windowSequenceNumber) {
            return new Pair((Object)true, (Object)0);
        }
        return new Pair((Object)false, (Object)-1);
    }

    private void updateAvailableCommands() {
        Player.Commands previousAvailableCommands = this.availableCommands;
        this.availableCommands = Util.getAvailableCommands((Player)this.wrappingPlayer, (Player.Commands)this.permanentAvailableCommands);
        if (!this.availableCommands.equals((Object)previousAvailableCommands)) {
            this.listeners.queueEvent(13, listener -> listener.onAvailableCommandsChanged(this.availableCommands));
        }
    }

    private void setMediaSourcesInternal(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs, boolean resetToDefaultPosition) {
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        long currentPositionMs = this.getCurrentPosition();
        ++this.pendingOperationAcks;
        if (!this.mediaSourceHolderSnapshots.isEmpty()) {
            this.removeMediaSourceHolders(0, this.mediaSourceHolderSnapshots.size());
        }
        List<MediaSourceList.MediaSourceHolder> holders = this.addMediaSourceHolders(0, mediaSources);
        Timeline timeline = this.createMaskingTimeline();
        if (!timeline.isEmpty() && startWindowIndex >= timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(timeline, startWindowIndex, startPositionMs);
        }
        if (resetToDefaultPosition) {
            startWindowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            startPositionMs = -9223372036854775807L;
        } else if (startWindowIndex == -1) {
            startWindowIndex = currentWindowIndex;
            startPositionMs = currentPositionMs;
        }
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, timeline, this.maskWindowPositionMsOrGetPeriodPositionUs(timeline, startWindowIndex, startPositionMs));
        int maskingPlaybackState = newPlaybackInfo.playbackState;
        if (startWindowIndex != -1 && newPlaybackInfo.playbackState != 1) {
            maskingPlaybackState = timeline.isEmpty() || startWindowIndex >= timeline.getWindowCount() ? 4 : 2;
        }
        newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(maskingPlaybackState);
        this.internalPlayer.setMediaSources(holders, startWindowIndex, Util.msToUs((long)startPositionMs), this.shuffleOrder);
        boolean positionDiscontinuity = !this.playbackInfo.periodId.periodUid.equals(newPlaybackInfo.periodId.periodUid) && !this.playbackInfo.timeline.isEmpty();
        this.updatePlaybackInfo(newPlaybackInfo, 0, 1, false, positionDiscontinuity, 4, this.getCurrentPositionUsInternal(newPlaybackInfo), -1);
    }

    private List<MediaSourceList.MediaSourceHolder> addMediaSourceHolders(int index, List<MediaSource> mediaSources) {
        ArrayList<MediaSourceList.MediaSourceHolder> holders = new ArrayList<MediaSourceList.MediaSourceHolder>();
        for (int i = 0; i < mediaSources.size(); ++i) {
            MediaSourceList.MediaSourceHolder holder = new MediaSourceList.MediaSourceHolder(mediaSources.get(i), this.useLazyPreparation);
            holders.add(holder);
            this.mediaSourceHolderSnapshots.add(i + index, new MediaSourceHolderSnapshot(holder.uid, holder.mediaSource.getTimeline()));
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndInsert(index, holders.size());
        return holders;
    }

    private PlaybackInfo removeMediaItemsInternal(int fromIndex, int toIndex) {
        boolean transitionsToEnded;
        Assertions.checkArgument((fromIndex >= 0 && toIndex >= fromIndex && toIndex <= this.mediaSourceHolderSnapshots.size() ? 1 : 0) != 0);
        int currentIndex = this.getCurrentMediaItemIndex();
        Timeline oldTimeline = this.getCurrentTimeline();
        int currentMediaSourceCount = this.mediaSourceHolderSnapshots.size();
        ++this.pendingOperationAcks;
        this.removeMediaSourceHolders(fromIndex, toIndex);
        Timeline newTimeline = this.createMaskingTimeline();
        PlaybackInfo newPlaybackInfo = this.maskTimelineAndPosition(this.playbackInfo, newTimeline, this.getPeriodPositionUsAfterTimelineChanged(oldTimeline, newTimeline));
        boolean bl = transitionsToEnded = newPlaybackInfo.playbackState != 1 && newPlaybackInfo.playbackState != 4 && fromIndex < toIndex && toIndex == currentMediaSourceCount && currentIndex >= newPlaybackInfo.timeline.getWindowCount();
        if (transitionsToEnded) {
            newPlaybackInfo = newPlaybackInfo.copyWithPlaybackState(4);
        }
        this.internalPlayer.removeMediaSources(fromIndex, toIndex, this.shuffleOrder);
        return newPlaybackInfo;
    }

    private void removeMediaSourceHolders(int fromIndex, int toIndexExclusive) {
        for (int i = toIndexExclusive - 1; i >= fromIndex; --i) {
            this.mediaSourceHolderSnapshots.remove(i);
        }
        this.shuffleOrder = this.shuffleOrder.cloneAndRemove(fromIndex, toIndexExclusive);
    }

    private Timeline createMaskingTimeline() {
        return new PlaylistTimeline(this.mediaSourceHolderSnapshots, this.shuffleOrder);
    }

    private PlaybackInfo maskTimelineAndPosition(PlaybackInfo playbackInfo, Timeline timeline, @Nullable Pair<Object, Long> periodPositionUs) {
        Assertions.checkArgument((timeline.isEmpty() || periodPositionUs != null ? 1 : 0) != 0);
        Timeline oldTimeline = playbackInfo.timeline;
        playbackInfo = playbackInfo.copyWithTimeline(timeline);
        if (timeline.isEmpty()) {
            MediaSource.MediaPeriodId dummyMediaPeriodId = PlaybackInfo.getDummyPeriodForEmptyTimeline();
            long positionUs = Util.msToUs((long)this.maskingWindowPositionMs);
            playbackInfo = playbackInfo.copyWithNewPosition(dummyMediaPeriodId, positionUs, positionUs, positionUs, 0L, TrackGroupArray.EMPTY, this.emptyTrackSelectorResult, (List<Metadata>)ImmutableList.of());
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(dummyMediaPeriodId);
            playbackInfo.bufferedPositionUs = playbackInfo.positionUs;
            return playbackInfo;
        }
        Object oldPeriodUid = playbackInfo.periodId.periodUid;
        boolean playingPeriodChanged = !oldPeriodUid.equals(((Pair)Util.castNonNull(periodPositionUs)).first);
        MediaSource.MediaPeriodId newPeriodId = playingPeriodChanged ? new MediaSource.MediaPeriodId(periodPositionUs.first) : playbackInfo.periodId;
        long newContentPositionUs = (Long)periodPositionUs.second;
        long oldContentPositionUs = Util.msToUs((long)this.getContentPosition());
        if (!oldTimeline.isEmpty()) {
            oldContentPositionUs -= oldTimeline.getPeriodByUid(oldPeriodUid, this.period).getPositionInWindowUs();
        }
        if (playingPeriodChanged || newContentPositionUs < oldContentPositionUs) {
            Assertions.checkState((!newPeriodId.isAd() ? 1 : 0) != 0);
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, newContentPositionUs, 0L, playingPeriodChanged ? TrackGroupArray.EMPTY : playbackInfo.trackGroups, playingPeriodChanged ? this.emptyTrackSelectorResult : playbackInfo.trackSelectorResult, (List<Metadata>)(playingPeriodChanged ? ImmutableList.of() : playbackInfo.staticMetadata));
            playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
            playbackInfo.bufferedPositionUs = newContentPositionUs;
        } else if (newContentPositionUs == oldContentPositionUs) {
            int loadingPeriodIndex = timeline.getIndexOfPeriod(playbackInfo.loadingMediaPeriodId.periodUid);
            if (loadingPeriodIndex == -1 || timeline.getPeriod((int)loadingPeriodIndex, (Timeline.Period)this.period).windowIndex != timeline.getPeriodByUid((Object)newPeriodId.periodUid, (Timeline.Period)this.period).windowIndex) {
                timeline.getPeriodByUid(newPeriodId.periodUid, this.period);
                long maskedBufferedPositionUs = newPeriodId.isAd() ? this.period.getAdDurationUs(newPeriodId.adGroupIndex, newPeriodId.adIndexInAdGroup) : this.period.durationUs;
                playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, playbackInfo.positionUs, playbackInfo.positionUs, playbackInfo.discontinuityStartPositionUs, maskedBufferedPositionUs - playbackInfo.positionUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata);
                playbackInfo = playbackInfo.copyWithLoadingMediaPeriodId(newPeriodId);
                playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
            }
        } else {
            Assertions.checkState((!newPeriodId.isAd() ? 1 : 0) != 0);
            long maskedTotalBufferedDurationUs = Math.max(0L, playbackInfo.totalBufferedDurationUs - (newContentPositionUs - oldContentPositionUs));
            long maskedBufferedPositionUs = playbackInfo.bufferedPositionUs;
            if (playbackInfo.loadingMediaPeriodId.equals((Object)playbackInfo.periodId)) {
                maskedBufferedPositionUs = newContentPositionUs + maskedTotalBufferedDurationUs;
            }
            playbackInfo = playbackInfo.copyWithNewPosition(newPeriodId, newContentPositionUs, newContentPositionUs, newContentPositionUs, maskedTotalBufferedDurationUs, playbackInfo.trackGroups, playbackInfo.trackSelectorResult, playbackInfo.staticMetadata);
            playbackInfo.bufferedPositionUs = maskedBufferedPositionUs;
        }
        return playbackInfo;
    }

    @Nullable
    private Pair<Object, Long> getPeriodPositionUsAfterTimelineChanged(Timeline oldTimeline, Timeline newTimeline) {
        long currentPositionMs = this.getContentPosition();
        if (oldTimeline.isEmpty() || newTimeline.isEmpty()) {
            boolean isCleared = !oldTimeline.isEmpty() && newTimeline.isEmpty();
            return this.maskWindowPositionMsOrGetPeriodPositionUs(newTimeline, isCleared ? -1 : this.getCurrentWindowIndexInternal(), isCleared ? -9223372036854775807L : currentPositionMs);
        }
        int currentMediaItemIndex = this.getCurrentMediaItemIndex();
        Pair oldPeriodPositionUs = oldTimeline.getPeriodPositionUs(this.window, this.period, currentMediaItemIndex, Util.msToUs((long)currentPositionMs));
        Object periodUid = ((Pair)Util.castNonNull((Object)oldPeriodPositionUs)).first;
        if (newTimeline.getIndexOfPeriod(periodUid) != -1) {
            return oldPeriodPositionUs;
        }
        Object nextPeriodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(this.window, this.period, this.repeatMode, this.shuffleModeEnabled, periodUid, oldTimeline, newTimeline);
        if (nextPeriodUid != null) {
            newTimeline.getPeriodByUid(nextPeriodUid, this.period);
            return this.maskWindowPositionMsOrGetPeriodPositionUs(newTimeline, this.period.windowIndex, newTimeline.getWindow(this.period.windowIndex, this.window).getDefaultPositionMs());
        }
        return this.maskWindowPositionMsOrGetPeriodPositionUs(newTimeline, -1, -9223372036854775807L);
    }

    @Nullable
    private Pair<Object, Long> maskWindowPositionMsOrGetPeriodPositionUs(Timeline timeline, int windowIndex, long windowPositionMs) {
        if (timeline.isEmpty()) {
            this.maskingWindowIndex = windowIndex;
            this.maskingWindowPositionMs = windowPositionMs == -9223372036854775807L ? 0L : windowPositionMs;
            this.maskingPeriodIndex = 0;
            return null;
        }
        if (windowIndex == -1 || windowIndex >= timeline.getWindowCount()) {
            windowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
            windowPositionMs = timeline.getWindow(windowIndex, this.window).getDefaultPositionMs();
        }
        return timeline.getPeriodPositionUs(this.window, this.period, windowIndex, Util.msToUs((long)windowPositionMs));
    }

    private long periodPositionUsToWindowPositionUs(Timeline timeline, MediaSource.MediaPeriodId periodId, long positionUs) {
        timeline.getPeriodByUid(periodId.periodUid, this.period);
        return positionUs += this.period.getPositionInWindowUs();
    }

    private PlayerMessage createMessageInternal(PlayerMessage.Target target) {
        int currentWindowIndex = this.getCurrentWindowIndexInternal();
        return new PlayerMessage(this.internalPlayer, target, this.playbackInfo.timeline, currentWindowIndex == -1 ? 0 : currentWindowIndex, this.clock, this.internalPlayer.getPlaybackLooper());
    }

    private MediaMetadata buildUpdatedMediaMetadata() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return this.staticAndDynamicMediaMetadata;
        }
        MediaItem mediaItem = timeline.getWindow((int)this.getCurrentMediaItemIndex(), (Timeline.Window)this.window).mediaItem;
        return this.staticAndDynamicMediaMetadata.buildUpon().populate(mediaItem.mediaMetadata).build();
    }

    private void removeSurfaceCallbacks() {
        if (this.sphericalGLSurfaceView != null) {
            this.createMessageInternal(this.frameMetadataListener).setType(10000).setPayload(null).send();
            this.sphericalGLSurfaceView.removeVideoSurfaceListener(this.componentListener);
            this.sphericalGLSurfaceView = null;
        }
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w((String)TAG, (String)"SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setSurfaceTextureInternal(SurfaceTexture surfaceTexture) {
        Surface surface = new Surface(surfaceTexture);
        this.setVideoOutputInternal(surface);
        this.ownedSurface = surface;
    }

    private void setVideoOutputInternal(@Nullable Object videoOutput) {
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages.add(this.createMessageInternal(renderer).setType(1).setPayload(videoOutput).send());
        }
        boolean messageDeliveryTimedOut = false;
        if (this.videoOutput != null && this.videoOutput != videoOutput) {
            try {
                for (PlayerMessage message : messages) {
                    message.blockUntilDelivered(this.detachSurfaceTimeoutMs);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                messageDeliveryTimedOut = true;
            }
            if (this.videoOutput == this.ownedSurface) {
                this.ownedSurface.release();
                this.ownedSurface = null;
            }
        }
        this.videoOutput = videoOutput;
        if (messageDeliveryTimedOut) {
            this.stopInternal(false, ExoPlaybackException.createForUnexpected(new ExoTimeoutException(3), 1003));
        }
    }

    private void setNonVideoOutputSurfaceHolderInternal(SurfaceHolder nonVideoOutputSurfaceHolder) {
        this.surfaceHolderSurfaceIsVideoOutput = false;
        this.surfaceHolder = nonVideoOutputSurfaceHolder;
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
        Surface surface = this.surfaceHolder.getSurface();
        if (surface != null && surface.isValid()) {
            Rect surfaceSize = this.surfaceHolder.getSurfaceFrame();
            this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
        } else {
            this.maybeNotifySurfaceSizeChanged(0, 0);
        }
    }

    private void maybeNotifySurfaceSizeChanged(int width, int height) {
        if (width != this.surfaceWidth || height != this.surfaceHeight) {
            this.surfaceWidth = width;
            this.surfaceHeight = height;
            this.listeners.sendEvent(24, listener -> listener.onSurfaceSizeChanged(width, height));
        }
    }

    private void sendVolumeToRenderers() {
        float scaledVolume = this.volume * this.audioFocusManager.getVolumeMultiplier();
        this.sendRendererMessage(1, 2, Float.valueOf(scaledVolume));
    }

    private void updatePlayWhenReady(boolean playWhenReady, int playerCommand, int playWhenReadyChangeReason) {
        int playbackSuppressionReason;
        playWhenReady = playWhenReady && playerCommand != -1;
        int n = playbackSuppressionReason = playWhenReady && playerCommand != 1 ? 1 : 0;
        if (this.playbackInfo.playWhenReady == playWhenReady && this.playbackInfo.playbackSuppressionReason == playbackSuppressionReason) {
            return;
        }
        ++this.pendingOperationAcks;
        PlaybackInfo playbackInfo = this.playbackInfo.copyWithPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.internalPlayer.setPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.updatePlaybackInfo(playbackInfo, 0, playWhenReadyChangeReason, false, false, 5, -9223372036854775807L, -1);
    }

    private void updateWakeAndWifiLock() {
        int playbackState = this.getPlaybackState();
        switch (playbackState) {
            case 2: 
            case 3: {
                boolean isSleeping = this.experimentalIsSleepingForOffload();
                this.wakeLockManager.setStayAwake(this.getPlayWhenReady() && !isSleeping);
                this.wifiLockManager.setStayAwake(this.getPlayWhenReady());
                break;
            }
            case 1: 
            case 4: {
                this.wakeLockManager.setStayAwake(false);
                this.wifiLockManager.setStayAwake(false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void verifyApplicationThread() {
        this.constructorFinished.blockUninterruptible();
        if (Thread.currentThread() != this.getApplicationLooper().getThread()) {
            String message = Util.formatInvariant((String)"Player is accessed on the wrong thread.\nCurrent thread: '%s'\nExpected thread: '%s'\nSee https://exoplayer.dev/issues/player-accessed-on-wrong-thread", (Object[])new Object[]{Thread.currentThread().getName(), this.getApplicationLooper().getThread().getName()});
            if (this.throwsWhenUsingWrongThread) {
                throw new IllegalStateException(message);
            }
            Log.w((String)TAG, (String)message, (Throwable)(this.hasNotifiedFullWrongThreadWarning ? null : new IllegalStateException()));
            this.hasNotifiedFullWrongThreadWarning = true;
        }
    }

    private void sendRendererMessage(int trackType, int messageType, @Nullable Object payload) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != trackType) continue;
            this.createMessageInternal(renderer).setType(messageType).setPayload(payload).send();
        }
    }

    private int initializeKeepSessionIdAudioTrack(int audioSessionId) {
        if (this.keepSessionIdAudioTrack != null && this.keepSessionIdAudioTrack.getAudioSessionId() != audioSessionId) {
            this.keepSessionIdAudioTrack.release();
            this.keepSessionIdAudioTrack = null;
        }
        if (this.keepSessionIdAudioTrack == null) {
            int sampleRate = 4000;
            int channelConfig = 4;
            int encoding = 2;
            int bufferSize = 2;
            this.keepSessionIdAudioTrack = new AudioTrack(3, sampleRate, channelConfig, encoding, bufferSize, 0, audioSessionId);
        }
        return this.keepSessionIdAudioTrack.getAudioSessionId();
    }

    private void updatePriorityTaskManagerForIsLoadingChange(boolean isLoading) {
        if (this.priorityTaskManager != null) {
            if (isLoading && !this.isPriorityTaskManagerRegistered) {
                this.priorityTaskManager.add(0);
                this.isPriorityTaskManagerRegistered = true;
            } else if (!isLoading && this.isPriorityTaskManagerRegistered) {
                this.priorityTaskManager.remove(0);
                this.isPriorityTaskManagerRegistered = false;
            }
        }
    }

    private static DeviceInfo createDeviceInfo(StreamVolumeManager streamVolumeManager) {
        return new DeviceInfo(0, streamVolumeManager.getMinVolume(), streamVolumeManager.getMaxVolume());
    }

    private static int getPlayWhenReadyChangeReason(boolean playWhenReady, int playerCommand) {
        return playWhenReady && playerCommand != 1 ? 2 : 1;
    }

    private static boolean isPlaying(PlaybackInfo playbackInfo) {
        return playbackInfo.playbackState == 3 && playbackInfo.playWhenReady && playbackInfo.playbackSuppressionReason == 0;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.exoplayer");
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static PlayerId createPlayerId() {
            return new PlayerId(LogSessionId.LOG_SESSION_ID_NONE);
        }
    }

    private static final class FrameMetadataListener
    implements VideoFrameMetadataListener,
    CameraMotionListener,
    PlayerMessage.Target {
        public static final int MSG_SET_VIDEO_FRAME_METADATA_LISTENER = 7;
        public static final int MSG_SET_CAMERA_MOTION_LISTENER = 8;
        public static final int MSG_SET_SPHERICAL_SURFACE_VIEW = 10000;
        @Nullable
        private VideoFrameMetadataListener videoFrameMetadataListener;
        @Nullable
        private CameraMotionListener cameraMotionListener;
        @Nullable
        private VideoFrameMetadataListener internalVideoFrameMetadataListener;
        @Nullable
        private CameraMotionListener internalCameraMotionListener;

        private FrameMetadataListener() {
        }

        @Override
        public void handleMessage(int messageType, @Nullable Object message) {
            switch (messageType) {
                case 7: {
                    this.videoFrameMetadataListener = (VideoFrameMetadataListener)message;
                    break;
                }
                case 8: {
                    this.cameraMotionListener = (CameraMotionListener)message;
                    break;
                }
                case 10000: {
                    SphericalGLSurfaceView surfaceView = (SphericalGLSurfaceView)((Object)message);
                    if (surfaceView == null) {
                        this.internalVideoFrameMetadataListener = null;
                        this.internalCameraMotionListener = null;
                        break;
                    }
                    this.internalVideoFrameMetadataListener = surfaceView.getVideoFrameMetadataListener();
                    this.internalCameraMotionListener = surfaceView.getCameraMotionListener();
                    break;
                }
            }
        }

        @Override
        public void onVideoFrameAboutToBeRendered(long presentationTimeUs, long releaseTimeNs, Format format, @Nullable MediaFormat mediaFormat) {
            if (this.internalVideoFrameMetadataListener != null) {
                this.internalVideoFrameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, mediaFormat);
            }
            if (this.videoFrameMetadataListener != null) {
                this.videoFrameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, mediaFormat);
            }
        }

        @Override
        public void onCameraMotion(long timeUs, float[] rotation) {
            if (this.internalCameraMotionListener != null) {
                this.internalCameraMotionListener.onCameraMotion(timeUs, rotation);
            }
            if (this.cameraMotionListener != null) {
                this.cameraMotionListener.onCameraMotion(timeUs, rotation);
            }
        }

        @Override
        public void onCameraMotionReset() {
            if (this.internalCameraMotionListener != null) {
                this.internalCameraMotionListener.onCameraMotionReset();
            }
            if (this.cameraMotionListener != null) {
                this.cameraMotionListener.onCameraMotionReset();
            }
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    SphericalGLSurfaceView.VideoSurfaceListener,
    AudioFocusManager.PlayerControl,
    AudioBecomingNoisyManager.EventListener,
    StreamVolumeManager.Listener,
    ExoPlayer.AudioOffloadListener {
        private ComponentListener() {
        }

        @Override
        public void onVideoEnabled(DecoderCounters counters) {
            ExoPlayerImpl.this.videoDecoderCounters = counters;
            ExoPlayerImpl.this.analyticsCollector.onVideoEnabled(counters);
        }

        @Override
        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            ExoPlayerImpl.this.analyticsCollector.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        @Override
        public void onVideoInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            ExoPlayerImpl.this.videoFormat = format;
            ExoPlayerImpl.this.analyticsCollector.onVideoInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onDroppedFrames(int count, long elapsed) {
            ExoPlayerImpl.this.analyticsCollector.onDroppedFrames(count, elapsed);
        }

        @Override
        public void onVideoSizeChanged(VideoSize newVideoSize) {
            ExoPlayerImpl.this.videoSize = newVideoSize;
            ExoPlayerImpl.this.listeners.sendEvent(25, listener -> listener.onVideoSizeChanged(newVideoSize));
        }

        @Override
        public void onRenderedFirstFrame(Object output, long renderTimeMs) {
            ExoPlayerImpl.this.analyticsCollector.onRenderedFirstFrame(output, renderTimeMs);
            if (ExoPlayerImpl.this.videoOutput == output) {
                ExoPlayerImpl.this.listeners.sendEvent(26, Player.Listener::onRenderedFirstFrame);
            }
        }

        @Override
        public void onVideoDecoderReleased(String decoderName) {
            ExoPlayerImpl.this.analyticsCollector.onVideoDecoderReleased(decoderName);
        }

        @Override
        public void onVideoDisabled(DecoderCounters counters) {
            ExoPlayerImpl.this.analyticsCollector.onVideoDisabled(counters);
            ExoPlayerImpl.this.videoFormat = null;
            ExoPlayerImpl.this.videoDecoderCounters = null;
        }

        @Override
        public void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
            ExoPlayerImpl.this.analyticsCollector.onVideoFrameProcessingOffset(totalProcessingOffsetUs, frameCount);
        }

        @Override
        public void onVideoCodecError(Exception videoCodecError) {
            ExoPlayerImpl.this.analyticsCollector.onVideoCodecError(videoCodecError);
        }

        @Override
        public void onAudioEnabled(DecoderCounters counters) {
            ExoPlayerImpl.this.audioDecoderCounters = counters;
            ExoPlayerImpl.this.analyticsCollector.onAudioEnabled(counters);
        }

        @Override
        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            ExoPlayerImpl.this.analyticsCollector.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        @Override
        public void onAudioInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            ExoPlayerImpl.this.audioFormat = format;
            ExoPlayerImpl.this.analyticsCollector.onAudioInputFormatChanged(format, decoderReuseEvaluation);
        }

        @Override
        public void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
            ExoPlayerImpl.this.analyticsCollector.onAudioPositionAdvancing(playoutStartSystemTimeMs);
        }

        @Override
        public void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            ExoPlayerImpl.this.analyticsCollector.onAudioUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }

        @Override
        public void onAudioDecoderReleased(String decoderName) {
            ExoPlayerImpl.this.analyticsCollector.onAudioDecoderReleased(decoderName);
        }

        @Override
        public void onAudioDisabled(DecoderCounters counters) {
            ExoPlayerImpl.this.analyticsCollector.onAudioDisabled(counters);
            ExoPlayerImpl.this.audioFormat = null;
            ExoPlayerImpl.this.audioDecoderCounters = null;
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean newSkipSilenceEnabled) {
            if (ExoPlayerImpl.this.skipSilenceEnabled == newSkipSilenceEnabled) {
                return;
            }
            ExoPlayerImpl.this.skipSilenceEnabled = newSkipSilenceEnabled;
            ExoPlayerImpl.this.listeners.sendEvent(23, listener -> listener.onSkipSilenceEnabledChanged(newSkipSilenceEnabled));
        }

        @Override
        public void onAudioSinkError(Exception audioSinkError) {
            ExoPlayerImpl.this.analyticsCollector.onAudioSinkError(audioSinkError);
        }

        @Override
        public void onAudioCodecError(Exception audioCodecError) {
            ExoPlayerImpl.this.analyticsCollector.onAudioCodecError(audioCodecError);
        }

        @Override
        public void onCues(List<Cue> cues) {
            ExoPlayerImpl.this.currentCues = cues;
            ExoPlayerImpl.this.listeners.sendEvent(27, listener -> listener.onCues(cues));
        }

        @Override
        public void onMetadata(Metadata metadata) {
            ExoPlayerImpl.this.staticAndDynamicMediaMetadata = ExoPlayerImpl.this.staticAndDynamicMediaMetadata.buildUpon().populateFromMetadata(metadata).build();
            MediaMetadata newMediaMetadata = ExoPlayerImpl.this.buildUpdatedMediaMetadata();
            if (!newMediaMetadata.equals((Object)ExoPlayerImpl.this.mediaMetadata)) {
                ExoPlayerImpl.this.mediaMetadata = newMediaMetadata;
                ExoPlayerImpl.this.listeners.queueEvent(14, listener -> listener.onMediaMetadataChanged(ExoPlayerImpl.this.mediaMetadata));
            }
            ExoPlayerImpl.this.listeners.queueEvent(28, listener -> listener.onMetadata(metadata));
            ExoPlayerImpl.this.listeners.flushEvents();
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (ExoPlayerImpl.this.surfaceHolderSurfaceIsVideoOutput) {
                ExoPlayerImpl.this.setVideoOutputInternal(holder.getSurface());
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            ExoPlayerImpl.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (ExoPlayerImpl.this.surfaceHolderSurfaceIsVideoOutput) {
                ExoPlayerImpl.this.setVideoOutputInternal(null);
            }
            ExoPlayerImpl.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            ExoPlayerImpl.this.setSurfaceTextureInternal(surfaceTexture);
            ExoPlayerImpl.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            ExoPlayerImpl.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            ExoPlayerImpl.this.setVideoOutputInternal(null);
            ExoPlayerImpl.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void onVideoSurfaceCreated(Surface surface) {
            ExoPlayerImpl.this.setVideoOutputInternal(surface);
        }

        @Override
        public void onVideoSurfaceDestroyed(Surface surface) {
            ExoPlayerImpl.this.setVideoOutputInternal(null);
        }

        @Override
        public void setVolumeMultiplier(float volumeMultiplier) {
            ExoPlayerImpl.this.sendVolumeToRenderers();
        }

        @Override
        public void executePlayerCommand(int playerCommand) {
            boolean playWhenReady = ExoPlayerImpl.this.getPlayWhenReady();
            ExoPlayerImpl.this.updatePlayWhenReady(playWhenReady, playerCommand, ExoPlayerImpl.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        }

        @Override
        public void onAudioBecomingNoisy() {
            ExoPlayerImpl.this.updatePlayWhenReady(false, -1, 3);
        }

        @Override
        public void onStreamTypeChanged(int streamType) {
            DeviceInfo newDeviceInfo = ExoPlayerImpl.createDeviceInfo(ExoPlayerImpl.this.streamVolumeManager);
            if (!newDeviceInfo.equals((Object)ExoPlayerImpl.this.deviceInfo)) {
                ExoPlayerImpl.this.deviceInfo = newDeviceInfo;
                ExoPlayerImpl.this.listeners.sendEvent(29, listener -> listener.onDeviceInfoChanged(newDeviceInfo));
            }
        }

        @Override
        public void onStreamVolumeChanged(int streamVolume, boolean streamMuted) {
            ExoPlayerImpl.this.listeners.sendEvent(30, listener -> listener.onDeviceVolumeChanged(streamVolume, streamMuted));
        }

        @Override
        public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
            ExoPlayerImpl.this.updateWakeAndWifiLock();
        }
    }

    private static final class MediaSourceHolderSnapshot
    implements MediaSourceInfoHolder {
        private final Object uid;
        private Timeline timeline;

        public MediaSourceHolderSnapshot(Object uid, Timeline timeline) {
            this.uid = uid;
            this.timeline = timeline;
        }

        @Override
        public Object getUid() {
            return this.uid;
        }

        @Override
        public Timeline getTimeline() {
            return this.timeline;
        }
    }
}

