/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface AudioProcessor {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());

    public AudioFormat configure(AudioFormat var1) throws UnhandledAudioFormatException;

    public boolean isActive();

    public void queueInput(ByteBuffer var1);

    public void queueEndOfStream();

    public ByteBuffer getOutput();

    public boolean isEnded();

    public void flush();

    public void reset();

    public static final class UnhandledAudioFormatException
    extends Exception {
        public UnhandledAudioFormatException(AudioFormat inputAudioFormat) {
            String string = String.valueOf(inputAudioFormat);
            super(new StringBuilder(18 + String.valueOf(string).length()).append("Unhandled format: ").append(string).toString());
        }
    }

    public static final class AudioFormat {
        public static final AudioFormat NOT_SET = new AudioFormat(-1, -1, -1);
        public final int sampleRate;
        public final int channelCount;
        public final int encoding;
        public final int bytesPerFrame;

        public AudioFormat(int sampleRate, int channelCount, int encoding) {
            this.sampleRate = sampleRate;
            this.channelCount = channelCount;
            this.encoding = encoding;
            this.bytesPerFrame = Util.isEncodingLinearPcm((int)encoding) ? Util.getPcmFrameSize((int)encoding, (int)channelCount) : -1;
        }

        public String toString() {
            int n = this.sampleRate;
            int n2 = this.channelCount;
            int n3 = this.encoding;
            return new StringBuilder(83).append("AudioFormat[sampleRate=").append(n).append(", channelCount=").append(n2).append(", encoding=").append(n3).append(']').toString();
        }
    }
}

