/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.DefaultAudioSink;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;

public class DefaultAudioTrackBufferSizeProvider
implements DefaultAudioSink.AudioTrackBufferSizeProvider {
    private static final int MIN_PCM_BUFFER_DURATION_US = 250000;
    private static final int MAX_PCM_BUFFER_DURATION_US = 750000;
    private static final int PCM_BUFFER_MULTIPLICATION_FACTOR = 4;
    private static final int PASSTHROUGH_BUFFER_DURATION_US = 250000;
    private static final int OFFLOAD_BUFFER_DURATION_US = 50000000;
    private static final int AC3_BUFFER_MULTIPLICATION_FACTOR = 2;
    protected final int minPcmBufferDurationUs;
    protected final int maxPcmBufferDurationUs;
    protected final int pcmBufferMultiplicationFactor;
    protected final int passthroughBufferDurationUs;
    protected final int offloadBufferDurationUs;
    public final int ac3BufferMultiplicationFactor;

    protected DefaultAudioTrackBufferSizeProvider(Builder builder) {
        this.minPcmBufferDurationUs = builder.minPcmBufferDurationUs;
        this.maxPcmBufferDurationUs = builder.maxPcmBufferDurationUs;
        this.pcmBufferMultiplicationFactor = builder.pcmBufferMultiplicationFactor;
        this.passthroughBufferDurationUs = builder.passthroughBufferDurationUs;
        this.offloadBufferDurationUs = builder.offloadBufferDurationUs;
        this.ac3BufferMultiplicationFactor = builder.ac3BufferMultiplicationFactor;
    }

    @Override
    public int getBufferSizeInBytes(int minBufferSizeInBytes, int encoding, int outputMode, int pcmFrameSize, int sampleRate, double maxAudioTrackPlaybackSpeed) {
        int bufferSize = this.get1xBufferSizeInBytes(minBufferSizeInBytes, encoding, outputMode, pcmFrameSize, sampleRate);
        bufferSize = (int)((double)bufferSize * maxAudioTrackPlaybackSpeed);
        bufferSize = Math.max(minBufferSizeInBytes, bufferSize);
        return (bufferSize + pcmFrameSize - 1) / pcmFrameSize * pcmFrameSize;
    }

    protected int get1xBufferSizeInBytes(int minBufferSizeInBytes, int encoding, int outputMode, int pcmFrameSize, int sampleRate) {
        switch (outputMode) {
            case 0: {
                return this.getPcmBufferSizeInBytes(minBufferSizeInBytes, sampleRate, pcmFrameSize);
            }
            case 2: {
                return this.getPassthroughBufferSizeInBytes(encoding);
            }
            case 1: {
                return this.getOffloadBufferSizeInBytes(encoding);
            }
        }
        throw new IllegalArgumentException();
    }

    protected int getPcmBufferSizeInBytes(int minBufferSizeInBytes, int samplingRate, int frameSize) {
        int targetBufferSize = minBufferSizeInBytes * this.pcmBufferMultiplicationFactor;
        int minAppBufferSize = DefaultAudioTrackBufferSizeProvider.durationUsToBytes(this.minPcmBufferDurationUs, samplingRate, frameSize);
        int maxAppBufferSize = DefaultAudioTrackBufferSizeProvider.durationUsToBytes(this.maxPcmBufferDurationUs, samplingRate, frameSize);
        return Util.constrainValue((int)targetBufferSize, (int)minAppBufferSize, (int)maxAppBufferSize);
    }

    protected int getPassthroughBufferSizeInBytes(int encoding) {
        int bufferSizeUs = this.passthroughBufferDurationUs;
        if (encoding == 5) {
            bufferSizeUs *= this.ac3BufferMultiplicationFactor;
        }
        int maxByteRate = DefaultAudioTrackBufferSizeProvider.getMaximumEncodedRateBytesPerSecond(encoding);
        return Ints.checkedCast((long)((long)bufferSizeUs * (long)maxByteRate / 1000000L));
    }

    protected int getOffloadBufferSizeInBytes(int encoding) {
        int maxByteRate = DefaultAudioTrackBufferSizeProvider.getMaximumEncodedRateBytesPerSecond(encoding);
        return Ints.checkedCast((long)((long)this.offloadBufferDurationUs * (long)maxByteRate / 1000000L));
    }

    protected static int durationUsToBytes(int durationUs, int samplingRate, int frameSize) {
        return Ints.checkedCast((long)((long)durationUs * (long)samplingRate * (long)frameSize / 1000000L));
    }

    protected static int getMaximumEncodedRateBytesPerSecond(int encoding) {
        switch (encoding) {
            case 9: {
                return 40000;
            }
            case 10: {
                return 100000;
            }
            case 11: {
                return 16000;
            }
            case 12: {
                return 7000;
            }
            case 16: {
                return 256000;
            }
            case 15: {
                return 8000;
            }
            case 5: {
                return 80000;
            }
            case 6: 
            case 18: {
                return 768000;
            }
            case 17: {
                return 336000;
            }
            case 7: {
                return 192000;
            }
            case 8: {
                return 2250000;
            }
            case 14: {
                return 3062500;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class Builder {
        private int minPcmBufferDurationUs = 250000;
        private int maxPcmBufferDurationUs = 750000;
        private int pcmBufferMultiplicationFactor = 4;
        private int passthroughBufferDurationUs = 250000;
        private int offloadBufferDurationUs = 50000000;
        private int ac3BufferMultiplicationFactor = 2;

        public Builder setMinPcmBufferDurationUs(int minPcmBufferDurationUs) {
            this.minPcmBufferDurationUs = minPcmBufferDurationUs;
            return this;
        }

        public Builder setMaxPcmBufferDurationUs(int maxPcmBufferDurationUs) {
            this.maxPcmBufferDurationUs = maxPcmBufferDurationUs;
            return this;
        }

        public Builder setPcmBufferMultiplicationFactor(int pcmBufferMultiplicationFactor) {
            this.pcmBufferMultiplicationFactor = pcmBufferMultiplicationFactor;
            return this;
        }

        public Builder setPassthroughBufferDurationUs(int passthroughBufferDurationUs) {
            this.passthroughBufferDurationUs = passthroughBufferDurationUs;
            return this;
        }

        public Builder setOffloadBufferDurationUs(int offloadBufferDurationUs) {
            this.offloadBufferDurationUs = offloadBufferDurationUs;
            return this;
        }

        public Builder setAc3BufferMultiplicationFactor(int ac3BufferMultiplicationFactor) {
            this.ac3BufferMultiplicationFactor = ac3BufferMultiplicationFactor;
            return this;
        }

        public DefaultAudioTrackBufferSizeProvider build() {
            return new DefaultAudioTrackBufferSizeProvider(this);
        }
    }
}

