/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.decoder;

import com.google.android.exoplayer2.util.Util;

public final class DecoderCounters {
    public int decoderInitCount;
    public int decoderReleaseCount;
    public int queuedInputBufferCount;
    public int skippedInputBufferCount;
    public int renderedOutputBufferCount;
    public int skippedOutputBufferCount;
    public int droppedBufferCount;
    public int droppedInputBufferCount;
    public int maxConsecutiveDroppedBufferCount;
    public int droppedToKeyframeCount;
    public long totalVideoFrameProcessingOffsetUs;
    public int videoFrameProcessingOffsetCount;

    public synchronized void ensureUpdated() {
    }

    public void merge(DecoderCounters other) {
        this.decoderInitCount += other.decoderInitCount;
        this.decoderReleaseCount += other.decoderReleaseCount;
        this.queuedInputBufferCount += other.queuedInputBufferCount;
        this.skippedInputBufferCount += other.skippedInputBufferCount;
        this.renderedOutputBufferCount += other.renderedOutputBufferCount;
        this.skippedOutputBufferCount += other.skippedOutputBufferCount;
        this.droppedBufferCount += other.droppedBufferCount;
        this.droppedInputBufferCount += other.droppedInputBufferCount;
        this.maxConsecutiveDroppedBufferCount = Math.max(this.maxConsecutiveDroppedBufferCount, other.maxConsecutiveDroppedBufferCount);
        this.droppedToKeyframeCount += other.droppedToKeyframeCount;
        this.addVideoFrameProcessingOffsets(other.totalVideoFrameProcessingOffsetUs, other.videoFrameProcessingOffsetCount);
    }

    public void addVideoFrameProcessingOffset(long processingOffsetUs) {
        this.addVideoFrameProcessingOffsets(processingOffsetUs, 1);
    }

    private void addVideoFrameProcessingOffsets(long totalProcessingOffsetUs, int count) {
        this.totalVideoFrameProcessingOffsetUs += totalProcessingOffsetUs;
        this.videoFrameProcessingOffsetCount += count;
    }

    public String toString() {
        return Util.formatInvariant((String)"DecoderCounters {\n decoderInits=%s,\n decoderReleases=%s\n queuedInputBuffers=%s\n skippedInputBuffers=%s\n renderedOutputBuffers=%s\n skippedOutputBuffers=%s\n droppedBuffers=%s\n droppedInputBuffers=%s\n maxConsecutiveDroppedBuffers=%s\n droppedToKeyframeEvents=%s\n totalVideoFrameProcessingOffsetUs=%s\n videoFrameProcessingOffsetCount=%s\n}", (Object[])new Object[]{this.decoderInitCount, this.decoderReleaseCount, this.queuedInputBufferCount, this.skippedInputBufferCount, this.renderedOutputBufferCount, this.skippedOutputBufferCount, this.droppedBufferCount, this.droppedInputBufferCount, this.maxConsecutiveDroppedBufferCount, this.droppedToKeyframeCount, this.totalVideoFrameProcessingOffsetUs, this.videoFrameProcessingOffsetCount});
    }
}

