/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.media.DeniedByServerException;
import android.media.MediaCryptoException;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.os.PersistableBundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.decoder.CryptoConfig;
import com.google.android.exoplayer2.drm.DrmInitData;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface ExoMediaDrm {
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;

    public void setOnEventListener(@Nullable OnEventListener var1);

    public void setOnKeyStatusChangeListener(@Nullable OnKeyStatusChangeListener var1);

    public void setOnExpirationUpdateListener(@Nullable OnExpirationUpdateListener var1);

    public byte[] openSession() throws MediaDrmException;

    public void closeSession(byte[] var1);

    default public void setPlayerIdForSession(byte[] sessionId, PlayerId playerId) {
    }

    public KeyRequest getKeyRequest(byte[] var1, @Nullable List<DrmInitData.SchemeData> var2, int var3, @Nullable HashMap<String, String> var4) throws NotProvisionedException;

    @Nullable
    public byte[] provideKeyResponse(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public ProvisionRequest getProvisionRequest();

    public void provideProvisionResponse(byte[] var1) throws DeniedByServerException;

    public Map<String, String> queryKeyStatus(byte[] var1);

    public boolean requiresSecureDecoder(byte[] var1, String var2);

    public void acquire();

    public void release();

    public void restoreKeys(byte[] var1, byte[] var2);

    @Nullable
    public PersistableBundle getMetrics();

    public String getPropertyString(String var1);

    public byte[] getPropertyByteArray(String var1);

    public void setPropertyString(String var1, String var2);

    public void setPropertyByteArray(String var1, byte[] var2);

    public CryptoConfig createCryptoConfig(byte[] var1) throws MediaCryptoException;

    public int getCryptoType();

    public static final class ProvisionRequest {
        private final byte[] data;
        private final String defaultUrl;

        public ProvisionRequest(byte[] data, String defaultUrl) {
            this.data = data;
            this.defaultUrl = defaultUrl;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getDefaultUrl() {
            return this.defaultUrl;
        }
    }

    public static final class KeyRequest {
        public static final int REQUEST_TYPE_UNKNOWN = Integer.MIN_VALUE;
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_UPDATE = 4;
        private final byte[] data;
        private final String licenseServerUrl;
        private final int requestType;

        public KeyRequest(byte[] data, String licenseServerUrl) {
            this(data, licenseServerUrl, Integer.MIN_VALUE);
        }

        public KeyRequest(byte[] data, String licenseServerUrl, int requestType) {
            this.data = data;
            this.licenseServerUrl = licenseServerUrl;
            this.requestType = requestType;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getLicenseServerUrl() {
            return this.licenseServerUrl;
        }

        public int getRequestType() {
            return this.requestType;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface RequestType {
        }
    }

    public static final class KeyStatus {
        private final int statusCode;
        private final byte[] keyId;

        public KeyStatus(int statusCode, byte[] keyId) {
            this.statusCode = statusCode;
            this.keyId = keyId;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getKeyId() {
            return this.keyId;
        }
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(ExoMediaDrm var1, byte[] var2, long var3);
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(ExoMediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface OnEventListener {
        public void onEvent(ExoMediaDrm var1, @Nullable byte[] var2, int var3, int var4, @Nullable byte[] var5);
    }

    public static final class AppManagedProvider
    implements Provider {
        private final ExoMediaDrm exoMediaDrm;

        public AppManagedProvider(ExoMediaDrm exoMediaDrm) {
            this.exoMediaDrm = exoMediaDrm;
        }

        @Override
        public ExoMediaDrm acquireExoMediaDrm(UUID uuid) {
            this.exoMediaDrm.acquire();
            return this.exoMediaDrm;
        }
    }

    public static interface Provider {
        public ExoMediaDrm acquireExoMediaDrm(UUID var1);
    }
}

