/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import com.google.android.exoplayer2.mediacodec.AsynchronousMediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.SynchronousMediaCodecAdapter;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class DefaultMediaCodecAdapterFactory
implements MediaCodecAdapter.Factory {
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ENABLED = 1;
    private static final int MODE_DISABLED = 2;
    private static final String TAG = "DMCodecAdapterFactory";
    private int asynchronousMode = 0;
    private boolean enableSynchronizeCodecInteractionsWithQueueing;
    private boolean enableImmediateCodecStartAfterFlush = true;

    public DefaultMediaCodecAdapterFactory forceEnableAsynchronous() {
        this.asynchronousMode = 1;
        return this;
    }

    public DefaultMediaCodecAdapterFactory forceDisableAsynchronous() {
        this.asynchronousMode = 2;
        return this;
    }

    public void experimentalSetSynchronizeCodecInteractionsWithQueueingEnabled(boolean enabled) {
        this.enableSynchronizeCodecInteractionsWithQueueing = enabled;
    }

    public void experimentalSetImmediateCodecStartAfterFlushEnabled(boolean enabled) {
        this.enableImmediateCodecStartAfterFlush = enabled;
    }

    @Override
    public MediaCodecAdapter createAdapter(MediaCodecAdapter.Configuration configuration) throws IOException {
        if (this.asynchronousMode == 1 && Util.SDK_INT >= 23 || this.asynchronousMode == 0 && Util.SDK_INT >= 31) {
            int trackType = MimeTypes.getTrackType((String)configuration.format.sampleMimeType);
            String string = String.valueOf(Util.getTrackTypeString((int)trackType));
            Log.i((String)TAG, (String)(string.length() != 0 ? "Creating an asynchronous MediaCodec adapter for track type ".concat(string) : new String("Creating an asynchronous MediaCodec adapter for track type ")));
            AsynchronousMediaCodecAdapter.Factory factory = new AsynchronousMediaCodecAdapter.Factory(trackType, this.enableSynchronizeCodecInteractionsWithQueueing, this.enableImmediateCodecStartAfterFlush);
            return factory.createAdapter(configuration);
        }
        return new SynchronousMediaCodecAdapter.Factory().createAdapter(configuration);
    }
}

