/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.decoder.DecoderException;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.util.Util;

public class MediaCodecDecoderException
extends DecoderException {
    @Nullable
    public final MediaCodecInfo codecInfo;
    @Nullable
    public final String diagnosticInfo;

    public MediaCodecDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        String string = String.valueOf(codecInfo == null ? null : codecInfo.name);
        super(string.length() != 0 ? "Decoder failed: ".concat(string) : new String("Decoder failed: "), cause);
        this.codecInfo = codecInfo;
        this.diagnosticInfo = Util.SDK_INT >= 21 ? MediaCodecDecoderException.getDiagnosticInfoV21(cause) : null;
    }

    @RequiresApi(value=21)
    @Nullable
    private static String getDiagnosticInfoV21(Throwable cause) {
        if (cause instanceof MediaCodec.CodecException) {
            return ((MediaCodec.CodecException)cause).getDiagnosticInfo();
        }
        return null;
    }
}

