/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import com.google.android.exoplayer2.offline.DownloadProgress;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class Download {
    public static final int STATE_QUEUED = 0;
    public static final int STATE_STOPPED = 1;
    public static final int STATE_DOWNLOADING = 2;
    public static final int STATE_COMPLETED = 3;
    public static final int STATE_FAILED = 4;
    public static final int STATE_REMOVING = 5;
    public static final int STATE_RESTARTING = 7;
    public static final int FAILURE_REASON_NONE = 0;
    public static final int FAILURE_REASON_UNKNOWN = 1;
    public static final int STOP_REASON_NONE = 0;
    public final DownloadRequest request;
    public final int state;
    public final long startTimeMs;
    public final long updateTimeMs;
    public final long contentLength;
    public final int stopReason;
    public final int failureReason;
    final DownloadProgress progress;

    public Download(DownloadRequest request, int state, long startTimeMs, long updateTimeMs, long contentLength, int stopReason, int failureReason) {
        this(request, state, startTimeMs, updateTimeMs, contentLength, stopReason, failureReason, new DownloadProgress());
    }

    public Download(DownloadRequest request, int state, long startTimeMs, long updateTimeMs, long contentLength, int stopReason, int failureReason, DownloadProgress progress) {
        Assertions.checkNotNull((Object)progress);
        Assertions.checkArgument((failureReason == 0 == (state != 4) ? 1 : 0) != 0);
        if (stopReason != 0) {
            Assertions.checkArgument((state != 2 && state != 0 ? 1 : 0) != 0);
        }
        this.request = request;
        this.state = state;
        this.startTimeMs = startTimeMs;
        this.updateTimeMs = updateTimeMs;
        this.contentLength = contentLength;
        this.stopReason = stopReason;
        this.failureReason = failureReason;
        this.progress = progress;
    }

    public boolean isTerminalState() {
        return this.state == 3 || this.state == 4;
    }

    public long getBytesDownloaded() {
        return this.progress.bytesDownloaded;
    }

    public float getPercentDownloaded() {
        return this.progress.percentDownloaded;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface FailureReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface State {
    }
}

