/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.scheduler;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class Requirements
implements Parcelable {
    public static final int NETWORK = 1;
    public static final int NETWORK_UNMETERED = 2;
    public static final int DEVICE_IDLE = 4;
    public static final int DEVICE_CHARGING = 8;
    public static final int DEVICE_STORAGE_NOT_LOW = 16;
    private final int requirements;
    public static final Parcelable.Creator<Requirements> CREATOR = new Parcelable.Creator<Requirements>(){

        public Requirements createFromParcel(Parcel in) {
            return new Requirements(in.readInt());
        }

        public Requirements[] newArray(int size) {
            return new Requirements[size];
        }
    };

    public Requirements(int requirements) {
        if ((requirements & 2) != 0) {
            requirements |= 1;
        }
        this.requirements = requirements;
    }

    public int getRequirements() {
        return this.requirements;
    }

    public Requirements filterRequirements(int requirementsFilter) {
        int filteredRequirements = this.requirements & requirementsFilter;
        return filteredRequirements == this.requirements ? this : new Requirements(filteredRequirements);
    }

    public boolean isNetworkRequired() {
        return (this.requirements & 1) != 0;
    }

    public boolean isUnmeteredNetworkRequired() {
        return (this.requirements & 2) != 0;
    }

    public boolean isChargingRequired() {
        return (this.requirements & 8) != 0;
    }

    public boolean isIdleRequired() {
        return (this.requirements & 4) != 0;
    }

    public boolean isStorageNotLowRequired() {
        return (this.requirements & 0x10) != 0;
    }

    public boolean checkRequirements(Context context) {
        return this.getNotMetRequirements(context) == 0;
    }

    public int getNotMetRequirements(Context context) {
        int notMetRequirements = this.getNotMetNetworkRequirements(context);
        if (this.isChargingRequired() && !this.isDeviceCharging(context)) {
            notMetRequirements |= 8;
        }
        if (this.isIdleRequired() && !this.isDeviceIdle(context)) {
            notMetRequirements |= 4;
        }
        if (this.isStorageNotLowRequired() && !this.isStorageNotLow(context)) {
            notMetRequirements |= 0x10;
        }
        return notMetRequirements;
    }

    private int getNotMetNetworkRequirements(Context context) {
        if (!this.isNetworkRequired()) {
            return 0;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)Assertions.checkNotNull((Object)context.getSystemService("connectivity"));
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected() || !Requirements.isInternetConnectivityValidated(connectivityManager)) {
            return this.requirements & 3;
        }
        if (this.isUnmeteredNetworkRequired() && connectivityManager.isActiveNetworkMetered()) {
            return 2;
        }
        return 0;
    }

    private boolean isDeviceCharging(Context context) {
        Intent batteryStatus = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (batteryStatus == null) {
            return false;
        }
        int status = batteryStatus.getIntExtra("status", -1);
        return status == 2 || status == 5;
    }

    private boolean isDeviceIdle(Context context) {
        PowerManager powerManager = (PowerManager)Assertions.checkNotNull((Object)context.getSystemService("power"));
        return Util.SDK_INT >= 23 ? powerManager.isDeviceIdleMode() : (Util.SDK_INT >= 20 ? !powerManager.isInteractive() : !powerManager.isScreenOn());
    }

    private boolean isStorageNotLow(Context context) {
        return context.registerReceiver(null, new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW")) == null;
    }

    private static boolean isInternetConnectivityValidated(ConnectivityManager connectivityManager) {
        if (Util.SDK_INT < 24) {
            return true;
        }
        Network activeNetwork = connectivityManager.getActiveNetwork();
        if (activeNetwork == null) {
            return false;
        }
        try {
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(activeNetwork);
            return networkCapabilities != null && networkCapabilities.hasCapability(16);
        }
        catch (SecurityException e) {
            return true;
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.requirements == ((Requirements)o).requirements;
    }

    public int hashCode() {
        return this.requirements;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.requirements);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface RequirementFlags {
    }
}

