/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.ClippingMediaSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class ClippingMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    public final MediaPeriod mediaPeriod;
    @Nullable
    private MediaPeriod.Callback callback;
    private @NullableType ClippingMediaPeriod.ClippingSampleStream[] sampleStreams;
    private long pendingInitialDiscontinuityPositionUs;
    long startUs;
    long endUs;
    @Nullable
    private ClippingMediaSource.IllegalClippingException clippingError;

    public ClippingMediaPeriod(MediaPeriod mediaPeriod, boolean enableInitialDiscontinuity, long startUs, long endUs) {
        this.mediaPeriod = mediaPeriod;
        this.sampleStreams = new ClippingSampleStream[0];
        this.pendingInitialDiscontinuityPositionUs = enableInitialDiscontinuity ? startUs : -9223372036854775807L;
        this.startUs = startUs;
        this.endUs = endUs;
    }

    public void updateClipping(long startUs, long endUs) {
        this.startUs = startUs;
        this.endUs = endUs;
    }

    public void setClippingError(ClippingMediaSource.IllegalClippingException clippingError) {
        this.clippingError = clippingError;
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.mediaPeriod.prepare(this, positionUs);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        if (this.clippingError != null) {
            throw this.clippingError;
        }
        this.mediaPeriod.maybeThrowPrepareError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.mediaPeriod.getTrackGroups();
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        this.sampleStreams = new ClippingSampleStream[streams.length];
        @NullableType SampleStream[] childStreams = new SampleStream[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            this.sampleStreams[i] = (ClippingSampleStream)streams[i];
            childStreams[i] = this.sampleStreams[i] != null ? this.sampleStreams[i].childStream : null;
        }
        long enablePositionUs = this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs);
        this.pendingInitialDiscontinuityPositionUs = this.isPendingInitialDiscontinuity() && positionUs == this.startUs && ClippingMediaPeriod.shouldKeepInitialDiscontinuity(this.startUs, selections) ? enablePositionUs : -9223372036854775807L;
        Assertions.checkState((enablePositionUs == positionUs || enablePositionUs >= this.startUs && (this.endUs == Long.MIN_VALUE || enablePositionUs <= this.endUs) ? 1 : 0) != 0);
        for (int i = 0; i < streams.length; ++i) {
            if (childStreams[i] == null) {
                this.sampleStreams[i] = null;
            } else if (this.sampleStreams[i] == null || this.sampleStreams[i].childStream != childStreams[i]) {
                this.sampleStreams[i] = new ClippingSampleStream(childStreams[i]);
            }
            streams[i] = this.sampleStreams[i];
        }
        return enablePositionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        this.mediaPeriod.discardBuffer(positionUs, toKeyframe);
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        this.mediaPeriod.reevaluateBuffer(positionUs);
    }

    @Override
    public long readDiscontinuity() {
        if (this.isPendingInitialDiscontinuity()) {
            long initialDiscontinuityUs = this.pendingInitialDiscontinuityPositionUs;
            this.pendingInitialDiscontinuityPositionUs = -9223372036854775807L;
            long childDiscontinuityUs = this.readDiscontinuity();
            return childDiscontinuityUs != -9223372036854775807L ? childDiscontinuityUs : initialDiscontinuityUs;
        }
        long discontinuityUs = this.mediaPeriod.readDiscontinuity();
        if (discontinuityUs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        Assertions.checkState((discontinuityUs >= this.startUs ? 1 : 0) != 0);
        Assertions.checkState((this.endUs == Long.MIN_VALUE || discontinuityUs <= this.endUs ? 1 : 0) != 0);
        return discontinuityUs;
    }

    @Override
    public long getBufferedPositionUs() {
        long bufferedPositionUs = this.mediaPeriod.getBufferedPositionUs();
        if (bufferedPositionUs == Long.MIN_VALUE || this.endUs != Long.MIN_VALUE && bufferedPositionUs >= this.endUs) {
            return Long.MIN_VALUE;
        }
        return bufferedPositionUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        this.pendingInitialDiscontinuityPositionUs = -9223372036854775807L;
        for (ClippingSampleStream sampleStream : this.sampleStreams) {
            if (sampleStream == null) continue;
            sampleStream.clearSentEos();
        }
        long seekUs = this.mediaPeriod.seekToUs(positionUs);
        Assertions.checkState((seekUs == positionUs || seekUs >= this.startUs && (this.endUs == Long.MIN_VALUE || seekUs <= this.endUs) ? 1 : 0) != 0);
        return seekUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        if (positionUs == this.startUs) {
            return this.startUs;
        }
        SeekParameters clippedSeekParameters = this.clipSeekParameters(positionUs, seekParameters);
        return this.mediaPeriod.getAdjustedSeekPositionUs(positionUs, clippedSeekParameters);
    }

    @Override
    public long getNextLoadPositionUs() {
        long nextLoadPositionUs = this.mediaPeriod.getNextLoadPositionUs();
        if (nextLoadPositionUs == Long.MIN_VALUE || this.endUs != Long.MIN_VALUE && nextLoadPositionUs >= this.endUs) {
            return Long.MIN_VALUE;
        }
        return nextLoadPositionUs;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.mediaPeriod.continueLoading(positionUs);
    }

    @Override
    public boolean isLoading() {
        return this.mediaPeriod.isLoading();
    }

    @Override
    public void onPrepared(MediaPeriod mediaPeriod) {
        if (this.clippingError != null) {
            return;
        }
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    boolean isPendingInitialDiscontinuity() {
        return this.pendingInitialDiscontinuityPositionUs != -9223372036854775807L;
    }

    private SeekParameters clipSeekParameters(long positionUs, SeekParameters seekParameters) {
        long toleranceBeforeUs = Util.constrainValue((long)seekParameters.toleranceBeforeUs, (long)0L, (long)(positionUs - this.startUs));
        long toleranceAfterUs = Util.constrainValue((long)seekParameters.toleranceAfterUs, (long)0L, (long)(this.endUs == Long.MIN_VALUE ? Long.MAX_VALUE : this.endUs - positionUs));
        if (toleranceBeforeUs == seekParameters.toleranceBeforeUs && toleranceAfterUs == seekParameters.toleranceAfterUs) {
            return seekParameters;
        }
        return new SeekParameters(toleranceBeforeUs, toleranceAfterUs);
    }

    private static boolean shouldKeepInitialDiscontinuity(long startUs, @NullableType ExoTrackSelection[] selections) {
        if (startUs != 0L) {
            for (ExoTrackSelection trackSelection : selections) {
                if (trackSelection == null) continue;
                Format selectedFormat = trackSelection.getSelectedFormat();
                if (MimeTypes.allSamplesAreSyncSamples((String)selectedFormat.sampleMimeType, (String)selectedFormat.codecs)) continue;
                return true;
            }
        }
        return false;
    }

    private final class ClippingSampleStream
    implements SampleStream {
        public final SampleStream childStream;
        private boolean sentEos;

        public ClippingSampleStream(SampleStream childStream) {
            this.childStream = childStream;
        }

        public void clearSentEos() {
            this.sentEos = false;
        }

        @Override
        public boolean isReady() {
            return !ClippingMediaPeriod.this.isPendingInitialDiscontinuity() && this.childStream.isReady();
        }

        @Override
        public void maybeThrowError() throws IOException {
            this.childStream.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            if (ClippingMediaPeriod.this.isPendingInitialDiscontinuity()) {
                return -3;
            }
            if (this.sentEos) {
                buffer.setFlags(4);
                return -4;
            }
            int result = this.childStream.readData(formatHolder, buffer, readFlags);
            if (result == -5) {
                Format format = (Format)Assertions.checkNotNull((Object)formatHolder.format);
                if (format.encoderDelay != 0 || format.encoderPadding != 0) {
                    int encoderDelay = ClippingMediaPeriod.this.startUs != 0L ? 0 : format.encoderDelay;
                    int encoderPadding = ClippingMediaPeriod.this.endUs != Long.MIN_VALUE ? 0 : format.encoderPadding;
                    formatHolder.format = format.buildUpon().setEncoderDelay(encoderDelay).setEncoderPadding(encoderPadding).build();
                }
                return -5;
            }
            if (ClippingMediaPeriod.this.endUs != Long.MIN_VALUE && (result == -4 && buffer.timeUs >= ClippingMediaPeriod.this.endUs || result == -3 && ClippingMediaPeriod.this.getBufferedPositionUs() == Long.MIN_VALUE && !buffer.waitingForKeys)) {
                buffer.clear();
                buffer.setFlags(4);
                this.sentEos = true;
                return -4;
            }
            return result;
        }

        @Override
        public int skipData(long positionUs) {
            if (ClippingMediaPeriod.this.isPendingInitialDiscontinuity()) {
                return -3;
            }
            return this.childStream.skipData(positionUs);
        }
    }
}

