/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.AbstractConcatenatedTimeline;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.MaskingMediaPeriod;
import com.google.android.exoplayer2.source.MaskingMediaSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConcatenatingMediaSource
extends CompositeMediaSource<MediaSourceHolder> {
    private static final int MSG_ADD = 0;
    private static final int MSG_REMOVE = 1;
    private static final int MSG_MOVE = 2;
    private static final int MSG_SET_SHUFFLE_ORDER = 3;
    private static final int MSG_UPDATE_TIMELINE = 4;
    private static final int MSG_ON_COMPLETION = 5;
    private static final MediaItem EMPTY_MEDIA_ITEM = new MediaItem.Builder().setUri(Uri.EMPTY).build();
    @GuardedBy(value="this")
    private final List<MediaSourceHolder> mediaSourcesPublic;
    @GuardedBy(value="this")
    private final Set<HandlerAndRunnable> pendingOnCompletionActions;
    @GuardedBy(value="this")
    @Nullable
    private Handler playbackThreadHandler;
    private final List<MediaSourceHolder> mediaSourceHolders;
    private final IdentityHashMap<MediaPeriod, MediaSourceHolder> mediaSourceByMediaPeriod;
    private final Map<Object, MediaSourceHolder> mediaSourceByUid;
    private final Set<MediaSourceHolder> enabledMediaSourceHolders;
    private final boolean isAtomic;
    private final boolean useLazyPreparation;
    private boolean timelineUpdateScheduled;
    private Set<HandlerAndRunnable> nextTimelineUpdateOnCompletionActions;
    private ShuffleOrder shuffleOrder;

    public ConcatenatingMediaSource(MediaSource ... mediaSources) {
        this(false, mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, MediaSource ... mediaSources) {
        this(isAtomic, new ShuffleOrder.DefaultShuffleOrder(0), mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, ShuffleOrder shuffleOrder, MediaSource ... mediaSources) {
        this(isAtomic, false, shuffleOrder, mediaSources);
    }

    public ConcatenatingMediaSource(boolean isAtomic, boolean useLazyPreparation, ShuffleOrder shuffleOrder, MediaSource ... mediaSources) {
        for (MediaSource mediaSource : mediaSources) {
            Assertions.checkNotNull((Object)mediaSource);
        }
        this.shuffleOrder = shuffleOrder.getLength() > 0 ? shuffleOrder.cloneAndClear() : shuffleOrder;
        this.mediaSourceByMediaPeriod = new IdentityHashMap();
        this.mediaSourceByUid = new HashMap<Object, MediaSourceHolder>();
        this.mediaSourcesPublic = new ArrayList<MediaSourceHolder>();
        this.mediaSourceHolders = new ArrayList<MediaSourceHolder>();
        this.nextTimelineUpdateOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.pendingOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.enabledMediaSourceHolders = new HashSet<MediaSourceHolder>();
        this.isAtomic = isAtomic;
        this.useLazyPreparation = useLazyPreparation;
        this.addMediaSources(Arrays.asList(mediaSources));
    }

    @Override
    public synchronized Timeline getInitialTimeline() {
        ShuffleOrder shuffleOrder = this.shuffleOrder.getLength() != this.mediaSourcesPublic.size() ? this.shuffleOrder.cloneAndClear().cloneAndInsert(0, this.mediaSourcesPublic.size()) : this.shuffleOrder;
        return new ConcatenatedTimeline(this.mediaSourcesPublic, shuffleOrder, this.isAtomic);
    }

    @Override
    public boolean isSingleWindow() {
        return false;
    }

    public synchronized void addMediaSource(MediaSource mediaSource) {
        this.addMediaSource(this.mediaSourcesPublic.size(), mediaSource);
    }

    public synchronized void addMediaSource(MediaSource mediaSource, Handler handler, Runnable onCompletionAction) {
        this.addMediaSource(this.mediaSourcesPublic.size(), mediaSource, handler, onCompletionAction);
    }

    public synchronized void addMediaSource(int index, MediaSource mediaSource) {
        this.addPublicMediaSources(index, Collections.singletonList(mediaSource), null, null);
    }

    public synchronized void addMediaSource(int index, MediaSource mediaSource, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(index, Collections.singletonList(mediaSource), handler, onCompletionAction);
    }

    public synchronized void addMediaSources(Collection<MediaSource> mediaSources) {
        this.addPublicMediaSources(this.mediaSourcesPublic.size(), mediaSources, null, null);
    }

    public synchronized void addMediaSources(Collection<MediaSource> mediaSources, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(this.mediaSourcesPublic.size(), mediaSources, handler, onCompletionAction);
    }

    public synchronized void addMediaSources(int index, Collection<MediaSource> mediaSources) {
        this.addPublicMediaSources(index, mediaSources, null, null);
    }

    public synchronized void addMediaSources(int index, Collection<MediaSource> mediaSources, Handler handler, Runnable onCompletionAction) {
        this.addPublicMediaSources(index, mediaSources, handler, onCompletionAction);
    }

    public synchronized MediaSource removeMediaSource(int index) {
        MediaSource removedMediaSource = this.getMediaSource(index);
        this.removePublicMediaSources(index, index + 1, null, null);
        return removedMediaSource;
    }

    public synchronized MediaSource removeMediaSource(int index, Handler handler, Runnable onCompletionAction) {
        MediaSource removedMediaSource = this.getMediaSource(index);
        this.removePublicMediaSources(index, index + 1, handler, onCompletionAction);
        return removedMediaSource;
    }

    public synchronized void removeMediaSourceRange(int fromIndex, int toIndex) {
        this.removePublicMediaSources(fromIndex, toIndex, null, null);
    }

    public synchronized void removeMediaSourceRange(int fromIndex, int toIndex, Handler handler, Runnable onCompletionAction) {
        this.removePublicMediaSources(fromIndex, toIndex, handler, onCompletionAction);
    }

    public synchronized void moveMediaSource(int currentIndex, int newIndex) {
        this.movePublicMediaSource(currentIndex, newIndex, null, null);
    }

    public synchronized void moveMediaSource(int currentIndex, int newIndex, Handler handler, Runnable onCompletionAction) {
        this.movePublicMediaSource(currentIndex, newIndex, handler, onCompletionAction);
    }

    public synchronized void clear() {
        this.removeMediaSourceRange(0, this.getSize());
    }

    public synchronized void clear(Handler handler, Runnable onCompletionAction) {
        this.removeMediaSourceRange(0, this.getSize(), handler, onCompletionAction);
    }

    public synchronized int getSize() {
        return this.mediaSourcesPublic.size();
    }

    public synchronized MediaSource getMediaSource(int index) {
        return this.mediaSourcesPublic.get((int)index).mediaSource;
    }

    public synchronized void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.setPublicShuffleOrder(shuffleOrder, null, null);
    }

    public synchronized void setShuffleOrder(ShuffleOrder shuffleOrder, Handler handler, Runnable onCompletionAction) {
        this.setPublicShuffleOrder(shuffleOrder, handler, onCompletionAction);
    }

    @Override
    public MediaItem getMediaItem() {
        return EMPTY_MEDIA_ITEM;
    }

    @Override
    protected synchronized void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        this.playbackThreadHandler = new Handler(this::handleMessage);
        if (this.mediaSourcesPublic.isEmpty()) {
            this.updateTimelineAndScheduleOnCompletionActions();
        } else {
            this.shuffleOrder = this.shuffleOrder.cloneAndInsert(0, this.mediaSourcesPublic.size());
            this.addMediaSourcesInternal(0, this.mediaSourcesPublic);
            this.scheduleTimelineUpdate();
        }
    }

    @Override
    protected void enableInternal() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        Object mediaSourceHolderUid = ConcatenatingMediaSource.getMediaSourceHolderUid(id.periodUid);
        MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(ConcatenatingMediaSource.getChildPeriodUid(id.periodUid));
        MediaSourceHolder holder = this.mediaSourceByUid.get(mediaSourceHolderUid);
        if (holder == null) {
            holder = new MediaSourceHolder(new FakeMediaSource(), this.useLazyPreparation);
            holder.isRemoved = true;
            this.prepareChildSource(holder, holder.mediaSource);
        }
        this.enableMediaSource(holder);
        holder.activeMediaPeriodIds.add(childMediaPeriodId);
        MaskingMediaPeriod mediaPeriod = holder.mediaSource.createPeriod(childMediaPeriodId, allocator, startPositionUs);
        this.mediaSourceByMediaPeriod.put(mediaPeriod, holder);
        this.disableUnusedMediaSources();
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MediaSourceHolder holder = (MediaSourceHolder)Assertions.checkNotNull((Object)this.mediaSourceByMediaPeriod.remove(mediaPeriod));
        holder.mediaSource.releasePeriod(mediaPeriod);
        holder.activeMediaPeriodIds.remove((Object)((MaskingMediaPeriod)mediaPeriod).id);
        if (!this.mediaSourceByMediaPeriod.isEmpty()) {
            this.disableUnusedMediaSources();
        }
        this.maybeReleaseChildSource(holder);
    }

    @Override
    protected void disableInternal() {
        super.disableInternal();
        this.enabledMediaSourceHolders.clear();
    }

    @Override
    protected synchronized void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.mediaSourceHolders.clear();
        this.enabledMediaSourceHolders.clear();
        this.mediaSourceByUid.clear();
        this.shuffleOrder = this.shuffleOrder.cloneAndClear();
        if (this.playbackThreadHandler != null) {
            this.playbackThreadHandler.removeCallbacksAndMessages(null);
            this.playbackThreadHandler = null;
        }
        this.timelineUpdateScheduled = false;
        this.nextTimelineUpdateOnCompletionActions.clear();
        this.dispatchOnCompletionActions(this.pendingOnCompletionActions);
    }

    @Override
    protected void onChildSourceInfoRefreshed(MediaSourceHolder mediaSourceHolder, MediaSource mediaSource, Timeline timeline) {
        this.updateMediaSourceInternal(mediaSourceHolder, timeline);
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSourceHolder mediaSourceHolder, MediaSource.MediaPeriodId mediaPeriodId) {
        for (int i = 0; i < mediaSourceHolder.activeMediaPeriodIds.size(); ++i) {
            if (mediaSourceHolder.activeMediaPeriodIds.get((int)i).windowSequenceNumber != mediaPeriodId.windowSequenceNumber) continue;
            Object periodUid = ConcatenatingMediaSource.getPeriodUid(mediaSourceHolder, mediaPeriodId.periodUid);
            return mediaPeriodId.copyWithPeriodUid(periodUid);
        }
        return null;
    }

    @Override
    protected int getWindowIndexForChildWindowIndex(MediaSourceHolder mediaSourceHolder, int windowIndex) {
        return windowIndex + mediaSourceHolder.firstWindowIndexInChild;
    }

    @GuardedBy(value="this")
    private void addPublicMediaSources(int index, Collection<MediaSource> mediaSources, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument((handler == null == (onCompletionAction == null) ? 1 : 0) != 0);
        Handler playbackThreadHandler = this.playbackThreadHandler;
        for (MediaSource mediaSource : mediaSources) {
            Assertions.checkNotNull((Object)mediaSource);
        }
        ArrayList<MediaSourceHolder> mediaSourceHolders = new ArrayList<MediaSourceHolder>(mediaSources.size());
        for (MediaSource mediaSource : mediaSources) {
            mediaSourceHolders.add(new MediaSourceHolder(mediaSource, this.useLazyPreparation));
        }
        this.mediaSourcesPublic.addAll(index, mediaSourceHolders);
        if (playbackThreadHandler != null && !mediaSources.isEmpty()) {
            HandlerAndRunnable handlerAndRunnable = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(0, new MessageData(index, mediaSourceHolders, handlerAndRunnable)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void removePublicMediaSources(int fromIndex, int toIndex, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument((handler == null == (onCompletionAction == null) ? 1 : 0) != 0);
        Handler playbackThreadHandler = this.playbackThreadHandler;
        Util.removeRange(this.mediaSourcesPublic, (int)fromIndex, (int)toIndex);
        if (playbackThreadHandler != null) {
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(1, new MessageData<Integer>(fromIndex, toIndex, callbackAction)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void movePublicMediaSource(int currentIndex, int newIndex, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument((handler == null == (onCompletionAction == null) ? 1 : 0) != 0);
        Handler playbackThreadHandler = this.playbackThreadHandler;
        this.mediaSourcesPublic.add(newIndex, this.mediaSourcesPublic.remove(currentIndex));
        if (playbackThreadHandler != null) {
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(2, new MessageData<Integer>(currentIndex, newIndex, callbackAction)).sendToTarget();
        } else if (onCompletionAction != null && handler != null) {
            handler.post(onCompletionAction);
        }
    }

    @GuardedBy(value="this")
    private void setPublicShuffleOrder(ShuffleOrder shuffleOrder, @Nullable Handler handler, @Nullable Runnable onCompletionAction) {
        Assertions.checkArgument((handler == null == (onCompletionAction == null) ? 1 : 0) != 0);
        Handler playbackThreadHandler = this.playbackThreadHandler;
        if (playbackThreadHandler != null) {
            int size = this.getSize();
            if (shuffleOrder.getLength() != size) {
                shuffleOrder = shuffleOrder.cloneAndClear().cloneAndInsert(0, size);
            }
            HandlerAndRunnable callbackAction = this.createOnCompletionAction(handler, onCompletionAction);
            playbackThreadHandler.obtainMessage(3, new MessageData<ShuffleOrder>(0, shuffleOrder, callbackAction)).sendToTarget();
        } else {
            ShuffleOrder shuffleOrder2 = this.shuffleOrder = shuffleOrder.getLength() > 0 ? shuffleOrder.cloneAndClear() : shuffleOrder;
            if (onCompletionAction != null && handler != null) {
                handler.post(onCompletionAction);
            }
        }
    }

    @GuardedBy(value="this")
    @Nullable
    private HandlerAndRunnable createOnCompletionAction(@Nullable Handler handler, @Nullable Runnable runnable) {
        if (handler == null || runnable == null) {
            return null;
        }
        HandlerAndRunnable handlerAndRunnable = new HandlerAndRunnable(handler, runnable);
        this.pendingOnCompletionActions.add(handlerAndRunnable);
        return handlerAndRunnable;
    }

    private boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                MessageData addMessage = (MessageData)Util.castNonNull((Object)msg.obj);
                this.shuffleOrder = this.shuffleOrder.cloneAndInsert(addMessage.index, ((Collection)addMessage.customData).size());
                this.addMediaSourcesInternal(addMessage.index, (Collection)addMessage.customData);
                this.scheduleTimelineUpdate(addMessage.onCompletionAction);
                break;
            }
            case 1: {
                MessageData removeMessage = (MessageData)Util.castNonNull((Object)msg.obj);
                int fromIndex = removeMessage.index;
                int toIndex = (Integer)removeMessage.customData;
                this.shuffleOrder = fromIndex == 0 && toIndex == this.shuffleOrder.getLength() ? this.shuffleOrder.cloneAndClear() : this.shuffleOrder.cloneAndRemove(fromIndex, toIndex);
                for (int index = toIndex - 1; index >= fromIndex; --index) {
                    this.removeMediaSourceInternal(index);
                }
                this.scheduleTimelineUpdate(removeMessage.onCompletionAction);
                break;
            }
            case 2: {
                MessageData moveMessage = (MessageData)Util.castNonNull((Object)msg.obj);
                this.shuffleOrder = this.shuffleOrder.cloneAndRemove(moveMessage.index, moveMessage.index + 1);
                this.shuffleOrder = this.shuffleOrder.cloneAndInsert((Integer)moveMessage.customData, 1);
                this.moveMediaSourceInternal(moveMessage.index, (Integer)moveMessage.customData);
                this.scheduleTimelineUpdate(moveMessage.onCompletionAction);
                break;
            }
            case 3: {
                MessageData shuffleOrderMessage = (MessageData)Util.castNonNull((Object)msg.obj);
                this.shuffleOrder = (ShuffleOrder)shuffleOrderMessage.customData;
                this.scheduleTimelineUpdate(shuffleOrderMessage.onCompletionAction);
                break;
            }
            case 4: {
                this.updateTimelineAndScheduleOnCompletionActions();
                break;
            }
            case 5: {
                Set actions = (Set)Util.castNonNull((Object)msg.obj);
                this.dispatchOnCompletionActions(actions);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private void scheduleTimelineUpdate() {
        this.scheduleTimelineUpdate(null);
    }

    private void scheduleTimelineUpdate(@Nullable HandlerAndRunnable onCompletionAction) {
        if (!this.timelineUpdateScheduled) {
            this.getPlaybackThreadHandlerOnPlaybackThread().obtainMessage(4).sendToTarget();
            this.timelineUpdateScheduled = true;
        }
        if (onCompletionAction != null) {
            this.nextTimelineUpdateOnCompletionActions.add(onCompletionAction);
        }
    }

    private void updateTimelineAndScheduleOnCompletionActions() {
        this.timelineUpdateScheduled = false;
        Set<HandlerAndRunnable> onCompletionActions = this.nextTimelineUpdateOnCompletionActions;
        this.nextTimelineUpdateOnCompletionActions = new HashSet<HandlerAndRunnable>();
        this.refreshSourceInfo(new ConcatenatedTimeline(this.mediaSourceHolders, this.shuffleOrder, this.isAtomic));
        this.getPlaybackThreadHandlerOnPlaybackThread().obtainMessage(5, onCompletionActions).sendToTarget();
    }

    private Handler getPlaybackThreadHandlerOnPlaybackThread() {
        return (Handler)Assertions.checkNotNull((Object)this.playbackThreadHandler);
    }

    private synchronized void dispatchOnCompletionActions(Set<HandlerAndRunnable> onCompletionActions) {
        for (HandlerAndRunnable pendingAction : onCompletionActions) {
            pendingAction.dispatch();
        }
        this.pendingOnCompletionActions.removeAll(onCompletionActions);
    }

    private void addMediaSourcesInternal(int index, Collection<MediaSourceHolder> mediaSourceHolders) {
        for (MediaSourceHolder mediaSourceHolder : mediaSourceHolders) {
            this.addMediaSourceInternal(index++, mediaSourceHolder);
        }
    }

    private void addMediaSourceInternal(int newIndex, MediaSourceHolder newMediaSourceHolder) {
        if (newIndex > 0) {
            MediaSourceHolder previousHolder = this.mediaSourceHolders.get(newIndex - 1);
            Timeline previousTimeline = previousHolder.mediaSource.getTimeline();
            newMediaSourceHolder.reset(newIndex, previousHolder.firstWindowIndexInChild + previousTimeline.getWindowCount());
        } else {
            newMediaSourceHolder.reset(newIndex, 0);
        }
        Timeline newTimeline = newMediaSourceHolder.mediaSource.getTimeline();
        this.correctOffsets(newIndex, 1, newTimeline.getWindowCount());
        this.mediaSourceHolders.add(newIndex, newMediaSourceHolder);
        this.mediaSourceByUid.put(newMediaSourceHolder.uid, newMediaSourceHolder);
        this.prepareChildSource(newMediaSourceHolder, newMediaSourceHolder.mediaSource);
        if (this.isEnabled() && this.mediaSourceByMediaPeriod.isEmpty()) {
            this.enabledMediaSourceHolders.add(newMediaSourceHolder);
        } else {
            this.disableChildSource(newMediaSourceHolder);
        }
    }

    private void updateMediaSourceInternal(MediaSourceHolder mediaSourceHolder, Timeline timeline) {
        if (mediaSourceHolder.childIndex + 1 < this.mediaSourceHolders.size()) {
            MediaSourceHolder nextHolder = this.mediaSourceHolders.get(mediaSourceHolder.childIndex + 1);
            int windowOffsetUpdate = timeline.getWindowCount() - (nextHolder.firstWindowIndexInChild - mediaSourceHolder.firstWindowIndexInChild);
            if (windowOffsetUpdate != 0) {
                this.correctOffsets(mediaSourceHolder.childIndex + 1, 0, windowOffsetUpdate);
            }
        }
        this.scheduleTimelineUpdate();
    }

    private void removeMediaSourceInternal(int index) {
        MediaSourceHolder holder = this.mediaSourceHolders.remove(index);
        this.mediaSourceByUid.remove(holder.uid);
        Timeline oldTimeline = holder.mediaSource.getTimeline();
        this.correctOffsets(index, -1, -oldTimeline.getWindowCount());
        holder.isRemoved = true;
        this.maybeReleaseChildSource(holder);
    }

    private void moveMediaSourceInternal(int currentIndex, int newIndex) {
        int startIndex = Math.min(currentIndex, newIndex);
        int endIndex = Math.max(currentIndex, newIndex);
        int windowOffset = this.mediaSourceHolders.get((int)startIndex).firstWindowIndexInChild;
        this.mediaSourceHolders.add(newIndex, this.mediaSourceHolders.remove(currentIndex));
        int i = startIndex;
        while (i <= endIndex) {
            MediaSourceHolder holder = this.mediaSourceHolders.get(i);
            holder.childIndex = i++;
            holder.firstWindowIndexInChild = windowOffset;
            windowOffset += holder.mediaSource.getTimeline().getWindowCount();
        }
    }

    private void correctOffsets(int startIndex, int childIndexUpdate, int windowOffsetUpdate) {
        for (int i = startIndex; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder holder = this.mediaSourceHolders.get(i);
            holder.childIndex += childIndexUpdate;
            holder.firstWindowIndexInChild += windowOffsetUpdate;
        }
    }

    private void maybeReleaseChildSource(MediaSourceHolder mediaSourceHolder) {
        if (mediaSourceHolder.isRemoved && mediaSourceHolder.activeMediaPeriodIds.isEmpty()) {
            this.enabledMediaSourceHolders.remove(mediaSourceHolder);
            this.releaseChildSource(mediaSourceHolder);
        }
    }

    private void enableMediaSource(MediaSourceHolder mediaSourceHolder) {
        this.enabledMediaSourceHolders.add(mediaSourceHolder);
        this.enableChildSource(mediaSourceHolder);
    }

    private void disableUnusedMediaSources() {
        Iterator<MediaSourceHolder> iterator = this.enabledMediaSourceHolders.iterator();
        while (iterator.hasNext()) {
            MediaSourceHolder holder = iterator.next();
            if (!holder.activeMediaPeriodIds.isEmpty()) continue;
            this.disableChildSource(holder);
            iterator.remove();
        }
    }

    private static Object getMediaSourceHolderUid(Object periodUid) {
        return ConcatenatedTimeline.getChildTimelineUidFromConcatenatedUid(periodUid);
    }

    private static Object getChildPeriodUid(Object periodUid) {
        return ConcatenatedTimeline.getChildPeriodUidFromConcatenatedUid(periodUid);
    }

    private static Object getPeriodUid(MediaSourceHolder holder, Object childPeriodUid) {
        return ConcatenatedTimeline.getConcatenatedUid(holder.uid, childPeriodUid);
    }

    private static final class HandlerAndRunnable {
        private final Handler handler;
        private final Runnable runnable;

        public HandlerAndRunnable(Handler handler, Runnable runnable) {
            this.handler = handler;
            this.runnable = runnable;
        }

        public void dispatch() {
            this.handler.post(this.runnable);
        }
    }

    private static final class FakeMediaSource
    extends BaseMediaSource {
        private FakeMediaSource() {
        }

        @Override
        protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        }

        @Override
        public MediaItem getMediaItem() {
            return EMPTY_MEDIA_ITEM;
        }

        @Override
        protected void releaseSourceInternal() {
        }

        @Override
        public void maybeThrowSourceInfoRefreshError() {
        }

        @Override
        public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void releasePeriod(MediaPeriod mediaPeriod) {
        }
    }

    private static final class ConcatenatedTimeline
    extends AbstractConcatenatedTimeline {
        private final int windowCount;
        private final int periodCount;
        private final int[] firstPeriodInChildIndices;
        private final int[] firstWindowInChildIndices;
        private final Timeline[] timelines;
        private final Object[] uids;
        private final HashMap<Object, Integer> childIndexByUid;

        public ConcatenatedTimeline(Collection<MediaSourceHolder> mediaSourceHolders, ShuffleOrder shuffleOrder, boolean isAtomic) {
            super(isAtomic, shuffleOrder);
            int childCount = mediaSourceHolders.size();
            this.firstPeriodInChildIndices = new int[childCount];
            this.firstWindowInChildIndices = new int[childCount];
            this.timelines = new Timeline[childCount];
            this.uids = new Object[childCount];
            this.childIndexByUid = new HashMap();
            int index = 0;
            int windowCount = 0;
            int periodCount = 0;
            for (MediaSourceHolder mediaSourceHolder : mediaSourceHolders) {
                this.timelines[index] = mediaSourceHolder.mediaSource.getTimeline();
                this.firstWindowInChildIndices[index] = windowCount;
                this.firstPeriodInChildIndices[index] = periodCount;
                windowCount += this.timelines[index].getWindowCount();
                periodCount += this.timelines[index].getPeriodCount();
                this.uids[index] = mediaSourceHolder.uid;
                this.childIndexByUid.put(this.uids[index], index++);
            }
            this.windowCount = windowCount;
            this.periodCount = periodCount;
        }

        @Override
        protected int getChildIndexByPeriodIndex(int periodIndex) {
            return Util.binarySearchFloor((int[])this.firstPeriodInChildIndices, (int)(periodIndex + 1), (boolean)false, (boolean)false);
        }

        @Override
        protected int getChildIndexByWindowIndex(int windowIndex) {
            return Util.binarySearchFloor((int[])this.firstWindowInChildIndices, (int)(windowIndex + 1), (boolean)false, (boolean)false);
        }

        @Override
        protected int getChildIndexByChildUid(Object childUid) {
            Integer index = this.childIndexByUid.get(childUid);
            return index == null ? -1 : index;
        }

        @Override
        protected Timeline getTimelineByChildIndex(int childIndex) {
            return this.timelines[childIndex];
        }

        @Override
        protected int getFirstPeriodIndexByChildIndex(int childIndex) {
            return this.firstPeriodInChildIndices[childIndex];
        }

        @Override
        protected int getFirstWindowIndexByChildIndex(int childIndex) {
            return this.firstWindowInChildIndices[childIndex];
        }

        @Override
        protected Object getChildUidByChildIndex(int childIndex) {
            return this.uids[childIndex];
        }

        public int getWindowCount() {
            return this.windowCount;
        }

        public int getPeriodCount() {
            return this.periodCount;
        }
    }

    private static final class MessageData<T> {
        public final int index;
        public final T customData;
        @Nullable
        public final HandlerAndRunnable onCompletionAction;

        public MessageData(int index, T customData, @Nullable HandlerAndRunnable onCompletionAction) {
            this.index = index;
            this.customData = customData;
            this.onCompletionAction = onCompletionAction;
        }
    }

    static final class MediaSourceHolder {
        public final MaskingMediaSource mediaSource;
        public final Object uid;
        public final List<MediaSource.MediaPeriodId> activeMediaPeriodIds;
        public int childIndex;
        public int firstWindowIndexInChild;
        public boolean isRemoved;

        public MediaSourceHolder(MediaSource mediaSource, boolean useLazyPreparation) {
            this.mediaSource = new MaskingMediaSource(mediaSource, useLazyPreparation);
            this.activeMediaPeriodIds = new ArrayList<MediaSource.MediaPeriodId>();
            this.uid = new Object();
        }

        public void reset(int childIndex, int firstWindowIndexInChild) {
            this.childIndex = childIndex;
            this.firstWindowIndexInChild = firstWindowIndexInChild;
            this.isRemoved = false;
            this.activeMediaPeriodIds.clear();
        }
    }
}

