/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.ClippingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.MergingMediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.text.SubtitleDecoderFactory;
import com.google.android.exoplayer2.text.SubtitleExtractor;
import com.google.android.exoplayer2.ui.AdViewProvider;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class DefaultMediaSourceFactory
implements MediaSourceFactory {
    private static final String TAG = "DMediaSourceFactory";
    private final DataSource.Factory dataSourceFactory;
    private final DelegateFactoryLoader delegateFactoryLoader;
    @Nullable
    private MediaSource.Factory serverSideAdInsertionMediaSourceFactory;
    @Nullable
    private AdsLoader.Provider adsLoaderProvider;
    @Nullable
    private AdViewProvider adViewProvider;
    @Nullable
    private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private long liveTargetOffsetMs;
    private long liveMinOffsetMs;
    private long liveMaxOffsetMs;
    private float liveMinSpeed;
    private float liveMaxSpeed;
    private boolean useProgressiveMediaSourceForSubtitles;

    public DefaultMediaSourceFactory(Context context) {
        this((DataSource.Factory)new DefaultDataSource.Factory(context));
    }

    public DefaultMediaSourceFactory(Context context, ExtractorsFactory extractorsFactory) {
        this((DataSource.Factory)new DefaultDataSource.Factory(context), extractorsFactory);
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory) {
        this(dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.delegateFactoryLoader = new DelegateFactoryLoader(dataSourceFactory, extractorsFactory);
        this.liveTargetOffsetMs = -9223372036854775807L;
        this.liveMinOffsetMs = -9223372036854775807L;
        this.liveMaxOffsetMs = -9223372036854775807L;
        this.liveMinSpeed = -3.4028235E38f;
        this.liveMaxSpeed = -3.4028235E38f;
    }

    public DefaultMediaSourceFactory experimentalUseProgressiveMediaSourceForSubtitles(boolean useProgressiveMediaSourceForSubtitles) {
        this.useProgressiveMediaSourceForSubtitles = useProgressiveMediaSourceForSubtitles;
        return this;
    }

    public DefaultMediaSourceFactory setAdsLoaderProvider(@Nullable AdsLoader.Provider adsLoaderProvider) {
        this.adsLoaderProvider = adsLoaderProvider;
        return this;
    }

    public DefaultMediaSourceFactory setAdViewProvider(@Nullable AdViewProvider adViewProvider) {
        this.adViewProvider = adViewProvider;
        return this;
    }

    public DefaultMediaSourceFactory setServerSideAdInsertionMediaSourceFactory(@Nullable MediaSource.Factory serverSideAdInsertionMediaSourceFactory) {
        this.serverSideAdInsertionMediaSourceFactory = serverSideAdInsertionMediaSourceFactory;
        return this;
    }

    public DefaultMediaSourceFactory setLiveTargetOffsetMs(long liveTargetOffsetMs) {
        this.liveTargetOffsetMs = liveTargetOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMinOffsetMs(long liveMinOffsetMs) {
        this.liveMinOffsetMs = liveMinOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMaxOffsetMs(long liveMaxOffsetMs) {
        this.liveMaxOffsetMs = liveMaxOffsetMs;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMinSpeed(float minSpeed) {
        this.liveMinSpeed = minSpeed;
        return this;
    }

    public DefaultMediaSourceFactory setLiveMaxSpeed(float maxSpeed) {
        this.liveMaxSpeed = maxSpeed;
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.delegateFactoryLoader.setDrmSessionManagerProvider(drmSessionManagerProvider);
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.delegateFactoryLoader.setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
        return this;
    }

    @Override
    public int[] getSupportedTypes() {
        return this.delegateFactoryLoader.getSupportedTypes();
    }

    @Override
    public MediaSource createMediaSource(MediaItem mediaItem) {
        MediaItem.LiveConfiguration liveConfiguration;
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        String scheme = mediaItem.localConfiguration.uri.getScheme();
        if (scheme != null && scheme.equals("ssai")) {
            return ((MediaSource.Factory)Assertions.checkNotNull((Object)this.serverSideAdInsertionMediaSourceFactory)).createMediaSource(mediaItem);
        }
        int type = Util.inferContentTypeForUriAndMimeType((Uri)mediaItem.localConfiguration.uri, (String)mediaItem.localConfiguration.mimeType);
        MediaSource.Factory mediaSourceFactory = this.delegateFactoryLoader.getMediaSourceFactory(type);
        Assertions.checkStateNotNull((Object)mediaSourceFactory, (Object)new StringBuilder(68).append("No suitable media source factory found for content type: ").append(type).toString());
        MediaItem.LiveConfiguration.Builder liveConfigurationBuilder = mediaItem.liveConfiguration.buildUpon();
        if (mediaItem.liveConfiguration.targetOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setTargetOffsetMs(this.liveTargetOffsetMs);
        }
        if (mediaItem.liveConfiguration.minPlaybackSpeed == -3.4028235E38f) {
            liveConfigurationBuilder.setMinPlaybackSpeed(this.liveMinSpeed);
        }
        if (mediaItem.liveConfiguration.maxPlaybackSpeed == -3.4028235E38f) {
            liveConfigurationBuilder.setMaxPlaybackSpeed(this.liveMaxSpeed);
        }
        if (mediaItem.liveConfiguration.minOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setMinOffsetMs(this.liveMinOffsetMs);
        }
        if (mediaItem.liveConfiguration.maxOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setMaxOffsetMs(this.liveMaxOffsetMs);
        }
        if (!(liveConfiguration = liveConfigurationBuilder.build()).equals((Object)mediaItem.liveConfiguration)) {
            mediaItem = mediaItem.buildUpon().setLiveConfiguration(liveConfiguration).build();
        }
        MediaSource mediaSource = mediaSourceFactory.createMediaSource(mediaItem);
        ImmutableList subtitleConfigurations = ((MediaItem.LocalConfiguration)Util.castNonNull((Object)mediaItem.localConfiguration)).subtitleConfigurations;
        if (!subtitleConfigurations.isEmpty()) {
            MediaSource[] mediaSources = new MediaSource[subtitleConfigurations.size() + 1];
            mediaSources[0] = mediaSource;
            for (int i = 0; i < subtitleConfigurations.size(); ++i) {
                if (this.useProgressiveMediaSourceForSubtitles) {
                    Format format = new Format.Builder().setSampleMimeType(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).mimeType).setLanguage(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).language).setSelectionFlags(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).selectionFlags).setRoleFlags(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).roleFlags).setLabel(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).label).setId(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).id).build();
                    ExtractorsFactory extractorsFactory = () -> new Extractor[]{SubtitleDecoderFactory.DEFAULT.supportsFormat(format) ? new SubtitleExtractor(SubtitleDecoderFactory.DEFAULT.createDecoder(format), format) : new UnknownSubtitlesExtractor(format)};
                    mediaSources[i + 1] = new ProgressiveMediaSource.Factory(this.dataSourceFactory, extractorsFactory).setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy).createMediaSource(MediaItem.fromUri((String)((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).uri.toString()));
                    continue;
                }
                mediaSources[i + 1] = new SingleSampleMediaSource.Factory(this.dataSourceFactory).setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy).createMediaSource((MediaItem.SubtitleConfiguration)subtitleConfigurations.get(i), -9223372036854775807L);
            }
            mediaSource = new MergingMediaSource(mediaSources);
        }
        return this.maybeWrapWithAdsMediaSource(mediaItem, DefaultMediaSourceFactory.maybeClipMediaSource(mediaItem, mediaSource));
    }

    private static MediaSource maybeClipMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        if (mediaItem.clippingConfiguration.startPositionMs == 0L && mediaItem.clippingConfiguration.endPositionMs == Long.MIN_VALUE && !mediaItem.clippingConfiguration.relativeToDefaultPosition) {
            return mediaSource;
        }
        return new ClippingMediaSource(mediaSource, Util.msToUs((long)mediaItem.clippingConfiguration.startPositionMs), Util.msToUs((long)mediaItem.clippingConfiguration.endPositionMs), !mediaItem.clippingConfiguration.startsAtKeyFrame, mediaItem.clippingConfiguration.relativeToLiveWindow, mediaItem.clippingConfiguration.relativeToDefaultPosition);
    }

    private MediaSource maybeWrapWithAdsMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        MediaItem.AdsConfiguration adsConfiguration = mediaItem.localConfiguration.adsConfiguration;
        if (adsConfiguration == null) {
            return mediaSource;
        }
        AdsLoader.Provider adsLoaderProvider = this.adsLoaderProvider;
        AdViewProvider adViewProvider = this.adViewProvider;
        if (adsLoaderProvider == null || adViewProvider == null) {
            Log.w((String)TAG, (String)"Playing media without ads. Configure ad support by calling setAdsLoaderProvider and setAdViewProvider.");
            return mediaSource;
        }
        AdsLoader adsLoader = adsLoaderProvider.getAdsLoader(adsConfiguration);
        if (adsLoader == null) {
            Log.w((String)TAG, (String)"Playing media without ads, as no AdsLoader was provided.");
            return mediaSource;
        }
        return new AdsMediaSource(mediaSource, new DataSpec(adsConfiguration.adTagUri), adsConfiguration.adsId != null ? adsConfiguration.adsId : ImmutableList.of((Object)mediaItem.mediaId, (Object)mediaItem.localConfiguration.uri, (Object)adsConfiguration.adTagUri), this, adsLoader, adViewProvider);
    }

    private static MediaSource.Factory newInstance(Class<? extends MediaSource.Factory> clazz, DataSource.Factory dataSourceFactory) {
        try {
            return clazz.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static MediaSource.Factory newInstance(Class<? extends MediaSource.Factory> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class UnknownSubtitlesExtractor
    implements Extractor {
        private final Format format;

        public UnknownSubtitlesExtractor(Format format) {
            this.format = format;
        }

        public boolean sniff(ExtractorInput input) {
            return true;
        }

        public void init(ExtractorOutput output) {
            TrackOutput trackOutput = output.track(0, 3);
            output.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
            output.endTracks();
            trackOutput.format(this.format.buildUpon().setSampleMimeType("text/x-unknown").setCodecs(this.format.sampleMimeType).build());
        }

        public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
            int skipResult = input.skip(Integer.MAX_VALUE);
            if (skipResult == -1) {
                return -1;
            }
            return 0;
        }

        public void seek(long position, long timeUs) {
        }

        public void release() {
        }
    }

    private static final class DelegateFactoryLoader {
        private final DataSource.Factory dataSourceFactory;
        private final ExtractorsFactory extractorsFactory;
        private final Map<Integer, @NullableType Supplier<MediaSource.Factory>> mediaSourceFactorySuppliers;
        private final Set<Integer> supportedTypes;
        private final Map<Integer, MediaSource.Factory> mediaSourceFactories;
        @Nullable
        private DrmSessionManagerProvider drmSessionManagerProvider;
        @Nullable
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;

        public DelegateFactoryLoader(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
            this.dataSourceFactory = dataSourceFactory;
            this.extractorsFactory = extractorsFactory;
            this.mediaSourceFactorySuppliers = new HashMap<Integer, Supplier<MediaSource.Factory>>();
            this.supportedTypes = new HashSet<Integer>();
            this.mediaSourceFactories = new HashMap<Integer, MediaSource.Factory>();
        }

        public int[] getSupportedTypes() {
            this.ensureAllSuppliersAreLoaded();
            return Ints.toArray(this.supportedTypes);
        }

        @Nullable
        public MediaSource.Factory getMediaSourceFactory(int contentType) {
            MediaSource.Factory mediaSourceFactory = this.mediaSourceFactories.get(contentType);
            if (mediaSourceFactory != null) {
                return mediaSourceFactory;
            }
            Supplier<MediaSource.Factory> mediaSourceFactorySupplier = this.maybeLoadSupplier(contentType);
            if (mediaSourceFactorySupplier == null) {
                return null;
            }
            mediaSourceFactory = (MediaSource.Factory)mediaSourceFactorySupplier.get();
            if (this.drmSessionManagerProvider != null) {
                mediaSourceFactory.setDrmSessionManagerProvider(this.drmSessionManagerProvider);
            }
            if (this.loadErrorHandlingPolicy != null) {
                mediaSourceFactory.setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
            }
            this.mediaSourceFactories.put(contentType, mediaSourceFactory);
            return mediaSourceFactory;
        }

        public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
            this.drmSessionManagerProvider = drmSessionManagerProvider;
            for (MediaSource.Factory mediaSourceFactory : this.mediaSourceFactories.values()) {
                mediaSourceFactory.setDrmSessionManagerProvider(drmSessionManagerProvider);
            }
        }

        public void setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
            for (MediaSource.Factory mediaSourceFactory : this.mediaSourceFactories.values()) {
                mediaSourceFactory.setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
            }
        }

        private void ensureAllSuppliersAreLoaded() {
            this.maybeLoadSupplier(0);
            this.maybeLoadSupplier(1);
            this.maybeLoadSupplier(2);
            this.maybeLoadSupplier(3);
            this.maybeLoadSupplier(4);
        }

        @Nullable
        private Supplier<MediaSource.Factory> maybeLoadSupplier(int contentType) {
            if (this.mediaSourceFactorySuppliers.containsKey(contentType)) {
                return this.mediaSourceFactorySuppliers.get(contentType);
            }
            Supplier mediaSourceFactorySupplier = null;
            try {
                switch (contentType) {
                    case 0: {
                        Class<MediaSource.Factory> clazz = Class.forName("com.google.android.exoplayer2.source.dash.DashMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, this.dataSourceFactory);
                        break;
                    }
                    case 1: {
                        Class<MediaSource.Factory> clazz = Class.forName("com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, this.dataSourceFactory);
                        break;
                    }
                    case 2: {
                        Class<MediaSource.Factory> clazz = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, this.dataSourceFactory);
                        break;
                    }
                    case 3: {
                        Class<MediaSource.Factory> clazz = Class.forName("com.google.android.exoplayer2.source.rtsp.RtspMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz);
                        break;
                    }
                    case 4: {
                        mediaSourceFactorySupplier = () -> new ProgressiveMediaSource.Factory(this.dataSourceFactory, this.extractorsFactory);
                        break;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.mediaSourceFactorySuppliers.put(contentType, (Supplier<MediaSource.Factory>)mediaSourceFactorySupplier);
            if (mediaSourceFactorySupplier != null) {
                this.supportedTypes.add(contentType);
            }
            return mediaSourceFactorySupplier;
        }
    }

    @Deprecated
    public static interface AdsLoaderProvider
    extends AdsLoader.Provider {
    }
}

