/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class MaskingMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    public final MediaSource.MediaPeriodId id;
    private final long preparePositionUs;
    private final Allocator allocator;
    private @MonotonicNonNull MediaSource mediaSource;
    private @MonotonicNonNull MediaPeriod mediaPeriod;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private PrepareListener listener;
    private boolean notifiedPrepareError;
    private long preparePositionOverrideUs;

    public MaskingMediaPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long preparePositionUs) {
        this.id = id;
        this.allocator = allocator;
        this.preparePositionUs = preparePositionUs;
        this.preparePositionOverrideUs = -9223372036854775807L;
    }

    public void setPrepareListener(PrepareListener listener) {
        this.listener = listener;
    }

    public long getPreparePositionUs() {
        return this.preparePositionUs;
    }

    public void overridePreparePositionUs(long preparePositionUs) {
        this.preparePositionOverrideUs = preparePositionUs;
    }

    public long getPreparePositionOverrideUs() {
        return this.preparePositionOverrideUs;
    }

    public void setMediaSource(MediaSource mediaSource) {
        Assertions.checkState((this.mediaSource == null ? 1 : 0) != 0);
        this.mediaSource = mediaSource;
    }

    public void createPeriod(MediaSource.MediaPeriodId id) {
        long preparePositionUs = this.getPreparePositionWithOverride(this.preparePositionUs);
        this.mediaPeriod = ((MediaSource)Assertions.checkNotNull((Object)this.mediaSource)).createPeriod(id, this.allocator, preparePositionUs);
        if (this.callback != null) {
            this.mediaPeriod.prepare(this, preparePositionUs);
        }
    }

    public void releasePeriod() {
        if (this.mediaPeriod != null) {
            ((MediaSource)Assertions.checkNotNull((Object)this.mediaSource)).releasePeriod(this.mediaPeriod);
        }
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        if (this.mediaPeriod != null) {
            this.mediaPeriod.prepare(this, this.getPreparePositionWithOverride(this.preparePositionUs));
        }
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        block6: {
            try {
                if (this.mediaPeriod != null) {
                    this.mediaPeriod.maybeThrowPrepareError();
                } else if (this.mediaSource != null) {
                    this.mediaSource.maybeThrowSourceInfoRefreshError();
                }
            }
            catch (IOException e) {
                if (this.listener == null) {
                    throw e;
                }
                if (this.notifiedPrepareError) break block6;
                this.notifiedPrepareError = true;
                this.listener.onPrepareError(this.id, e);
            }
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).getTrackGroups();
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        if (this.preparePositionOverrideUs != -9223372036854775807L && positionUs == this.preparePositionUs) {
            positionUs = this.preparePositionOverrideUs;
            this.preparePositionOverrideUs = -9223372036854775807L;
        }
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).selectTracks(selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).discardBuffer(positionUs, toKeyframe);
    }

    @Override
    public long readDiscontinuity() {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).readDiscontinuity();
    }

    @Override
    public long getBufferedPositionUs() {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).getBufferedPositionUs();
    }

    @Override
    public long seekToUs(long positionUs) {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).seekToUs(positionUs);
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    @Override
    public long getNextLoadPositionUs() {
        return ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).getNextLoadPositionUs();
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        ((MediaPeriod)Util.castNonNull((Object)this.mediaPeriod)).reevaluateBuffer(positionUs);
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.mediaPeriod != null && this.mediaPeriod.continueLoading(positionUs);
    }

    @Override
    public boolean isLoading() {
        return this.mediaPeriod != null && this.mediaPeriod.isLoading();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        ((MediaPeriod.Callback)Util.castNonNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    @Override
    public void onPrepared(MediaPeriod mediaPeriod) {
        ((MediaPeriod.Callback)Util.castNonNull((Object)this.callback)).onPrepared(this);
        if (this.listener != null) {
            this.listener.onPrepareComplete(this.id);
        }
    }

    private long getPreparePositionWithOverride(long preparePositionUs) {
        return this.preparePositionOverrideUs != -9223372036854775807L ? this.preparePositionOverrideUs : preparePositionUs;
    }

    public static interface PrepareListener {
        public void onPrepareComplete(MediaSource.MediaPeriodId var1);

        public void onPrepareError(MediaSource.MediaPeriodId var1, IOException var2);
    }
}

