/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;

public interface MediaSourceEventListener {
    default public void onLoadStarted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCompleted(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCanceled(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    default public void onUpstreamDiscarded(int windowIndex, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
    }

    default public void onDownstreamFormatChanged(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
    }

    public static class EventDispatcher {
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        private final CopyOnWriteArrayList<ListenerAndHandler> listenerAndHandlers;
        private final long mediaTimeOffsetMs;

        public EventDispatcher() {
            this(new CopyOnWriteArrayList<ListenerAndHandler>(), 0, null, 0L);
        }

        private EventDispatcher(CopyOnWriteArrayList<ListenerAndHandler> listenerAndHandlers, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
            this.listenerAndHandlers = listenerAndHandlers;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
            this.mediaTimeOffsetMs = mediaTimeOffsetMs;
        }

        @CheckResult
        public EventDispatcher withParameters(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
            return new EventDispatcher(this.listenerAndHandlers, windowIndex, mediaPeriodId, mediaTimeOffsetMs);
        }

        public void addEventListener(Handler handler, MediaSourceEventListener eventListener) {
            Assertions.checkNotNull((Object)handler);
            Assertions.checkNotNull((Object)eventListener);
            this.listenerAndHandlers.add(new ListenerAndHandler(handler, eventListener));
        }

        public void removeEventListener(MediaSourceEventListener eventListener) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                if (listenerAndHandler.listener != eventListener) continue;
                this.listenerAndHandlers.remove(listenerAndHandler);
            }
        }

        public void loadStarted(LoadEventInfo loadEventInfo, int dataType) {
            this.loadStarted(loadEventInfo, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadStarted(LoadEventInfo loadEventInfo, int dataType, int trackType, @Nullable Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long mediaStartTimeUs, long mediaEndTimeUs) {
            this.loadStarted(loadEventInfo, new MediaLoadData(dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, this.adjustMediaTime(mediaStartTimeUs), this.adjustMediaTime(mediaEndTimeUs)));
        }

        public void loadStarted(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onLoadStarted(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData));
            }
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, int dataType) {
            this.loadCompleted(loadEventInfo, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, int dataType, int trackType, @Nullable Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long mediaStartTimeUs, long mediaEndTimeUs) {
            this.loadCompleted(loadEventInfo, new MediaLoadData(dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, this.adjustMediaTime(mediaStartTimeUs), this.adjustMediaTime(mediaEndTimeUs)));
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onLoadCompleted(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData));
            }
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, int dataType) {
            this.loadCanceled(loadEventInfo, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, int dataType, int trackType, @Nullable Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long mediaStartTimeUs, long mediaEndTimeUs) {
            this.loadCanceled(loadEventInfo, new MediaLoadData(dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, this.adjustMediaTime(mediaStartTimeUs), this.adjustMediaTime(mediaEndTimeUs)));
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onLoadCanceled(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData));
            }
        }

        public void loadError(LoadEventInfo loadEventInfo, int dataType, IOException error, boolean wasCanceled) {
            this.loadError(loadEventInfo, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, error, wasCanceled);
        }

        public void loadError(LoadEventInfo loadEventInfo, int dataType, int trackType, @Nullable Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long mediaStartTimeUs, long mediaEndTimeUs, IOException error, boolean wasCanceled) {
            this.loadError(loadEventInfo, new MediaLoadData(dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, this.adjustMediaTime(mediaStartTimeUs), this.adjustMediaTime(mediaEndTimeUs)), error, wasCanceled);
        }

        public void loadError(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onLoadError(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData, error, wasCanceled));
            }
        }

        public void upstreamDiscarded(int trackType, long mediaStartTimeUs, long mediaEndTimeUs) {
            this.upstreamDiscarded(new MediaLoadData(1, trackType, null, 3, null, this.adjustMediaTime(mediaStartTimeUs), this.adjustMediaTime(mediaEndTimeUs)));
        }

        public void upstreamDiscarded(MediaLoadData mediaLoadData) {
            MediaSource.MediaPeriodId mediaPeriodId = (MediaSource.MediaPeriodId)((Object)Assertions.checkNotNull((Object)((Object)this.mediaPeriodId)));
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onUpstreamDiscarded(this.windowIndex, mediaPeriodId, mediaLoadData));
            }
        }

        public void downstreamFormatChanged(int trackType, @Nullable Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long mediaTimeUs) {
            this.downstreamFormatChanged(new MediaLoadData(1, trackType, trackFormat, trackSelectionReason, trackSelectionData, this.adjustMediaTime(mediaTimeUs), -9223372036854775807L));
        }

        public void downstreamFormatChanged(MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener listener = listenerAndHandler.listener;
                Util.postOrRun((Handler)listenerAndHandler.handler, () -> listener.onDownstreamFormatChanged(this.windowIndex, this.mediaPeriodId, mediaLoadData));
            }
        }

        private long adjustMediaTime(long mediaTimeUs) {
            long mediaTimeMs = Util.usToMs((long)mediaTimeUs);
            return mediaTimeMs == -9223372036854775807L ? -9223372036854775807L : this.mediaTimeOffsetMs + mediaTimeMs;
        }

        private static final class ListenerAndHandler {
            public Handler handler;
            public MediaSourceEventListener listener;

            public ListenerAndHandler(Handler handler, MediaSourceEventListener listener) {
                this.handler = handler;
                this.listener = listener;
            }
        }
    }
}

